/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class FindIndirectParamsVisitor
extends AbstractSoyNodeVisitor<IndirectParamsInfo> {
    private final boolean shouldOnlyVisitEachCalleeOnce;
    private final boolean shouldLimitResultsToOneCalleePerCallPath;
    private Map<String, TemplateNode> templateNameToNodeMap;
    private boolean isStartOfPass;
    private TemplateNode currTemplate;
    private Set<TemplateNode> visitedTemplates;
    private Map<TemplateNode, Set<String>> memoizedListedParamKeys;
    private Deque<CallerFrame> callerStack;
    private LinkedHashMap<String, TemplateNode.SoyDocParam> indirectParams;
    private Multimap<String, TemplateNode> paramKeyToCalleesMultimap;
    private boolean mayHaveExternalIndirectParams;

    public FindIndirectParamsVisitor(boolean bl, boolean bl2, @Nullable Map<String, TemplateNode> map) {
        this.shouldOnlyVisitEachCalleeOnce = bl;
        this.shouldLimitResultsToOneCalleePerCallPath = bl2;
        this.templateNameToNodeMap = map;
    }

    @Override
    protected void setup() {
        this.isStartOfPass = true;
        this.currTemplate = null;
        this.visitedTemplates = Sets.newHashSet();
        this.memoizedListedParamKeys = Maps.newHashMap();
        this.callerStack = new ArrayDeque<CallerFrame>();
        this.indirectParams = Maps.newLinkedHashMap();
        this.paramKeyToCalleesMultimap = LinkedHashMultimap.create();
        this.mayHaveExternalIndirectParams = false;
    }

    @Override
    protected IndirectParamsInfo getResult() {
        return new IndirectParamsInfo((ImmutableMap<String, TemplateNode.SoyDocParam>)ImmutableMap.copyOf(this.indirectParams), this.paramKeyToCalleesMultimap, this.mayHaveExternalIndirectParams);
    }

    @Override
    protected void visitInternal(TemplateNode templateNode) {
        if (!this.isStartOfPass) {
            throw new AssertionError((Object)"In the way this pass is designed, callee templates should not be visited. Instead, we call visitChildren() directly on the callee.");
        }
        this.isStartOfPass = false;
        if (this.templateNameToNodeMap == null) {
            SoyFileSetNode soyFileSetNode = (SoyFileSetNode)templateNode.getParent().getParent();
            this.templateNameToNodeMap = Maps.newHashMap();
            for (SoyFileNode soyFileNode : soyFileSetNode.getChildren()) {
                for (TemplateNode templateNode2 : soyFileNode.getChildren()) {
                    this.templateNameToNodeMap.put(templateNode2.getTemplateName(), templateNode2);
                }
            }
        }
        this.currTemplate = templateNode;
        this.visitedTemplates.add(templateNode);
        this.visitChildren(templateNode);
    }

    @Override
    protected void visitInternal(CallNode callNode) {
        Object object2;
        this.visitChildren(callNode);
        if (!callNode.isPassingAllData()) {
            return;
        }
        TemplateNode templateNode = this.templateNameToNodeMap.get(callNode.getCalleeName());
        if (templateNode == null) {
            this.mayHaveExternalIndirectParams = true;
            return;
        }
        if (this.shouldOnlyVisitEachCalleeOnce && this.visitedTemplates.contains(templateNode)) {
            return;
        }
        HashSet hashSet = Sets.newHashSet();
        for (Object object2 : callNode.getChildren()) {
            hashSet.add(((CallParamNode)object2).getKey());
        }
        CallerFrame callerFrame = new CallerFrame(this.currTemplate, hashSet);
        this.callerStack.push(callerFrame);
        if (this.isTemplateInStack(templateNode)) {
            return;
        }
        for (TemplateNode.SoyDocParam soyDocParam : templateNode.getSoyDocParams()) {
            if (this.isParamPassedExplicitly(soyDocParam.key) || this.shouldLimitResultsToOneCalleePerCallPath && this.isParamListedByEarlierTemplate(soyDocParam.key)) continue;
            if (!this.indirectParams.containsKey(soyDocParam.key)) {
                this.indirectParams.put(soyDocParam.key, soyDocParam);
            }
            this.paramKeyToCalleesMultimap.put((Object)soyDocParam.key, (Object)templateNode);
        }
        this.currTemplate = templateNode;
        this.visitedTemplates.add(templateNode);
        this.visitChildren(templateNode);
        object2 = this.callerStack.pop();
        if (object2 != callerFrame) {
            throw new AssertionError();
        }
        this.currTemplate = callerFrame.caller;
    }

    private boolean isTemplateInStack(TemplateNode templateNode) {
        for (CallerFrame callerFrame : this.callerStack) {
            if (callerFrame.caller != templateNode) continue;
            return true;
        }
        return false;
    }

    private boolean isParamPassedExplicitly(String string) {
        for (CallerFrame callerFrame : this.callerStack) {
            if (!callerFrame.callParamKeys.contains(string)) continue;
            return true;
        }
        return false;
    }

    private boolean isParamListedByEarlierTemplate(String string) {
        for (CallerFrame callerFrame : this.callerStack) {
            TemplateNode templateNode = callerFrame.caller;
            HashSet hashSet = this.memoizedListedParamKeys.get(templateNode);
            if (hashSet == null) {
                hashSet = Sets.newHashSet();
                for (TemplateNode.SoyDocParam soyDocParam : templateNode.getSoyDocParams()) {
                    hashSet.add(soyDocParam.key);
                }
                this.memoizedListedParamKeys.put(templateNode, hashSet);
            }
            if (!hashSet.contains(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void visitInternal(SoyNode soyNode) {
    }

    @Override
    protected void visitInternal(SoyNode.ParentSoyNode<? extends SoyNode> parentSoyNode) {
        this.visitChildren(parentSoyNode);
    }

    private static class CallerFrame {
        public final TemplateNode caller;
        public final Set<String> callParamKeys;

        public CallerFrame(TemplateNode templateNode, Set<String> set) {
            this.caller = templateNode;
            this.callParamKeys = set;
        }
    }

    public static class IndirectParamsInfo {
        public final ImmutableMap<String, TemplateNode.SoyDocParam> indirectParams;
        public final Multimap<String, TemplateNode> paramKeyToCalleesMultimap;
        public final boolean mayHaveExternalIndirectParams;

        public IndirectParamsInfo(ImmutableMap<String, TemplateNode.SoyDocParam> immutableMap, Multimap<String, TemplateNode> multimap, boolean bl) {
            this.indirectParams = immutableMap;
            this.paramKeyToCalleesMultimap = multimap;
            this.mayHaveExternalIndirectParams = bl;
        }
    }
}

