/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses;

import com.google.template.soy.base.IdGenerator;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.basetree.ParentNode;
import com.google.template.soy.coredirectives.CoreDirectiveUtils;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.internal.base.CharEscapers;
import com.google.template.soy.sharedpasses.CombineConsecutiveRawTextNodesVisitor;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;

public class ReplaceStringPrintNodesVisitor
extends AbstractSoyNodeVisitor<Void> {
    private IdGenerator nodeIdGen;

    @Override
    public Void exec(SoyNode soyNode) {
        this.nodeIdGen = soyNode.getNearestAncestor(SoyFileSetNode.class).getNodeIdGen();
        super.exec(soyNode);
        new CombineConsecutiveRawTextNodesVisitor().exec(soyNode);
        return null;
    }

    @Override
    protected void visitInternal(PrintNode printNode) {
        if (printNode.getSyntaxVersion() != SoyNode.SyntaxVersion.V2) {
            return;
        }
        ParentNode parentNode = printNode.getParent();
        if (parentNode instanceof MsgNode) {
            return;
        }
        Node node = printNode.getExpr().getChild(0);
        if (!(node instanceof StringNode)) {
            return;
        }
        String string = ((StringNode)node).getValue();
        for (PrintDirectiveNode printDirectiveNode : printNode.getChildren()) {
            if (CoreDirectiveUtils.isEscapeHtmlDirective(printDirectiveNode)) {
                string = CharEscapers.asciiHtmlEscaper().escape(string);
                continue;
            }
            if (CoreDirectiveUtils.isNoAutoescapeOrIdDirective(printDirectiveNode)) continue;
            return;
        }
        parentNode.setChild(parentNode.getChildIndex(printNode), new RawTextNode(this.nodeIdGen.genStringId(), string));
    }

    @Override
    protected void visitInternal(SoyNode soyNode) {
    }

    @Override
    protected void visitInternal(SoyNode.ParentSoyNode<? extends SoyNode> parentSoyNode) {
        this.visitChildren(parentSoyNode);
    }
}

