/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soyparse;

import com.google.template.soy.base.IdGenerator;
import com.google.template.soy.base.IntegerIdGenerator;
import com.google.template.soy.base.SoyFileSupplier;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.soyparse.ParseException;
import com.google.template.soy.soyparse.SoyFileParser;
import com.google.template.soy.soyparse.TokenMgrError;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import java.io.IOException;
import java.io.Reader;
import java.util.List;

public class SoyFileSetParser {
    private SoyFileSetParser() {
    }

    public static SoyFileSetNode parseSoyFiles(List<SoyFileSupplier> list) throws SoySyntaxException {
        IntegerIdGenerator integerIdGenerator = new IntegerIdGenerator();
        SoyFileSetNode soyFileSetNode = new SoyFileSetNode(integerIdGenerator.genStringId(), integerIdGenerator);
        for (SoyFileSupplier soyFileSupplier : list) {
            soyFileSetNode.addChild(SoyFileSetParser.parseSoyFileHelper(soyFileSupplier, integerIdGenerator));
        }
        return soyFileSetNode;
    }

    private static SoyFileNode parseSoyFileHelper(SoyFileSupplier soyFileSupplier, IdGenerator idGenerator) throws SoySyntaxException {
        Reader reader;
        try {
            reader = soyFileSupplier.getInput();
        }
        catch (IOException iOException) {
            throw new SoySyntaxException("Error opening Soy file " + soyFileSupplier.getPath() + ": " + iOException);
        }
        try {
            SoyFileNode soyFileNode = new SoyFileParser(reader, idGenerator).parseSoyFile();
            soyFileNode.setFilePath(soyFileSupplier.getPath());
            SoyFileNode soyFileNode2 = soyFileNode;
            return soyFileNode2;
        }
        catch (TokenMgrError tokenMgrError) {
            throw new SoySyntaxException(tokenMgrError).setFilePath(soyFileSupplier.getPath());
        }
        catch (ParseException parseException) {
            throw new SoySyntaxException(parseException).setFilePath(soyFileSupplier.getPath());
        }
        catch (SoySyntaxException soySyntaxException) {
            throw soySyntaxException.setFilePath(soyFileSupplier.getPath());
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                throw new SoySyntaxException("Error closing Soy file " + soyFileSupplier.getPath() + ": " + iOException);
            }
        }
    }
}

