/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soyparse;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.template.soy.base.IdGenerator;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.soyparse.ParseException;
import com.google.template.soy.soyparse.SimpleCharStream;
import com.google.template.soy.soyparse.TemplateParserConstants;
import com.google.template.soy.soyparse.TemplateParserTokenManager;
import com.google.template.soy.soyparse.Token;
import com.google.template.soy.soyparse.TokenMgrError;
import com.google.template.soy.soytree.AbstractParentSoyCommandNode;
import com.google.template.soy.soytree.AbstractParentSoyNode;
import com.google.template.soy.soytree.AbstractSoyNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.CssNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForeachIfemptyNode;
import com.google.template.soy.soytree.ForeachNode;
import com.google.template.soy.soytree.ForeachNonemptyNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TemplateParser
implements TemplateParserConstants {
    private static final String LINE_BOUNDARY_REGEX = "\\s*?(\\n|\\r)\\s*";
    private static final Pattern LINE_BOUNDARY_PATTERN = Pattern.compile("\\s*?(\\n|\\r)\\s*");
    private static final Pattern EDGE_LINE_BOUNDARY_PATTERN = Pattern.compile("^\\s*?(\\n|\\r)\\s*|\\s*?(\\n|\\r)\\s*$");
    private static final Pattern NONEDGE_LINE_BOUNDARY_PATTERN = Pattern.compile("(?<=\\S)\\s*?(\\n|\\r)\\s*(?=\\S)");
    private IdGenerator nodeIdGen;
    private static final Map<String, String> SPECIAL_CHAR_CMD_NAME_TO_RAW_TEXT = ImmutableMap.builder().put((Object)"sp", (Object)" ").put((Object)"nil", (Object)"").put((Object)"\\n", (Object)"\n").put((Object)"\\r", (Object)"\r").put((Object)"\\t", (Object)"\t").put((Object)"lb", (Object)"{").put((Object)"rb", (Object)"}").build();
    public TemplateParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[18];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private final JJCalls[] jj_2_rtns = new JJCalls[29];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public TemplateParser(Reader reader, IdGenerator idGenerator) {
        this(reader);
        this.nodeIdGen = idGenerator;
    }

    public TemplateParser(String string, IdGenerator idGenerator) {
        this(new StringReader(string), idGenerator);
    }

    public List<SoyNode> parseTemplateBody() throws SoySyntaxException, TokenMgrError, ParseException {
        Preconditions.checkNotNull((Object)this.nodeIdGen);
        return this.TemplateBodyInput();
    }

    private final void SoyTagOpen() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: {
                this.jj_consume_token(5);
                break;
            }
            case 6: {
                this.jj_consume_token(6);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    private final void RegSoyTagClose() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 44: {
                this.jj_consume_token(44);
                break;
            }
            case 46: {
                this.jj_consume_token(46);
                break;
            }
            case 53: {
                this.jj_consume_token(53);
                break;
            }
            case 55: {
                this.jj_consume_token(55);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    private final void SelfEndingSoyTagClose() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 45: {
                this.jj_consume_token(45);
                break;
            }
            case 47: {
                this.jj_consume_token(47);
                break;
            }
            case 54: {
                this.jj_consume_token(54);
                break;
            }
            case 56: {
                this.jj_consume_token(56);
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    private final String CmdText() throws ParseException {
        List<String> list = this.CmdTextParts();
        return Joiner.on((String)"").join(list);
    }

    private final List<String> CmdTextParts() throws ParseException {
        StringBuilder stringBuilder;
        ArrayList arrayList;
        block17: {
            arrayList = Lists.newArrayList();
            stringBuilder = new StringBuilder();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: {
                    String string = this.AnyCmdName();
                    stringBuilder.append(string);
                    this.jj_consume_token(49);
                    break;
                }
                default: {
                    this.jj_la1[3] = this.jj_gen;
                }
            }
            block11: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 50: 
                    case 51: 
                    case 52: {
                        break;
                    }
                    default: {
                        this.jj_la1[4] = this.jj_gen;
                        break block17;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 51: {
                        Token token = this.jj_consume_token(51);
                        stringBuilder.append(token.image);
                        continue block11;
                    }
                    case 52: {
                        Token token = this.jj_consume_token(52);
                        stringBuilder.append(token.image);
                        continue block11;
                    }
                    case 50: {
                        Token token = this.jj_consume_token(50);
                        if (stringBuilder.length() > 0) {
                            arrayList.add(stringBuilder.toString());
                            stringBuilder = new StringBuilder();
                        }
                        arrayList.add(token.image);
                        continue block11;
                    }
                }
                break;
            }
            this.jj_la1[5] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        if (stringBuilder.length() > 0) {
            arrayList.add(stringBuilder.toString());
            stringBuilder = new StringBuilder();
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)arrayList.get(i);
            if (i == 0) {
                string = CharMatcher.WHITESPACE.trimLeadingFrom((CharSequence)string);
            }
            if (i == n - 1) {
                string = CharMatcher.WHITESPACE.trimTrailingFrom((CharSequence)string);
            }
            string = LINE_BOUNDARY_PATTERN.matcher(string).replaceAll(" ");
            arrayList.set(i, string);
        }
        return arrayList;
    }

    private final String AnyCmdName() throws ParseException {
        Token token;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: {
                token = this.jj_consume_token(9);
                break;
            }
            case 10: {
                token = this.jj_consume_token(10);
                break;
            }
            case 11: {
                token = this.jj_consume_token(11);
                break;
            }
            case 12: {
                token = this.jj_consume_token(12);
                break;
            }
            case 13: {
                token = this.jj_consume_token(13);
                break;
            }
            case 14: {
                token = this.jj_consume_token(14);
                break;
            }
            case 15: {
                token = this.jj_consume_token(15);
                break;
            }
            case 16: {
                token = this.jj_consume_token(16);
                break;
            }
            case 17: {
                token = this.jj_consume_token(17);
                break;
            }
            case 18: {
                token = this.jj_consume_token(18);
                break;
            }
            case 19: {
                token = this.jj_consume_token(19);
                break;
            }
            case 20: {
                token = this.jj_consume_token(20);
                break;
            }
            case 21: {
                token = this.jj_consume_token(21);
                break;
            }
            case 22: {
                token = this.jj_consume_token(22);
                break;
            }
            case 23: {
                token = this.jj_consume_token(23);
                break;
            }
            case 24: {
                token = this.jj_consume_token(24);
                break;
            }
            case 25: {
                token = this.jj_consume_token(25);
                break;
            }
            case 26: {
                token = this.jj_consume_token(26);
                break;
            }
            case 27: {
                token = this.jj_consume_token(27);
                break;
            }
            case 28: {
                token = this.jj_consume_token(28);
                break;
            }
            case 29: {
                token = this.jj_consume_token(29);
                break;
            }
            case 30: {
                token = this.jj_consume_token(30);
                break;
            }
            case 31: {
                token = this.jj_consume_token(31);
                break;
            }
            case 32: {
                token = this.jj_consume_token(32);
                break;
            }
            case 33: {
                token = this.jj_consume_token(33);
                break;
            }
            case 34: {
                token = this.jj_consume_token(34);
                break;
            }
            case 35: {
                token = this.jj_consume_token(35);
                break;
            }
            case 36: {
                token = this.jj_consume_token(36);
                break;
            }
            case 37: {
                token = this.jj_consume_token(37);
                break;
            }
            case 38: {
                token = this.jj_consume_token(38);
                break;
            }
            case 39: {
                token = this.jj_consume_token(39);
                break;
            }
            case 40: {
                token = this.jj_consume_token(40);
                break;
            }
            case 41: {
                token = this.jj_consume_token(41);
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return token.image;
    }

    private final String BasicRawText() throws ParseException {
        boolean bl;
        StringBuilder stringBuilder = new StringBuilder();
        Token token = this.jj_consume_token(67);
        stringBuilder.append(token.image);
        boolean bl2 = bl = token.beginLine == 1 && token.beginColumn == 1;
        while (this.jj_2_1(Integer.MAX_VALUE)) {
            token = this.jj_consume_token(67);
            stringBuilder.append(token.image);
        }
        String string = stringBuilder.toString();
        if (bl) {
            string = CharMatcher.WHITESPACE.trimLeadingFrom((CharSequence)string);
        }
        string = EDGE_LINE_BOUNDARY_PATTERN.matcher(string).replaceAll("");
        Matcher matcher = NONEDGE_LINE_BOUNDARY_PATTERN.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            char c = string.charAt(matcher.start() - 1);
            char c2 = string.charAt(matcher.end());
            matcher.appendReplacement(stringBuffer, c == '>' || c2 == '<' ? "" : " ");
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    private final void MaybeWhitespace(String string, String string2) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 67: {
                String string3 = this.BasicRawText();
                if (string3.trim().length() == 0) break;
                throw new ParseException("No content allowed between '" + string + "' and '" + string2 + "' (whitespace and comments are okay).");
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
            }
        }
    }

    private final String LiteralRawText() throws ParseException {
        this.SoyTagOpen();
        this.jj_consume_token(16);
        this.RegSoyTagClose();
        Token token = this.jj_consume_token(64);
        return token.image;
    }

    private final String SpecialCharRawText() throws ParseException {
        this.SoyTagOpen();
        String string = this.SpecialCharCmdName();
        this.RegSoyTagClose();
        return SPECIAL_CHAR_CMD_NAME_TO_RAW_TEXT.get(string);
    }

    private final String SpecialCharCmdName() throws ParseException {
        Token token;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: {
                token = this.jj_consume_token(9);
                break;
            }
            case 10: {
                token = this.jj_consume_token(10);
                break;
            }
            case 11: {
                token = this.jj_consume_token(11);
                break;
            }
            case 12: {
                token = this.jj_consume_token(12);
                break;
            }
            case 13: {
                token = this.jj_consume_token(13);
                break;
            }
            case 14: {
                token = this.jj_consume_token(14);
                break;
            }
            case 15: {
                token = this.jj_consume_token(15);
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return token.image;
    }

    private final String MsgTag() throws ParseException {
        this.SoyTagOpen();
        this.jj_consume_token(18);
        this.jj_consume_token(48);
        String string = this.CmdText();
        this.RegSoyTagClose();
        return string;
    }

    private final void EndMsgTag() throws ParseException {
        this.SoyTagOpen();
        this.jj_consume_token(19);
        this.RegSoyTagClose();
    }

    private final List<String> PrintTag() throws ParseException {
        this.SoyTagOpen();
        if (this.jj_2_2(Integer.MAX_VALUE)) {
            this.jj_consume_token(20);
            this.jj_consume_token(48);
        }
        List<String> list = this.CmdTextParts();
        this.RegSoyTagClose();
        return list;
    }

    private final String CssTag() throws ParseException {
        this.SoyTagOpen();
        this.jj_consume_token(21);
        this.jj_consume_token(48);
        String string = this.CmdText();
        this.RegSoyTagClose();
        return string;
    }

    private final String IfTag() throws ParseException {
        this.SoyTagOpen();
        this.jj_consume_token(22);
        this.jj_consume_token(48);
        String string = this.CmdText();
        this.RegSoyTagClose();
        return string;
    }

    private final String ElseifTag() throws ParseException {
        this.SoyTagOpen();
        this.jj_consume_token(23);
        this.jj_consume_token(48);
        String string = this.CmdText();
        this.RegSoyTagClose();
        return string;
    }

    private final void ElseTag() throws ParseException {
        this.SoyTagOpen();
        this.jj_consume_token(24);
        this.RegSoyTagClose();
    }

    private final void EndIfTag() throws ParseException {
        this.SoyTagOpen();
        this.jj_consume_token(25);
        this.RegSoyTagClose();
    }

    private final String SwitchTag() throws ParseException {
        this.SoyTagOpen();
        this.jj_consume_token(26);
        this.jj_consume_token(48);
        String string = this.CmdText();
        this.RegSoyTagClose();
        return string;
    }

    private final String CaseTag() throws ParseException {
        this.SoyTagOpen();
        this.jj_consume_token(27);
        this.jj_consume_token(48);
        String string = this.CmdText();
        this.RegSoyTagClose();
        return string;
    }

    private final void DefaultTag() throws ParseException {
        this.SoyTagOpen();
        this.jj_consume_token(28);
        this.RegSoyTagClose();
    }

    private final void EndSwitchTag() throws ParseException {
        this.SoyTagOpen();
        this.jj_consume_token(29);
        this.RegSoyTagClose();
    }

    private final String ForeachTag() throws ParseException {
        this.SoyTagOpen();
        this.jj_consume_token(30);
        this.jj_consume_token(48);
        String string = this.CmdText();
        this.RegSoyTagClose();
        return string;
    }

    private final void IfemptyTag() throws ParseException {
        this.SoyTagOpen();
        this.jj_consume_token(31);
        this.RegSoyTagClose();
    }

    private final void EndForeachTag() throws ParseException {
        this.SoyTagOpen();
        this.jj_consume_token(32);
        this.RegSoyTagClose();
    }

    private final String ForTag() throws ParseException {
        this.SoyTagOpen();
        this.jj_consume_token(33);
        this.jj_consume_token(48);
        String string = this.CmdText();
        this.RegSoyTagClose();
        return string;
    }

    private final void EndForTag() throws ParseException {
        this.SoyTagOpen();
        this.jj_consume_token(34);
        this.RegSoyTagClose();
    }

    private final String CallTagSelfEnding() throws ParseException {
        this.SoyTagOpen();
        this.jj_consume_token(35);
        this.jj_consume_token(48);
        String string = this.CmdText();
        this.SelfEndingSoyTagClose();
        return string;
    }

    private final String CallTagNotSelfEnding() throws ParseException {
        this.SoyTagOpen();
        this.jj_consume_token(35);
        this.jj_consume_token(48);
        String string = this.CmdText();
        this.RegSoyTagClose();
        return string;
    }

    private final void EndCallTag() throws ParseException {
        this.SoyTagOpen();
        this.jj_consume_token(36);
        this.RegSoyTagClose();
    }

    private final String ParamTagSelfEnding() throws ParseException {
        this.SoyTagOpen();
        this.jj_consume_token(37);
        this.jj_consume_token(48);
        String string = this.CmdText();
        this.SelfEndingSoyTagClose();
        return string;
    }

    private final String ParamTagNotSelfEnding() throws ParseException {
        this.SoyTagOpen();
        this.jj_consume_token(37);
        this.jj_consume_token(48);
        String string = this.CmdText();
        this.RegSoyTagClose();
        return string;
    }

    private final void EndParamTag() throws ParseException {
        this.SoyTagOpen();
        this.jj_consume_token(38);
        this.RegSoyTagClose();
    }

    private final List<SoyNode> TemplateBodyInput() throws ParseException, SoySyntaxException {
        List<SoyNode> list = this.TemplateBlock();
        this.jj_consume_token(0);
        if (this.token_source.curLexState == 2) {
            throw new ParseException("At end of template, found comment block that is never closed.");
        }
        return list;
    }

    private final List<SoyNode> TemplateBlock() throws ParseException, SoySyntaxException {
        ArrayList arrayList = Lists.newArrayList();
        block3: while (this.jj_2_3(Integer.MAX_VALUE)) {
            if (this.jj_2_4(Integer.MAX_VALUE)) {
                RawTextNode rawTextNode = this.ContiguousRawText();
                if (rawTextNode == null) continue;
                arrayList.add(rawTextNode);
                continue;
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: 
                case 6: {
                    SoyNode.SoyStatementNode soyStatementNode = this.SoyStmt();
                    arrayList.add(soyStatementNode);
                    continue block3;
                }
            }
            this.jj_la1[9] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return arrayList;
    }

    private final RawTextNode ContiguousRawText() throws ParseException {
        StringBuilder stringBuilder = new StringBuilder();
        do {
            block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 67: {
                    String string = this.BasicRawText();
                    stringBuilder.append(string);
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                    if (this.jj_2_5(Integer.MAX_VALUE)) {
                        String string = this.LiteralRawText();
                        stringBuilder.append(string);
                        break;
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 5: 
                        case 6: {
                            String string = this.SpecialCharRawText();
                            stringBuilder.append(string);
                            break block0;
                        }
                    }
                    this.jj_la1[11] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        } while (this.jj_2_6(Integer.MAX_VALUE));
        return stringBuilder.length() > 0 ? new RawTextNode(this.nodeIdGen.genStringId(), stringBuilder.toString()) : null;
    }

    private final void ContiguousRawTextLookaheadHelper() throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 67: {
                this.jj_consume_token(67);
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
                if (this.jj_2_7(Integer.MAX_VALUE)) {
                    this.SoyTagOpen();
                    this.jj_consume_token(16);
                    this.RegSoyTagClose();
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: 
                    case 6: {
                        this.SpecialCharRawText();
                        break block0;
                    }
                }
                this.jj_la1[13] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    private final SoyNode.SoyStatementNode SoyStmt() throws ParseException, SoySyntaxException {
        AbstractSoyNode abstractSoyNode;
        if (this.jj_2_8(Integer.MAX_VALUE)) {
            abstractSoyNode = this.MsgStmt();
        } else if (this.jj_2_9(Integer.MAX_VALUE)) {
            abstractSoyNode = this.PrintStmt();
        } else if (this.jj_2_10(Integer.MAX_VALUE)) {
            abstractSoyNode = this.CssStmt();
        } else if (this.jj_2_11(Integer.MAX_VALUE)) {
            abstractSoyNode = this.IfStmt();
        } else if (this.jj_2_12(Integer.MAX_VALUE)) {
            abstractSoyNode = this.SwitchStmt();
        } else if (this.jj_2_13(Integer.MAX_VALUE)) {
            abstractSoyNode = this.ForeachStmt();
        } else if (this.jj_2_14(Integer.MAX_VALUE)) {
            abstractSoyNode = this.ForStmt();
        } else if (this.jj_2_15(Integer.MAX_VALUE)) {
            abstractSoyNode = this.CallStmt();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return abstractSoyNode;
    }

    private final void SoyStmtLookaheadHelper() throws ParseException {
        if (this.jj_2_16(Integer.MAX_VALUE)) {
            this.PrintStmtLookaheadHelper();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: 
                case 6: {
                    this.SoyTagOpen();
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 18: {
                            this.jj_consume_token(18);
                            break;
                        }
                        case 21: {
                            this.jj_consume_token(21);
                            break;
                        }
                        case 22: {
                            this.jj_consume_token(22);
                            break;
                        }
                        case 26: {
                            this.jj_consume_token(26);
                            break;
                        }
                        case 30: {
                            this.jj_consume_token(30);
                            break;
                        }
                        case 33: {
                            this.jj_consume_token(33);
                            break;
                        }
                        case 35: {
                            this.jj_consume_token(35);
                            break;
                        }
                        default: {
                            this.jj_la1[14] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    this.jj_consume_token(48);
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    private final MsgNode MsgStmt() throws ParseException, SoySyntaxException {
        String string = this.MsgTag();
        MsgNode msgNode = new MsgNode(this.nodeIdGen.genStringId(), string);
        List<SoyNode> list = this.TemplateBlockForMsg();
        msgNode.addChildren(list);
        this.EndMsgTag();
        return msgNode;
    }

    private final List<SoyNode> TemplateBlockForMsg() throws ParseException, SoySyntaxException {
        ArrayList arrayList = Lists.newArrayList();
        block4: while (this.jj_2_17(Integer.MAX_VALUE)) {
            if (this.jj_2_18(Integer.MAX_VALUE)) {
                RawTextNode rawTextNode = this.ContiguousRawText();
                if (rawTextNode == null) continue;
                arrayList.add(rawTextNode);
                continue;
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: 
                case 6: {
                    SoyNode.SoyStatementNode soyStatementNode = this.SoyStmt();
                    if (!(soyStatementNode instanceof SoyNode.MsgPlaceholderNode)) {
                        String string = soyStatementNode instanceof IfNode ? "if" : ((SoyNode.SoyCommandNode)((Object)soyStatementNode)).getCommandName();
                        throw new SoySyntaxException("Command '" + string + "' not allowed within a 'msg' block.");
                    }
                    arrayList.add(soyStatementNode);
                    continue block4;
                }
                case 61: {
                    MsgHtmlTagNode msgHtmlTagNode = this.MsgHtmlTag();
                    arrayList.add(msgHtmlTagNode);
                    continue block4;
                }
            }
            this.jj_la1[16] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return arrayList;
    }

    private final MsgHtmlTagNode MsgHtmlTag() throws ParseException, SoySyntaxException {
        SoyNode soyNode2;
        Object object;
        this.jj_consume_token(61);
        List<SoyNode> list = this.TemplateBlock();
        this.jj_consume_token(62);
        if (list.get(0) instanceof RawTextNode) {
            RawTextNode rawTextNode = (RawTextNode)list.get(0);
            list.set(0, new RawTextNode(this.nodeIdGen.genStringId(), "<" + rawTextNode.getRawText()));
        } else {
            list.add(0, new RawTextNode(this.nodeIdGen.genStringId(), "<"));
        }
        int n = list.size() - 1;
        if (list.get(n) instanceof RawTextNode) {
            object = (RawTextNode)list.get(n);
            list.set(n, new RawTextNode(this.nodeIdGen.genStringId(), ((RawTextNode)object).getRawText() + ">"));
        } else {
            list.add(new RawTextNode(this.nodeIdGen.genStringId(), ">"));
        }
        object = new StringBuilder();
        for (SoyNode soyNode2 : list) {
            ((StringBuilder)object).append(soyNode2.toSourceString());
        }
        boolean bl = list.size() == 1;
        soyNode2 = new MsgHtmlTagNode(this.nodeIdGen.genStringId(), ((StringBuilder)object).toString(), bl);
        ((AbstractParentSoyNode)soyNode2).addChildren(list);
        return soyNode2;
    }

    private final PrintNode PrintStmt() throws ParseException, SoySyntaxException {
        List<String> list = this.PrintTag();
        if (list.size() == 0) {
            throw new SoySyntaxException("Found 'print' command with empty command text.");
        }
        String string = Joiner.on((String)"").join(list);
        String string2 = list.get(0).trim();
        PrintNode printNode = new PrintNode(this.nodeIdGen.genStringId(), string, string2);
        String string3 = null;
        int n = list.size();
        for (int i = 1; i < n; ++i) {
            String string4 = list.get(i);
            if (string4.startsWith("|")) {
                if (string3 != null) {
                    printNode.addChild(new PrintDirectiveNode(this.nodeIdGen.genStringId(), string3, ""));
                }
                string3 = string4;
                continue;
            }
            if (string4.startsWith(":")) {
                if (string3 == null) {
                    throw new AssertionError();
                }
                String string5 = string4.substring(1);
                printNode.addChild(new PrintDirectiveNode(this.nodeIdGen.genStringId(), string3, string5));
                string3 = null;
                continue;
            }
            if (string4.trim().length() == 0) continue;
            throw new SoySyntaxException("Invalid 'print' command text \"" + string + "\" (check the directives).");
        }
        if (string3 != null) {
            printNode.addChild(new PrintDirectiveNode(this.nodeIdGen.genStringId(), string3, ""));
        }
        return printNode;
    }

    private final void PrintStmtLookaheadHelper() throws ParseException {
        this.SoyTagOpen();
        if (this.jj_2_19(Integer.MAX_VALUE)) {
            this.jj_consume_token(20);
            this.jj_consume_token(48);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: {
                    this.AnyCmdName();
                    this.jj_consume_token(49);
                    break;
                }
                case 51: {
                    this.jj_consume_token(51);
                    break;
                }
                case 52: {
                    this.jj_consume_token(52);
                    break;
                }
                default: {
                    this.jj_la1[17] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    private final CssNode CssStmt() throws ParseException, SoySyntaxException {
        String string = this.CssTag();
        return new CssNode(this.nodeIdGen.genStringId(), string);
    }

    private final IfNode IfStmt() throws ParseException, SoySyntaxException {
        String string = this.IfTag();
        IfNode ifNode = new IfNode(this.nodeIdGen.genStringId());
        IfCondNode ifCondNode = new IfCondNode(this.nodeIdGen.genStringId(), "if", string);
        ifNode.addChild(ifCondNode);
        List<SoyNode> list = this.TemplateBlock();
        ifCondNode.addChildren(list);
        while (this.jj_2_20(Integer.MAX_VALUE)) {
            string = this.ElseifTag();
            ifCondNode = new IfCondNode(this.nodeIdGen.genStringId(), "elseif", string);
            ifNode.addChild(ifCondNode);
            list = this.TemplateBlock();
            ifCondNode.addChildren(list);
        }
        if (this.jj_2_21(Integer.MAX_VALUE)) {
            this.ElseTag();
            IfElseNode ifElseNode = new IfElseNode(this.nodeIdGen.genStringId());
            ifNode.addChild(ifElseNode);
            list = this.TemplateBlock();
            ifElseNode.addChildren(list);
        }
        this.EndIfTag();
        return ifNode;
    }

    private final SwitchNode SwitchStmt() throws ParseException, SoySyntaxException {
        List<SoyNode> list;
        AbstractParentSoyCommandNode abstractParentSoyCommandNode;
        String string = this.SwitchTag();
        SwitchNode switchNode = new SwitchNode(this.nodeIdGen.genStringId(), string);
        this.MaybeWhitespace("switch", "case");
        while (this.jj_2_22(Integer.MAX_VALUE)) {
            string = this.CaseTag();
            abstractParentSoyCommandNode = new SwitchCaseNode(this.nodeIdGen.genStringId(), string);
            switchNode.addChild(abstractParentSoyCommandNode);
            list = this.TemplateBlock();
            abstractParentSoyCommandNode.addChildren(list);
        }
        if (this.jj_2_23(Integer.MAX_VALUE)) {
            this.DefaultTag();
            abstractParentSoyCommandNode = new SwitchDefaultNode(this.nodeIdGen.genStringId());
            switchNode.addChild(abstractParentSoyCommandNode);
            list = this.TemplateBlock();
            abstractParentSoyCommandNode.addChildren(list);
        }
        this.EndSwitchTag();
        return switchNode;
    }

    private final ForeachNode ForeachStmt() throws ParseException, SoySyntaxException {
        String string = this.ForeachTag();
        ForeachNode foreachNode = new ForeachNode(this.nodeIdGen.genStringId(), string);
        List<SoyNode> list = this.TemplateBlock();
        ForeachNonemptyNode foreachNonemptyNode = new ForeachNonemptyNode(this.nodeIdGen.genStringId(), foreachNode);
        foreachNode.addChild(foreachNonemptyNode);
        foreachNonemptyNode.addChildren(list);
        if (this.jj_2_24(Integer.MAX_VALUE)) {
            this.IfemptyTag();
            list = this.TemplateBlock();
            ForeachIfemptyNode foreachIfemptyNode = new ForeachIfemptyNode(this.nodeIdGen.genStringId());
            foreachNode.addChild(foreachIfemptyNode);
            foreachIfemptyNode.addChildren(list);
        }
        this.EndForeachTag();
        return foreachNode;
    }

    private final ForNode ForStmt() throws ParseException, SoySyntaxException {
        String string = this.ForTag();
        ForNode forNode = new ForNode(this.nodeIdGen.genStringId(), string);
        List<SoyNode> list = this.TemplateBlock();
        forNode.addChildren(list);
        this.EndForTag();
        return forNode;
    }

    private final CallNode CallStmt() throws ParseException, SoySyntaxException {
        CallNode callNode;
        if (this.jj_2_26(Integer.MAX_VALUE)) {
            String string = this.CallTagSelfEnding();
            callNode = new CallNode(this.nodeIdGen.genStringId(), string);
        } else if (this.jj_2_27(Integer.MAX_VALUE)) {
            String string = this.CallTagNotSelfEnding();
            callNode = new CallNode(this.nodeIdGen.genStringId(), string);
            this.MaybeWhitespace("call", "param");
            while (this.jj_2_25(Integer.MAX_VALUE)) {
                CallParamNode callParamNode = this.CallParam();
                callNode.addChild(callParamNode);
                this.MaybeWhitespace("param", "param");
            }
            this.EndCallTag();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return callNode;
    }

    private final CallParamNode CallParam() throws ParseException, SoySyntaxException {
        CallParamNode callParamNode;
        if (this.jj_2_28(Integer.MAX_VALUE)) {
            String string = this.ParamTagSelfEnding();
            callParamNode = new CallParamValueNode(this.nodeIdGen.genStringId(), string);
        } else if (this.jj_2_29(Integer.MAX_VALUE)) {
            String string = this.ParamTagNotSelfEnding();
            CallParamContentNode callParamContentNode = new CallParamContentNode(this.nodeIdGen.genStringId(), string);
            List<SoyNode> list = this.TemplateBlock();
            callParamContentNode.addChildren((List<? extends SoyNode>)list);
            callParamNode = callParamContentNode;
            this.EndParamTag();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return callParamNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_2(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_3(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_4(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_5(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_6(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_7(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_8(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_9(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_10(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_11(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_12(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_13(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_14(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_15(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_16(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_17(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(16, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_18(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_18();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(17, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_19(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_19();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(18, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_20(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_20();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(19, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_21(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_21();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(20, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_22(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_22();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(21, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_23(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_23();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(22, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_24(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_24();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(23, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_25(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_25();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(24, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_26(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_26();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(25, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_27(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_27();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(26, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_28(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_28();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(27, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_29(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_29();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(28, n);
        }
    }

    private final boolean jj_3R_33() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(9)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(10)) {
                this.jj_scanpos = token;
                if (this.jj_scan_token(11)) {
                    this.jj_scanpos = token;
                    if (this.jj_scan_token(12)) {
                        this.jj_scanpos = token;
                        if (this.jj_scan_token(13)) {
                            this.jj_scanpos = token;
                            if (this.jj_scan_token(14)) {
                                this.jj_scanpos = token;
                                if (this.jj_scan_token(15)) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_23() {
        return this.jj_3R_30();
    }

    private final boolean jj_3R_12() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(5)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(6)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_17() {
        if (this.jj_3R_12()) {
            return true;
        }
        if (this.jj_scan_token(35)) {
            return true;
        }
        if (this.jj_scan_token(48)) {
            return true;
        }
        if (this.jj_3R_26()) {
            return true;
        }
        return this.jj_3R_27();
    }

    private final boolean jj_3R_22() {
        if (this.jj_3R_12()) {
            return true;
        }
        if (this.jj_scan_token(16)) {
            return true;
        }
        return this.jj_3R_13();
    }

    private final boolean jj_3R_11() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(67)) {
            this.jj_scanpos = token;
            if (this.jj_3R_22()) {
                this.jj_scanpos = token;
                if (this.jj_3R_23()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3_25() {
        if (this.jj_3R_12()) {
            return true;
        }
        if (this.jj_scan_token(37)) {
            return true;
        }
        return this.jj_scan_token(48);
    }

    private final boolean jj_3R_38() {
        return this.jj_scan_token(50);
    }

    private final boolean jj_3R_30() {
        if (this.jj_3R_12()) {
            return true;
        }
        if (this.jj_3R_33()) {
            return true;
        }
        return this.jj_3R_13();
    }

    private final boolean jj_3_23() {
        if (this.jj_3R_12()) {
            return true;
        }
        if (this.jj_scan_token(28)) {
            return true;
        }
        return this.jj_3R_13();
    }

    private final boolean jj_3_19() {
        if (this.jj_scan_token(20)) {
            return true;
        }
        return this.jj_scan_token(48);
    }

    private final boolean jj_3R_37() {
        return this.jj_scan_token(52);
    }

    private final boolean jj_3_5() {
        if (this.jj_3R_12()) {
            return true;
        }
        if (this.jj_scan_token(16)) {
            return true;
        }
        return this.jj_3R_13();
    }

    private final boolean jj_3R_10() {
        return this.jj_3R_21();
    }

    private final boolean jj_3_27() {
        return this.jj_3R_18();
    }

    private final boolean jj_3R_36() {
        return this.jj_scan_token(51);
    }

    private final boolean jj_3_2() {
        if (this.jj_scan_token(20)) {
            return true;
        }
        return this.jj_scan_token(48);
    }

    private final boolean jj_3R_35() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_36()) {
            this.jj_scanpos = token;
            if (this.jj_3R_37()) {
                this.jj_scanpos = token;
                if (this.jj_3R_38()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_25() {
        if (this.jj_3R_31()) {
            return true;
        }
        return this.jj_scan_token(49);
    }

    private final boolean jj_3_6() {
        return this.jj_3R_11();
    }

    private final boolean jj_3_26() {
        return this.jj_3R_17();
    }

    private final boolean jj_3_16() {
        return this.jj_3R_14();
    }

    private final boolean jj_3_22() {
        if (this.jj_3R_12()) {
            return true;
        }
        if (this.jj_scan_token(27)) {
            return true;
        }
        return this.jj_scan_token(48);
    }

    private final boolean jj_3R_24() {
        if (this.jj_scan_token(20)) {
            return true;
        }
        return this.jj_scan_token(48);
    }

    private final boolean jj_3R_34() {
        if (this.jj_3R_31()) {
            return true;
        }
        return this.jj_scan_token(49);
    }

    private final boolean jj_3R_16() {
        return this.jj_3R_21();
    }

    private final boolean jj_3R_14() {
        if (this.jj_3R_12()) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_24()) {
            this.jj_scanpos = token;
            if (this.jj_3R_25()) {
                this.jj_scanpos = token;
                if (this.jj_scan_token(51)) {
                    this.jj_scanpos = token;
                    if (this.jj_scan_token(52)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_29() {
        if (this.jj_3R_12()) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(18)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(21)) {
                this.jj_scanpos = token;
                if (this.jj_scan_token(22)) {
                    this.jj_scanpos = token;
                    if (this.jj_scan_token(26)) {
                        this.jj_scanpos = token;
                        if (this.jj_scan_token(30)) {
                            this.jj_scanpos = token;
                            if (this.jj_scan_token(33)) {
                                this.jj_scanpos = token;
                                if (this.jj_scan_token(35)) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return this.jj_scan_token(48);
    }

    private final boolean jj_3R_20() {
        if (this.jj_3R_12()) {
            return true;
        }
        if (this.jj_scan_token(37)) {
            return true;
        }
        if (this.jj_scan_token(48)) {
            return true;
        }
        if (this.jj_3R_26()) {
            return true;
        }
        return this.jj_3R_13();
    }

    private final boolean jj_3R_32() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_34()) {
            this.jj_scanpos = token;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_35());
        this.jj_scanpos = token;
        return false;
    }

    private final boolean jj_3R_28() {
        return this.jj_3R_14();
    }

    private final boolean jj_3R_21() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_28()) {
            this.jj_scanpos = token;
            if (this.jj_3R_29()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_15() {
        if (this.jj_3R_12()) {
            return true;
        }
        if (this.jj_scan_token(35)) {
            return true;
        }
        return this.jj_scan_token(48);
    }

    private final boolean jj_3_4() {
        return this.jj_3R_11();
    }

    private final boolean jj_3_14() {
        if (this.jj_3R_12()) {
            return true;
        }
        if (this.jj_scan_token(33)) {
            return true;
        }
        return this.jj_scan_token(48);
    }

    private final boolean jj_3R_19() {
        if (this.jj_3R_12()) {
            return true;
        }
        if (this.jj_scan_token(37)) {
            return true;
        }
        if (this.jj_scan_token(48)) {
            return true;
        }
        if (this.jj_3R_26()) {
            return true;
        }
        return this.jj_3R_27();
    }

    private final boolean jj_3_13() {
        if (this.jj_3R_12()) {
            return true;
        }
        if (this.jj_scan_token(30)) {
            return true;
        }
        return this.jj_scan_token(48);
    }

    private final boolean jj_3_3() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_9()) {
            this.jj_scanpos = token;
            if (this.jj_3R_10()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_9() {
        return this.jj_3R_11();
    }

    private final boolean jj_3R_26() {
        return this.jj_3R_32();
    }

    private final boolean jj_3_21() {
        if (this.jj_3R_12()) {
            return true;
        }
        if (this.jj_scan_token(24)) {
            return true;
        }
        return this.jj_3R_13();
    }

    private final boolean jj_3_12() {
        if (this.jj_3R_12()) {
            return true;
        }
        if (this.jj_scan_token(26)) {
            return true;
        }
        return this.jj_scan_token(48);
    }

    private final boolean jj_3_11() {
        if (this.jj_3R_12()) {
            return true;
        }
        if (this.jj_scan_token(22)) {
            return true;
        }
        return this.jj_scan_token(48);
    }

    private final boolean jj_3_10() {
        if (this.jj_3R_12()) {
            return true;
        }
        if (this.jj_scan_token(21)) {
            return true;
        }
        return this.jj_scan_token(48);
    }

    private final boolean jj_3_18() {
        return this.jj_3R_11();
    }

    private final boolean jj_3R_31() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(9)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(10)) {
                this.jj_scanpos = token;
                if (this.jj_scan_token(11)) {
                    this.jj_scanpos = token;
                    if (this.jj_scan_token(12)) {
                        this.jj_scanpos = token;
                        if (this.jj_scan_token(13)) {
                            this.jj_scanpos = token;
                            if (this.jj_scan_token(14)) {
                                this.jj_scanpos = token;
                                if (this.jj_scan_token(15)) {
                                    this.jj_scanpos = token;
                                    if (this.jj_scan_token(16)) {
                                        this.jj_scanpos = token;
                                        if (this.jj_scan_token(17)) {
                                            this.jj_scanpos = token;
                                            if (this.jj_scan_token(18)) {
                                                this.jj_scanpos = token;
                                                if (this.jj_scan_token(19)) {
                                                    this.jj_scanpos = token;
                                                    if (this.jj_scan_token(20)) {
                                                        this.jj_scanpos = token;
                                                        if (this.jj_scan_token(21)) {
                                                            this.jj_scanpos = token;
                                                            if (this.jj_scan_token(22)) {
                                                                this.jj_scanpos = token;
                                                                if (this.jj_scan_token(23)) {
                                                                    this.jj_scanpos = token;
                                                                    if (this.jj_scan_token(24)) {
                                                                        this.jj_scanpos = token;
                                                                        if (this.jj_scan_token(25)) {
                                                                            this.jj_scanpos = token;
                                                                            if (this.jj_scan_token(26)) {
                                                                                this.jj_scanpos = token;
                                                                                if (this.jj_scan_token(27)) {
                                                                                    this.jj_scanpos = token;
                                                                                    if (this.jj_scan_token(28)) {
                                                                                        this.jj_scanpos = token;
                                                                                        if (this.jj_scan_token(29)) {
                                                                                            this.jj_scanpos = token;
                                                                                            if (this.jj_scan_token(30)) {
                                                                                                this.jj_scanpos = token;
                                                                                                if (this.jj_scan_token(31)) {
                                                                                                    this.jj_scanpos = token;
                                                                                                    if (this.jj_scan_token(32)) {
                                                                                                        this.jj_scanpos = token;
                                                                                                        if (this.jj_scan_token(33)) {
                                                                                                            this.jj_scanpos = token;
                                                                                                            if (this.jj_scan_token(34)) {
                                                                                                                this.jj_scanpos = token;
                                                                                                                if (this.jj_scan_token(35)) {
                                                                                                                    this.jj_scanpos = token;
                                                                                                                    if (this.jj_scan_token(36)) {
                                                                                                                        this.jj_scanpos = token;
                                                                                                                        if (this.jj_scan_token(37)) {
                                                                                                                            this.jj_scanpos = token;
                                                                                                                            if (this.jj_scan_token(38)) {
                                                                                                                                this.jj_scanpos = token;
                                                                                                                                if (this.jj_scan_token(39)) {
                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                    if (this.jj_scan_token(40)) {
                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                        if (this.jj_scan_token(41)) {
                                                                                                                                            return true;
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3_9() {
        return this.jj_3R_14();
    }

    private final boolean jj_3_20() {
        if (this.jj_3R_12()) {
            return true;
        }
        if (this.jj_scan_token(23)) {
            return true;
        }
        return this.jj_scan_token(48);
    }

    private final boolean jj_3R_15() {
        return this.jj_3R_11();
    }

    private final boolean jj_3_17() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_15()) {
            this.jj_scanpos = token;
            if (this.jj_3R_16()) {
                this.jj_scanpos = token;
                if (this.jj_scan_token(61)) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_27() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(45)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(47)) {
                this.jj_scanpos = token;
                if (this.jj_scan_token(54)) {
                    this.jj_scanpos = token;
                    if (this.jj_scan_token(56)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3_8() {
        if (this.jj_3R_12()) {
            return true;
        }
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(48);
    }

    private final boolean jj_3_29() {
        return this.jj_3R_20();
    }

    private final boolean jj_3_24() {
        if (this.jj_3R_12()) {
            return true;
        }
        if (this.jj_scan_token(31)) {
            return true;
        }
        return this.jj_3R_13();
    }

    private final boolean jj_3_28() {
        return this.jj_3R_19();
    }

    private final boolean jj_3R_18() {
        if (this.jj_3R_12()) {
            return true;
        }
        if (this.jj_scan_token(35)) {
            return true;
        }
        if (this.jj_scan_token(48)) {
            return true;
        }
        if (this.jj_3R_26()) {
            return true;
        }
        return this.jj_3R_13();
    }

    private final boolean jj_3_1() {
        return this.jj_scan_token(67);
    }

    private final boolean jj_3R_13() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(44)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(46)) {
                this.jj_scanpos = token;
                if (this.jj_scan_token(53)) {
                    this.jj_scanpos = token;
                    if (this.jj_scan_token(55)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3_7() {
        if (this.jj_3R_12()) {
            return true;
        }
        if (this.jj_scan_token(16)) {
            return true;
        }
        return this.jj_3R_13();
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{96, 0, 0, -512, 0, 0, -512, 0, 65024, 96, 0, 96, 0, 96, 0x44640000, 96, 96, -512};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{0, 0xA05000, 21012480, 1023, 0x1C0000, 0x1C0000, 1023, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0x20000000, 1573887};
    }

    private static void jj_la1_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 8, 0, 8, 0, 0, 0, 0, 0};
    }

    public TemplateParser(InputStream inputStream) {
        this(inputStream, null);
    }

    public TemplateParser(InputStream inputStream, String string) {
        int n;
        try {
            this.jj_input_stream = new SimpleCharStream(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        this.token_source = new TemplateParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 18; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(InputStream inputStream) {
        this.ReInit(inputStream, null);
    }

    public void ReInit(InputStream inputStream, String string) {
        int n;
        try {
            this.jj_input_stream.ReInit(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 18; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public TemplateParser(Reader reader) {
        int n;
        this.jj_input_stream = new SimpleCharStream(reader, 1, 1);
        this.token_source = new TemplateParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 18; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(Reader reader) {
        int n;
        this.jj_input_stream.ReInit(reader, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 18; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public TemplateParser(TemplateParserTokenManager templateParserTokenManager) {
        int n;
        this.token_source = templateParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 18; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(TemplateParserTokenManager templateParserTokenManager) {
        int n;
        this.token_source = templateParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 18; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == n) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls jJCalls = this.jj_2_rtns[i];
                    while (jJCalls != null) {
                        if (jJCalls.gen < this.jj_gen) {
                            jJCalls.first = null;
                        }
                        jJCalls = jJCalls.next;
                    }
                }
            }
            return this.token;
        }
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int n) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int n2 = 0;
            Token token = this.token;
            while (token != null && token != this.jj_scanpos) {
                ++n2;
                token = token.next;
            }
            if (token != null) {
                this.jj_add_error_token(n, n2);
            }
        }
        if (this.jj_scanpos.kind != n) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < n; ++i) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
        }
        return token;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int n, int n2) {
        if (n2 >= 100) {
            return;
        }
        if (n2 == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = n;
        } else if (this.jj_endpos != 0) {
            int n3;
            this.jj_expentry = new int[this.jj_endpos];
            for (n3 = 0; n3 < this.jj_endpos; ++n3) {
                this.jj_expentry[n3] = this.jj_lasttokens[n3];
            }
            n3 = 0;
            Enumeration enumeration = this.jj_expentries.elements();
            while (enumeration.hasMoreElements()) {
                int[] nArray = (int[])enumeration.nextElement();
                if (nArray.length != this.jj_expentry.length) continue;
                n3 = 1;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (nArray[i] == this.jj_expentry[i]) continue;
                    n3 = 0;
                    break;
                }
                if (n3 == 0) continue;
                break;
            }
            if (n3 == 0) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (n2 != 0) {
                this.jj_endpos = n2;
                this.jj_lasttokens[this.jj_endpos - 1] = n;
            }
        }
    }

    public ParseException generateParseException() {
        int n;
        int n2;
        this.jj_expentries.removeAllElements();
        boolean[] blArray = new boolean[74];
        for (n2 = 0; n2 < 74; ++n2) {
            blArray[n2] = false;
        }
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (n2 = 0; n2 < 18; ++n2) {
            if (this.jj_la1[n2] != this.jj_gen) continue;
            for (n = 0; n < 32; ++n) {
                if ((jj_la1_0[n2] & 1 << n) != 0) {
                    blArray[n] = true;
                }
                if ((jj_la1_1[n2] & 1 << n) != 0) {
                    blArray[32 + n] = true;
                }
                if ((jj_la1_2[n2] & 1 << n) == 0) continue;
                blArray[64 + n] = true;
            }
        }
        for (n2 = 0; n2 < 74; ++n2) {
            if (!blArray[n2]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = n2;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        for (n = 0; n < this.jj_expentries.size(); ++n) {
            nArrayArray[n] = (int[])this.jj_expentries.elementAt(n);
        }
        return new ParseException(this.token, nArrayArray, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 29; ++i) {
            try {
                JJCalls jJCalls = this.jj_2_rtns[i];
                do {
                    if (jJCalls.gen <= this.jj_gen) continue;
                    this.jj_la = jJCalls.arg;
                    this.jj_lastpos = this.jj_scanpos = jJCalls.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                            break;
                        }
                        case 12: {
                            this.jj_3_13();
                            break;
                        }
                        case 13: {
                            this.jj_3_14();
                            break;
                        }
                        case 14: {
                            this.jj_3_15();
                            break;
                        }
                        case 15: {
                            this.jj_3_16();
                            break;
                        }
                        case 16: {
                            this.jj_3_17();
                            break;
                        }
                        case 17: {
                            this.jj_3_18();
                            break;
                        }
                        case 18: {
                            this.jj_3_19();
                            break;
                        }
                        case 19: {
                            this.jj_3_20();
                            break;
                        }
                        case 20: {
                            this.jj_3_21();
                            break;
                        }
                        case 21: {
                            this.jj_3_22();
                            break;
                        }
                        case 22: {
                            this.jj_3_23();
                            break;
                        }
                        case 23: {
                            this.jj_3_24();
                            break;
                        }
                        case 24: {
                            this.jj_3_25();
                            break;
                        }
                        case 25: {
                            this.jj_3_26();
                            break;
                        }
                        case 26: {
                            this.jj_3_27();
                            break;
                        }
                        case 27: {
                            this.jj_3_28();
                            break;
                        }
                        case 28: {
                            this.jj_3_29();
                        }
                    }
                } while ((jJCalls = jJCalls.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int n, int n2) {
        JJCalls jJCalls = this.jj_2_rtns[n];
        while (jJCalls.gen > this.jj_gen) {
            if (jJCalls.next == null) {
                jJCalls = jJCalls.next = new JJCalls();
                break;
            }
            jJCalls = jJCalls.next;
        }
        jJCalls.gen = this.jj_gen + n2 - this.jj_la;
        jJCalls.first = this.token;
        jJCalls.arg = n2;
    }

    static {
        TemplateParser.jj_la1_0();
        TemplateParser.jj_la1_1();
        TemplateParser.jj_la1_2();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

