/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.template.soy.basetree.AbstractNode;
import com.google.template.soy.soytree.SoyNode;

public abstract class AbstractSoyNode
extends AbstractNode
implements SoyNode {
    private final String id;
    private SoyNode.SyntaxVersion syntaxVersion;

    protected AbstractSoyNode(String string) {
        Preconditions.checkNotNull((Object)string);
        this.id = string;
        this.syntaxVersion = SoyNode.SyntaxVersion.V2;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public SoyNode.SyntaxVersion getSyntaxVersion() {
        return this.syntaxVersion;
    }

    protected void maybeSetSyntaxVersion(SoyNode.SyntaxVersion syntaxVersion) {
        if (this.syntaxVersion.compareTo(syntaxVersion) > 0) {
            this.syntaxVersion = syntaxVersion;
        }
    }

    @Override
    public SoyNode.ParentSoyNode<? extends SoyNode> getParent() {
        SoyNode.ParentSoyNode parentSoyNode = (SoyNode.ParentSoyNode)super.getParent();
        return parentSoyNode;
    }

    @Override
    public String toString() {
        return super.toString() + "_" + this.id;
    }
}

