/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.basetree.MixinParentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CommandTextAttributesParser;
import com.google.template.soy.soytree.SoyNode;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CallParamContentNode
extends CallParamNode
implements SoyNode.ParentSoyNode<SoyNode> {
    private static final Pattern NONATTRIBUTE_COMMAND_TEXT = Pattern.compile("^ (?! key=\") ([\\w]+) (?: \\s* : \\s* (.+) )? $", 4);
    private static final CommandTextAttributesParser ATTRIBUTES_PARSER = new CommandTextAttributesParser("param", new CommandTextAttributesParser.Attribute("key", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, "__NDVBR__"), new CommandTextAttributesParser.Attribute("value", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, null));
    private final MixinParentNode<SoyNode> parentMixin = new MixinParentNode<SoyNode>(this);
    private final String key;

    public CallParamContentNode(String string, String string2) throws SoySyntaxException {
        super(string, string2);
        String string3;
        Matcher matcher = NONATTRIBUTE_COMMAND_TEXT.matcher(string2);
        if (matcher.matches()) {
            this.key = this.parseKeyHelper(matcher.group(1));
            string3 = matcher.group(2);
        } else {
            Map<String, String> map = ATTRIBUTES_PARSER.parse(string2);
            this.key = this.parseKeyHelper(map.get("key"));
            string3 = map.get("value");
        }
        if (string3 != null) {
            throw new SoySyntaxException("If a 'param' tag contains a value, then the tag must be self-ending (with a trailing '/').");
        }
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String toSourceString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getTagString());
        this.appendSourceStringForChildren(stringBuilder);
        stringBuilder.append("{/").append(this.getCommandName()).append("}");
        return stringBuilder.toString();
    }

    @Override
    public int numChildren() {
        return this.parentMixin.numChildren();
    }

    @Override
    public SoyNode getChild(int n) {
        return this.parentMixin.getChild(n);
    }

    @Override
    public int getChildIndex(SoyNode soyNode) {
        return this.parentMixin.getChildIndex(soyNode);
    }

    @Override
    public List<SoyNode> getChildren() {
        return this.parentMixin.getChildren();
    }

    @Override
    public void addChild(SoyNode soyNode) {
        this.parentMixin.addChild(soyNode);
    }

    @Override
    public void addChild(int n, SoyNode soyNode) {
        this.parentMixin.addChild(n, soyNode);
    }

    @Override
    public void removeChild(int n) {
        this.parentMixin.removeChild(n);
    }

    @Override
    public void removeChild(SoyNode soyNode) {
        this.parentMixin.removeChild(soyNode);
    }

    @Override
    public void setChild(int n, SoyNode soyNode) {
        this.parentMixin.setChild(n, soyNode);
    }

    @Override
    public void clearChildren() {
        this.parentMixin.clearChildren();
    }

    @Override
    public void addChildren(List<? extends SoyNode> list) {
        this.parentMixin.addChildren(list);
    }

    @Override
    public void appendSourceStringForChildren(StringBuilder stringBuilder) {
        this.parentMixin.appendSourceStringForChildren(stringBuilder);
    }

    @Override
    public void appendTreeStringForChildren(StringBuilder stringBuilder, int n) {
        this.parentMixin.appendTreeStringForChildren(stringBuilder, n);
    }

    @Override
    public String toTreeString(int n) {
        return this.parentMixin.toTreeString(n);
    }
}

