/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprparse.ParseException;
import com.google.template.soy.exprparse.TokenMgrError;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CommandTextAttributesParser;
import com.google.template.soy.soytree.SoyNode;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CallParamValueNode
extends CallParamNode
implements SoyNode.ExprHolderNode {
    private static final Pattern NONATTRIBUTE_COMMAND_TEXT = Pattern.compile("^ (?! key=\") ([\\w]+) (?: \\s* : \\s* (.+) )? $", 4);
    private static final CommandTextAttributesParser ATTRIBUTES_PARSER = new CommandTextAttributesParser("param", new CommandTextAttributesParser.Attribute("key", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, "__NDVBR__"), new CommandTextAttributesParser.Attribute("value", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, "__NDVBR__"));
    private final String key;
    private final String valueExprText;
    private final ExprRootNode<ExprNode> valueExpr;

    public CallParamValueNode(String string, String string2) throws SoySyntaxException {
        super(string, string2);
        Object object;
        Matcher matcher = NONATTRIBUTE_COMMAND_TEXT.matcher(string2);
        if (matcher.matches()) {
            this.key = this.parseKeyHelper(matcher.group(1));
            this.valueExprText = matcher.group(2);
        } else {
            object = ATTRIBUTES_PARSER.parse(string2);
            this.key = this.parseKeyHelper(object.get("key"));
            this.valueExprText = object.get("value");
        }
        object = null;
        try {
            object = new ExpressionParser(this.valueExprText).parseExpression();
        }
        catch (TokenMgrError tokenMgrError) {
            this.maybeSetSyntaxVersion(SoyNode.SyntaxVersion.V1);
        }
        catch (ParseException parseException) {
            this.maybeSetSyntaxVersion(SoyNode.SyntaxVersion.V1);
        }
        this.valueExpr = object;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public String getValueExprText() {
        return this.valueExprText;
    }

    public ExprRootNode<ExprNode> getValueExpr() {
        return this.valueExpr;
    }

    @Override
    public String getTagString() {
        return this.buildTagStringHelper(true);
    }

    @Override
    public List<? extends ExprRootNode<? extends ExprNode>> getAllExprs() {
        return this.valueExpr != null ? ImmutableList.of(this.valueExpr) : Collections.emptyList();
    }
}

