/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.template.soy.base.SoySyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class CommandTextAttributesParser {
    private static final Pattern ATTRIBUTE_TEXT = Pattern.compile("([a-z][a-z-]*) = \" ([^\"]*) \" \\s*", 4);
    private final String commandName;
    private final Set<Attribute> supportedAttributes;
    private final Set<String> supportedAttributeNames;

    public CommandTextAttributesParser(String string, Attribute ... attributeArray) {
        this.commandName = string;
        this.supportedAttributes = Sets.newHashSet((Object[])attributeArray);
        this.supportedAttributeNames = Sets.newHashSet();
        for (Attribute attribute : attributeArray) {
            this.supportedAttributeNames.add(attribute.name);
            if (attribute.allowedValues == Attribute.ALLOW_ALL_VALUES || attribute.defaultValue == "__NDVBR__") continue;
            Preconditions.checkArgument((boolean)attribute.allowedValues.contains(attribute.defaultValue));
        }
    }

    public Map<String, String> parse(String string) throws SoySyntaxException {
        HashMap hashMap = Maps.newHashMap();
        int n = 0;
        Matcher matcher = ATTRIBUTE_TEXT.matcher(string);
        while (matcher.find(n)) {
            if (matcher.start() != n) {
                throw new SoySyntaxException("Malformed attributes in tag {" + this.commandName + " " + string + "}.");
            }
            n = matcher.end();
            String string2 = matcher.group(1);
            String object = matcher.group(2);
            if (!this.supportedAttributeNames.contains(string2)) {
                throw new SoySyntaxException("Unsupported attribute '" + (String)string2 + "' in tag {" + this.commandName + " " + string + "}.");
            }
            if (hashMap.containsKey(string2)) {
                throw new SoySyntaxException("Duplicate attribute '" + (String)string2 + "' in tag {" + this.commandName + " " + string + "}.");
            }
            hashMap.put(string2, object);
        }
        if (n != string.length()) {
            throw new SoySyntaxException("Malformed attributes in tag {" + this.commandName + " " + string + "}.");
        }
        for (Attribute attribute : this.supportedAttributes) {
            if (hashMap.containsKey(attribute.name)) {
                if (attribute.allowedValues == Attribute.ALLOW_ALL_VALUES || attribute.allowedValues.contains(hashMap.get(attribute.name))) continue;
                throw new SoySyntaxException("Invalid value for attribute '" + attribute.name + "' in tag {" + this.commandName + " " + string + "}.");
            }
            if ("__NDVBR__".equals(attribute.defaultValue)) {
                throw new SoySyntaxException("Missing required attribute '" + attribute.name + "' in tag {" + this.commandName + " " + string + "}.");
            }
            hashMap.put(attribute.name, attribute.defaultValue);
        }
        return hashMap;
    }

    public static class Attribute {
        public static final Collection<String> ALLOW_ALL_VALUES = null;
        public static final Collection<String> BOOLEAN_VALUES = ImmutableSet.of((Object)"true", (Object)"false");
        public static final String NO_DEFAULT_VALUE_BECAUSE_REQUIRED = "__NDVBR__";
        final String name;
        final Collection<String> allowedValues;
        final String defaultValue;

        public Attribute(String string, Collection<String> collection, String string2) {
            this.name = string;
            this.allowedValues = collection;
            this.defaultValue = string2;
        }
    }
}

