/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.soytree.AbstractParentSoyNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MsgHtmlTagNode
extends AbstractParentSoyNode<SoyNode>
implements SoyNode.MsgPlaceholderNode {
    private static final Pattern TAG_NAME_PATTERN = Pattern.compile("(?<= ^< ) /? [a-zA-Z0-9]+", 4);
    private static final Map<String, String> LC_TAG_NAME_TO_PLACEHOLDER_NAME_MAP = ImmutableMap.builder().put((Object)"a", (Object)"link").put((Object)"br", (Object)"break").put((Object)"b", (Object)"bold").put((Object)"i", (Object)"italic").put((Object)"li", (Object)"item").put((Object)"ol", (Object)"ordered_list").put((Object)"ul", (Object)"unordered_list").put((Object)"p", (Object)"paragraph").put((Object)"img", (Object)"image").put((Object)"em", (Object)"emphasis").build();
    private final String lcTagName;
    private final boolean isSelfEnding;
    private final boolean isOnlyRawText;
    private final int fullTagTextHash;
    private String basePlaceholderName;

    public MsgHtmlTagNode(String string, String string2, boolean bl) throws SoySyntaxException {
        super(string);
        Matcher matcher = TAG_NAME_PATTERN.matcher(string2);
        if (!matcher.find()) {
            if (string2.startsWith("!--")) {
                throw new SoySyntaxException("Found HTML comment within 'msg' block: " + string2);
            }
            throw new SoySyntaxException("HTML tag within 'msg' block has no tag name: " + string2);
        }
        this.lcTagName = matcher.group().toLowerCase();
        this.isSelfEnding = string2.endsWith("/>");
        this.isOnlyRawText = bl;
        this.fullTagTextHash = bl ? string2.hashCode() : 0;
    }

    public String getLcTagName() {
        return this.lcTagName;
    }

    @Override
    public String genBasePlaceholderName() {
        String string;
        boolean bl;
        if (this.basePlaceholderName != null) {
            return this.basePlaceholderName;
        }
        if (this.lcTagName.startsWith("/")) {
            bl = true;
            string = this.lcTagName.substring(1);
        } else {
            bl = false;
            string = this.lcTagName;
        }
        String string2 = this.basePlaceholderName = LC_TAG_NAME_TO_PLACEHOLDER_NAME_MAP.containsKey(string) ? LC_TAG_NAME_TO_PLACEHOLDER_NAME_MAP.get(string) : string;
        if (bl) {
            this.basePlaceholderName = "end_" + this.basePlaceholderName;
        } else if (!this.isSelfEnding) {
            this.basePlaceholderName = "start_" + this.basePlaceholderName;
        }
        this.basePlaceholderName = this.basePlaceholderName.toUpperCase();
        return this.basePlaceholderName;
    }

    @Override
    public boolean isSamePlaceholderAs(SoyNode.MsgPlaceholderNode msgPlaceholderNode) {
        if (!(msgPlaceholderNode instanceof MsgHtmlTagNode)) {
            return false;
        }
        MsgHtmlTagNode msgHtmlTagNode = (MsgHtmlTagNode)msgPlaceholderNode;
        return this.isOnlyRawText && msgHtmlTagNode.isOnlyRawText && this.fullTagTextHash == msgHtmlTagNode.fullTagTextHash;
    }

    @Override
    public String toSourceString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendSourceStringForChildren(stringBuilder);
        return stringBuilder.toString();
    }
}

