/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprparse.ParseException;
import com.google.template.soy.exprparse.TokenMgrError;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AbstractSoyNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class PrintDirectiveNode
extends AbstractSoyNode
implements SoyNode.ExprHolderNode {
    private static final Map<String, String> V1_TO_V2_DIRECTIVE_NAMES = ImmutableMap.of((Object)"|noescape", (Object)"|noAutoescape", (Object)"|escape", (Object)"|escapeHtml", (Object)"|insertwordbreaks", (Object)"|insertWordBreaks");
    private String name;
    private final String argsText;
    private final List<ExprRootNode<ExprNode>> args;

    public PrintDirectiveNode(String string, String string2, String string3) throws SoySyntaxException {
        super(string);
        String string4 = V1_TO_V2_DIRECTIVE_NAMES.get(string2);
        if (string4 == null) {
            this.name = string2;
        } else {
            this.name = string4;
            this.maybeSetSyntaxVersion(SoyNode.SyntaxVersion.V1);
        }
        this.argsText = string3;
        if (this.argsText.length() > 0) {
            try {
                this.args = new ExpressionParser(string3).parseExpressionList();
            }
            catch (TokenMgrError tokenMgrError) {
                throw this.createExceptionForInvalidArgs(tokenMgrError);
            }
            catch (ParseException parseException) {
                throw this.createExceptionForInvalidArgs(parseException);
            }
        } else {
            this.args = Collections.emptyList();
        }
    }

    private SoySyntaxException createExceptionForInvalidArgs(Throwable throwable) {
        return new SoySyntaxException("Invalid arguments for print directive \"" + this.toString() + "\".", throwable);
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public String getArgsText() {
        return this.argsText;
    }

    public List<ExprRootNode<ExprNode>> getArgs() {
        return this.args;
    }

    @Override
    public String toSourceString() {
        return this.name + (this.argsText.length() > 0 ? ":" + this.argsText : "");
    }

    @Override
    public List<? extends ExprRootNode<? extends ExprNode>> getAllExprs() {
        return this.args;
    }
}

