/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableMap;
import com.google.template.soy.soytree.AbstractSoyNode;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RawTextNode
extends AbstractSoyNode {
    private static final Pattern SPECIAL_CHARS_TO_ESCAPE = Pattern.compile("[\n\r\t{}]");
    private static final Map<String, String> SPECIAL_CHAR_TO_TAG = ImmutableMap.builder().put((Object)"\n", (Object)"{\\n}").put((Object)"\r", (Object)"{\\r}").put((Object)"\t", (Object)"{\\t}").put((Object)"{", (Object)"{lb}").put((Object)"}", (Object)"{rb}").build();
    private final String rawText;

    public RawTextNode(String string, String string2) {
        super(string);
        this.rawText = string2;
    }

    public String getRawText() {
        return this.rawText;
    }

    @Override
    public String toSourceString() {
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = SPECIAL_CHARS_TO_ESCAPE.matcher(this.rawText);
        while (matcher.find()) {
            String string = SPECIAL_CHAR_TO_TAG.get(matcher.group());
            matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement(string));
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }
}

