/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprparse.ParseException;
import com.google.template.soy.exprparse.TokenMgrError;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AbstractParentSoyCommandNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.List;

public class SwitchCaseNode
extends AbstractParentSoyCommandNode<SoyNode>
implements SoyNode.ConditionalBlockNode<SoyNode>,
SoyNode.ParentExprHolderNode<SoyNode> {
    private final String exprListText;
    private final List<ExprRootNode<ExprNode>> exprList;

    public SwitchCaseNode(String string, String string2) throws SoySyntaxException {
        super(string, "case", string2);
        this.exprListText = string2;
        List<ExprRootNode<ExprNode>> list = null;
        try {
            list = new ExpressionParser(this.exprListText).parseExpressionList();
        }
        catch (TokenMgrError tokenMgrError) {
            throw this.createExceptionForInvalidExprList(tokenMgrError);
        }
        catch (ParseException parseException) {
            throw this.createExceptionForInvalidExprList(parseException);
        }
        this.exprList = list;
    }

    private SoySyntaxException createExceptionForInvalidExprList(Throwable throwable) {
        return new SoySyntaxException("Invalid expression list in 'case' command text \"" + this.getCommandText() + "\".", throwable);
    }

    public String getExprListText() {
        return this.exprListText;
    }

    public List<ExprRootNode<ExprNode>> getExprList() {
        return this.exprList;
    }

    @Override
    public String toSourceString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getTagString());
        this.appendSourceStringForChildren(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public List<? extends ExprRootNode<? extends ExprNode>> getAllExprs() {
        return this.exprList;
    }
}

