/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.template.soy.base.BaseUtils;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.soytree.AbstractParentSoyCommandNode;
import com.google.template.soy.soytree.CommandTextAttributesParser;
import com.google.template.soy.soytree.SoyNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class TemplateNode
extends AbstractParentSoyCommandNode<SoyNode> {
    private static final Pattern NONATTRIBUTE_TEMPLATE_NAME = Pattern.compile("^ (?! name=\") [.\\w]+ (?= \\s | $)", 4);
    private static final Pattern VALID_V2_NAME = Pattern.compile("[.][a-zA-Z_]\\w*");
    private static final CommandTextAttributesParser ATTRIBUTES_PARSER = new CommandTextAttributesParser("template", new CommandTextAttributesParser.Attribute("name", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, "__NDVBR__"), new CommandTextAttributesParser.Attribute("private", CommandTextAttributesParser.Attribute.BOOLEAN_VALUES, "false"), new CommandTextAttributesParser.Attribute("override", Sets.newHashSet((Object[])new String[]{"true", "false", null}), null), new CommandTextAttributesParser.Attribute("autoescape", CommandTextAttributesParser.Attribute.BOOLEAN_VALUES, "true"));
    private static final Pattern NEWLINE = Pattern.compile("\\n|\\r\\n?");
    private static final Pattern SOY_DOC_START = Pattern.compile("^ [/][*][*] [\\ ]* \\r?\\n?", 4);
    private static final Pattern SOY_DOC_END = Pattern.compile("\\r?\\n? [\\ ]* [*][/] $", 4);
    private static final Pattern SOY_DOC_PARAM = Pattern.compile("(@param [?]?) \\s+ ([a-zA-Z_]\\w*)", 4);
    private String templateName;
    private final String partialTemplateName;
    private final boolean isPrivate;
    private final boolean isOverride;
    private final boolean shouldAutoescape;
    private String soyDoc;
    private String soyDocDesc;
    private List<SoyDocParam> soyDocParams;

    public TemplateNode(String string, String string2, @Nullable String string3) throws SoySyntaxException {
        super(string, "template", string2);
        Matcher matcher = NONATTRIBUTE_TEMPLATE_NAME.matcher(string2);
        if (matcher.find()) {
            string2 = matcher.replaceFirst("name=\"" + matcher.group() + "\"");
        }
        Map<String, String> map = ATTRIBUTES_PARSER.parse(string2);
        this.templateName = map.get("name");
        if (!BaseUtils.isDottedIdentifier(this.templateName)) {
            throw new SoySyntaxException("Invalid template name \"" + this.templateName + "\".");
        }
        if (VALID_V2_NAME.matcher(this.templateName).matches()) {
            this.partialTemplateName = this.templateName;
        } else {
            this.maybeSetSyntaxVersion(SoyNode.SyntaxVersion.V1);
            this.partialTemplateName = null;
        }
        this.isPrivate = map.get("private").equals("true");
        String string4 = map.get("override");
        if (string4 == null) {
            this.isOverride = false;
        } else {
            this.maybeSetSyntaxVersion(SoyNode.SyntaxVersion.V1);
            this.isOverride = string4.equals("true");
        }
        this.shouldAutoescape = map.get("autoescape").equals("true");
        this.soyDoc = string3;
        if (string3 != null) {
            Preconditions.checkArgument((string3.startsWith("/**") && string3.endsWith("*/") ? 1 : 0) != 0);
            String string5 = TemplateNode.cleanSoyDoc(string3);
            this.soyDocDesc = TemplateNode.parseSoyDocDesc(string5);
            this.soyDocParams = TemplateNode.parseSoyDocParams(string5);
        } else {
            this.maybeSetSyntaxVersion(SoyNode.SyntaxVersion.V1);
            this.soyDocDesc = null;
            this.soyDocParams = null;
        }
    }

    private static String cleanSoyDoc(String string) {
        string = NEWLINE.matcher(string).replaceAll("\n");
        string = SOY_DOC_START.matcher(string).replaceFirst("");
        string = SOY_DOC_END.matcher(string).replaceFirst("");
        ArrayList arrayList = Lists.newArrayList((Iterable)Splitter.on((Pattern)NEWLINE).split((CharSequence)string));
        TemplateNode.removeCommonStartChar(arrayList, ' ', true);
        if (TemplateNode.removeCommonStartChar(arrayList, '*', false) == 1) {
            TemplateNode.removeCommonStartChar(arrayList, ' ', true);
        }
        return Joiner.on((char)'\n').join((Iterable)arrayList);
    }

    private static int removeCommonStartChar(List<String> list, char c, boolean bl) {
        int n;
        int n2 = 0;
        boolean bl2 = true;
        do {
            n = 1;
            for (String string : list) {
                if (string.length() == 0) continue;
                n = 0;
                if (string.length() > n2 && string.charAt(n2) == c) continue;
                bl2 = false;
                break;
            }
            if (n != 0) {
                bl2 = false;
            }
            if (!bl2) continue;
            ++n2;
        } while (bl2 && bl);
        if (n2 > 0) {
            for (n = 0; n < list.size(); ++n) {
                String string = list.get(n);
                if (string.length() == 0) continue;
                list.set(n, string.substring(n2));
            }
        }
        return n2;
    }

    private static String parseSoyDocDesc(String string) {
        Matcher matcher = SOY_DOC_PARAM.matcher(string);
        int n = matcher.find() ? matcher.start() : string.length();
        String string2 = string.substring(0, n);
        return CharMatcher.WHITESPACE.trimTrailingFrom((CharSequence)string2);
    }

    private static List<SoyDocParam> parseSoyDocParams(String string) {
        ArrayList arrayList = Lists.newArrayList();
        HashSet hashSet = Sets.newHashSet();
        Matcher matcher = SOY_DOC_PARAM.matcher(string);
        boolean bl = matcher.find();
        while (bl) {
            boolean bl2;
            String string2 = matcher.group(2);
            if (hashSet.contains(string2)) {
                throw new SoySyntaxException("Duplicate declaration of param in SoyDoc: " + string2);
            }
            hashSet.add(string2);
            if (matcher.group(1).equals("@param")) {
                bl2 = true;
            } else if (matcher.group(1).equals("@param?")) {
                bl2 = false;
            } else {
                throw new AssertionError();
            }
            int n = matcher.end();
            bl = matcher.find();
            int n2 = bl ? matcher.start() : string.length();
            String string3 = string.substring(n, n2).trim();
            arrayList.add(new SoyDocParam(string2, bl2, string3));
        }
        return arrayList;
    }

    public void setTemplateName(String string) {
        Preconditions.checkArgument((BaseUtils.isDottedIdentifier(string) && string.charAt(0) != '.' ? 1 : 0) != 0);
        this.templateName = string;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public String getPartialTemplateName() {
        return this.partialTemplateName;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public boolean isOverride() {
        return this.isOverride;
    }

    public boolean shouldAutoescape() {
        return this.shouldAutoescape;
    }

    public void clearSoyDocStrings() {
        this.soyDoc = null;
        this.soyDocDesc = null;
        for (SoyDocParam soyDocParam : this.soyDocParams) {
            soyDocParam.clearDesc();
        }
    }

    public String getSoyDoc() {
        return this.soyDoc;
    }

    public String getSoyDocDesc() {
        return this.soyDocDesc;
    }

    public List<SoyDocParam> getSoyDocParams() {
        return this.soyDocParams;
    }

    @Override
    public String toSourceString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.soyDoc != null) {
            stringBuilder.append(this.soyDoc).append("\n");
        }
        stringBuilder.append(this.getTagString()).append("\n");
        StringBuilder stringBuilder2 = new StringBuilder();
        this.appendSourceStringForChildren(stringBuilder2);
        if (stringBuilder2.charAt(0) == ' ') {
            stringBuilder2.replace(0, 1, "{sp}");
        }
        if (stringBuilder2.charAt((n = stringBuilder2.length()) - 1) == ' ') {
            stringBuilder2.replace(n - 1, n, "{sp}");
        }
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("\n");
        stringBuilder.append("{/template}\n");
        return stringBuilder.toString();
    }

    public static class SoyDocParam {
        public final String key;
        public final boolean isRequired;
        public String desc;

        public SoyDocParam(String string, boolean bl, @Nullable String string2) {
            this.key = string;
            this.isRequired = bl;
            this.desc = string2;
        }

        private void clearDesc() {
            this.desc = null;
        }
    }
}

