/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.tofu.internal;

import com.google.common.collect.Maps;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.template.soy.data.SoyMapData;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.parseinfo.SoyTemplateInfo;
import com.google.template.soy.shared.internal.ApiCallScopeUtils;
import com.google.template.soy.shared.internal.GuiceSimpleScope;
import com.google.template.soy.shared.restricted.ApiCallScopeBindingAnnotations;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.tofu.SoyTofu;
import com.google.template.soy.tofu.SoyTofuException;
import com.google.template.soy.tofu.internal.NamespacedTofu;
import com.google.template.soy.tofu.internal.RenderVisitor;
import java.util.Map;
import javax.annotation.Nullable;

public class BaseTofu
implements SoyTofu {
    private final GuiceSimpleScope apiCallScope;
    private final RenderVisitor.RenderVisitorFactory renderVisitorFactory;
    private final SoyFileSetNode soyTree;
    private final Map<String, TemplateNode> templateMap;

    @AssistedInject
    public BaseTofu(@ApiCallScopeBindingAnnotations.ApiCall GuiceSimpleScope guiceSimpleScope, RenderVisitor.RenderVisitorFactory renderVisitorFactory, @Assisted SoyFileSetNode soyFileSetNode) {
        this.apiCallScope = guiceSimpleScope;
        this.renderVisitorFactory = renderVisitorFactory;
        this.soyTree = soyFileSetNode;
        this.templateMap = Maps.newHashMap();
        for (SoyFileNode soyFileNode : soyFileSetNode.getChildren()) {
            for (TemplateNode templateNode : soyFileNode.getChildren()) {
                this.templateMap.put(templateNode.getTemplateName(), templateNode);
            }
        }
    }

    @Override
    public String getNamespace() {
        return null;
    }

    @Override
    public SoyTofu forNamespace(@Nullable String string) {
        return string == null ? this : new NamespacedTofu(this, string);
    }

    @Override
    public String render(SoyTemplateInfo soyTemplateInfo, @Nullable Map<String, ?> map, @Nullable SoyMsgBundle soyMsgBundle) {
        return this.render(soyTemplateInfo.getName(), map, soyMsgBundle);
    }

    @Override
    public String render(SoyTemplateInfo soyTemplateInfo, @Nullable SoyMapData soyMapData, @Nullable SoyMsgBundle soyMsgBundle) {
        return this.render(soyTemplateInfo.getName(), soyMapData, soyMsgBundle);
    }

    @Override
    public String render(String string, @Nullable Map<String, ?> map, @Nullable SoyMsgBundle soyMsgBundle) {
        return this.render(string, map == null ? null : new SoyMapData(map), soyMsgBundle);
    }

    @Override
    public String render(String string, @Nullable SoyMapData soyMapData, @Nullable SoyMsgBundle soyMsgBundle) {
        return this.renderMain(string, soyMapData, soyMsgBundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String renderMain(String string, @Nullable SoyMapData soyMapData, @Nullable SoyMsgBundle soyMsgBundle) {
        StringBuilder stringBuilder = new StringBuilder();
        this.apiCallScope.enter();
        try {
            ApiCallScopeUtils.seedSharedParams(this.apiCallScope, soyMsgBundle, 0);
            this.renderInternal(stringBuilder, string, soyMapData);
        }
        finally {
            this.apiCallScope.exit();
        }
        return stringBuilder.toString();
    }

    void renderInternal(StringBuilder stringBuilder, String string, @Nullable SoyMapData soyMapData) {
        TemplateNode templateNode = this.templateMap.get(string);
        if (templateNode == null) {
            throw new SoyTofuException("Attempting to render undefined template '" + string + "'.");
        }
        this.renderVisitorFactory.create(stringBuilder, this, soyMapData, null).exec(templateNode);
    }

    public static interface BaseTofuFactory {
        public BaseTofu create(SoyFileSetNode var1);
    }
}

