/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.tofu.internal;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.SoyMapData;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.CollectionData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.data.restricted.UndefinedData;
import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.DataRefIndexNode;
import com.google.template.soy.exprtree.DataRefKeyNode;
import com.google.template.soy.exprtree.DataRefNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.shared.internal.ImpureFunction;
import com.google.template.soy.tofu.SoyTofuException;
import com.google.template.soy.tofu.restricted.SoyTofuFunction;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Map;
import javax.annotation.Nullable;

class EvalVisitor
extends AbstractExprNodeVisitor<SoyData> {
    private final Map<String, SoyTofuFunction> soyTofuFunctionsMap;
    private final SoyMapData data;
    private final Deque<Map<String, SoyData>> env;
    private Deque<SoyData> resultStack;

    @AssistedInject
    EvalVisitor(Map<String, SoyTofuFunction> map, @Assisted @Nullable SoyMapData soyMapData, @Assisted Deque<Map<String, SoyData>> deque) {
        this.soyTofuFunctionsMap = map;
        this.data = soyMapData;
        this.env = deque;
    }

    @Override
    protected void setup() {
        this.resultStack = new ArrayDeque<SoyData>();
    }

    @Override
    protected SoyData getResult() {
        return this.resultStack.peek();
    }

    @Override
    protected void visitInternal(ExprRootNode<? extends ExprNode> exprRootNode) {
        this.visitChildren(exprRootNode);
    }

    @Override
    protected void visitInternal(NullNode nullNode) {
        this.resultStack.push(NullData.INSTANCE);
    }

    @Override
    protected void visitInternal(BooleanNode booleanNode) {
        this.pushResult(booleanNode.getValue());
    }

    @Override
    protected void visitInternal(IntegerNode integerNode) {
        this.pushResult(integerNode.getValue());
    }

    @Override
    protected void visitInternal(FloatNode floatNode) {
        this.pushResult(floatNode.getValue());
    }

    @Override
    protected void visitInternal(StringNode stringNode) {
        this.pushResult(stringNode.getValue());
    }

    @Override
    protected void visitInternal(DataRefNode dataRefNode) {
        SoyData soyData;
        String string = ((DataRefKeyNode)dataRefNode.getChild(0)).getKey();
        SoyData soyData2 = this.getVarOrDataKey(string);
        if (dataRefNode.numChildren() == 1) {
            this.resultStack.push(soyData2);
            return;
        }
        ArrayList arrayList = Lists.newArrayList();
        for (int i = 1; i < dataRefNode.numChildren(); ++i) {
            ExprNode exprNode = dataRefNode.getChild(i);
            this.visit(exprNode);
            arrayList.add(this.resultStack.pop().toString());
        }
        SoyData soyData3 = soyData = soyData2 instanceof CollectionData ? ((CollectionData)soyData2).get(Joiner.on((char)'.').join((Iterable)arrayList)) : null;
        if (soyData != null) {
            this.resultStack.push(soyData);
        } else {
            this.resultStack.push(new UndefinedData());
        }
    }

    @Override
    protected void visitInternal(DataRefKeyNode dataRefKeyNode) {
        this.pushResult(dataRefKeyNode.getKey());
    }

    @Override
    protected void visitInternal(DataRefIndexNode dataRefIndexNode) {
        this.pushResult(dataRefIndexNode.getIndex());
    }

    @Override
    protected void visitInternal(GlobalNode globalNode) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void visitInternal(OperatorNodes.NegativeOpNode negativeOpNode) {
        this.visitChildren(negativeOpNode);
        SoyData soyData = this.resultStack.pop();
        if (soyData instanceof IntegerData) {
            this.pushResult(-soyData.integerValue());
        } else {
            this.pushResult(-soyData.floatValue());
        }
    }

    @Override
    protected void visitInternal(OperatorNodes.NotOpNode notOpNode) {
        this.visitChildren(notOpNode);
        SoyData soyData = this.resultStack.pop();
        this.pushResult(!soyData.toBoolean());
    }

    @Override
    protected void visitInternal(OperatorNodes.TimesOpNode timesOpNode) {
        this.visitChildren(timesOpNode);
        SoyData soyData = this.resultStack.pop();
        SoyData soyData2 = this.resultStack.pop();
        if (soyData2 instanceof IntegerData && soyData instanceof IntegerData) {
            this.pushResult(soyData2.integerValue() * soyData.integerValue());
        } else {
            this.pushResult(soyData2.numberValue() * soyData.numberValue());
        }
    }

    @Override
    protected void visitInternal(OperatorNodes.DivideByOpNode divideByOpNode) {
        this.visitChildren(divideByOpNode);
        SoyData soyData = this.resultStack.pop();
        SoyData soyData2 = this.resultStack.pop();
        this.pushResult(soyData2.numberValue() / soyData.numberValue());
    }

    @Override
    protected void visitInternal(OperatorNodes.ModOpNode modOpNode) {
        this.visitChildren(modOpNode);
        SoyData soyData = this.resultStack.pop();
        SoyData soyData2 = this.resultStack.pop();
        this.pushResult(soyData2.integerValue() % soyData.integerValue());
    }

    @Override
    protected void visitInternal(OperatorNodes.PlusOpNode plusOpNode) {
        this.visitChildren(plusOpNode);
        SoyData soyData = this.resultStack.pop();
        SoyData soyData2 = this.resultStack.pop();
        if (soyData2 instanceof IntegerData && soyData instanceof IntegerData) {
            this.pushResult(soyData2.integerValue() + soyData.integerValue());
        } else if (soyData2 instanceof StringData || soyData instanceof StringData) {
            this.pushResult(soyData2.toString() + soyData.toString());
        } else {
            this.pushResult(soyData2.numberValue() + soyData.numberValue());
        }
    }

    @Override
    protected void visitInternal(OperatorNodes.MinusOpNode minusOpNode) {
        this.visitChildren(minusOpNode);
        SoyData soyData = this.resultStack.pop();
        SoyData soyData2 = this.resultStack.pop();
        if (soyData2 instanceof IntegerData && soyData instanceof IntegerData) {
            this.pushResult(soyData2.integerValue() - soyData.integerValue());
        } else {
            this.pushResult(soyData2.numberValue() - soyData.numberValue());
        }
    }

    @Override
    protected void visitInternal(OperatorNodes.LessThanOpNode lessThanOpNode) {
        this.visitChildren(lessThanOpNode);
        SoyData soyData = this.resultStack.pop();
        SoyData soyData2 = this.resultStack.pop();
        if (soyData2 instanceof IntegerData && soyData instanceof IntegerData) {
            this.pushResult(soyData2.integerValue() < soyData.integerValue());
        } else {
            this.pushResult(soyData2.numberValue() < soyData.numberValue());
        }
    }

    @Override
    protected void visitInternal(OperatorNodes.GreaterThanOpNode greaterThanOpNode) {
        this.visitChildren(greaterThanOpNode);
        SoyData soyData = this.resultStack.pop();
        SoyData soyData2 = this.resultStack.pop();
        if (soyData2 instanceof IntegerData && soyData instanceof IntegerData) {
            this.pushResult(soyData2.integerValue() > soyData.integerValue());
        } else {
            this.pushResult(soyData2.numberValue() > soyData.numberValue());
        }
    }

    @Override
    protected void visitInternal(OperatorNodes.LessThanOrEqualOpNode lessThanOrEqualOpNode) {
        this.visitChildren(lessThanOrEqualOpNode);
        SoyData soyData = this.resultStack.pop();
        SoyData soyData2 = this.resultStack.pop();
        if (soyData2 instanceof IntegerData && soyData instanceof IntegerData) {
            this.pushResult(soyData2.integerValue() <= soyData.integerValue());
        } else {
            this.pushResult(soyData2.numberValue() <= soyData.numberValue());
        }
    }

    @Override
    protected void visitInternal(OperatorNodes.GreaterThanOrEqualOpNode greaterThanOrEqualOpNode) {
        this.visitChildren(greaterThanOrEqualOpNode);
        SoyData soyData = this.resultStack.pop();
        SoyData soyData2 = this.resultStack.pop();
        if (soyData2 instanceof IntegerData && soyData instanceof IntegerData) {
            this.pushResult(soyData2.integerValue() >= soyData.integerValue());
        } else {
            this.pushResult(soyData2.numberValue() >= soyData.numberValue());
        }
    }

    @Override
    protected void visitInternal(OperatorNodes.EqualOpNode equalOpNode) {
        this.visitChildren(equalOpNode);
        SoyData soyData = this.resultStack.pop();
        SoyData soyData2 = this.resultStack.pop();
        this.pushResult(soyData2.equals(soyData));
    }

    @Override
    protected void visitInternal(OperatorNodes.NotEqualOpNode notEqualOpNode) {
        this.visitChildren(notEqualOpNode);
        SoyData soyData = this.resultStack.pop();
        SoyData soyData2 = this.resultStack.pop();
        this.pushResult(!soyData2.equals(soyData));
    }

    @Override
    protected void visitInternal(OperatorNodes.AndOpNode andOpNode) {
        this.visit(andOpNode.getChild(0));
        SoyData soyData = this.resultStack.pop();
        if (!soyData.toBoolean()) {
            this.pushResult(false);
        } else {
            this.visit(andOpNode.getChild(1));
            SoyData soyData2 = this.resultStack.pop();
            this.pushResult(soyData2.toBoolean());
        }
    }

    @Override
    protected void visitInternal(OperatorNodes.OrOpNode orOpNode) {
        this.visit(orOpNode.getChild(0));
        SoyData soyData = this.resultStack.pop();
        if (soyData.toBoolean()) {
            this.pushResult(true);
        } else {
            this.visit(orOpNode.getChild(1));
            SoyData soyData2 = this.resultStack.pop();
            this.pushResult(soyData2.toBoolean());
        }
    }

    @Override
    protected void visitInternal(OperatorNodes.ConditionalOpNode conditionalOpNode) {
        this.visit(conditionalOpNode.getChild(0));
        SoyData soyData = this.resultStack.pop();
        if (soyData.toBoolean()) {
            this.visit(conditionalOpNode.getChild(1));
        } else {
            this.visit(conditionalOpNode.getChild(2));
        }
    }

    @Override
    protected void visitInternal(FunctionNode functionNode) {
        String string = functionNode.getFunctionName();
        int n = functionNode.numChildren();
        ImpureFunction impureFunction = ImpureFunction.forFunctionName(string);
        if (impureFunction != null) {
            if (n != impureFunction.getNumArgs()) {
                throw new SoyTofuException("Function '" + string + "' called with the wrong number of arguments" + " (function call \"" + functionNode.toSourceString() + "\").");
            }
            switch (impureFunction) {
                case IS_FIRST: {
                    this.visitIsFirstFunction(functionNode);
                    return;
                }
                case IS_LAST: {
                    this.visitIsLastFunction(functionNode);
                    return;
                }
                case INDEX: {
                    this.visitIndexFunction(functionNode);
                    return;
                }
                case HAS_DATA: {
                    this.visitHasDataFunction();
                    return;
                }
            }
            throw new AssertionError();
        }
        SoyTofuFunction soyTofuFunction = this.soyTofuFunctionsMap.get(string);
        if (soyTofuFunction != null) {
            if (!soyTofuFunction.getValidArgsSizes().contains(n)) {
                throw new SoyTofuException("Function '" + string + "' called with the wrong number of arguments" + " (function call \"" + functionNode.toSourceString() + "\").");
            }
            ArrayList arrayList = Lists.newArrayList();
            for (ExprNode exprNode : functionNode.getChildren()) {
                this.visit(exprNode);
                arrayList.add(this.resultStack.pop());
            }
            try {
                this.resultStack.push(soyTofuFunction.computeForTofu(arrayList));
            }
            catch (Exception exception) {
                throw new SoyTofuException("Error while evaluating function \"" + functionNode.toSourceString() + "\": " + exception.getMessage());
            }
            return;
        }
        throw new SoyTofuException("Failed to find SoyTofuFunction with name '" + string + "'" + " (function call \"" + functionNode.toSourceString() + "\").");
    }

    private void visitIsFirstFunction(FunctionNode functionNode) {
        int n;
        try {
            DataRefNode dataRefNode = (DataRefNode)functionNode.getChild(0);
            String string = ((DataRefKeyNode)dataRefNode.getChild(0)).getKey();
            n = this.getVarOrDataKey(string + "__index").integerValue();
        }
        catch (Exception exception) {
            throw new SoyTofuException("Failed to evaluate function call " + functionNode.toSourceString() + ".");
        }
        this.pushResult(n == 0);
    }

    private void visitIsLastFunction(FunctionNode functionNode) {
        int n;
        int n2;
        try {
            DataRefNode dataRefNode = (DataRefNode)functionNode.getChild(0);
            String string = ((DataRefKeyNode)dataRefNode.getChild(0)).getKey();
            n2 = this.getVarOrDataKey(string + "__index").integerValue();
            n = this.getVarOrDataKey(string + "__lastIndex").integerValue();
        }
        catch (Exception exception) {
            throw new SoyTofuException("Failed to evaluate function call " + functionNode.toSourceString() + ".");
        }
        this.pushResult(n2 == n);
    }

    private void visitIndexFunction(FunctionNode functionNode) {
        int n;
        try {
            DataRefNode dataRefNode = (DataRefNode)functionNode.getChild(0);
            String string = ((DataRefKeyNode)dataRefNode.getChild(0)).getKey();
            n = this.getVarOrDataKey(string + "__index").integerValue();
        }
        catch (Exception exception) {
            throw new SoyTofuException("Failed to evaluate function call " + functionNode.toSourceString() + ".");
        }
        this.pushResult(n);
    }

    private void visitHasDataFunction() {
        this.pushResult(this.data != null);
    }

    private void pushResult(boolean bl) {
        this.resultStack.push(new BooleanData(bl));
    }

    private void pushResult(int n) {
        this.resultStack.push(new IntegerData(n));
    }

    private void pushResult(double d) {
        this.resultStack.push(new FloatData(d));
    }

    private void pushResult(String string) {
        this.resultStack.push(new StringData(string));
    }

    private SoyData getVarOrDataKey(String string) {
        SoyData soyData = null;
        for (Map<String, SoyData> map : this.env) {
            soyData = map.get(string);
            if (soyData == null) continue;
            return soyData;
        }
        soyData = this.data.get(string);
        if (soyData != null) {
            return soyData;
        }
        return new UndefinedData();
    }

    static interface EvalVisitorFactory {
        public EvalVisitor create(@Nullable SoyMapData var1, Deque<Map<String, SoyData>> var2);
    }
}

