/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.tofu.internal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.SoyListData;
import com.google.template.soy.data.SoyMapData;
import com.google.template.soy.data.internal.AugmentedSoyMapData;
import com.google.template.soy.data.restricted.CollectionData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.UndefinedData;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.internal.MsgUtils;
import com.google.template.soy.msgs.restricted.SoyMsg;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.google.template.soy.msgs.restricted.SoyMsgPlaceholderPart;
import com.google.template.soy.msgs.restricted.SoyMsgRawTextPart;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForeachIfemptyNode;
import com.google.template.soy.soytree.ForeachNode;
import com.google.template.soy.soytree.ForeachNonemptyNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.tofu.SoyTofuException;
import com.google.template.soy.tofu.internal.BaseTofu;
import com.google.template.soy.tofu.internal.EvalVisitor;
import com.google.template.soy.tofu.restricted.SoyTofuPrintDirective;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class RenderVisitor
extends AbstractSoyNodeVisitor<Void> {
    Map<String, SoyTofuPrintDirective> soyTofuDirectivesMap;
    private final RenderVisitorFactory renderVisitorFactory;
    private final StringBuilder outputSb;
    private final BaseTofu baseTofu;
    private final SoyMapData data;
    private final Deque<Map<String, SoyData>> env;
    private final SoyMsgBundle msgBundle;
    private final EvalVisitor evalVisitor;
    private SoyListData foreachList;

    @AssistedInject
    RenderVisitor(Map<String, SoyTofuPrintDirective> map, EvalVisitor.EvalVisitorFactory evalVisitorFactory, RenderVisitorFactory renderVisitorFactory, @Assisted StringBuilder stringBuilder, @Assisted @Nullable BaseTofu baseTofu, @Assisted @Nullable SoyMapData soyMapData, @Assisted @Nullable Deque<Map<String, SoyData>> arrayDeque, @Nullable SoyMsgBundle soyMsgBundle) {
        this.soyTofuDirectivesMap = map;
        this.renderVisitorFactory = renderVisitorFactory;
        this.outputSb = stringBuilder;
        this.baseTofu = baseTofu;
        this.data = soyMapData;
        this.env = arrayDeque != null ? arrayDeque : new ArrayDeque();
        this.msgBundle = soyMsgBundle;
        this.evalVisitor = evalVisitorFactory.create(this.data, this.env);
    }

    @Override
    protected void visitInternal(RawTextNode rawTextNode) {
        this.outputSb.append(rawTextNode.getRawText());
    }

    @Override
    protected void visitInternal(MsgNode msgNode) {
        SoyMsg soyMsg;
        this.env.push(Maps.newHashMap());
        long l = MsgUtils.computeMsgId(msgNode);
        SoyMsg soyMsg2 = soyMsg = this.msgBundle == null ? null : this.msgBundle.getMsg(l);
        if (soyMsg != null) {
            for (SoyMsgPart soyMsgPart : soyMsg.getParts()) {
                if (soyMsgPart instanceof SoyMsgRawTextPart) {
                    this.outputSb.append(((SoyMsgRawTextPart)soyMsgPart).getRawText());
                    continue;
                }
                if (soyMsgPart instanceof SoyMsgPlaceholderPart) {
                    String string = ((SoyMsgPlaceholderPart)soyMsgPart).getPlaceholderName();
                    this.visit(msgNode.getPlaceholderNode(string));
                    continue;
                }
                throw new AssertionError();
            }
        } else {
            this.visitChildren(msgNode);
        }
        this.env.pop();
    }

    @Override
    protected void visitInternal(MsgHtmlTagNode msgHtmlTagNode) {
        this.visitChildren(msgHtmlTagNode);
    }

    @Override
    protected void visitInternal(PrintNode printNode) {
        SoyData soyData = this.eval(printNode.getExpr());
        if (soyData instanceof UndefinedData) {
            throw new SoyTofuException("In 'print' tag, expression \"" + printNode.getExprText() + "\" evaluates to undefined.");
        }
        String string = soyData.toString();
        for (PrintDirectiveNode printDirectiveNode : printNode.getChildren()) {
            SoyTofuPrintDirective soyTofuPrintDirective = this.soyTofuDirectivesMap.get(printDirectiveNode.getName());
            if (soyTofuPrintDirective == null) {
                throw new SoyTofuException("Failed to find SoyTofuPrintDirective with name '" + printDirectiveNode.getName() + "'" + " (tag " + printNode.toSourceString() + ")");
            }
            List<ExprRootNode<ExprNode>> list = printDirectiveNode.getArgs();
            if (!soyTofuPrintDirective.getValidArgsSizes().contains(list.size())) {
                throw new SoyTofuException("Print directive '" + printDirectiveNode.getName() + "' used with the wrong number of" + " arguments (tag " + printNode.toSourceString() + ").");
            }
            ArrayList arrayList = Lists.newArrayListWithCapacity((int)list.size());
            for (ExprRootNode<ExprNode> exprRootNode : list) {
                arrayList.add(this.evalVisitor.exec(exprRootNode));
            }
            string = soyTofuPrintDirective.applyForTofu(string, arrayList);
        }
        this.outputSb.append(string);
    }

    @Override
    protected void visitInternal(IfNode ifNode) {
        for (SoyNode soyNode : ifNode.getChildren()) {
            if (soyNode instanceof IfCondNode) {
                IfCondNode ifCondNode = (IfCondNode)soyNode;
                if (!this.eval(ifCondNode.getExpr()).toBoolean()) continue;
                this.visit(ifCondNode);
                return;
            }
            if (soyNode instanceof IfElseNode) {
                this.visit((IfElseNode)soyNode);
                return;
            }
            throw new AssertionError();
        }
    }

    @Override
    protected void visitInternal(SwitchNode switchNode) {
        SoyData soyData = this.eval(switchNode.getExpr());
        for (SoyNode soyNode : switchNode.getChildren()) {
            if (soyNode instanceof SwitchCaseNode) {
                SwitchCaseNode switchCaseNode = (SwitchCaseNode)soyNode;
                for (ExprRootNode<ExprNode> exprRootNode : switchCaseNode.getExprList()) {
                    if (!soyData.equals(this.eval(exprRootNode))) continue;
                    this.visit(switchCaseNode);
                    return;
                }
                continue;
            }
            if (soyNode instanceof SwitchDefaultNode) {
                this.visit((SwitchDefaultNode)soyNode);
                return;
            }
            throw new AssertionError();
        }
    }

    @Override
    protected void visitInternal(ForeachNode foreachNode) {
        SoyData soyData = this.eval(foreachNode.getDataRef());
        if (!(soyData instanceof SoyListData)) {
            throw new SoyTofuException("In 'foreach' command " + foreachNode.toSourceString() + ", the data reference does not resolve to a SoyListData.");
        }
        this.foreachList = (SoyListData)soyData;
        if (this.foreachList.length() > 0) {
            this.visit((ForeachNonemptyNode)foreachNode.getChild(0));
        } else if (foreachNode.numChildren() == 2) {
            this.visit((ForeachIfemptyNode)foreachNode.getChild(1));
        }
    }

    @Override
    protected void visitInternal(ForeachNonemptyNode foreachNonemptyNode) {
        SoyListData soyListData = this.foreachList;
        this.foreachList = null;
        String string = foreachNonemptyNode.getVarName();
        HashMap hashMap = Maps.newHashMap();
        hashMap.put(string + "__lastIndex", new IntegerData(soyListData.length() - 1));
        this.env.push(hashMap);
        for (int i = 0; i < soyListData.length(); ++i) {
            hashMap.put(string + "__index", new IntegerData(i));
            hashMap.put(string, soyListData.get(i));
            this.visitChildren(foreachNonemptyNode);
        }
        this.env.pop();
    }

    @Override
    protected void visitInternal(ForNode forNode) {
        ArrayList arrayList = Lists.newArrayList();
        for (ExprRootNode<ExprNode> exprRootNode : forNode.getRangeArgs()) {
            SoyData soyData = this.eval(exprRootNode);
            if (!(soyData instanceof IntegerData)) {
                throw new SoyTofuException("In 'for' command " + forNode.toSourceString() + ", the expression \"" + exprRootNode.toSourceString() + "\" does not resolve to an integer.");
            }
            arrayList.add(((IntegerData)soyData).getValue());
        }
        int n = arrayList.size() == 3 ? (Integer)arrayList.remove(2) : 1;
        int n2 = arrayList.size() == 2 ? (Integer)arrayList.remove(0) : 0;
        int n3 = (Integer)arrayList.get(0);
        String string = forNode.getLocalVarName();
        HashMap hashMap = Maps.newHashMap();
        this.env.push(hashMap);
        for (int i = n2; i < n3; i += n) {
            hashMap.put(string, new IntegerData(i));
            this.visitChildren(forNode);
        }
        this.env.pop();
    }

    @Override
    protected void visitInternal(CallNode callNode) {
        SoyData soyData;
        SoyMapData soyMapData;
        if (callNode.isPassingAllData()) {
            soyMapData = this.data;
        } else if (callNode.isPassingData()) {
            soyData = this.eval(callNode.getDataRef());
            if (!(soyData instanceof SoyMapData)) {
                throw new SoyTofuException("In 'call' command " + callNode.toSourceString() + ", the data reference does not resolve to a SoyMapData.");
            }
            soyMapData = (SoyMapData)soyData;
        } else {
            soyMapData = null;
        }
        soyData = !callNode.isPassingData() ? new SoyMapData() : (callNode.numChildren() == 0 ? soyMapData : new AugmentedSoyMapData(soyMapData));
        for (CallParamNode callParamNode : callNode.getChildren()) {
            Object object;
            CallParamNode callParamNode2;
            if (callParamNode instanceof CallParamValueNode) {
                callParamNode2 = (CallParamValueNode)callParamNode;
                object = this.eval(((CallParamValueNode)callParamNode2).getValueExpr());
                ((CollectionData)soyData).put(((CallParamValueNode)callParamNode2).getKey(), (SoyData)object);
                continue;
            }
            if (callParamNode instanceof CallParamContentNode) {
                callParamNode2 = (CallParamContentNode)callParamNode;
                object = new StringBuilder();
                RenderVisitor renderVisitor = this.renderVisitorFactory.create((StringBuilder)object, this.baseTofu, this.data, this.env);
                renderVisitor.visit(callParamNode2);
                ((CollectionData)soyData).put(((CallParamContentNode)callParamNode2).getKey(), ((StringBuilder)object).toString());
                continue;
            }
            throw new AssertionError();
        }
        this.baseTofu.renderInternal(this.outputSb, callNode.getCalleeName(), (SoyMapData)soyData);
    }

    @Override
    protected void visitInternal(SoyNode.ParentSoyNode<? extends SoyNode> parentSoyNode) {
        this.env.push(Maps.newHashMap());
        this.visitChildren(parentSoyNode);
        this.env.pop();
    }

    private SoyData eval(ExprNode exprNode) {
        try {
            return (SoyData)this.evalVisitor.exec(exprNode);
        }
        catch (Exception exception) {
            throw new SoyTofuException("When evaluating \"" + exprNode.toSourceString() + "\": " + exception.getMessage());
        }
    }

    public static interface RenderVisitorFactory {
        public RenderVisitor create(StringBuilder var1, BaseTofu var2, @Nullable SoyMapData var3, @Nullable Deque<Map<String, SoyData>> var4);
    }
}

