(ns clean-up)

(defn -main [& args]
  (let [res-path (first args)]
    (if res-path
      (let [res-dir (clojure.java.io/file res-path)
            js-files (mapv str (filter (fn [v]
                                         (and (.isFile v)
                                              (clojure.string/includes? (str v)
                                                                        ".js")))
                                       (file-seq res-dir)))]
        (doseq [js-file js-files]
          (let [parsed-file (slurp js-file)]
            (when (clojure.string/includes? parsed-file "cljs.core.load_file(\"resources\\\\public\\\\js")
              (spit js-file (clojure.string/replace parsed-file
                                                    #"cljs\.core\.load_file\(\"resources\\\\public\\\\js"
                                                    (fn [m]
                                                      (clojure.string/re-quote-replacement "cljs.core.load_file(\"resources\\app\\resources\\public\\js"))))))))
      (println "Missing resource path"))))

(try (require 'leiningen.exec)
     (when @(ns-resolve 'leiningen.exec '*running?*)
       (apply -main (rest *command-line-args*)))
     (catch java.io.FileNotFoundException e))
;resources \\ \\ app \\ \\