(defproject {{name}} "1.0.0"
  :description ""
  :url ""
  :min-lein-version "2.7.1"

  :dependencies [[org.clojure/clojure "1.9.0"]
                 [org.clojure/clojurescript "1.10.339" :exclusions [org.apache.ant/ant]]
                 [org.clojure/core.async "0.4.474"]
                 [cljsjs/nodejs-externs "1.0.4-1"]
                 [cljs-http "0.1.44"]
                 [re-frame "0.10.6"]
                 [cljsjs/react-bootstrap "0.31.5-0"]
                 [cljsjs/react-datepicker "1.5.0-0"]]

  :plugins [[lein-cljsbuild "1.1.7" :exclusions [[org.clojure/clojure]]]
            [lein-shell "0.5.0"]
            [lein-externs "0.1.6"]
            [lein-figwheel "0.5.16" :exclusions [org.clojure/core.cache]]
            [lein-exec "0.3.7"]]

  :source-paths ["src"]

  :cljsbuild {:builds
              [{:id           "main-dev"
                :source-paths ["src/main" "src/shared"]
                :figwheel     {:on-jsload "{{name}}.core/reload"}
                :compiler     {:main           {{name}}.core
                               :output-to      "resources/main.js"
                               :output-dir     "resources/public/js/main-dev"
                               :optimizations  :none
                               :install-deps   true
                               :target         :nodejs
                               :parallel-build true
                               :source-map     true
                               :npm-deps       {:electron "3.0.3"
                                                :ws       "3.3.1"}}}

               {:id           "main"
                :source-paths ["src/main" "src/shared"]
                :compiler     {:main           {{name}}.core
                               :optimizations  :none
                               :output-to      "resources/main.js"
                               :output-dir     "resources/public/js/main-out"
                               :asset-path "resources/app/resources/public/js/main-out"
                               :install-deps   true
                               :target         :nodejs
                               :parallel-build true
                               :process-shim   true
                               :pretty-print   false
                               :npm-deps       {:electron "3.0.3"}}}

               {:id           "ui-dev"
                :source-paths ["src/ui" "src/shared"]
                :figwheel     true
                :compiler     {:main           {{name}}.core
                               :output-to      "resources/public/js/ui.js"
                               :output-dir     "resources/public/js/ui-dev"
                               :closure-defines {"re_frame.trace.trace_enabled_QMARK_" true}
                               :preloads [day8.re-frame-10x.preload]
                               :optimizations  :none
                               :install-deps   true
                               :hashbang       false
                               :target         :nodejs
                               :parallel-build true
                               :source-map     true
                               :npm-deps       {:electron              "3.0.3"
                                                :react                 "15.5.4"
                                                :react-dom             "15.5.4"
                                                :electron-default-menu "1.0.1"
                                                :create-react-class    "15.5.3"}}}

               {:id           "ui"
                :source-paths ["src/ui" "src/shared"]
                :compiler     {:main           {{name}}.core
                               :optimizations  :none
                               :output-to      "resources/public/js/ui.js"
                               :output-dir     "resources/public/js/ui-out"
                               :asset-path "resources/app/resources/public/js/ui-out/"
                               :install-deps   true
                               :target         :nodejs
                               :hashbang       false
                               :parallel-build true
                               :process-shim   true
                               :pretty-print   false
                               :npm-deps       {:electron              "3.0.3"
                                                :react                 "15.5.4"
                                                :react-dom             "15.5.4"
                                                :electron-default-menu "1.0.1"
                                                :create-react-class    "15.5.3"}}}

               {:id           "worker-dev"
                :source-paths ["src/worker" "src/shared"]
                :figwheel     true
                :compiler     {:main           {{name}}.core
                               :output-to      "resources/public/js/worker.js"
                               :output-dir     "resources/public/js/worker-dev"
                               :optimizations  :none
                               :install-deps   true
                               :hashbang       false
                               :target         :nodejs
                               :parallel-build true
                               :npm-deps       {:electron "3.0.3"}}}

               {:id           "worker"
                :source-paths ["src/worker" "src/shared"]
                :compiler     {:main           {{name}}.core
                               :optimizations  :none
                               :output-to      "resources/public/js/worker.js"
                               :output-dir     "resources/public/js/worker-out"
                               :asset-path "resources/app/resources/public/js/worker-out/"
                               :install-deps   true
                               :hashbang       false
                               :process-shim   true
                               :target         :nodejs
                               :parallel-build true
                               :npm-deps       {:electron "3.0.3"}}}]}

  :aliases {"electron" ["shell" "node_modules/.bin/electron.cmd" "resources/main.js"]
            "build"    ["do" "clean" ["cljsbuild" "once" "worker" "main" "ui"]]
            "start"    ["do" "clean" ["figwheel" "main-dev" "worker-dev" "ui-dev"]]
            "uberapp-win64" ["do"
                             ["shell" "bash" "build-win64.sh"]
                             ["exec" "clean_up.clj" "release/{{name}}-win32-x64/resources/app/resources"]]}

  :figwheel {:css-dirs         ["resources/public/css"]
             :nrepl-port       7888
             :nrepl-middleware ["cider.nrepl/cider-middleware"
                                "cemerick.piggieback/wrap-cljs-repl"]}

  ;; Setting up nREPL for Figwheel and ClojureScript dev
  ;; Please see:
  ;; https://github.com/bhauman/lein-figwheel/wiki/Using-the-Figwheel-REPL-within-NRepl
  :profiles {:dev {:dependencies [[cider/piggieback "0.3.8"]
                                  [figwheel-sidecar "0.5.16"]
                                  [day8.re-frame/re-frame-10x "0.3.3"]]
                   ;; need to add dev source path here to get user.clj loaded
                   :source-paths ["src/ui" "src/main" "src/worker" "dev"]
                   :plugins      [[cider/cider-nrepl "0.18.0-SNAPSHOT"]]
                   :repl-options {:nrepl-middleware [cider.piggieback/wrap-cljs-repl]}

                   :clean-targets ^{:protect false} ["resources/main.js"
                                                     "resources/public/js"
                                                     :target-path]}})
