(ns {{name}}.bootstrap
  (:require cljsjs.react-bootstrap
            cljsjs.react-datepicker))

(def react-bootstrap js/ReactBootstrap)
(def nav-container (aget react-bootstrap "Nav"))
(def nav-item (aget react-bootstrap "NavItem"))
(def nav-bar (aget react-bootstrap "Navbar"))
(def nav-header (aget nav-bar "Header"))
(def nav-brand (aget react-bootstrap "NavbarBrand"))
(def nav-toogle (aget nav-bar "Toggle"))
(def nav-collapse (aget nav-bar "Collapse"))
(def nav-dropdown (aget react-bootstrap "NavDropdown"))
(def img (aget react-bootstrap "Image"))
(def thumb (aget react-bootstrap "Thumbnail"))
(def well (aget react-bootstrap "Well"))
(def panel (aget react-bootstrap "Panel"))
(def panel-group (aget react-bootstrap "PanelGroup"))
(def panel-header (aget panel "Heading"))
(def panel-body (aget panel "Body"))
(def collapse (aget react-bootstrap "Collapse"))
(def panel-title (aget panel "Title"))
(def header (aget react-bootstrap "PageHeader"))
(def grid (aget react-bootstrap "Grid"))
(def row (aget react-bootstrap "Row"))
(def col (aget react-bootstrap "Col"))
(def form (aget react-bootstrap "Form"))
(def form-group (aget react-bootstrap "FormGroup"))
(def control-label (aget react-bootstrap "ControlLabel"))
(def form-control (aget react-bootstrap "FormControl"))
(def button (aget react-bootstrap "Button"))
(def label (aget react-bootstrap "Label"))
(def modal (aget react-bootstrap "Modal"))
(def modal-header (aget modal "Header"))
(def modal-title (aget modal "Title"))
(def modal-body (aget modal "Body"))
(def glyphicon (aget react-bootstrap "Glyphicon"))
(def table (aget react-bootstrap "Table"))
(def tabs (aget react-bootstrap "Tabs"))
(def tab (aget react-bootstrap "Tab"))
(def toggle-group (aget react-bootstrap "ToggleButtonGroup"))
(def togglebutton (aget react-bootstrap "ToggleButton"))
(def progress-bar (aget react-bootstrap "ProgressBar"))
(def checkbox (aget react-bootstrap "Checkbox"))

(defn header-subheader [main sub]
  [:> header [:small sub]])

(defn header-small [name]
  [:> header [:small name]])

(defn multiline-well [lines]
  [:> well (for [line lines]
             ^{:key line} [:div line])])

(defn simple-panel
  [id title body]
  [:> panel {:id id}
   [:> panel-header
    [:> panel-title
     title]]
   [:> panel-body
    body]])

(defn collab-panel [pref id title body]
  [:> panel {:id (str pref id)
             :eventKey id}
   [:> panel-header
    [:> panel-title {:toggle true}
     title]]
   [:> panel-body {:collapsible true}
    body]])

(defn form-element
  ([c-id label-val type placeholder id value change-fn style]
   [:> form-group
    [:> control-label label-val]
    [:> form-control {:type type
                      :placeholder placeholder
                      :id id
                      :value value
                      :style style
                      :on-change change-fn}]])
  ([c-id label-val type placeholder id value change-fn]
   [:> form-group
    [:> control-label label-val]
    [:> form-control {:type type
                      :placeholder placeholder
                      :id id
                      :value value
                      :on-change change-fn}]]))

(defn form-element-uncontrolled
  ([label-val type placeholder id change-fn style]
   [:> form-group
    [:> control-label label-val]
    [:> form-control {:type type
                      :placeholder placeholder
                      :id id
                      :style style
                      :on-change change-fn}]])
  ([label-val type placeholder id change-fn]
   [:> form-group
    [:> control-label label-val]
    [:> form-control {:type type
                      :placeholder placeholder
                      :id id
                      :on-change change-fn}]]))

(defn file-element [c-id label-val id accept change-fn]
  [:> form-group
   [:> control-label label-val]
   [:> form-control {:type "file"
                     :id id
                     :accept accept
                     :on-change change-fn}]])

(def calendar js/DatePicker)
