(ns leiningen.new.cljs-npm
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files]]))

(def render (renderer "cljs-npm"))

(defn cljs-npm [name]
  (let [data {:name name
              :sanitized (name-to-path name)}]
    (->files data
             ["package.json" (render "package.json" data)]
             ["project.clj" (render "project.clj" data)]
             ["README.md" (render "README.md" data)]
             ["src/cljs/{{sanitized}}/core.cljs" (render "core.cljs" data)]
             ["src/bin/executable/core.cljs" (render "executable.cljs" data)]
             ["src/clj/repl/core.clj" (render "repl.clj" data)]
             [".gitignore" (render "gitignore" data)])))
