# {{name}}

Write a brief introductory text here.

## Usage on command line

```
npm install -g {{name}}
{{name}} arguments...
```

## Usage as a library

```
var {{name}} = require("{{name}}");
...
```

## Development Setup

* `npm install`
* Launch clojure nREPL via
  * `lein repl` on a shell
  * `cider-jack-in` on emacs
  * etc...
* Launch a figwheel REPL with `(launch-figwheel-repl)`
* Start figwheel in a terminal window

```
node target/server_dev/{{name}}.js
```

* Changes to your source code will trigger incremental compilation.
* Or, instead of a figwheel REPL, launch a clojurescript REPL with

```
(launch-cljs-repl)
```

## Structure

### src/cljs

contains library code. It is compiled to `index.js`.

### src/bin

contains executable code. It is compiled to `bin/{{name}}.js`.
Source files in `src/bin` have access to namespaces in `src/cljs`.

### src/clj

contains repl functions `(launch-figwheel-repl)` and
`(launch-cljs-repl)`. It is not part of clojurescript build.

## Production Build

```sh
lein cljsbuild once lib
```

builds the library as `index.js`

```sh
lein cljsbuild once bin
```

builds an executable as `bin/{{name}}.js`

```sh
lein cljsbuild once lib bin
```

compiles both `index.js` and `bin/{{name}}.js`

Note that you have to include `bin/{{name}}.js` in your source code
repository if you want to submit an executable npm module. But, you don't
have to include `index.js` in your repository.

## License

...