# Introduction

A ClojureScript template for developing npm modules.
The template sets up a project with development(`dev`),
library(`lib`), and executable(`bin`) targets.
The development target includes the Figwheel auto-builder and code loader.

## Preparation

Run the following to create a project:

```sh
$ lein new cljs-npm <<project-name>>
$ cd <<project-name>>
```

## Development Setup

* `npm install`
* Launch clojure REPL via
  * `lein repl` on a shell
  * `cider-jack-in` on emacs
  * etc...
* Launch figwheel REPL on clojure REPL by executing `(launch-figwheel-repl)`
* Start figwheel in a terminal window

```
node target/server_dev/<<project-name>>.js
```

* Changes to your source code will trigger incremental compilation.
* Or, instead of figwheel REPL, launch clojurescript REPL on clojure REPL with

```
(launch-cljs-repl)
```

## Structure

### src/cljs

contains library code. It is compiled to `index.js`.

### src/bin

contains executable code. It is compiled to `bin/<<project-name>>.js`.
Source files in `src/bin` have access to namespaces in `src/cljs`.

### src/clj

contains repl functions `(launch-figwheel-repl)` and
`(launch-cljs-repl)`. It is not part of clojurescript build.

## Production Build

```sh
lein cljsbuild once lib
```

builds the library as `index.js`

```sh
lein cljsbuild once bin
```

builds an executable as `bin/<<project-name>>.js`

```sh
lein cljsbuild once lib bin
```

compiles both `index.js` and `bin/<<project-name>>.js`

Note that you have to include `bin/<<project-name>>.js` in your source code
repository if you want to submit an executable npm module. But, you don't
have to include `index.js` in your repository.

## License

Copyright © 2015 crocket

This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this
file, You can obtain one at http://mozilla.org/MPL/2.0/.
