# Introduction

A leiningen template for developing nodejs programs and npm executables in
clojurescript. The template sets up a project with development(`dev`),
library(`lib`), and executable(`bin`) targets.
The development target includes the Figwheel auto-builder and code loader.

Currently, it is not recommended to publish npm libraries written in
clojurescript because each javascript file compiled by clojurescript compiler
contains clojurescript runtime. Even if `:advanced` optimization is applied,
the overhead of clojurescript runtime could become several megabytes and lead
to a few seconds of loading time if a nodejs program requires many
clojurescript npm libraries.

## Preparation

Run the following to create a project:

```sh
$ lein new cljs-npm <<project-name>>
$ cd <<project-name>>
```

## Development Setup

* `npm install`
* Launch clojure REPL via
  * `lein repl` on a shell
  * `cider-jack-in` on emacs
  * etc...
* Launch figwheel REPL on clojure REPL by executing `(launch-figwheel-repl)`
* Start figwheel in a terminal window

```
node target/server_dev/<<project-name>>.js
```

* Changes to your source code will trigger incremental compilation.
* Or, instead of figwheel REPL, launch clojurescript REPL on clojure REPL with

```
(launch-cljs-repl)
```

## Structure

### src/cljs

contains executable code. It is compiled to `index.js`.

### src/clj

contains repl functions `(launch-figwheel-repl)` and
`(launch-cljs-repl)`. It is not part of clojurescript build.

## Production Build

```sh
lein cljsbuild once prod
```

builds an executable as `index.js`

Note that you don't have to include `index.js` in your source code
repository.

## License

Copyright © 2015 crocket

This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this
file, You can obtain one at http://mozilla.org/MPL/2.0/.
