## Introduction

It converts the character encodings of given files to UTF-8 and
converts every end of line into a newline character '\\n'.

## Dependencies to be manually installed

* `icu`

## Usage

```
npm install -g to-utf8-unix
to-utf8-unix /path/to/file1 ...
```

## Development Setup

* Install npm and leiningen.
* `npm install`
* Launch clojure REPL via
  * `lein repl` on a shell
  * `cider-jack-in` on emacs
  * etc...
* Launch figwheel REPL on clojure REPL by executing `(launch-figwheel-repl)`.
* Start figwheel in a terminal window

```
node target/server_dev/to-utf8-unix.js
```

* Changes to your source code will trigger incremental compilation.
* Or, instead of figwheel REPL, launch clojurescript REPL on clojure REPL with

```
(launch-cljs-repl)
```

## Structure

### src/cljs

contains executable code. It is compiled to `index.js`.

to-utf8-unix internally uses `buffer_descriptor`. `buffer_descriptor` is
defined as

```
{"charset" : String, "confidence" : Number, "message" : String,
 "buffer" : Buffer, "save" : true|false}
```

### src/clj

contains repl functions `(launch-figwheel-repl)` and
`(launch-cljs-repl)`. It is not part of clojurescript build.

## Production Build

```sh
lein cljsbuild once prod
```

builds an executable as `index.js`

Note that you don't have to include `index.js` in your source code
repository.

## License

Copyright © 2015 crocket

This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this
file, You can obtain one at http://mozilla.org/MPL/2.0/.
