(defproject {{ns-name}} "0.1.0-SNAPSHOT"

  :dependencies
  [[org.clojure/clojure "1.6.0"]
   [org.clojure/clojurescript "0.0-2227"]]

  :plugins
  [[lein-cljsbuild "1.0.3"]]

  :clean-targets
  [:target-path "out" "resources/public/{{ns-name}}.js" "resources/public/out"]

  :profiles
  {:dev
   {:dependencies
    [[ring "1.2.2"]
     [compojure "1.1.8"]
     [com.cemerick/piggieback "0.1.3"]
     [weasel "0.2.0"]]

    :source-paths
    ["dev/clj"]

    :repl-options
    {:init-ns repl
     :nrepl-middleware [cemerick.piggieback/wrap-cljs-repl]
     :init (run!)}

    :cljsbuild
    {:builds
     [{:id "dev"
       :source-paths ["src" "dev/cljs"]
       :compiler {
                  :output-to "resources/public/{{ns-name}}.js"
                  :output-dir "resources/public/out/"
                  :optimizations :none
                  :static-fns false
                  :source-map true}}]
     }
    }

   }
  )
