(ns leiningen.new.cljsr
  (:require
   [leiningen.new.templates :as t]))


(def render (t/renderer "cljsr"))


(defn cljsr
  [name]
  (let [data {:name name
              :ns-name (t/sanitize-ns name)
              :sanitized-path (t/name-to-path name)
              :sanitized-name (t/sanitize name)}]
    (t/->files data
               ["project.clj" (render "project.clj" data)]
               [".gitignore" (render "gitignore" data)]
               ["src/{{sanitized-path}}/core.cljs" (render "core.cljs" data)]
               ["dev/clj/repl.clj" (render "dev/clj/repl.clj")]
               ["dev/cljs/repl.cljs" (render "dev/cljs/repl.cljs")]
               ["resources/public/index.html" (render "resources/public/index.html" data)])))
