(ns zhang.agent.process-table
  "Process-tracking for the Zhang agent."
  (:require [clojure.core.async :as async]
            [zhang.agent.process-table.impl :as process-table]))

(def ^:dynamic *process-table* (atom nil))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;  Process Table Wrappers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defn create
  "Create a new process table.

  It is intended that there will only be one process table per agent/node."
  []
  (reset! *process-table*
          (process-table/->ZhangProcessTable (async/chan)
                                             {})))
(defn ls
  ""
  []
  (process-table/list-processes @*process-table*))

(defn add
  ""
  [process]
  (process-table/add-process @*process-table* process))

(defn lookup
  ""
  [id]
  (process-table/lookup-process @*process-table* id))

(defn remove
  ""
  [id]
  (process-table/remove-process @*process-table* id))
