# Resources

Various reading materials and background information useful in one way for another for the zhang project.

## Erlang

* [Erlang Processes](http://erlang.org/doc/reference_manual/processes.html)
* [Ports and Port Drivers](http://erlang.org/doc/reference_manual/ports.html)
* [The Jinterface Package](http://erlang.org/doc/apps/jinterface/jinterface_users_guide.html)
* [Concurrent Programming](http://media.pragprog.com/titles/jaerlang/Concurrent.pdf) (Programming Erlang, Chapter 8)
* [Erlang explained: Selective receive](http://ndpar.blogspot.com/2010/11/erlang-explained-selective-receive.html)
* Erlang mail list thread (2014): "Erlang is *not* a implementation of the Actor model (was Re: Go vs Erlang for distribution)"

    * [Processes with links/monitors, mailboxes, and messages](http://erlang.org/pipermail/erlang-questions/2014-June/079792.html)
    * [Actor Model and Process Calculi](http://erlang.org/pipermail/erlang-questions/2014-June/079805.html)
    * [Selective Receive and Complexity](http://erlang.org/pipermail/erlang-questions/2014-June/079828.html)

* [Golang dev maillist: rlang concepts modeled in Go](https://groups.google.com/forum/#!topic/golang-dev/4SClhkQbmyQ)
* [Session Typing for a Featherweight Erlang](http://www.di.fc.ul.pt/~dimitris/mostrous.vasconcelos.session-typing-erlang.pdf)
* [Stackoverflow - erlang - how to limit message queue or emulate it?](http://stackoverflow.com/questions/2120771/erlang-how-to-limit-message-queue-or-emulate-it)


## Clojure

* [core.async API Reference](http://clojure.github.io/core.async/)
* [Mastering Concurrent Processes with core.async](http://www.braveclojure.com/core-async/)
* [Clojure maillist: Mimic erlang in core.async](https://groups.google.com/forum/#!msg/clojure/gcWT6S0Ngog/MHFfdWfinm0J)
* [Go tutorials translated to core.async](https://github.com/martintrojer/go-tutorials-core-async/tree/master/src)
* Okku tutorials

    * [Getting Started Tutorial](https://github.com/gaverhae/okku-pi)
    * [Akka Remoting Tutorial for Okku](https://github.com/gaverhae/okku-remote)


## CSP, Actor Model, and π-Calculi

* [Stackoverflow: The actor model: Why is erlang special?](http://stackoverflow.com/questions/8107612/the-actor-model-why-is-erlang-special-or-why-do-you-need-another-language-for)
* [Concurrency in Erlang & Scala: The Actor Model](https://rocketeer.be/articles/concurrency-in-erlang-scala/)
* [A gentle introduction to Process Algebras*](http://www.pst.ifi.lmu.de/Lehre/fruhere-semester/sose-2013/formale-spezifikation-und-verifikation/intro-to-pa.pdf)
* [Differences between the Actor Model and Communicating Sequential Processes (CSP)](http://cs.stackexchange.com/questions/19506/differences-between-the-actor-model-and-communicating-sequential-processes-csp)
