*This is a fork of alembic for the sole purpose of upgrade its dynapath dependency to fix compatibility issues with java9 as described in [this issue](https://github.com/clojure-emacs/refactor-nrepl/issues/169). There is no intention at the moment to revive/maintain alembic as a project.*

# alembic

[Repository](https://github.com/pallet/alembic) &#xb7;
[Issues](https://github.com/pallet/alembic/issues) &#xb7;
[API docs](http://palletops.com/alembic/0.1/api) &#xb7;
[Annotated source](http://palletops.com/alembic/0.1/annotated/uberdoc.html) &#xb7;
[Release Notes](https://github.com/pallet/alembic/blob/develop/ReleaseNotes.md)

Alembic is a clojure library that allows you to distill jars onto your
classpath in a running JVM instance.  You can use it to add
dependencies to a running REPL, either in an ad-hoc fashion, or by
reloading your `project.clj` file.

You can also use it to invoke leiningen tasks.

It uses [leiningen][lein] and [pomegranate][pomegranate] to resolve
the jars, [classlojure][classlojure] to isolate leiningen and its
dependencies, and [dynapath][dynapath] to modify the classpath.

This means you can use lein and pomegranate without their dependencies
interfering with your project classpath.  The only dependencies added
are classlojure and dynapath - both small libraries with no transitive
dependencies.

## Project Dependency

To use Alembic with nREPL or any other clojure REPL, you will need to add
Alembic to you development dependencies.  For a leiningen based project, you can
do this by adding it to the `:dependencies` vector of the `:dev` profile in
`project.clj`.

```clj
:profiles {:dev {:dependencies [[clojure-emacs/alembic "0.3.3"]]}}
```

You can enable Alembic on all you projects, by adding it to the `:dependencies`
vector of the `:user` profile in `~/.lein/profiles.clj`.

## Usage

### Reloading project.clj

If you modify the dependencies in your `project.clj` file, you can load the
modified dependencies with `load-project`.

This will add all non-conflicting dependency changes.  Only new
dependencies are considered non-conflicting.  New versions of existing
dependencies are not loaded.  Removed dependencies are not unloaded.

### Adding Ad-Hoc Dependencies

To add a dependency to the classpath, use the `distill` function, passing a
leiningen style dependency vector.

```clj
(alembic.still/distill '[org.clojure/tools.logging "0.3.2"])
```

You can pass a sequence of dependencies to add, or just a single
dependency as in the example above.

`distill` prints the dependencies added to the classpath, and those
not added due to conflicts.

The distill function returns with no side-effects, if the dependency's
jars are already on the classpath.

By default, `distill` uses the repositories in the current lein project.  You
can override this by passing a map of lein style repository information to the
`:repositories` option.  The `project-repositories` function can be used to
obtain the lein project repositories, should you want to adapt these to pass as
an `:repositories` argument.


For programmatic use, `distill*` returns a sequence of maps, where
each map represents a dependent jar.  Those jars without a current
version on the classpath will be added to the classpath.  The jars
with a version already on the classpath are not added to the
classpath, and the currently loaded version is reported on the
:current-version key.

You can query the dependencies that have been added with the
`dependencies-added` function, which returns a sequence of leiningen style
dependency vectors.

You can lookup the dependency jars for the distilled dependencies, using the
`dependency-jars` function.

The `conflicting-versions` function returns a sequence of dependencies for a
distilled dependency, where the dependency jar version doesn't match the version
currently on the classpath.

### Invoking Leiningen Tasks

The `lein` macro invokes [leiningen][lein].  For example, to
show your project's dependency tree, you could run:

```clj
(alembic.still/lein deps :tree)
```

The macro allows you to invoke tasks without passing string arguments.
If you need to call lein functionally, use the `lein*` function
instead.

## Configuring User Profile with Injections

You can reduce the amount of typing you need to use alembic by using
the [`lein-inject`][lein-inject] plugin and configuring your `:user`
profile in `~/.lein/profiles.clj`.

```clj
{:user
  {:dependencies [[alembic "0.2.0"]]
   :plugins [[com.palletops/lein-inject "0.1.0"]]
   :inject-ns {. [alembic.still/distill alembic.still/lein]}}}
```

This will define the `.` namespace, so you can run `(./lein deps :tree)`.

## Support and Discussion

Discussion of alembic, either on the
[clojure-tools](https://groups.google.com/forum/?fromgroups#!forum/clojure-tools)
google group, or on #clojure or #pallet on freenode IRC.

## License

Copyright © 2013 Hugo Duncan

Distributed under the Eclipse Public License.

[lein]: http://leiningen.org "Leiningen"
[lein-inject]: http://github.com/palletops/lein-inject "Lein-inject plugin"
[pomegranate]: https://github.com/cemerick/pomegranate#pomegranate-- "Pomegranate"
[classlojure]: https://github.com/flatland/classlojure "Classlojure"
[dynapath]: https://github.com/tobias/dynapath#dynapath- "Dynapath"
