(ns com.amazonaws.handlers.HandlerAfterAttemptContext$HandlerAfterAttemptContextBuilder
  "Builder class for HandlerAfterAttemptContext"
  (:refer-clojure :only [require comment defn ->])
  (:import [com.amazonaws.handlers HandlerAfterAttemptContext$HandlerAfterAttemptContextBuilder]))

(defn with-request
  "Fluent set for what the request should be on the eventual HandlerAfterAttemptContext instance

  request - the request that was attempted - `com.amazonaws.Request`

  returns: the modified builder - `com.amazonaws.handlers.HandlerAfterAttemptContext$HandlerAfterAttemptContextBuilder`"
  (^com.amazonaws.handlers.HandlerAfterAttemptContext$HandlerAfterAttemptContextBuilder [^HandlerAfterAttemptContext$HandlerAfterAttemptContextBuilder this ^com.amazonaws.Request request]
    (-> this (.withRequest request))))

(defn with-response
  "Fluent set for what the response should be on the eventual HandlerAfterAttemptContext instance

  response - response from the request attempt, or null if there was an error - `com.amazonaws.Response`

  returns: the modified builder - `com.amazonaws.handlers.HandlerAfterAttemptContext$HandlerAfterAttemptContextBuilder`"
  (^com.amazonaws.handlers.HandlerAfterAttemptContext$HandlerAfterAttemptContextBuilder [^HandlerAfterAttemptContext$HandlerAfterAttemptContextBuilder this ^com.amazonaws.Response response]
    (-> this (.withResponse response))))

(defn with-exception
  "Fluent set for what the exception should be on the eventual HandlerAfterAttemptContext instance

  exception - exception generated by the request attempt, or null if the attempt was succcessful - `java.lang.Exception`

  returns: the modified builder - `com.amazonaws.handlers.HandlerAfterAttemptContext$HandlerAfterAttemptContextBuilder`"
  (^com.amazonaws.handlers.HandlerAfterAttemptContext$HandlerAfterAttemptContextBuilder [^HandlerAfterAttemptContext$HandlerAfterAttemptContextBuilder this ^java.lang.Exception exception]
    (-> this (.withException exception))))

(defn build
  "returns: a new HandlerAfterAttemptContext object - `com.amazonaws.handlers.HandlerAfterAttemptContext`"
  (^com.amazonaws.handlers.HandlerAfterAttemptContext [^HandlerAfterAttemptContext$HandlerAfterAttemptContextBuilder this]
    (-> this (.build))))

