# Apache Commons Math Bindings for Clojure.

These bindings are created to simplify interaction with java classes from clojure.
For each java class was created a separate namespace.
Each method/field has its own function/field binding.
Their names are changed for a more native look in the clojure code. Each function has docstring - information about the parameters, return value and possible exceptions.

## Clojars

```
[clojure-interop/commons-math "1.0.0"]
```

## Class Members Naming Conventions

| Class Member | Java | Clojure |
|:--|:--|:--|
| constructor | new File() | (->file) |
| instance method | getAnyValue() | (get-any-value) |
| instance field | instanceField | (-instance-field) |
| static method | staticMethod() | (*static-method) |
| static field | ANY_STATIC_FIELD | (*-any-static-field) |
| boolean field/method | isExists(), canUse() | (exists?), (can-use?) |

## Classes

- interface **org.apache.commons.math4.Field**
- interface **org.apache.commons.math4.FieldElement**
- interface **org.apache.commons.math4.RealFieldElement**
- interface **org.apache.commons.math4.analysis.BivariateFunction**
- class **org.apache.commons.math4.analysis.FunctionUtils**
- interface **org.apache.commons.math4.analysis.MultivariateFunction**
- interface **org.apache.commons.math4.analysis.MultivariateMatrixFunction**
- interface **org.apache.commons.math4.analysis.MultivariateVectorFunction**
- interface **org.apache.commons.math4.analysis.ParametricUnivariateFunction**
- interface **org.apache.commons.math4.analysis.RealFieldUnivariateFunction**
- interface **org.apache.commons.math4.analysis.TrivariateFunction**
- interface **org.apache.commons.math4.analysis.UnivariateFunction**
- interface **org.apache.commons.math4.analysis.UnivariateMatrixFunction**
- interface **org.apache.commons.math4.analysis.UnivariateVectorFunction**
- class **org.apache.commons.math4.analysis.differentiation.DSCompiler**
- class **org.apache.commons.math4.analysis.differentiation.DerivativeStructure**
- class **org.apache.commons.math4.analysis.differentiation.FiniteDifferencesDifferentiator**
- class **org.apache.commons.math4.analysis.differentiation.GradientFunction**
- class **org.apache.commons.math4.analysis.differentiation.JacobianFunction**
- interface **org.apache.commons.math4.analysis.differentiation.MultivariateDifferentiableFunction**
- interface **org.apache.commons.math4.analysis.differentiation.MultivariateDifferentiableVectorFunction**
- class **org.apache.commons.math4.analysis.differentiation.SparseGradient**
- interface **org.apache.commons.math4.analysis.differentiation.UnivariateDifferentiableFunction**
- interface **org.apache.commons.math4.analysis.differentiation.UnivariateDifferentiableMatrixFunction**
- interface **org.apache.commons.math4.analysis.differentiation.UnivariateDifferentiableVectorFunction**
- interface **org.apache.commons.math4.analysis.differentiation.UnivariateFunctionDifferentiator**
- interface **org.apache.commons.math4.analysis.differentiation.UnivariateMatrixFunctionDifferentiator**
- interface **org.apache.commons.math4.analysis.differentiation.UnivariateVectorFunctionDifferentiator**
- class **org.apache.commons.math4.analysis.function.Abs**
- class **org.apache.commons.math4.analysis.function.Acos**
- class **org.apache.commons.math4.analysis.function.Acosh**
- class **org.apache.commons.math4.analysis.function.Add**
- class **org.apache.commons.math4.analysis.function.Asin**
- class **org.apache.commons.math4.analysis.function.Asinh**
- class **org.apache.commons.math4.analysis.function.Atan**
- class **org.apache.commons.math4.analysis.function.Atan2**
- class **org.apache.commons.math4.analysis.function.Atanh**
- class **org.apache.commons.math4.analysis.function.Cbrt**
- class **org.apache.commons.math4.analysis.function.Ceil**
- class **org.apache.commons.math4.analysis.function.Constant**
- class **org.apache.commons.math4.analysis.function.Cos**
- class **org.apache.commons.math4.analysis.function.Cosh**
- class **org.apache.commons.math4.analysis.function.Divide**
- class **org.apache.commons.math4.analysis.function.Exp**
- class **org.apache.commons.math4.analysis.function.Expm1**
- class **org.apache.commons.math4.analysis.function.Floor**
- class **org.apache.commons.math4.analysis.function.Gaussian$Parametric**
- class **org.apache.commons.math4.analysis.function.Gaussian**
- class **org.apache.commons.math4.analysis.function.HarmonicOscillator$Parametric**
- class **org.apache.commons.math4.analysis.function.HarmonicOscillator**
- class **org.apache.commons.math4.analysis.function.Identity**
- class **org.apache.commons.math4.analysis.function.Inverse**
- class **org.apache.commons.math4.analysis.function.Log**
- class **org.apache.commons.math4.analysis.function.Log10**
- class **org.apache.commons.math4.analysis.function.Log1p**
- class **org.apache.commons.math4.analysis.function.Logistic$Parametric**
- class **org.apache.commons.math4.analysis.function.Logistic**
- class **org.apache.commons.math4.analysis.function.Logit$Parametric**
- class **org.apache.commons.math4.analysis.function.Logit**
- class **org.apache.commons.math4.analysis.function.Max**
- class **org.apache.commons.math4.analysis.function.Min**
- class **org.apache.commons.math4.analysis.function.Minus**
- class **org.apache.commons.math4.analysis.function.Multiply**
- class **org.apache.commons.math4.analysis.function.Pow**
- class **org.apache.commons.math4.analysis.function.Power**
- class **org.apache.commons.math4.analysis.function.Rint**
- class **org.apache.commons.math4.analysis.function.Sigmoid$Parametric**
- class **org.apache.commons.math4.analysis.function.Sigmoid**
- class **org.apache.commons.math4.analysis.function.Signum**
- class **org.apache.commons.math4.analysis.function.Sin**
- class **org.apache.commons.math4.analysis.function.Sinc**
- class **org.apache.commons.math4.analysis.function.Sinh**
- class **org.apache.commons.math4.analysis.function.Sqrt**
- class **org.apache.commons.math4.analysis.function.StepFunction**
- class **org.apache.commons.math4.analysis.function.Subtract**
- class **org.apache.commons.math4.analysis.function.Tan**
- class **org.apache.commons.math4.analysis.function.Tanh**
- class **org.apache.commons.math4.analysis.function.Ulp**
- class **org.apache.commons.math4.analysis.integration.BaseAbstractUnivariateIntegrator**
- class **org.apache.commons.math4.analysis.integration.IterativeLegendreGaussIntegrator**
- class **org.apache.commons.math4.analysis.integration.MidPointIntegrator**
- class **org.apache.commons.math4.analysis.integration.RombergIntegrator**
- class **org.apache.commons.math4.analysis.integration.SimpsonIntegrator**
- class **org.apache.commons.math4.analysis.integration.TrapezoidIntegrator**
- interface **org.apache.commons.math4.analysis.integration.UnivariateIntegrator**
- class **org.apache.commons.math4.analysis.integration.gauss.BaseRuleFactory**
- class **org.apache.commons.math4.analysis.integration.gauss.GaussIntegrator**
- class **org.apache.commons.math4.analysis.integration.gauss.GaussIntegratorFactory**
- class **org.apache.commons.math4.analysis.integration.gauss.HermiteRuleFactory**
- class **org.apache.commons.math4.analysis.integration.gauss.LaguerreRuleFactory**
- class **org.apache.commons.math4.analysis.integration.gauss.LegendreHighPrecisionRuleFactory**
- class **org.apache.commons.math4.analysis.integration.gauss.LegendreRuleFactory**
- class **org.apache.commons.math4.analysis.integration.gauss.SymmetricGaussIntegrator**
- class **org.apache.commons.math4.analysis.interpolation.AkimaSplineInterpolator**
- class **org.apache.commons.math4.analysis.interpolation.BicubicInterpolatingFunction**
- class **org.apache.commons.math4.analysis.interpolation.BicubicInterpolator**
- interface **org.apache.commons.math4.analysis.interpolation.BivariateGridInterpolator**
- class **org.apache.commons.math4.analysis.interpolation.DividedDifferenceInterpolator**
- class **org.apache.commons.math4.analysis.interpolation.FieldHermiteInterpolator**
- class **org.apache.commons.math4.analysis.interpolation.HermiteInterpolator**
- class **org.apache.commons.math4.analysis.interpolation.InterpolatingMicrosphere**
- class **org.apache.commons.math4.analysis.interpolation.InterpolatingMicrosphere2D**
- class **org.apache.commons.math4.analysis.interpolation.LinearInterpolator**
- class **org.apache.commons.math4.analysis.interpolation.LoessInterpolator**
- class **org.apache.commons.math4.analysis.interpolation.MicrosphereProjectionInterpolator**
- interface **org.apache.commons.math4.analysis.interpolation.MultivariateInterpolator**
- class **org.apache.commons.math4.analysis.interpolation.NevilleInterpolator**
- class **org.apache.commons.math4.analysis.interpolation.PiecewiseBicubicSplineInterpolatingFunction**
- class **org.apache.commons.math4.analysis.interpolation.PiecewiseBicubicSplineInterpolator**
- class **org.apache.commons.math4.analysis.interpolation.SplineInterpolator**
- class **org.apache.commons.math4.analysis.interpolation.TricubicInterpolatingFunction**
- class **org.apache.commons.math4.analysis.interpolation.TricubicInterpolator**
- interface **org.apache.commons.math4.analysis.interpolation.TrivariateGridInterpolator**
- interface **org.apache.commons.math4.analysis.interpolation.UnivariateInterpolator**
- class **org.apache.commons.math4.analysis.interpolation.UnivariatePeriodicInterpolator**
- class **org.apache.commons.math4.analysis.polynomials.PolynomialFunction$Parametric**
- class **org.apache.commons.math4.analysis.polynomials.PolynomialFunction**
- class **org.apache.commons.math4.analysis.polynomials.PolynomialFunctionLagrangeForm**
- class **org.apache.commons.math4.analysis.polynomials.PolynomialFunctionNewtonForm**
- class **org.apache.commons.math4.analysis.polynomials.PolynomialSplineFunction**
- class **org.apache.commons.math4.analysis.polynomials.PolynomialsUtils**
- class **org.apache.commons.math4.analysis.solvers.AbstractPolynomialSolver**
- class **org.apache.commons.math4.analysis.solvers.AbstractUnivariateDifferentiableSolver**
- class **org.apache.commons.math4.analysis.solvers.AbstractUnivariateSolver**
- enum **org.apache.commons.math4.analysis.solvers.AllowedSolution**
- class **org.apache.commons.math4.analysis.solvers.BaseAbstractUnivariateSolver**
- enum **org.apache.commons.math4.analysis.solvers.BaseSecantSolver$Method**
- class **org.apache.commons.math4.analysis.solvers.BaseSecantSolver**
- interface **org.apache.commons.math4.analysis.solvers.BaseUnivariateSolver**
- class **org.apache.commons.math4.analysis.solvers.BisectionSolver**
- interface **org.apache.commons.math4.analysis.solvers.BracketedRealFieldUnivariateSolver**
- interface **org.apache.commons.math4.analysis.solvers.BracketedUnivariateSolver**
- class **org.apache.commons.math4.analysis.solvers.BracketingNthOrderBrentSolver**
- class **org.apache.commons.math4.analysis.solvers.BrentSolver**
- class **org.apache.commons.math4.analysis.solvers.FieldBracketingNthOrderBrentSolver**
- class **org.apache.commons.math4.analysis.solvers.IllinoisSolver**
- class **org.apache.commons.math4.analysis.solvers.LaguerreSolver**
- class **org.apache.commons.math4.analysis.solvers.MullerSolver**
- class **org.apache.commons.math4.analysis.solvers.MullerSolver2**
- class **org.apache.commons.math4.analysis.solvers.NewtonRaphsonSolver**
- class **org.apache.commons.math4.analysis.solvers.PegasusSolver**
- interface **org.apache.commons.math4.analysis.solvers.PolynomialSolver**
- class **org.apache.commons.math4.analysis.solvers.RegulaFalsiSolver**
- class **org.apache.commons.math4.analysis.solvers.RiddersSolver**
- class **org.apache.commons.math4.analysis.solvers.SecantSolver**
- interface **org.apache.commons.math4.analysis.solvers.UnivariateDifferentiableSolver**
- interface **org.apache.commons.math4.analysis.solvers.UnivariateSolver**
- class **org.apache.commons.math4.analysis.solvers.UnivariateSolverUtils**
- class **org.apache.commons.math4.complex.Complex**
- class **org.apache.commons.math4.complex.ComplexField**
- class **org.apache.commons.math4.complex.ComplexFormat**
- class **org.apache.commons.math4.complex.ComplexUtils**
- class **org.apache.commons.math4.complex.Quaternion**
- class **org.apache.commons.math4.complex.RootsOfUnity**
- class **org.apache.commons.math4.dfp.Dfp**
- class **org.apache.commons.math4.dfp.DfpDec**
- enum **org.apache.commons.math4.dfp.DfpField$RoundingMode**
- class **org.apache.commons.math4.dfp.DfpField**
- class **org.apache.commons.math4.dfp.DfpMath**
- class **org.apache.commons.math4.distribution.AbstractIntegerDistribution**
- class **org.apache.commons.math4.distribution.AbstractMultivariateRealDistribution**
- class **org.apache.commons.math4.distribution.AbstractRealDistribution**
- class **org.apache.commons.math4.distribution.BetaDistribution**
- class **org.apache.commons.math4.distribution.BinomialDistribution**
- class **org.apache.commons.math4.distribution.CauchyDistribution**
- class **org.apache.commons.math4.distribution.ChiSquaredDistribution**
- class **org.apache.commons.math4.distribution.ConstantRealDistribution**
- class **org.apache.commons.math4.distribution.EmpiricalDistribution**
- class **org.apache.commons.math4.distribution.EnumeratedDistribution**
- class **org.apache.commons.math4.distribution.EnumeratedIntegerDistribution**
- class **org.apache.commons.math4.distribution.EnumeratedRealDistribution**
- class **org.apache.commons.math4.distribution.ExponentialDistribution**
- class **org.apache.commons.math4.distribution.FDistribution**
- class **org.apache.commons.math4.distribution.GammaDistribution**
- class **org.apache.commons.math4.distribution.GeometricDistribution**
- class **org.apache.commons.math4.distribution.GumbelDistribution**
- class **org.apache.commons.math4.distribution.HypergeometricDistribution**
- interface **org.apache.commons.math4.distribution.IntegerDistribution$Sampler**
- interface **org.apache.commons.math4.distribution.IntegerDistribution**
- class **org.apache.commons.math4.distribution.LaplaceDistribution**
- class **org.apache.commons.math4.distribution.LevyDistribution**
- class **org.apache.commons.math4.distribution.LogNormalDistribution**
- class **org.apache.commons.math4.distribution.LogisticDistribution**
- class **org.apache.commons.math4.distribution.MixtureMultivariateNormalDistribution**
- class **org.apache.commons.math4.distribution.MixtureMultivariateRealDistribution**
- class **org.apache.commons.math4.distribution.MultivariateNormalDistribution**
- interface **org.apache.commons.math4.distribution.MultivariateRealDistribution$Sampler**
- interface **org.apache.commons.math4.distribution.MultivariateRealDistribution**
- class **org.apache.commons.math4.distribution.NakagamiDistribution**
- class **org.apache.commons.math4.distribution.NormalDistribution**
- class **org.apache.commons.math4.distribution.ParetoDistribution**
- class **org.apache.commons.math4.distribution.PascalDistribution**
- class **org.apache.commons.math4.distribution.PoissonDistribution**
- interface **org.apache.commons.math4.distribution.RealDistribution$Sampler**
- interface **org.apache.commons.math4.distribution.RealDistribution**
- class **org.apache.commons.math4.distribution.TDistribution**
- class **org.apache.commons.math4.distribution.TriangularDistribution**
- class **org.apache.commons.math4.distribution.UniformIntegerDistribution**
- class **org.apache.commons.math4.distribution.UniformRealDistribution**
- class **org.apache.commons.math4.distribution.WeibullDistribution**
- class **org.apache.commons.math4.distribution.ZipfDistribution**
- class **org.apache.commons.math4.distribution.fitting.MultivariateNormalMixtureExpectationMaximization**
- class **org.apache.commons.math4.exception.ConvergenceException**
- class **org.apache.commons.math4.exception.DimensionMismatchException**
- class **org.apache.commons.math4.exception.InsufficientDataException**
- class **org.apache.commons.math4.exception.MathArithmeticException**
- class **org.apache.commons.math4.exception.MathIllegalArgumentException**
- class **org.apache.commons.math4.exception.MathIllegalNumberException**
- class **org.apache.commons.math4.exception.MathIllegalStateException**
- class **org.apache.commons.math4.exception.MathInternalError**
- class **org.apache.commons.math4.exception.MathParseException**
- class **org.apache.commons.math4.exception.MathRuntimeException**
- class **org.apache.commons.math4.exception.MathUnsupportedOperationException**
- class **org.apache.commons.math4.exception.MaxCountExceededException**
- class **org.apache.commons.math4.exception.MultiDimensionMismatchException**
- class **org.apache.commons.math4.exception.NoBracketingException**
- class **org.apache.commons.math4.exception.NoDataException**
- class **org.apache.commons.math4.exception.NonMonotonicSequenceException**
- class **org.apache.commons.math4.exception.NotANumberException**
- class **org.apache.commons.math4.exception.NotFiniteNumberException**
- class **org.apache.commons.math4.exception.NotPositiveException**
- class **org.apache.commons.math4.exception.NotStrictlyPositiveException**
- class **org.apache.commons.math4.exception.NullArgumentException**
- class **org.apache.commons.math4.exception.NumberIsTooLargeException**
- class **org.apache.commons.math4.exception.NumberIsTooSmallException**
- class **org.apache.commons.math4.exception.OutOfRangeException**
- class **org.apache.commons.math4.exception.TooManyEvaluationsException**
- class **org.apache.commons.math4.exception.TooManyIterationsException**
- class **org.apache.commons.math4.exception.ZeroException**
- class **org.apache.commons.math4.exception.util.ArgUtils**
- class **org.apache.commons.math4.exception.util.DummyLocalizable**
- class **org.apache.commons.math4.exception.util.ExceptionContext**
- interface **org.apache.commons.math4.exception.util.ExceptionContextProvider**
- interface **org.apache.commons.math4.exception.util.Localizable**
- enum **org.apache.commons.math4.exception.util.LocalizedFormats**
- class **org.apache.commons.math4.filter.DefaultMeasurementModel**
- class **org.apache.commons.math4.filter.DefaultProcessModel**
- class **org.apache.commons.math4.filter.KalmanFilter**
- interface **org.apache.commons.math4.filter.MeasurementModel**
- interface **org.apache.commons.math4.filter.ProcessModel**
- class **org.apache.commons.math4.fitting.AbstractCurveFitter$TheoreticalValuesFunction**
- class **org.apache.commons.math4.fitting.AbstractCurveFitter**
- class **org.apache.commons.math4.fitting.GaussianCurveFitter$ParameterGuesser**
- class **org.apache.commons.math4.fitting.GaussianCurveFitter**
- class **org.apache.commons.math4.fitting.HarmonicCurveFitter$ParameterGuesser**
- class **org.apache.commons.math4.fitting.HarmonicCurveFitter**
- class **org.apache.commons.math4.fitting.PolynomialCurveFitter**
- class **org.apache.commons.math4.fitting.SimpleCurveFitter**
- class **org.apache.commons.math4.fitting.WeightedObservedPoint**
- class **org.apache.commons.math4.fitting.WeightedObservedPoints**
- class **org.apache.commons.math4.fitting.leastsquares.AbstractEvaluation**
- class **org.apache.commons.math4.fitting.leastsquares.EvaluationRmsChecker**
- enum **org.apache.commons.math4.fitting.leastsquares.GaussNewtonOptimizer$Decomposition**
- class **org.apache.commons.math4.fitting.leastsquares.GaussNewtonOptimizer**
- class **org.apache.commons.math4.fitting.leastsquares.LeastSquaresAdapter**
- class **org.apache.commons.math4.fitting.leastsquares.LeastSquaresBuilder**
- class **org.apache.commons.math4.fitting.leastsquares.LeastSquaresFactory**
- interface **org.apache.commons.math4.fitting.leastsquares.LeastSquaresOptimizer$Optimum**
- interface **org.apache.commons.math4.fitting.leastsquares.LeastSquaresOptimizer**
- interface **org.apache.commons.math4.fitting.leastsquares.LeastSquaresProblem$Evaluation**
- interface **org.apache.commons.math4.fitting.leastsquares.LeastSquaresProblem**
- class **org.apache.commons.math4.fitting.leastsquares.LevenbergMarquardtOptimizer**
- interface **org.apache.commons.math4.fitting.leastsquares.MultivariateJacobianFunction**
- interface **org.apache.commons.math4.fitting.leastsquares.ParameterValidator**
- interface **org.apache.commons.math4.fitting.leastsquares.ValueAndJacobianFunction**
- class **org.apache.commons.math4.fraction.AbstractFormat**
- class **org.apache.commons.math4.fraction.BigFraction**
- class **org.apache.commons.math4.fraction.BigFractionField**
- class **org.apache.commons.math4.fraction.BigFractionFormat**
- class **org.apache.commons.math4.fraction.Fraction**
- class **org.apache.commons.math4.fraction.FractionConversionException**
- class **org.apache.commons.math4.fraction.FractionField**
- class **org.apache.commons.math4.fraction.FractionFormat**
- class **org.apache.commons.math4.fraction.ProperBigFractionFormat**
- class **org.apache.commons.math4.fraction.ProperFractionFormat**
- class **org.apache.commons.math4.genetics.AbstractListChromosome**
- class **org.apache.commons.math4.genetics.BinaryChromosome**
- class **org.apache.commons.math4.genetics.BinaryMutation**
- class **org.apache.commons.math4.genetics.Chromosome**
- class **org.apache.commons.math4.genetics.ChromosomePair**
- interface **org.apache.commons.math4.genetics.CrossoverPolicy**
- class **org.apache.commons.math4.genetics.CycleCrossover**
- class **org.apache.commons.math4.genetics.ElitisticListPopulation**
- interface **org.apache.commons.math4.genetics.Fitness**
- class **org.apache.commons.math4.genetics.FixedElapsedTime**
- class **org.apache.commons.math4.genetics.FixedGenerationCount**
- class **org.apache.commons.math4.genetics.GeneticAlgorithm**
- class **org.apache.commons.math4.genetics.InvalidRepresentationException**
- class **org.apache.commons.math4.genetics.ListPopulation**
- interface **org.apache.commons.math4.genetics.MutationPolicy**
- class **org.apache.commons.math4.genetics.NPointCrossover**
- class **org.apache.commons.math4.genetics.OnePointCrossover**
- class **org.apache.commons.math4.genetics.OrderedCrossover**
- interface **org.apache.commons.math4.genetics.PermutationChromosome**
- interface **org.apache.commons.math4.genetics.Population**
- class **org.apache.commons.math4.genetics.RandomKey**
- class **org.apache.commons.math4.genetics.RandomKeyMutation**
- interface **org.apache.commons.math4.genetics.SelectionPolicy**
- interface **org.apache.commons.math4.genetics.StoppingCondition**
- class **org.apache.commons.math4.genetics.TournamentSelection**
- class **org.apache.commons.math4.genetics.UniformCrossover**
- interface **org.apache.commons.math4.geometry.Point**
- interface **org.apache.commons.math4.geometry.Space**
- interface **org.apache.commons.math4.geometry.Vector**
- class **org.apache.commons.math4.geometry.VectorFormat**
- interface **org.apache.commons.math4.geometry.enclosing.Encloser**
- class **org.apache.commons.math4.geometry.enclosing.EnclosingBall**
- interface **org.apache.commons.math4.geometry.enclosing.SupportBallGenerator**
- class **org.apache.commons.math4.geometry.enclosing.WelzlEncloser**
- class **org.apache.commons.math4.geometry.euclidean.oned.Euclidean1D$NoSubSpaceException**
- class **org.apache.commons.math4.geometry.euclidean.oned.Euclidean1D**
- class **org.apache.commons.math4.geometry.euclidean.oned.Interval**
- class **org.apache.commons.math4.geometry.euclidean.oned.IntervalsSet**
- class **org.apache.commons.math4.geometry.euclidean.oned.OrientedPoint**
- class **org.apache.commons.math4.geometry.euclidean.oned.SubOrientedPoint**
- class **org.apache.commons.math4.geometry.euclidean.oned.Vector1D**
- class **org.apache.commons.math4.geometry.euclidean.oned.Vector1DFormat**
- class **org.apache.commons.math4.geometry.euclidean.threed.CardanEulerSingularityException**
- class **org.apache.commons.math4.geometry.euclidean.threed.Euclidean3D**
- class **org.apache.commons.math4.geometry.euclidean.threed.FieldRotation**
- class **org.apache.commons.math4.geometry.euclidean.threed.FieldVector3D**
- class **org.apache.commons.math4.geometry.euclidean.threed.Line**
- class **org.apache.commons.math4.geometry.euclidean.threed.NotARotationMatrixException**
- class **org.apache.commons.math4.geometry.euclidean.threed.OutlineExtractor**
- class **org.apache.commons.math4.geometry.euclidean.threed.Plane**
- class **org.apache.commons.math4.geometry.euclidean.threed.PolyhedronsSet**
- class **org.apache.commons.math4.geometry.euclidean.threed.Rotation**
- enum **org.apache.commons.math4.geometry.euclidean.threed.RotationConvention**
- class **org.apache.commons.math4.geometry.euclidean.threed.RotationOrder**
- class **org.apache.commons.math4.geometry.euclidean.threed.Segment**
- class **org.apache.commons.math4.geometry.euclidean.threed.SphereGenerator**
- class **org.apache.commons.math4.geometry.euclidean.threed.SphericalCoordinates**
- class **org.apache.commons.math4.geometry.euclidean.threed.SubLine**
- class **org.apache.commons.math4.geometry.euclidean.threed.SubPlane**
- class **org.apache.commons.math4.geometry.euclidean.threed.Vector3D**
- class **org.apache.commons.math4.geometry.euclidean.threed.Vector3DFormat**
- class **org.apache.commons.math4.geometry.euclidean.twod.DiskGenerator**
- class **org.apache.commons.math4.geometry.euclidean.twod.Euclidean2D**
- class **org.apache.commons.math4.geometry.euclidean.twod.Line**
- class **org.apache.commons.math4.geometry.euclidean.twod.PolygonsSet**
- class **org.apache.commons.math4.geometry.euclidean.twod.Segment**
- class **org.apache.commons.math4.geometry.euclidean.twod.SubLine**
- class **org.apache.commons.math4.geometry.euclidean.twod.Vector2D**
- class **org.apache.commons.math4.geometry.euclidean.twod.Vector2DFormat**
- class **org.apache.commons.math4.geometry.euclidean.twod.hull.AklToussaintHeuristic**
- class **org.apache.commons.math4.geometry.euclidean.twod.hull.ConvexHull2D**
- interface **org.apache.commons.math4.geometry.euclidean.twod.hull.ConvexHullGenerator2D**
- class **org.apache.commons.math4.geometry.euclidean.twod.hull.MonotoneChain**
- interface **org.apache.commons.math4.geometry.hull.ConvexHull**
- interface **org.apache.commons.math4.geometry.hull.ConvexHullGenerator**
- class **org.apache.commons.math4.geometry.partitioning.AbstractRegion**
- class **org.apache.commons.math4.geometry.partitioning.AbstractSubHyperplane**
- interface **org.apache.commons.math4.geometry.partitioning.BSPTree$LeafMerger**
- interface **org.apache.commons.math4.geometry.partitioning.BSPTree$VanishingCutHandler**
- class **org.apache.commons.math4.geometry.partitioning.BSPTree**
- enum **org.apache.commons.math4.geometry.partitioning.BSPTreeVisitor$Order**
- interface **org.apache.commons.math4.geometry.partitioning.BSPTreeVisitor**
- class **org.apache.commons.math4.geometry.partitioning.BoundaryAttribute**
- class **org.apache.commons.math4.geometry.partitioning.BoundaryProjection**
- interface **org.apache.commons.math4.geometry.partitioning.Embedding**
- interface **org.apache.commons.math4.geometry.partitioning.Hyperplane**
- class **org.apache.commons.math4.geometry.partitioning.NodesSet**
- enum **org.apache.commons.math4.geometry.partitioning.Region$Location**
- interface **org.apache.commons.math4.geometry.partitioning.Region**
- class **org.apache.commons.math4.geometry.partitioning.RegionFactory**
- enum **org.apache.commons.math4.geometry.partitioning.Side**
- class **org.apache.commons.math4.geometry.partitioning.SubHyperplane$SplitSubHyperplane**
- interface **org.apache.commons.math4.geometry.partitioning.SubHyperplane**
- interface **org.apache.commons.math4.geometry.partitioning.Transform**
- class **org.apache.commons.math4.geometry.spherical.oned.Arc**
- class **org.apache.commons.math4.geometry.spherical.oned.ArcsSet$InconsistentStateAt2PiWrapping**
- class **org.apache.commons.math4.geometry.spherical.oned.ArcsSet$Split**
- class **org.apache.commons.math4.geometry.spherical.oned.ArcsSet**
- class **org.apache.commons.math4.geometry.spherical.oned.LimitAngle**
- class **org.apache.commons.math4.geometry.spherical.oned.S1Point**
- class **org.apache.commons.math4.geometry.spherical.oned.Sphere1D$NoSubSpaceException**
- class **org.apache.commons.math4.geometry.spherical.oned.Sphere1D**
- class **org.apache.commons.math4.geometry.spherical.oned.SubLimitAngle**
- class **org.apache.commons.math4.geometry.spherical.twod.Circle**
- class **org.apache.commons.math4.geometry.spherical.twod.Edge**
- class **org.apache.commons.math4.geometry.spherical.twod.S2Point**
- class **org.apache.commons.math4.geometry.spherical.twod.Sphere2D**
- class **org.apache.commons.math4.geometry.spherical.twod.SphericalPolygonsSet**
- class **org.apache.commons.math4.geometry.spherical.twod.SubCircle**
- class **org.apache.commons.math4.geometry.spherical.twod.Vertex**
- class **org.apache.commons.math4.linear.AbstractFieldMatrix**
- class **org.apache.commons.math4.linear.AbstractRealMatrix**
- interface **org.apache.commons.math4.linear.AnyMatrix**
- class **org.apache.commons.math4.linear.Array2DRowFieldMatrix**
- class **org.apache.commons.math4.linear.Array2DRowRealMatrix**
- class **org.apache.commons.math4.linear.ArrayFieldVector**
- class **org.apache.commons.math4.linear.ArrayRealVector**
- class **org.apache.commons.math4.linear.BlockFieldMatrix**
- class **org.apache.commons.math4.linear.BlockRealMatrix**
- class **org.apache.commons.math4.linear.CholeskyDecomposition**
- class **org.apache.commons.math4.linear.ConjugateGradient**
- interface **org.apache.commons.math4.linear.DecompositionSolver**
- class **org.apache.commons.math4.linear.DefaultFieldMatrixChangingVisitor**
- class **org.apache.commons.math4.linear.DefaultFieldMatrixPreservingVisitor**
- class **org.apache.commons.math4.linear.DefaultIterativeLinearSolverEvent**
- class **org.apache.commons.math4.linear.DefaultRealMatrixChangingVisitor**
- class **org.apache.commons.math4.linear.DefaultRealMatrixPreservingVisitor**
- class **org.apache.commons.math4.linear.DiagonalMatrix**
- class **org.apache.commons.math4.linear.EigenDecomposition**
- interface **org.apache.commons.math4.linear.FieldDecompositionSolver**
- class **org.apache.commons.math4.linear.FieldLUDecomposition**
- interface **org.apache.commons.math4.linear.FieldMatrix**
- interface **org.apache.commons.math4.linear.FieldMatrixChangingVisitor**
- interface **org.apache.commons.math4.linear.FieldMatrixPreservingVisitor**
- interface **org.apache.commons.math4.linear.FieldVector**
- interface **org.apache.commons.math4.linear.FieldVectorChangingVisitor**
- interface **org.apache.commons.math4.linear.FieldVectorPreservingVisitor**
- class **org.apache.commons.math4.linear.IllConditionedOperatorException**
- class **org.apache.commons.math4.linear.IterativeLinearSolver**
- class **org.apache.commons.math4.linear.IterativeLinearSolverEvent**
- class **org.apache.commons.math4.linear.JacobiPreconditioner**
- class **org.apache.commons.math4.linear.LUDecomposition**
- class **org.apache.commons.math4.linear.MatrixDimensionMismatchException**
- class **org.apache.commons.math4.linear.MatrixUtils**
- class **org.apache.commons.math4.linear.NonPositiveDefiniteMatrixException**
- class **org.apache.commons.math4.linear.NonPositiveDefiniteOperatorException**
- class **org.apache.commons.math4.linear.NonSelfAdjointOperatorException**
- class **org.apache.commons.math4.linear.NonSquareMatrixException**
- class **org.apache.commons.math4.linear.NonSquareOperatorException**
- class **org.apache.commons.math4.linear.NonSymmetricMatrixException**
- class **org.apache.commons.math4.linear.OpenMapRealMatrix**
- class **org.apache.commons.math4.linear.OpenMapRealVector**
- class **org.apache.commons.math4.linear.PreconditionedIterativeLinearSolver**
- class **org.apache.commons.math4.linear.QRDecomposition**
- class **org.apache.commons.math4.linear.RRQRDecomposition**
- class **org.apache.commons.math4.linear.RealLinearOperator**
- interface **org.apache.commons.math4.linear.RealMatrix**
- interface **org.apache.commons.math4.linear.RealMatrixChangingVisitor**
- class **org.apache.commons.math4.linear.RealMatrixFormat**
- interface **org.apache.commons.math4.linear.RealMatrixPreservingVisitor**
- class **org.apache.commons.math4.linear.RealVector**
- interface **org.apache.commons.math4.linear.RealVectorChangingVisitor**
- class **org.apache.commons.math4.linear.RealVectorFormat**
- interface **org.apache.commons.math4.linear.RealVectorPreservingVisitor**
- class **org.apache.commons.math4.linear.RectangularCholeskyDecomposition**
- class **org.apache.commons.math4.linear.SingularMatrixException**
- class **org.apache.commons.math4.linear.SingularOperatorException**
- class **org.apache.commons.math4.linear.SingularValueDecomposition**
- class **org.apache.commons.math4.linear.SparseFieldMatrix**
- class **org.apache.commons.math4.linear.SparseFieldVector**
- interface **org.apache.commons.math4.linear.SparseRealMatrix**
- class **org.apache.commons.math4.linear.SparseRealVector**
- class **org.apache.commons.math4.linear.SymmLQ**
- class **org.apache.commons.math4.ml.clustering.CentroidCluster**
- class **org.apache.commons.math4.ml.clustering.Cluster**
- interface **org.apache.commons.math4.ml.clustering.Clusterable**
- class **org.apache.commons.math4.ml.clustering.Clusterer**
- class **org.apache.commons.math4.ml.clustering.DBSCANClusterer**
- class **org.apache.commons.math4.ml.clustering.DoublePoint**
- class **org.apache.commons.math4.ml.clustering.FuzzyKMeansClusterer**
- enum **org.apache.commons.math4.ml.clustering.KMeansPlusPlusClusterer$EmptyClusterStrategy**
- class **org.apache.commons.math4.ml.clustering.KMeansPlusPlusClusterer**
- class **org.apache.commons.math4.ml.clustering.MultiKMeansPlusPlusClusterer**
- class **org.apache.commons.math4.ml.clustering.evaluation.ClusterEvaluator**
- class **org.apache.commons.math4.ml.clustering.evaluation.SumOfClusterVariances**
- class **org.apache.commons.math4.ml.distance.CanberraDistance**
- class **org.apache.commons.math4.ml.distance.ChebyshevDistance**
- interface **org.apache.commons.math4.ml.distance.DistanceMeasure**
- class **org.apache.commons.math4.ml.distance.EarthMoversDistance**
- class **org.apache.commons.math4.ml.distance.EuclideanDistance**
- class **org.apache.commons.math4.ml.distance.ManhattanDistance**
- interface **org.apache.commons.math4.ml.neuralnet.FeatureInitializer**
- class **org.apache.commons.math4.ml.neuralnet.FeatureInitializerFactory**
- class **org.apache.commons.math4.ml.neuralnet.MapUtils**
- class **org.apache.commons.math4.ml.neuralnet.Network$NeuronIdentifierComparator**
- class **org.apache.commons.math4.ml.neuralnet.Network**
- class **org.apache.commons.math4.ml.neuralnet.Neuron**
- enum **org.apache.commons.math4.ml.neuralnet.SquareNeighbourhood**
- interface **org.apache.commons.math4.ml.neuralnet.UpdateAction**
- class **org.apache.commons.math4.ml.neuralnet.oned.NeuronString**
- class **org.apache.commons.math4.ml.neuralnet.sofm.KohonenTrainingTask**
- class **org.apache.commons.math4.ml.neuralnet.sofm.KohonenUpdateAction**
- interface **org.apache.commons.math4.ml.neuralnet.sofm.LearningFactorFunction**
- class **org.apache.commons.math4.ml.neuralnet.sofm.LearningFactorFunctionFactory**
- interface **org.apache.commons.math4.ml.neuralnet.sofm.NeighbourhoodSizeFunction**
- class **org.apache.commons.math4.ml.neuralnet.sofm.NeighbourhoodSizeFunctionFactory**
- class **org.apache.commons.math4.ml.neuralnet.sofm.util.ExponentialDecayFunction**
- class **org.apache.commons.math4.ml.neuralnet.sofm.util.QuasiSigmoidDecayFunction**
- enum **org.apache.commons.math4.ml.neuralnet.twod.NeuronSquareMesh2D$HorizontalDirection**
- enum **org.apache.commons.math4.ml.neuralnet.twod.NeuronSquareMesh2D$VerticalDirection**
- class **org.apache.commons.math4.ml.neuralnet.twod.NeuronSquareMesh2D**
- class **org.apache.commons.math4.ml.neuralnet.twod.util.HitHistogram**
- class **org.apache.commons.math4.ml.neuralnet.twod.util.LocationFinder$Location**
- class **org.apache.commons.math4.ml.neuralnet.twod.util.LocationFinder**
- interface **org.apache.commons.math4.ml.neuralnet.twod.util.MapDataVisualization**
- interface **org.apache.commons.math4.ml.neuralnet.twod.util.MapVisualization**
- class **org.apache.commons.math4.ml.neuralnet.twod.util.QuantizationError**
- class **org.apache.commons.math4.ml.neuralnet.twod.util.SmoothedDataHistogram**
- class **org.apache.commons.math4.ml.neuralnet.twod.util.TopographicErrorHistogram**
- class **org.apache.commons.math4.ml.neuralnet.twod.util.UnifiedDistanceMatrix**
- class **org.apache.commons.math4.ode.AbstractFieldIntegrator**
- class **org.apache.commons.math4.ode.AbstractIntegrator**
- class **org.apache.commons.math4.ode.AbstractParameterizable**
- class **org.apache.commons.math4.ode.ContinuousOutputFieldModel**
- class **org.apache.commons.math4.ode.ContinuousOutputModel**
- class **org.apache.commons.math4.ode.EquationsMapper**
- class **org.apache.commons.math4.ode.ExpandableStatefulODE**
- class **org.apache.commons.math4.ode.FieldEquationsMapper**
- class **org.apache.commons.math4.ode.FieldExpandableODE**
- class **org.apache.commons.math4.ode.FieldODEState**
- class **org.apache.commons.math4.ode.FieldODEStateAndDerivative**
- interface **org.apache.commons.math4.ode.FieldSecondaryEquations**
- class **org.apache.commons.math4.ode.FirstOrderConverter**
- interface **org.apache.commons.math4.ode.FirstOrderDifferentialEquations**
- interface **org.apache.commons.math4.ode.FirstOrderFieldDifferentialEquations**
- interface **org.apache.commons.math4.ode.FirstOrderFieldIntegrator**
- interface **org.apache.commons.math4.ode.FirstOrderIntegrator**
- class **org.apache.commons.math4.ode.JacobianMatrices$MismatchedEquations**
- class **org.apache.commons.math4.ode.JacobianMatrices**
- interface **org.apache.commons.math4.ode.MainStateJacobianProvider**
- class **org.apache.commons.math4.ode.MultistepFieldIntegrator**
- interface **org.apache.commons.math4.ode.MultistepIntegrator$NordsieckTransformer**
- class **org.apache.commons.math4.ode.MultistepIntegrator**
- interface **org.apache.commons.math4.ode.ODEIntegrator**
- interface **org.apache.commons.math4.ode.ParameterJacobianProvider**
- interface **org.apache.commons.math4.ode.Parameterizable**
- interface **org.apache.commons.math4.ode.ParameterizedODE**
- interface **org.apache.commons.math4.ode.SecondOrderDifferentialEquations**
- interface **org.apache.commons.math4.ode.SecondOrderIntegrator**
- interface **org.apache.commons.math4.ode.SecondaryEquations**
- class **org.apache.commons.math4.ode.UnknownParameterException**
- enum **org.apache.commons.math4.ode.events.Action**
- class **org.apache.commons.math4.ode.events.EventFilter**
- enum **org.apache.commons.math4.ode.events.EventHandler$Action**
- interface **org.apache.commons.math4.ode.events.EventHandler**
- class **org.apache.commons.math4.ode.events.EventState**
- interface **org.apache.commons.math4.ode.events.FieldEventHandler**
- class **org.apache.commons.math4.ode.events.FieldEventState**
- enum **org.apache.commons.math4.ode.events.FilterType**
- class **org.apache.commons.math4.ode.nonstiff.AdamsBashforthFieldIntegrator**
- class **org.apache.commons.math4.ode.nonstiff.AdamsBashforthIntegrator**
- class **org.apache.commons.math4.ode.nonstiff.AdamsFieldIntegrator**
- class **org.apache.commons.math4.ode.nonstiff.AdamsIntegrator**
- class **org.apache.commons.math4.ode.nonstiff.AdamsMoultonFieldIntegrator**
- class **org.apache.commons.math4.ode.nonstiff.AdamsMoultonIntegrator**
- class **org.apache.commons.math4.ode.nonstiff.AdamsNordsieckFieldTransformer**
- class **org.apache.commons.math4.ode.nonstiff.AdamsNordsieckTransformer**
- class **org.apache.commons.math4.ode.nonstiff.AdaptiveStepsizeFieldIntegrator**
- class **org.apache.commons.math4.ode.nonstiff.AdaptiveStepsizeIntegrator**
- class **org.apache.commons.math4.ode.nonstiff.ClassicalRungeKuttaFieldIntegrator**
- class **org.apache.commons.math4.ode.nonstiff.ClassicalRungeKuttaIntegrator**
- class **org.apache.commons.math4.ode.nonstiff.DormandPrince54FieldIntegrator**
- class **org.apache.commons.math4.ode.nonstiff.DormandPrince54Integrator**
- class **org.apache.commons.math4.ode.nonstiff.DormandPrince853FieldIntegrator**
- class **org.apache.commons.math4.ode.nonstiff.DormandPrince853Integrator**
- class **org.apache.commons.math4.ode.nonstiff.EmbeddedRungeKuttaFieldIntegrator**
- class **org.apache.commons.math4.ode.nonstiff.EmbeddedRungeKuttaIntegrator**
- class **org.apache.commons.math4.ode.nonstiff.EulerFieldIntegrator**
- class **org.apache.commons.math4.ode.nonstiff.EulerIntegrator**
- interface **org.apache.commons.math4.ode.nonstiff.FieldButcherArrayProvider**
- class **org.apache.commons.math4.ode.nonstiff.GillFieldIntegrator**
- class **org.apache.commons.math4.ode.nonstiff.GillIntegrator**
- class **org.apache.commons.math4.ode.nonstiff.GraggBulirschStoerIntegrator**
- class **org.apache.commons.math4.ode.nonstiff.HighamHall54FieldIntegrator**
- class **org.apache.commons.math4.ode.nonstiff.HighamHall54Integrator**
- class **org.apache.commons.math4.ode.nonstiff.LutherFieldIntegrator**
- class **org.apache.commons.math4.ode.nonstiff.LutherIntegrator**
- class **org.apache.commons.math4.ode.nonstiff.MidpointFieldIntegrator**
- class **org.apache.commons.math4.ode.nonstiff.MidpointIntegrator**
- class **org.apache.commons.math4.ode.nonstiff.RungeKuttaFieldIntegrator**
- class **org.apache.commons.math4.ode.nonstiff.RungeKuttaIntegrator**
- class **org.apache.commons.math4.ode.nonstiff.ThreeEighthesFieldIntegrator**
- class **org.apache.commons.math4.ode.nonstiff.ThreeEighthesIntegrator**
- class **org.apache.commons.math4.ode.sampling.AbstractFieldStepInterpolator**
- class **org.apache.commons.math4.ode.sampling.AbstractStepInterpolator**
- class **org.apache.commons.math4.ode.sampling.DummyStepHandler**
- interface **org.apache.commons.math4.ode.sampling.FieldFixedStepHandler**
- interface **org.apache.commons.math4.ode.sampling.FieldStepHandler**
- interface **org.apache.commons.math4.ode.sampling.FieldStepInterpolator**
- class **org.apache.commons.math4.ode.sampling.FieldStepNormalizer**
- interface **org.apache.commons.math4.ode.sampling.FixedStepHandler**
- class **org.apache.commons.math4.ode.sampling.NordsieckStepInterpolator**
- interface **org.apache.commons.math4.ode.sampling.StepHandler**
- interface **org.apache.commons.math4.ode.sampling.StepInterpolator**
- class **org.apache.commons.math4.ode.sampling.StepNormalizer**
- enum **org.apache.commons.math4.ode.sampling.StepNormalizerBounds**
- enum **org.apache.commons.math4.ode.sampling.StepNormalizerMode**
- class **org.apache.commons.math4.optim.AbstractConvergenceChecker**
- class **org.apache.commons.math4.optim.AbstractOptimizationProblem**
- class **org.apache.commons.math4.optim.BaseMultiStartMultivariateOptimizer**
- class **org.apache.commons.math4.optim.BaseMultivariateOptimizer**
- class **org.apache.commons.math4.optim.BaseOptimizer**
- interface **org.apache.commons.math4.optim.ConvergenceChecker**
- class **org.apache.commons.math4.optim.InitialGuess**
- class **org.apache.commons.math4.optim.MaxEval**
- class **org.apache.commons.math4.optim.MaxIter**
- interface **org.apache.commons.math4.optim.OptimizationData**
- interface **org.apache.commons.math4.optim.OptimizationProblem**
- class **org.apache.commons.math4.optim.PointValuePair**
- class **org.apache.commons.math4.optim.PointVectorValuePair**
- class **org.apache.commons.math4.optim.SimpleBounds**
- class **org.apache.commons.math4.optim.SimplePointChecker**
- class **org.apache.commons.math4.optim.SimpleValueChecker**
- class **org.apache.commons.math4.optim.SimpleVectorValueChecker**
- class **org.apache.commons.math4.optim.linear.LinearConstraint**
- class **org.apache.commons.math4.optim.linear.LinearConstraintSet**
- class **org.apache.commons.math4.optim.linear.LinearObjectiveFunction**
- class **org.apache.commons.math4.optim.linear.LinearOptimizer**
- class **org.apache.commons.math4.optim.linear.NoFeasibleSolutionException**
- class **org.apache.commons.math4.optim.linear.NonNegativeConstraint**
- enum **org.apache.commons.math4.optim.linear.PivotSelectionRule**
- enum **org.apache.commons.math4.optim.linear.Relationship**
- class **org.apache.commons.math4.optim.linear.SimplexSolver**
- class **org.apache.commons.math4.optim.linear.SolutionCallback**
- class **org.apache.commons.math4.optim.linear.UnboundedSolutionException**
- enum **org.apache.commons.math4.optim.nonlinear.scalar.GoalType**
- class **org.apache.commons.math4.optim.nonlinear.scalar.GradientMultivariateOptimizer**
- class **org.apache.commons.math4.optim.nonlinear.scalar.LeastSquaresConverter**
- class **org.apache.commons.math4.optim.nonlinear.scalar.LineSearch**
- class **org.apache.commons.math4.optim.nonlinear.scalar.MultiStartMultivariateOptimizer**
- class **org.apache.commons.math4.optim.nonlinear.scalar.MultivariateFunctionMappingAdapter**
- class **org.apache.commons.math4.optim.nonlinear.scalar.MultivariateFunctionPenaltyAdapter**
- class **org.apache.commons.math4.optim.nonlinear.scalar.MultivariateOptimizer**
- class **org.apache.commons.math4.optim.nonlinear.scalar.ObjectiveFunction**
- class **org.apache.commons.math4.optim.nonlinear.scalar.ObjectiveFunctionGradient**
- enum **org.apache.commons.math4.optim.nonlinear.scalar.gradient.NonLinearConjugateGradientOptimizer$Formula**
- class **org.apache.commons.math4.optim.nonlinear.scalar.gradient.NonLinearConjugateGradientOptimizer$IdentityPreconditioner**
- class **org.apache.commons.math4.optim.nonlinear.scalar.gradient.NonLinearConjugateGradientOptimizer**
- interface **org.apache.commons.math4.optim.nonlinear.scalar.gradient.Preconditioner**
- class **org.apache.commons.math4.optim.nonlinear.scalar.noderiv.AbstractSimplex**
- class **org.apache.commons.math4.optim.nonlinear.scalar.noderiv.BOBYQAOptimizer**
- class **org.apache.commons.math4.optim.nonlinear.scalar.noderiv.CMAESOptimizer$PopulationSize**
- class **org.apache.commons.math4.optim.nonlinear.scalar.noderiv.CMAESOptimizer$Sigma**
- class **org.apache.commons.math4.optim.nonlinear.scalar.noderiv.CMAESOptimizer**
- class **org.apache.commons.math4.optim.nonlinear.scalar.noderiv.MultiDirectionalSimplex**
- class **org.apache.commons.math4.optim.nonlinear.scalar.noderiv.NelderMeadSimplex**
- class **org.apache.commons.math4.optim.nonlinear.scalar.noderiv.PowellOptimizer**
- class **org.apache.commons.math4.optim.nonlinear.scalar.noderiv.SimplexOptimizer**
- class **org.apache.commons.math4.optim.univariate.BracketFinder**
- class **org.apache.commons.math4.optim.univariate.BrentOptimizer**
- class **org.apache.commons.math4.optim.univariate.MultiStartUnivariateOptimizer**
- class **org.apache.commons.math4.optim.univariate.SearchInterval**
- class **org.apache.commons.math4.optim.univariate.SimpleUnivariateValueChecker**
- class **org.apache.commons.math4.optim.univariate.UnivariateObjectiveFunction**
- class **org.apache.commons.math4.optim.univariate.UnivariateOptimizer**
- class **org.apache.commons.math4.optim.univariate.UnivariatePointValuePair**
- class **org.apache.commons.math4.primes.Primes**
- class **org.apache.commons.math4.random.CorrelatedRandomVectorGenerator**
- class **org.apache.commons.math4.random.GaussianRandomGenerator**
- class **org.apache.commons.math4.random.HaltonSequenceGenerator**
- class **org.apache.commons.math4.random.JDKRandomAdaptor**
- interface **org.apache.commons.math4.random.NormalizedRandomGenerator**
- interface **org.apache.commons.math4.random.RandomGenerator**
- class **org.apache.commons.math4.random.RandomUtils$DataGenerator**
- class **org.apache.commons.math4.random.RandomUtils**
- interface **org.apache.commons.math4.random.RandomVectorGenerator**
- class **org.apache.commons.math4.random.RngAdaptor**
- class **org.apache.commons.math4.random.SobolSequenceGenerator**
- class **org.apache.commons.math4.random.StableRandomGenerator**
- class **org.apache.commons.math4.random.SynchronizedRandomGenerator**
- class **org.apache.commons.math4.random.UncorrelatedRandomVectorGenerator**
- class **org.apache.commons.math4.random.UniformRandomGenerator**
- class **org.apache.commons.math4.random.UnitSphereRandomVectorGenerator**
- class **org.apache.commons.math4.special.BesselJ$BesselJResult**
- class **org.apache.commons.math4.special.BesselJ**
- class **org.apache.commons.math4.special.Beta**
- class **org.apache.commons.math4.special.Erf**
- class **org.apache.commons.math4.special.Gamma**
- class **org.apache.commons.math4.stat.Frequency**
- class **org.apache.commons.math4.stat.StatUtils**
- class **org.apache.commons.math4.stat.correlation.Covariance**
- class **org.apache.commons.math4.stat.correlation.KendallsCorrelation**
- class **org.apache.commons.math4.stat.correlation.PearsonsCorrelation**
- class **org.apache.commons.math4.stat.correlation.SpearmansCorrelation**
- class **org.apache.commons.math4.stat.correlation.StorelessCovariance**
- class **org.apache.commons.math4.stat.descriptive.AbstractStorelessUnivariateStatistic**
- class **org.apache.commons.math4.stat.descriptive.AbstractUnivariateStatistic**
- class **org.apache.commons.math4.stat.descriptive.AggregateSummaryStatistics**
- class **org.apache.commons.math4.stat.descriptive.DescriptiveStatistics**
- class **org.apache.commons.math4.stat.descriptive.MultivariateSummaryStatistics**
- interface **org.apache.commons.math4.stat.descriptive.StatisticalMultivariateSummary**
- interface **org.apache.commons.math4.stat.descriptive.StatisticalSummary**
- class **org.apache.commons.math4.stat.descriptive.StatisticalSummaryValues**
- interface **org.apache.commons.math4.stat.descriptive.StorelessUnivariateStatistic**
- class **org.apache.commons.math4.stat.descriptive.SummaryStatistics**
- class **org.apache.commons.math4.stat.descriptive.SynchronizedDescriptiveStatistics**
- class **org.apache.commons.math4.stat.descriptive.SynchronizedMultivariateSummaryStatistics**
- class **org.apache.commons.math4.stat.descriptive.SynchronizedSummaryStatistics**
- interface **org.apache.commons.math4.stat.descriptive.UnivariateStatistic**
- interface **org.apache.commons.math4.stat.descriptive.WeightedEvaluation**
- class **org.apache.commons.math4.stat.descriptive.moment.GeometricMean**
- class **org.apache.commons.math4.stat.descriptive.moment.Kurtosis**
- class **org.apache.commons.math4.stat.descriptive.moment.Mean**
- class **org.apache.commons.math4.stat.descriptive.moment.SecondMoment**
- enum **org.apache.commons.math4.stat.descriptive.moment.SemiVariance$Direction**
- class **org.apache.commons.math4.stat.descriptive.moment.SemiVariance**
- class **org.apache.commons.math4.stat.descriptive.moment.Skewness**
- class **org.apache.commons.math4.stat.descriptive.moment.StandardDeviation**
- class **org.apache.commons.math4.stat.descriptive.moment.Variance**
- class **org.apache.commons.math4.stat.descriptive.moment.VectorialCovariance**
- class **org.apache.commons.math4.stat.descriptive.moment.VectorialMean**
- class **org.apache.commons.math4.stat.descriptive.rank.Max**
- class **org.apache.commons.math4.stat.descriptive.rank.Median**
- class **org.apache.commons.math4.stat.descriptive.rank.Min**
- interface **org.apache.commons.math4.stat.descriptive.rank.PSquarePercentile$PSquareMarkers**
- class **org.apache.commons.math4.stat.descriptive.rank.PSquarePercentile**
- enum **org.apache.commons.math4.stat.descriptive.rank.Percentile$EstimationType**
- class **org.apache.commons.math4.stat.descriptive.rank.Percentile**
- class **org.apache.commons.math4.stat.descriptive.summary.Product**
- class **org.apache.commons.math4.stat.descriptive.summary.Sum**
- class **org.apache.commons.math4.stat.descriptive.summary.SumOfLogs**
- class **org.apache.commons.math4.stat.descriptive.summary.SumOfSquares**
- enum **org.apache.commons.math4.stat.inference.AlternativeHypothesis**
- class **org.apache.commons.math4.stat.inference.BinomialTest**
- class **org.apache.commons.math4.stat.inference.ChiSquareTest**
- class **org.apache.commons.math4.stat.inference.GTest**
- class **org.apache.commons.math4.stat.inference.InferenceTestUtils**
- class **org.apache.commons.math4.stat.inference.KolmogorovSmirnovTest**
- class **org.apache.commons.math4.stat.inference.MannWhitneyUTest**
- class **org.apache.commons.math4.stat.inference.OneWayAnova**
- class **org.apache.commons.math4.stat.inference.TTest**
- class **org.apache.commons.math4.stat.inference.WilcoxonSignedRankTest**
- class **org.apache.commons.math4.stat.interval.AgrestiCoullInterval**
- interface **org.apache.commons.math4.stat.interval.BinomialConfidenceInterval**
- class **org.apache.commons.math4.stat.interval.ClopperPearsonInterval**
- class **org.apache.commons.math4.stat.interval.ConfidenceInterval**
- class **org.apache.commons.math4.stat.interval.IntervalUtils**
- class **org.apache.commons.math4.stat.interval.NormalApproximationInterval**
- class **org.apache.commons.math4.stat.interval.WilsonScoreInterval**
- enum **org.apache.commons.math4.stat.ranking.NaNStrategy**
- class **org.apache.commons.math4.stat.ranking.NaturalRanking**
- interface **org.apache.commons.math4.stat.ranking.RankingAlgorithm**
- enum **org.apache.commons.math4.stat.ranking.TiesStrategy**
- class **org.apache.commons.math4.stat.regression.AbstractMultipleLinearRegression**
- class **org.apache.commons.math4.stat.regression.GLSMultipleLinearRegression**
- class **org.apache.commons.math4.stat.regression.MillerUpdatingRegression**
- class **org.apache.commons.math4.stat.regression.ModelSpecificationException**
- interface **org.apache.commons.math4.stat.regression.MultipleLinearRegression**
- class **org.apache.commons.math4.stat.regression.OLSMultipleLinearRegression**
- class **org.apache.commons.math4.stat.regression.RegressionResults**
- class **org.apache.commons.math4.stat.regression.SimpleRegression**
- interface **org.apache.commons.math4.stat.regression.UpdatingMultipleLinearRegression**
- enum **org.apache.commons.math4.transform.DctNormalization**
- enum **org.apache.commons.math4.transform.DftNormalization**
- enum **org.apache.commons.math4.transform.DstNormalization**
- class **org.apache.commons.math4.transform.FastCosineTransformer**
- class **org.apache.commons.math4.transform.FastFourierTransformer**
- class **org.apache.commons.math4.transform.FastHadamardTransformer**
- class **org.apache.commons.math4.transform.FastSineTransformer**
- interface **org.apache.commons.math4.transform.RealTransformer**
- enum **org.apache.commons.math4.transform.TransformType**
- class **org.apache.commons.math4.transform.TransformUtils**
- class **org.apache.commons.math4.util.ArithmeticUtils**
- class **org.apache.commons.math4.util.BigReal**
- class **org.apache.commons.math4.util.BigRealField**
- class **org.apache.commons.math4.util.CentralPivotingStrategy**
- class **org.apache.commons.math4.util.Combinations**
- class **org.apache.commons.math4.util.CombinatoricsUtils$FactorialLog**
- class **org.apache.commons.math4.util.CombinatoricsUtils**
- class **org.apache.commons.math4.util.CompositeFormat**
- class **org.apache.commons.math4.util.ContinuedFraction**
- class **org.apache.commons.math4.util.Decimal64**
- class **org.apache.commons.math4.util.Decimal64Field**
- class **org.apache.commons.math4.util.DefaultTransformer**
- interface **org.apache.commons.math4.util.DoubleArray**
- class **org.apache.commons.math4.util.FastMath**
- interface **org.apache.commons.math4.util.Incrementor$MaxCountExceededCallback**
- class **org.apache.commons.math4.util.Incrementor**
- interface **org.apache.commons.math4.util.IntegerSequence$Incrementor$MaxCountExceededCallback**
- class **org.apache.commons.math4.util.IntegerSequence$Incrementor**
- class **org.apache.commons.math4.util.IntegerSequence$Range**
- class **org.apache.commons.math4.util.IntegerSequence**
- class **org.apache.commons.math4.util.IterationEvent**
- interface **org.apache.commons.math4.util.IterationListener**
- class **org.apache.commons.math4.util.IterationManager**
- class **org.apache.commons.math4.util.KthSelector**
- interface **org.apache.commons.math4.util.MathArrays$Function**
- enum **org.apache.commons.math4.util.MathArrays$OrderDirection**
- enum **org.apache.commons.math4.util.MathArrays$Position**
- class **org.apache.commons.math4.util.MathArrays**
- class **org.apache.commons.math4.util.MathUtils**
- class **org.apache.commons.math4.util.MedianOf3PivotingStrategy**
- class **org.apache.commons.math4.util.MultidimensionalCounter**
- interface **org.apache.commons.math4.util.NumberTransformer**
- class **org.apache.commons.math4.util.OpenIntToDoubleHashMap**
- class **org.apache.commons.math4.util.OpenIntToFieldHashMap**
- class **org.apache.commons.math4.util.Pair**
- interface **org.apache.commons.math4.util.PivotingStrategyInterface**
- class **org.apache.commons.math4.util.Precision**
- class **org.apache.commons.math4.util.RandomPivotingStrategy**
- enum **org.apache.commons.math4.util.ResizableDoubleArray$ExpansionMode**
- class **org.apache.commons.math4.util.ResizableDoubleArray**
- class **org.apache.commons.math4.util.TransformerMap**

## Contributors

[Eugene Potapenko](https://github.com/potapenko/)

## License

Distributed under the Eclipse Public License, the same as Clojure.
