(ns org.apache.commons.math4.distribution.AbstractIntegerDistribution
  "Base class for integer-valued discrete distributions.  Default
  implementations are provided for some of the methods that do not vary
  from distribution to distribution."
  (:refer-clojure :only [require comment defn ->])
  (:import [org.apache.commons.math4.distribution AbstractIntegerDistribution]))

(defn ->abstract-integer-distribution
  "Constructor."
  (^AbstractIntegerDistribution []
    (new AbstractIntegerDistribution )))

(defn *sample
  "Utility function for allocating an array and filling it with n
   samples generated by the given sampler.

  n - Number of samples. - `int`
  sampler - Sampler. - `org.apache.commons.math4.distribution.IntegerDistribution$Sampler`

  returns: an array of size n. - `int[]`"
  ([^Integer n ^org.apache.commons.math4.distribution.IntegerDistribution$Sampler sampler]
    (AbstractIntegerDistribution/sample n sampler)))

(defn probability
  "For a random variable X whose values are distributed according
   to this distribution, this method returns P(x0 < X <= x1).

   The default implementation uses the identity
   P(x0 < X <= x1) = P(X <= x1) - P(X <= x0)

  x-0 - the exclusive lower bound - `int`
  x-1 - the inclusive upper bound - `int`

  returns: the probability that a random variable with this distribution
   will take a value between x0 and x1,
   excluding the lower and including the upper endpoint - `double`

  throws: org.apache.commons.math4.exception.NumberIsTooLargeException - if x0 > x1"
  (^Double [^AbstractIntegerDistribution this ^Integer x-0 ^Integer x-1]
    (-> this (.probability x-0 x-1))))

(defn inverse-cumulative-probability
  "Computes the quantile function of this distribution.
   For a random variable X distributed according to this distribution,
   the returned value is

   inf{x in Z | P(X<=x) >= p} for 0 < p <= 1,
   inf{x in Z | P(X<=x) > 0} for p = 0.

   If the result exceeds the range of the data type int,
   then Integer.MIN_VALUE or Integer.MAX_VALUE is returned.

   The default implementation returns

   IntegerDistribution.getSupportLowerBound() for p = 0,
   IntegerDistribution.getSupportUpperBound() for p = 1, and
   solveInverseCumulativeProbability(double, int, int) for
       0 < p < 1.

  p - the cumulative probability - `double`

  returns: the smallest p-quantile of this distribution
   (largest 0-quantile for p = 0) - `int`

  throws: org.apache.commons.math4.exception.OutOfRangeException - if p < 0 or p > 1"
  (^Integer [^AbstractIntegerDistribution this ^Double p]
    (-> this (.inverseCumulativeProbability p))))

(defn log-probability
  "For a random variable X whose values are distributed according to
   this distribution, this method returns log(P(X = x)), where
   log is the natural logarithm. In other words, this method
   represents the logarithm of the probability mass function (PMF) for the
   distribution. Note that due to the floating point precision and
   under/overflow issues, this method will for some distributions be more
   precise and faster than computing the logarithm of
   IntegerDistribution.probability(int).

   The default implementation simply computes the logarithm of probability(x).

  x - the point at which the PMF is evaluated - `int`

  returns: the logarithm of the value of the probability mass function at x - `double`"
  (^Double [^AbstractIntegerDistribution this ^Integer x]
    (-> this (.logProbability x))))

(defn create-sampler
  "Creates a sampler.

  rng - Generator of uniformly distributed numbers. - `org.apache.commons.rng.UniformRandomProvider`

  returns: a sampler that produces random numbers according this
   distribution. - `org.apache.commons.math4.distribution.IntegerDistribution$Sampler`"
  (^org.apache.commons.math4.distribution.IntegerDistribution$Sampler [^AbstractIntegerDistribution this ^org.apache.commons.rng.UniformRandomProvider rng]
    (-> this (.createSampler rng))))

