(ns org.apache.commons.math4.distribution.AbstractMultivariateRealDistribution
  "Base class for multivariate probability distributions."
  (:refer-clojure :only [require comment defn ->])
  (:import [org.apache.commons.math4.distribution AbstractMultivariateRealDistribution]))

(defn *sample
  "Utility function for creating n vectors generated by the
   given sampler.

  n - Number of samples. - `int`
  sampler - Sampler. - `org.apache.commons.math4.distribution.MultivariateRealDistribution$Sampler`

  returns: an array of size n whose elements are random vectors
   sampled from this distribution. - `double[][]`"
  ([^Integer n ^org.apache.commons.math4.distribution.MultivariateRealDistribution$Sampler sampler]
    (AbstractMultivariateRealDistribution/sample n sampler)))

(defn get-dimension
  "Gets the number of random variables of the distribution.
   It is the size of the array returned by the sample
   method.

  returns: the number of variables. - `int`"
  (^Integer [^AbstractMultivariateRealDistribution this]
    (-> this (.getDimension))))

(defn create-sampler
  "Creates a sampler.

  rng - Generator of uniformly distributed numbers. - `org.apache.commons.rng.UniformRandomProvider`

  returns: a sampler that produces random numbers according this
   distribution. - `org.apache.commons.math4.distribution.MultivariateRealDistribution$Sampler`"
  (^org.apache.commons.math4.distribution.MultivariateRealDistribution$Sampler [^AbstractMultivariateRealDistribution this ^org.apache.commons.rng.UniformRandomProvider rng]
    (-> this (.createSampler rng))))

