(ns org.apache.commons.math4.distribution.AbstractRealDistribution
  "Base class for probability distributions on the reals.
  Default implementations are provided for some of the methods
  that do not vary from distribution to distribution.


  This base class provides a default factory method for creating
  a sampler instance that uses the

  inversion method for generating random samples that follow the
  distribution."
  (:refer-clojure :only [require comment defn ->])
  (:import [org.apache.commons.math4.distribution AbstractRealDistribution]))

(defn ->abstract-real-distribution
  "Constructor."
  (^AbstractRealDistribution []
    (new AbstractRealDistribution )))

(def *-solver-default-absolute-accuracy
  "Static Constant.

  Default absolute accuracy for inverse cumulative computation.

  type: double"
  AbstractRealDistribution/SOLVER_DEFAULT_ABSOLUTE_ACCURACY)

(defn *sample
  "Utility function for allocating an array and filling it with n
   samples generated by the given sampler.

  n - Number of samples. - `int`
  sampler - Sampler. - `org.apache.commons.math4.distribution.RealDistribution$Sampler`

  returns: an array of size n. - `double[]`"
  ([^Integer n ^org.apache.commons.math4.distribution.RealDistribution$Sampler sampler]
    (AbstractRealDistribution/sample n sampler)))

(defn probability
  "For a random variable X whose values are distributed according
   to this distribution, this method returns P(x0 < X <= x1).

  x-0 - Lower bound (excluded). - `double`
  x-1 - Upper bound (included). - `double`

  returns: the probability that a random variable with this distribution
   takes a value between x0 and x1, excluding the lower
   and including the upper endpoint. - `double`

  throws: org.apache.commons.math4.exception.NumberIsTooLargeException - if x0 > x1. The default implementation uses the identity P(x0 < X <= x1) = P(X <= x1) - P(X <= x0)"
  (^Double [^AbstractRealDistribution this ^Double x-0 ^Double x-1]
    (-> this (.probability x-0 x-1)))
  (^Double [^AbstractRealDistribution this ^Double x]
    (-> this (.probability x))))

(defn inverse-cumulative-probability
  "Computes the quantile function of this distribution. For a random
   variable X distributed according to this distribution, the
   returned value is

   inf{x in R | P(X<=x) >= p} for 0 < p <= 1,
   inf{x in R | P(X<=x) > 0} for p = 0.


   The default implementation returns

   RealDistribution.getSupportLowerBound() for p = 0,
   RealDistribution.getSupportUpperBound() for p = 1.

  p - the cumulative probability - `double`

  returns: the smallest p-quantile of this distribution
   (largest 0-quantile for p = 0) - `double`

  throws: org.apache.commons.math4.exception.OutOfRangeException - if p < 0 or p > 1"
  (^Double [^AbstractRealDistribution this ^Double p]
    (-> this (.inverseCumulativeProbability p))))

(defn log-density
  "Returns the natural logarithm of the probability density function
   (PDF) of this distribution evaluated at the specified point x.
   In general, the PDF is the derivative of the CDF.
   If the derivative does not exist at x, then an appropriate replacement
   should be returned, e.g. Double.POSITIVE_INFINITY, Double.NaN,
   or the limit inferior or limit superior of the difference quotient. Note that
   due to the floating point precision and under/overflow issues, this method will
   for some distributions be more precise and faster than computing the logarithm of
   RealDistribution.density(double).

   The default implementation simply computes the logarithm of density(x).

  x - the point at which the PDF is evaluated - `double`

  returns: the logarithm of the value of the probability density function at point x - `double`"
  (^Double [^AbstractRealDistribution this ^Double x]
    (-> this (.logDensity x))))

(defn create-sampler
  "Creates a sampler.

  rng - Generator of uniformly distributed numbers. - `org.apache.commons.rng.UniformRandomProvider`

  returns: a sampler that produces random numbers according this
   distribution. - `org.apache.commons.math4.distribution.RealDistribution$Sampler`"
  (^org.apache.commons.math4.distribution.RealDistribution$Sampler [^AbstractRealDistribution this ^org.apache.commons.rng.UniformRandomProvider rng]
    (-> this (.createSampler rng))))

