# Deep Learning for Java (deeplearning4j) Bindings for Clojure.

These bindings are created to simplify interaction with java classes from clojure.
For each java class was created a separate namespace.
Each method/field has its own function/field binding.
Their names are changed for a more native look in the clojure code. Each function has docstring - information about the parameters, return value and possible exceptions.

## Clojars

```
[clojure-interop/deeplearning4j "1.0.0"]
```

## Class Members Naming Conventions

| Class Member | Java | Clojure |
|:--|:--|:--|
| constructor | new File() | (->file) |
| instance method | getAnyValue() | (get-any-value) |
| instance field | instanceField | (-instance-field) |
| static method | staticMethod() | (*static-method) |
| static field | ANY_STATIC_FIELD | (*-any-static-field) |
| boolean field/method | isExists(), canUse() | (exists?), (can-use?) |

## Classes

- class **com.atilika.kuromoji.TokenBase**
- class **com.atilika.kuromoji.TokenizerBase$Builder**
- enum **com.atilika.kuromoji.TokenizerBase$Mode**
- class **com.atilika.kuromoji.TokenizerBase**
- class **com.atilika.kuromoji.buffer.BufferEntry**
- class **com.atilika.kuromoji.buffer.FeatureInfoMap**
- class **com.atilika.kuromoji.buffer.StringValueMapBuffer**
- class **com.atilika.kuromoji.buffer.TokenInfoBuffer**
- class **com.atilika.kuromoji.buffer.WordIdMap**
- class **com.atilika.kuromoji.compile.CharacterDefinitionsCompiler**
- interface **com.atilika.kuromoji.compile.Compiler**
- class **com.atilika.kuromoji.compile.ConnectionCostsCompiler**
- class **com.atilika.kuromoji.compile.DictionaryCompilerBase**
- class **com.atilika.kuromoji.compile.DoubleArrayTrieCompiler**
- class **com.atilika.kuromoji.compile.ProgressLog**
- class **com.atilika.kuromoji.compile.TokenInfoBufferCompiler**
- class **com.atilika.kuromoji.compile.TokenInfoDictionaryCompilerBase**
- class **com.atilika.kuromoji.compile.UnknownDictionaryCompiler**
- class **com.atilika.kuromoji.compile.WordIdMapCompiler$GrowableIntArray**
- class **com.atilika.kuromoji.compile.WordIdMapCompiler**
- class **com.atilika.kuromoji.dict.CharacterDefinitions**
- class **com.atilika.kuromoji.dict.ConnectionCosts**
- interface **com.atilika.kuromoji.dict.Dictionary**
- class **com.atilika.kuromoji.dict.DictionaryEntryBase**
- class **com.atilika.kuromoji.dict.DictionaryField**
- class **com.atilika.kuromoji.dict.GenericDictionaryEntry$Builder**
- class **com.atilika.kuromoji.dict.GenericDictionaryEntry**
- class **com.atilika.kuromoji.dict.InsertedDictionary**
- class **com.atilika.kuromoji.dict.TokenInfoDictionary**
- class **com.atilika.kuromoji.dict.UnknownDictionary**
- class **com.atilika.kuromoji.dict.UserDictionary$UserDictionaryMatch**
- class **com.atilika.kuromoji.dict.UserDictionary**
- class **com.atilika.kuromoji.io.ByteBufferIO**
- class **com.atilika.kuromoji.io.IntegerArrayIO**
- class **com.atilika.kuromoji.io.StringArrayIO**
- class **com.atilika.kuromoji.ipadic.Token**
- class **com.atilika.kuromoji.ipadic.Tokenizer$Builder**
- class **com.atilika.kuromoji.ipadic.Tokenizer**
- class **com.atilika.kuromoji.ipadic.compile.DictionaryCompiler**
- class **com.atilika.kuromoji.ipadic.compile.DictionaryEntry**
- class **com.atilika.kuromoji.ipadic.compile.TokenInfoDictionaryCompiler**
- class **com.atilika.kuromoji.trie.DoubleArrayTrie**
- interface **com.atilika.kuromoji.trie.PatriciaTrie$KeyMapper**
- class **com.atilika.kuromoji.trie.PatriciaTrie$PatriciaNode**
- class **com.atilika.kuromoji.trie.PatriciaTrie$StringKeyMapper**
- class **com.atilika.kuromoji.trie.PatriciaTrie**
- class **com.atilika.kuromoji.trie.PatriciaTrieFormatter**
- class **com.atilika.kuromoji.trie.Trie**
- class **com.atilika.kuromoji.util.DictionaryEntryLineParser**
- class **com.atilika.kuromoji.util.FileResourceResolver**
- class **com.atilika.kuromoji.util.KuromojiBinFilesFetcher**
- interface **com.atilika.kuromoji.util.ResourceResolver**
- class **com.atilika.kuromoji.util.SimpleResourceResolver**
- class **com.atilika.kuromoji.util.StringUtils**
- class **com.atilika.kuromoji.util.UnknownDictionaryEntryParser**
- interface **com.atilika.kuromoji.viterbi.TokenFactory**
- class **com.atilika.kuromoji.viterbi.ViterbiBuilder**
- class **com.atilika.kuromoji.viterbi.ViterbiFormatter**
- class **com.atilika.kuromoji.viterbi.ViterbiLattice**
- enum **com.atilika.kuromoji.viterbi.ViterbiNode$Type**
- class **com.atilika.kuromoji.viterbi.ViterbiNode**
- class **com.atilika.kuromoji.viterbi.ViterbiSearcher**
- enum **onnx.OnnxMlProto3$AttributeProto$AttributeType**
- class **onnx.OnnxMlProto3$AttributeProto$Builder**
- class **onnx.OnnxMlProto3$AttributeProto**
- interface **onnx.OnnxMlProto3$AttributeProtoOrBuilder**
- class **onnx.OnnxMlProto3$GraphProto$Builder**
- class **onnx.OnnxMlProto3$GraphProto**
- interface **onnx.OnnxMlProto3$GraphProtoOrBuilder**
- class **onnx.OnnxMlProto3$ModelProto$Builder**
- class **onnx.OnnxMlProto3$ModelProto**
- interface **onnx.OnnxMlProto3$ModelProtoOrBuilder**
- class **onnx.OnnxMlProto3$NodeProto$Builder**
- class **onnx.OnnxMlProto3$NodeProto**
- interface **onnx.OnnxMlProto3$NodeProtoOrBuilder**
- class **onnx.OnnxMlProto3$OperatorSetIdProto$Builder**
- class **onnx.OnnxMlProto3$OperatorSetIdProto**
- interface **onnx.OnnxMlProto3$OperatorSetIdProtoOrBuilder**
- class **onnx.OnnxMlProto3$StringStringEntryProto$Builder**
- class **onnx.OnnxMlProto3$StringStringEntryProto**
- interface **onnx.OnnxMlProto3$StringStringEntryProtoOrBuilder**
- class **onnx.OnnxMlProto3$TensorProto$Builder**
- enum **onnx.OnnxMlProto3$TensorProto$DataType**
- class **onnx.OnnxMlProto3$TensorProto$Segment$Builder**
- class **onnx.OnnxMlProto3$TensorProto$Segment**
- interface **onnx.OnnxMlProto3$TensorProto$SegmentOrBuilder**
- class **onnx.OnnxMlProto3$TensorProto**
- interface **onnx.OnnxMlProto3$TensorProtoOrBuilder**
- class **onnx.OnnxMlProto3$TensorShapeProto$Builder**
- class **onnx.OnnxMlProto3$TensorShapeProto$Dimension$Builder**
- enum **onnx.OnnxMlProto3$TensorShapeProto$Dimension$ValueCase**
- class **onnx.OnnxMlProto3$TensorShapeProto$Dimension**
- interface **onnx.OnnxMlProto3$TensorShapeProto$DimensionOrBuilder**
- class **onnx.OnnxMlProto3$TensorShapeProto**
- interface **onnx.OnnxMlProto3$TensorShapeProtoOrBuilder**
- class **onnx.OnnxMlProto3$TypeProto$Builder**
- class **onnx.OnnxMlProto3$TypeProto$Map$Builder**
- class **onnx.OnnxMlProto3$TypeProto$Map**
- interface **onnx.OnnxMlProto3$TypeProto$MapOrBuilder**
- class **onnx.OnnxMlProto3$TypeProto$Sequence$Builder**
- class **onnx.OnnxMlProto3$TypeProto$Sequence**
- interface **onnx.OnnxMlProto3$TypeProto$SequenceOrBuilder**
- class **onnx.OnnxMlProto3$TypeProto$Tensor$Builder**
- class **onnx.OnnxMlProto3$TypeProto$Tensor**
- interface **onnx.OnnxMlProto3$TypeProto$TensorOrBuilder**
- enum **onnx.OnnxMlProto3$TypeProto$ValueCase**
- class **onnx.OnnxMlProto3$TypeProto**
- interface **onnx.OnnxMlProto3$TypeProtoOrBuilder**
- class **onnx.OnnxMlProto3$ValueInfoProto$Builder**
- class **onnx.OnnxMlProto3$ValueInfoProto**
- interface **onnx.OnnxMlProto3$ValueInfoProtoOrBuilder**
- enum **onnx.OnnxMlProto3$Version**
- class **onnx.OnnxMlProto3**
- class **onnx.OnnxOperatorsProto3$OperatorProto$Builder**
- enum **onnx.OnnxOperatorsProto3$OperatorProto$OperatorStatus**
- class **onnx.OnnxOperatorsProto3$OperatorProto**
- interface **onnx.OnnxOperatorsProto3$OperatorProtoOrBuilder**
- class **onnx.OnnxOperatorsProto3$OperatorSetProto$Builder**
- class **onnx.OnnxOperatorsProto3$OperatorSetProto**
- interface **onnx.OnnxOperatorsProto3$OperatorSetProtoOrBuilder**
- class **onnx.OnnxOperatorsProto3**
- enum **onnx.OnnxProto3$AttributeProto$AttributeType**
- class **onnx.OnnxProto3$AttributeProto$Builder**
- class **onnx.OnnxProto3$AttributeProto**
- interface **onnx.OnnxProto3$AttributeProtoOrBuilder**
- class **onnx.OnnxProto3$GraphProto$Builder**
- class **onnx.OnnxProto3$GraphProto**
- interface **onnx.OnnxProto3$GraphProtoOrBuilder**
- class **onnx.OnnxProto3$ModelProto$Builder**
- class **onnx.OnnxProto3$ModelProto**
- interface **onnx.OnnxProto3$ModelProtoOrBuilder**
- class **onnx.OnnxProto3$NodeProto$Builder**
- class **onnx.OnnxProto3$NodeProto**
- interface **onnx.OnnxProto3$NodeProtoOrBuilder**
- class **onnx.OnnxProto3$OperatorSetIdProto$Builder**
- class **onnx.OnnxProto3$OperatorSetIdProto**
- interface **onnx.OnnxProto3$OperatorSetIdProtoOrBuilder**
- class **onnx.OnnxProto3$StringStringEntryProto$Builder**
- class **onnx.OnnxProto3$StringStringEntryProto**
- interface **onnx.OnnxProto3$StringStringEntryProtoOrBuilder**
- class **onnx.OnnxProto3$TensorProto$Builder**
- enum **onnx.OnnxProto3$TensorProto$DataType**
- class **onnx.OnnxProto3$TensorProto$Segment$Builder**
- class **onnx.OnnxProto3$TensorProto$Segment**
- interface **onnx.OnnxProto3$TensorProto$SegmentOrBuilder**
- class **onnx.OnnxProto3$TensorProto**
- interface **onnx.OnnxProto3$TensorProtoOrBuilder**
- class **onnx.OnnxProto3$TensorShapeProto$Builder**
- class **onnx.OnnxProto3$TensorShapeProto$Dimension$Builder**
- enum **onnx.OnnxProto3$TensorShapeProto$Dimension$ValueCase**
- class **onnx.OnnxProto3$TensorShapeProto$Dimension**
- interface **onnx.OnnxProto3$TensorShapeProto$DimensionOrBuilder**
- class **onnx.OnnxProto3$TensorShapeProto**
- interface **onnx.OnnxProto3$TensorShapeProtoOrBuilder**
- class **onnx.OnnxProto3$TypeProto$Builder**
- class **onnx.OnnxProto3$TypeProto$Tensor$Builder**
- class **onnx.OnnxProto3$TypeProto$Tensor**
- interface **onnx.OnnxProto3$TypeProto$TensorOrBuilder**
- enum **onnx.OnnxProto3$TypeProto$ValueCase**
- class **onnx.OnnxProto3$TypeProto**
- interface **onnx.OnnxProto3$TypeProtoOrBuilder**
- class **onnx.OnnxProto3$ValueInfoProto$Builder**
- class **onnx.OnnxProto3$ValueInfoProto**
- interface **onnx.OnnxProto3$ValueInfoProtoOrBuilder**
- enum **onnx.OnnxProto3$Version**
- class **onnx.OnnxProto3**
- class **org.ansj.app.crf.Config**
- class **org.ansj.app.crf.MakeTrainFile**
- class **org.ansj.app.crf.Model**
- class **org.ansj.app.crf.SplitWord**
- class **org.ansj.app.crf.model.CRFModel**
- class **org.ansj.app.crf.model.CRFppTxtModel**
- class **org.ansj.app.crf.model.WapitiCRFModel**
- class **org.ansj.app.crf.pojo.Element**
- class **org.ansj.app.keyword.KeyWordComputer**
- class **org.ansj.app.keyword.Keyword**
- class **org.ansj.app.summary.SummaryComputer**
- class **org.ansj.app.summary.TagContent**
- class **org.ansj.app.summary.pojo.Summary**
- class **org.ansj.dic.DicReader**
- class **org.ansj.dic.LearnTool**
- class **org.ansj.dic.PathToStream**
- class **org.ansj.dic.impl.File2Stream**
- class **org.ansj.dic.impl.Jar2Stream**
- class **org.ansj.dic.impl.Jdbc2Stream**
- class **org.ansj.dic.impl.Url2Stream**
- class **org.ansj.domain.AnsjItem**
- class **org.ansj.domain.KV**
- class **org.ansj.domain.Nature**
- class **org.ansj.domain.NewWord**
- class **org.ansj.domain.NumNatureAttr**
- class **org.ansj.domain.PersonNatureAttr**
- class **org.ansj.domain.Result**
- class **org.ansj.domain.Term**
- class **org.ansj.domain.TermNature**
- class **org.ansj.domain.TermNatures**
- class **org.ansj.exception.LibraryException**
- class **org.ansj.library.AmbiguityLibrary**
- class **org.ansj.library.CrfLibrary**
- class **org.ansj.library.DATDictionary**
- class **org.ansj.library.DicLibrary**
- class **org.ansj.library.NatureLibrary**
- class **org.ansj.library.NgramLibrary**
- class **org.ansj.library.StopLibrary**
- class **org.ansj.library.SynonymsLibrary**
- class **org.ansj.library.company.CompanyAttrLibrary**
- class **org.ansj.library.name.PersonAttrLibrary**
- interface **org.ansj.recognition.Recognition**
- interface **org.ansj.recognition.TermArrRecognition**
- class **org.ansj.recognition.arrimpl.AsianPersonRecognition**
- class **org.ansj.recognition.arrimpl.ForeignPersonRecognition**
- class **org.ansj.recognition.arrimpl.NewWordRecognition**
- class **org.ansj.recognition.arrimpl.NumRecognition**
- class **org.ansj.recognition.arrimpl.UserDefineRecognition**
- class **org.ansj.recognition.impl.BookRecognition**
- class **org.ansj.recognition.impl.DicRecognition**
- class **org.ansj.recognition.impl.EmailRecognition**
- class **org.ansj.recognition.impl.IDCardRecognition**
- class **org.ansj.recognition.impl.NatureRecognition**
- class **org.ansj.recognition.impl.StopRecognition**
- class **org.ansj.recognition.impl.SynonymsRecgnition**
- class **org.ansj.recognition.impl.TimeRecognition**
- class **org.ansj.recognition.impl.UserDicNatureRecognition**
- class **org.ansj.splitWord.Analysis**
- interface **org.ansj.splitWord.GetWords**
- class **org.ansj.splitWord.analysis.BaseAnalysis**
- class **org.ansj.splitWord.analysis.DicAnalysis**
- class **org.ansj.splitWord.analysis.IndexAnalysis**
- class **org.ansj.splitWord.analysis.NlpAnalysis**
- class **org.ansj.splitWord.analysis.ToAnalysis**
- class **org.ansj.splitWord.impl.GetWordsImpl**
- class **org.ansj.util.AnsjReader**
- class **org.ansj.util.Graph**
- class **org.ansj.util.MathUtil**
- class **org.ansj.util.MatrixUtil**
- class **org.ansj.util.MyStaticValue**
- class **org.ansj.util.NameFix**
- enum **org.ansj.util.TermUtil$InsertTermType**
- class **org.ansj.util.TermUtil**
- interface **org.datavec.api.conf.Configurable**
- class **org.datavec.api.conf.Configuration$IntegerRanges**
- class **org.datavec.api.conf.Configuration**
- class **org.datavec.api.conf.Configured**
- class **org.datavec.api.exceptions.DataVecException**
- class **org.datavec.api.exceptions.UnknownFormatException**
- class **org.datavec.api.formats.input.BaseInputFormat**
- interface **org.datavec.api.formats.input.InputFormat**
- class **org.datavec.api.formats.input.impl.CSVInputFormat**
- class **org.datavec.api.formats.input.impl.LibSvmInputFormat**
- class **org.datavec.api.formats.input.impl.LineInputFormat**
- class **org.datavec.api.formats.input.impl.ListStringInputFormat**
- class **org.datavec.api.formats.input.impl.MatlabInputFormat**
- class **org.datavec.api.formats.input.impl.SVMLightInputFormat**
- interface **org.datavec.api.formats.output.OutputFormat**
- class **org.datavec.api.formats.output.impl.CSVOutputFormat**
- class **org.datavec.api.formats.output.impl.LibSvmOutputFormat**
- class **org.datavec.api.formats.output.impl.LineOutputFormat**
- class **org.datavec.api.formats.output.impl.SVMLightOutputFormat**
- class **org.datavec.api.io.BinaryComparable**
- class **org.datavec.api.io.DataInputBuffer**
- class **org.datavec.api.io.DataOutputBuffer**
- interface **org.datavec.api.io.RawComparator**
- interface **org.datavec.api.io.WritableComparable**
- class **org.datavec.api.io.WritableComparator**
- interface **org.datavec.api.io.WritableConverter**
- class **org.datavec.api.io.WritableUtils**
- class **org.datavec.api.io.converters.DoubleWritableConverter**
- class **org.datavec.api.io.converters.FloatWritableConverter**
- class **org.datavec.api.io.converters.LabelWriterConverter**
- class **org.datavec.api.io.converters.SelfWritableConverter**
- class **org.datavec.api.io.converters.WritableConverterException**
- class **org.datavec.api.io.filters.BalancedPathFilter**
- interface **org.datavec.api.io.filters.PathFilter**
- class **org.datavec.api.io.filters.RandomPathFilter**
- class **org.datavec.api.io.labels.ParentPathLabelGenerator**
- interface **org.datavec.api.io.labels.PathLabelGenerator**
- interface **org.datavec.api.io.labels.PathMultiLabelGenerator**
- class **org.datavec.api.io.labels.PatternPathLabelGenerator**
- interface **org.datavec.api.io.serializers.Deserializer**
- interface **org.datavec.api.io.serializers.Serialization**
- class **org.datavec.api.io.serializers.SerializationFactory**
- interface **org.datavec.api.io.serializers.Serializer**
- class **org.datavec.api.records.Buffer**
- class **org.datavec.api.records.IOUtils**
- interface **org.datavec.api.records.Index**
- interface **org.datavec.api.records.Record**
- interface **org.datavec.api.records.SequenceRecord**
- class **org.datavec.api.records.converter.RecordReaderConverter**
- class **org.datavec.api.records.impl.Record**
- class **org.datavec.api.records.impl.SequenceRecord**
- interface **org.datavec.api.records.listener.RecordListener**
- class **org.datavec.api.records.listener.impl.LogRecordListener**
- class **org.datavec.api.records.mapper.RecordMapper**
- interface **org.datavec.api.records.metadata.RecordMetaData**
- class **org.datavec.api.records.metadata.RecordMetaDataComposable**
- class **org.datavec.api.records.metadata.RecordMetaDataComposableMap**
- class **org.datavec.api.records.metadata.RecordMetaDataImageURI**
- class **org.datavec.api.records.metadata.RecordMetaDataIndex**
- class **org.datavec.api.records.metadata.RecordMetaDataInterval**
- class **org.datavec.api.records.metadata.RecordMetaDataJdbc**
- class **org.datavec.api.records.metadata.RecordMetaDataLine**
- class **org.datavec.api.records.metadata.RecordMetaDataLineInterval**
- class **org.datavec.api.records.metadata.RecordMetaDataURI**
- class **org.datavec.api.records.reader.BaseRecordReader**
- interface **org.datavec.api.records.reader.RecordReader**
- interface **org.datavec.api.records.reader.SequenceRecordReader**
- interface **org.datavec.api.records.reader.factory.RecordReaderFactory**
- interface **org.datavec.api.records.reader.factory.RecordWriterFactory**
- class **org.datavec.api.records.reader.impl.ComposableRecordReader**
- class **org.datavec.api.records.reader.impl.ConcatenatingRecordReader**
- class **org.datavec.api.records.reader.impl.FileRecordReader**
- class **org.datavec.api.records.reader.impl.LineRecordReader**
- class **org.datavec.api.records.reader.impl.collection.CollectionRecordReader**
- class **org.datavec.api.records.reader.impl.collection.CollectionSequenceRecordReader**
- class **org.datavec.api.records.reader.impl.collection.ListStringRecordReader**
- class **org.datavec.api.records.reader.impl.csv.CSVLineSequenceRecordReader**
- enum **org.datavec.api.records.reader.impl.csv.CSVMultiSequenceRecordReader$Mode**
- class **org.datavec.api.records.reader.impl.csv.CSVMultiSequenceRecordReader**
- class **org.datavec.api.records.reader.impl.csv.CSVNLinesSequenceRecordReader**
- class **org.datavec.api.records.reader.impl.csv.CSVRecordReader**
- class **org.datavec.api.records.reader.impl.csv.CSVRegexRecordReader**
- class **org.datavec.api.records.reader.impl.csv.CSVSequenceRecordReader**
- class **org.datavec.api.records.reader.impl.csv.CSVVariableSlidingWindowRecordReader**
- class **org.datavec.api.records.reader.impl.csv.SerializableCSVParser**
- class **org.datavec.api.records.reader.impl.inmemory.InMemoryRecordReader**
- class **org.datavec.api.records.reader.impl.inmemory.InMemorySequenceRecordReader**
- class **org.datavec.api.records.reader.impl.jackson.FieldSelection$Builder**
- class **org.datavec.api.records.reader.impl.jackson.FieldSelection**
- class **org.datavec.api.records.reader.impl.jackson.JacksonLineRecordReader**
- class **org.datavec.api.records.reader.impl.jackson.JacksonLineSequenceRecordReader**
- class **org.datavec.api.records.reader.impl.jackson.JacksonReaderUtils**
- class **org.datavec.api.records.reader.impl.jackson.JacksonRecordReader**
- class **org.datavec.api.records.reader.impl.jdbc.JDBCRecordReader**
- class **org.datavec.api.records.reader.impl.misc.LibSvmRecordReader**
- class **org.datavec.api.records.reader.impl.misc.MatlabRecordReader**
- class **org.datavec.api.records.reader.impl.misc.SVMLightRecordReader**
- class **org.datavec.api.records.reader.impl.regex.RegexLineRecordReader**
- enum **org.datavec.api.records.reader.impl.regex.RegexSequenceRecordReader$LineErrorHandling**
- class **org.datavec.api.records.reader.impl.regex.RegexSequenceRecordReader**
- class **org.datavec.api.records.reader.impl.transform.TransformProcessRecordReader**
- class **org.datavec.api.records.reader.impl.transform.TransformProcessSequenceRecordReader**
- interface **org.datavec.api.records.writer.RecordWriter**
- interface **org.datavec.api.records.writer.SequenceRecordWriter**
- class **org.datavec.api.records.writer.impl.FileRecordWriter**
- class **org.datavec.api.records.writer.impl.LineRecordWriter**
- class **org.datavec.api.records.writer.impl.csv.CSVRecordWriter**
- class **org.datavec.api.records.writer.impl.misc.LibSvmRecordWriter**
- class **org.datavec.api.records.writer.impl.misc.MatlabRecordWriter**
- class **org.datavec.api.records.writer.impl.misc.SVMLightRecordWriter**
- class **org.datavec.api.split.BaseInputSplit**
- class **org.datavec.api.split.CollectionInputSplit**
- class **org.datavec.api.split.FileSplit**
- interface **org.datavec.api.split.InputSplit**
- class **org.datavec.api.split.InputStreamInputSplit**
- class **org.datavec.api.split.ListStringSplit**
- class **org.datavec.api.split.NumberedFileInputSplit**
- class **org.datavec.api.split.OutputStreamInputSplit**
- class **org.datavec.api.split.StringSplit**
- interface **org.datavec.api.split.TransformSplit$URITransform**
- class **org.datavec.api.split.TransformSplit**
- class **org.datavec.api.split.partition.NumberOfRecordsPartitioner**
- class **org.datavec.api.split.partition.PartitionMetaData**
- interface **org.datavec.api.split.partition.Partitioner**
- class **org.datavec.api.timeseries.util.TimeSeriesWritableUtils$RecordDetails**
- class **org.datavec.api.timeseries.util.TimeSeriesWritableUtils$ZeroLengthSequenceException**
- class **org.datavec.api.timeseries.util.TimeSeriesWritableUtils**
- interface **org.datavec.api.transform.ColumnOp**
- enum **org.datavec.api.transform.ColumnType**
- class **org.datavec.api.transform.DataAction**
- enum **org.datavec.api.transform.Distance**
- enum **org.datavec.api.transform.MathFunction**
- enum **org.datavec.api.transform.MathOp**
- enum **org.datavec.api.transform.ReduceOp**
- enum **org.datavec.api.transform.StringReduceOp**
- interface **org.datavec.api.transform.Transform**
- class **org.datavec.api.transform.TransformProcess$Builder**
- class **org.datavec.api.transform.TransformProcess**
- interface **org.datavec.api.transform.analysis.AnalysisCounter**
- class **org.datavec.api.transform.analysis.DataAnalysis**
- class **org.datavec.api.transform.analysis.DataVecAnalysisUtils**
- class **org.datavec.api.transform.analysis.SequenceDataAnalysis**
- class **org.datavec.api.transform.analysis.columns.BytesAnalysis$Builder**
- class **org.datavec.api.transform.analysis.columns.BytesAnalysis**
- class **org.datavec.api.transform.analysis.columns.CategoricalAnalysis**
- interface **org.datavec.api.transform.analysis.columns.ColumnAnalysis**
- class **org.datavec.api.transform.analysis.columns.DoubleAnalysis$Builder**
- class **org.datavec.api.transform.analysis.columns.DoubleAnalysis**
- class **org.datavec.api.transform.analysis.columns.IntegerAnalysis$Builder**
- class **org.datavec.api.transform.analysis.columns.IntegerAnalysis**
- class **org.datavec.api.transform.analysis.columns.LongAnalysis$Builder**
- class **org.datavec.api.transform.analysis.columns.LongAnalysis**
- class **org.datavec.api.transform.analysis.columns.NDArrayAnalysis**
- class **org.datavec.api.transform.analysis.columns.NumericalColumnAnalysis$Builder**
- class **org.datavec.api.transform.analysis.columns.NumericalColumnAnalysis**
- class **org.datavec.api.transform.analysis.columns.StringAnalysis$Builder**
- class **org.datavec.api.transform.analysis.columns.StringAnalysis**
- class **org.datavec.api.transform.analysis.columns.TimeAnalysis$Builder**
- class **org.datavec.api.transform.analysis.columns.TimeAnalysis**
- class **org.datavec.api.transform.analysis.counter.BytesAnalysisCounter**
- class **org.datavec.api.transform.analysis.counter.CategoricalAnalysisCounter**
- class **org.datavec.api.transform.analysis.counter.DoubleAnalysisCounter**
- class **org.datavec.api.transform.analysis.counter.IntegerAnalysisCounter**
- class **org.datavec.api.transform.analysis.counter.LongAnalysisCounter**
- class **org.datavec.api.transform.analysis.counter.NDArrayAnalysisCounter**
- class **org.datavec.api.transform.analysis.counter.StatCounter**
- class **org.datavec.api.transform.analysis.counter.StringAnalysisCounter**
- class **org.datavec.api.transform.analysis.counter.StringAnalysisMergeFunction**
- class **org.datavec.api.transform.analysis.histogram.CategoricalHistogramCounter**
- class **org.datavec.api.transform.analysis.histogram.DoubleHistogramCounter**
- interface **org.datavec.api.transform.analysis.histogram.HistogramCounter**
- class **org.datavec.api.transform.analysis.histogram.NDArrayHistogramCounter**
- class **org.datavec.api.transform.analysis.histogram.StringHistogramCounter**
- class **org.datavec.api.transform.analysis.json.TDigestDeserializer**
- class **org.datavec.api.transform.analysis.json.TDigestSerializer**
- class **org.datavec.api.transform.analysis.quality.QualityAnalysisAddFunction**
- class **org.datavec.api.transform.analysis.quality.QualityAnalysisCombineFunction**
- interface **org.datavec.api.transform.analysis.quality.QualityAnalysisState**
- class **org.datavec.api.transform.analysis.quality.bytes.BytesQualityAnalysisState**
- class **org.datavec.api.transform.analysis.quality.categorical.CategoricalQualityAddFunction**
- class **org.datavec.api.transform.analysis.quality.categorical.CategoricalQualityAnalysisState**
- class **org.datavec.api.transform.analysis.quality.categorical.CategoricalQualityMergeFunction**
- class **org.datavec.api.transform.analysis.quality.integer.IntegerQualityAddFunction**
- class **org.datavec.api.transform.analysis.quality.integer.IntegerQualityAnalysisState**
- class **org.datavec.api.transform.analysis.quality.integer.IntegerQualityMergeFunction**
- class **org.datavec.api.transform.analysis.quality.longq.LongQualityAddFunction**
- class **org.datavec.api.transform.analysis.quality.longq.LongQualityAnalysisState**
- class **org.datavec.api.transform.analysis.quality.longq.LongQualityMergeFunction**
- class **org.datavec.api.transform.analysis.quality.real.RealQualityAddFunction**
- class **org.datavec.api.transform.analysis.quality.real.RealQualityAnalysisState**
- class **org.datavec.api.transform.analysis.quality.real.RealQualityMergeFunction**
- class **org.datavec.api.transform.analysis.quality.string.StringQualityAddFunction**
- class **org.datavec.api.transform.analysis.quality.string.StringQualityAnalysisState**
- class **org.datavec.api.transform.analysis.quality.string.StringQualityMergeFunction**
- class **org.datavec.api.transform.analysis.quality.time.TimeQualityAddFunction**
- class **org.datavec.api.transform.analysis.quality.time.TimeQualityAnalysisState**
- class **org.datavec.api.transform.analysis.quality.time.TimeQualityMergeFunction**
- class **org.datavec.api.transform.analysis.sequence.SequenceLengthAnalysis**
- enum **org.datavec.api.transform.condition.BooleanCondition$Type**
- class **org.datavec.api.transform.condition.BooleanCondition**
- interface **org.datavec.api.transform.condition.Condition**
- enum **org.datavec.api.transform.condition.ConditionOp**
- enum **org.datavec.api.transform.condition.SequenceConditionMode**
- class **org.datavec.api.transform.condition.column.BaseColumnCondition**
- class **org.datavec.api.transform.condition.column.BooleanColumnCondition**
- class **org.datavec.api.transform.condition.column.CategoricalColumnCondition**
- interface **org.datavec.api.transform.condition.column.ColumnCondition**
- class **org.datavec.api.transform.condition.column.DoubleColumnCondition**
- class **org.datavec.api.transform.condition.column.FloatColumnCondition**
- class **org.datavec.api.transform.condition.column.InfiniteColumnCondition**
- class **org.datavec.api.transform.condition.column.IntegerColumnCondition**
- class **org.datavec.api.transform.condition.column.InvalidValueColumnCondition**
- class **org.datavec.api.transform.condition.column.LongColumnCondition**
- class **org.datavec.api.transform.condition.column.NaNColumnCondition**
- class **org.datavec.api.transform.condition.column.NullWritableColumnCondition**
- class **org.datavec.api.transform.condition.column.StringColumnCondition**
- class **org.datavec.api.transform.condition.column.TimeColumnCondition**
- class **org.datavec.api.transform.condition.column.TrivialColumnCondition**
- class **org.datavec.api.transform.condition.sequence.SequenceLengthCondition**
- class **org.datavec.api.transform.condition.string.StringRegexColumnCondition**
- class **org.datavec.api.transform.filter.BaseColumnFilter**
- class **org.datavec.api.transform.filter.ConditionFilter**
- interface **org.datavec.api.transform.filter.Filter**
- class **org.datavec.api.transform.filter.FilterInvalidValues**
- class **org.datavec.api.transform.filter.InvalidNumColumns**
- enum **org.datavec.api.transform.geo.LocationType**
- class **org.datavec.api.transform.join.Join$Builder**
- enum **org.datavec.api.transform.join.Join$JoinType**
- class **org.datavec.api.transform.join.Join**
- class **org.datavec.api.transform.metadata.BaseColumnMetaData**
- class **org.datavec.api.transform.metadata.BinaryMetaData**
- class **org.datavec.api.transform.metadata.BooleanMetaData**
- class **org.datavec.api.transform.metadata.CategoricalMetaData**
- interface **org.datavec.api.transform.metadata.ColumnMetaData**
- class **org.datavec.api.transform.metadata.DoubleMetaData**
- class **org.datavec.api.transform.metadata.FloatMetaData**
- class **org.datavec.api.transform.metadata.IntegerMetaData**
- class **org.datavec.api.transform.metadata.LongMetaData**
- class **org.datavec.api.transform.metadata.NDArrayMetaData**
- class **org.datavec.api.transform.metadata.StringMetaData**
- class **org.datavec.api.transform.metadata.TimeMetaData**
- class **org.datavec.api.transform.ndarray.NDArrayColumnsMathOpTransform**
- class **org.datavec.api.transform.ndarray.NDArrayDistanceTransform**
- class **org.datavec.api.transform.ndarray.NDArrayMathFunctionTransform**
- class **org.datavec.api.transform.ndarray.NDArrayScalarOpTransform**
- class **org.datavec.api.transform.ops.AggregableCheckingOp**
- class **org.datavec.api.transform.ops.AggregableMultiOp**
- class **org.datavec.api.transform.ops.AggregatorImpls$AggregableCount**
- class **org.datavec.api.transform.ops.AggregatorImpls$AggregableCountUnique**
- class **org.datavec.api.transform.ops.AggregatorImpls$AggregableFirst**
- class **org.datavec.api.transform.ops.AggregatorImpls$AggregableLast**
- class **org.datavec.api.transform.ops.AggregatorImpls$AggregableMax**
- class **org.datavec.api.transform.ops.AggregatorImpls$AggregableMean**
- class **org.datavec.api.transform.ops.AggregatorImpls$AggregableMin**
- class **org.datavec.api.transform.ops.AggregatorImpls$AggregablePopulationVariance**
- class **org.datavec.api.transform.ops.AggregatorImpls$AggregableProd**
- class **org.datavec.api.transform.ops.AggregatorImpls$AggregableRange**
- class **org.datavec.api.transform.ops.AggregatorImpls$AggregableStdDev**
- class **org.datavec.api.transform.ops.AggregatorImpls$AggregableSum**
- class **org.datavec.api.transform.ops.AggregatorImpls$AggregableUncorrectedStdDev**
- class **org.datavec.api.transform.ops.AggregatorImpls$AggregableVariance**
- class **org.datavec.api.transform.ops.AggregatorImpls**
- class **org.datavec.api.transform.ops.ByteWritableOp**
- class **org.datavec.api.transform.ops.DispatchOp**
- class **org.datavec.api.transform.ops.DispatchWithConditionOp**
- class **org.datavec.api.transform.ops.DoubleWritableOp**
- class **org.datavec.api.transform.ops.FloatWritableOp**
- interface **org.datavec.api.transform.ops.IAggregableReduceOp**
- class **org.datavec.api.transform.ops.IntWritableOp**
- class **org.datavec.api.transform.ops.LongWritableOp**
- class **org.datavec.api.transform.ops.StringAggregatorImpls$AggregableStringAppend**
- class **org.datavec.api.transform.ops.StringAggregatorImpls$AggregableStringPrepend**
- class **org.datavec.api.transform.ops.StringAggregatorImpls**
- class **org.datavec.api.transform.ops.StringWritableOp**
- class **org.datavec.api.transform.quality.DataQualityAnalysis**
- class **org.datavec.api.transform.quality.columns.BytesQuality**
- class **org.datavec.api.transform.quality.columns.CategoricalQuality**
- class **org.datavec.api.transform.quality.columns.ColumnQuality**
- class **org.datavec.api.transform.quality.columns.DoubleQuality**
- class **org.datavec.api.transform.quality.columns.IntegerQuality**
- class **org.datavec.api.transform.quality.columns.LongQuality**
- class **org.datavec.api.transform.quality.columns.StringQuality**
- class **org.datavec.api.transform.quality.columns.TimeQuality**
- class **org.datavec.api.transform.rank.CalculateSortedRank**
- interface **org.datavec.api.transform.reduce.AggregableColumnReduction**
- class **org.datavec.api.transform.reduce.AggregableReductionUtils**
- interface **org.datavec.api.transform.reduce.ColumnReduction**
- interface **org.datavec.api.transform.reduce.IAssociativeReducer**
- class **org.datavec.api.transform.reduce.Reducer$Builder**
- class **org.datavec.api.transform.reduce.Reducer$ConditionalReduction**
- class **org.datavec.api.transform.reduce.Reducer**
- class **org.datavec.api.transform.reduce.geo.CoordinatesReduction$CoordinateAggregableReduceOp**
- class **org.datavec.api.transform.reduce.geo.CoordinatesReduction**
- class **org.datavec.api.transform.reduce.impl.GeographicMidpointReduction$AverageCoordinateReduceOp**
- class **org.datavec.api.transform.reduce.impl.GeographicMidpointReduction**
- class **org.datavec.api.transform.schema.InferredSchema**
- class **org.datavec.api.transform.schema.Schema$Builder**
- class **org.datavec.api.transform.schema.Schema**
- class **org.datavec.api.transform.schema.SequenceSchema$Builder**
- class **org.datavec.api.transform.schema.SequenceSchema**
- class **org.datavec.api.transform.schema.conversion.TypeConversion**
- class **org.datavec.api.transform.sequence.ConvertFromSequence**
- class **org.datavec.api.transform.sequence.ConvertToSequence**
- class **org.datavec.api.transform.sequence.ReduceSequenceTransform**
- interface **org.datavec.api.transform.sequence.SequenceComparator**
- interface **org.datavec.api.transform.sequence.SequenceSplit**
- class **org.datavec.api.transform.sequence.comparator.BaseColumnComparator**
- class **org.datavec.api.transform.sequence.comparator.NumericalColumnComparator**
- class **org.datavec.api.transform.sequence.comparator.StringComparator**
- class **org.datavec.api.transform.sequence.expansion.BaseSequenceExpansionTransform**
- class **org.datavec.api.transform.sequence.merge.SequenceMerge**
- class **org.datavec.api.transform.sequence.split.SequenceSplitTimeSeparation**
- class **org.datavec.api.transform.sequence.split.SplitMaxLengthSequence**
- class **org.datavec.api.transform.sequence.trim.SequenceTrimTransform**
- class **org.datavec.api.transform.sequence.window.OverlappingTimeWindowFunction$Builder**
- class **org.datavec.api.transform.sequence.window.OverlappingTimeWindowFunction**
- class **org.datavec.api.transform.sequence.window.ReduceSequenceByWindowTransform**
- class **org.datavec.api.transform.sequence.window.TimeWindowFunction$Builder**
- class **org.datavec.api.transform.sequence.window.TimeWindowFunction**
- interface **org.datavec.api.transform.sequence.window.WindowFunction**
- class **org.datavec.api.transform.serde.BaseSerializer**
- class **org.datavec.api.transform.serde.JsonMappers**
- class **org.datavec.api.transform.serde.JsonSerializer**
- class **org.datavec.api.transform.serde.ListWrappers$ConditionList**
- class **org.datavec.api.transform.serde.ListWrappers$DataActionList**
- class **org.datavec.api.transform.serde.ListWrappers$FilterList**
- class **org.datavec.api.transform.serde.ListWrappers$ReducerList**
- class **org.datavec.api.transform.serde.ListWrappers$SequenceComparatorList**
- class **org.datavec.api.transform.serde.ListWrappers$TransformList**
- class **org.datavec.api.transform.serde.ListWrappers**
- class **org.datavec.api.transform.serde.YamlSerializer**
- class **org.datavec.api.transform.serde.legacy.GenericLegacyDeserializer**
- class **org.datavec.api.transform.serde.legacy.LegacyMappingHelper$CalculateSortedRankHelper**
- class **org.datavec.api.transform.serde.legacy.LegacyMappingHelper$ColumnAnalysisHelper**
- class **org.datavec.api.transform.serde.legacy.LegacyMappingHelper$ColumnMetaDataHelper**
- class **org.datavec.api.transform.serde.legacy.LegacyMappingHelper$ConditionHelper**
- class **org.datavec.api.transform.serde.legacy.LegacyMappingHelper$FilterHelper**
- class **org.datavec.api.transform.serde.legacy.LegacyMappingHelper$IStringReducerHelper**
- class **org.datavec.api.transform.serde.legacy.LegacyMappingHelper$LegacyCalculateSortedRankDeserializer**
- class **org.datavec.api.transform.serde.legacy.LegacyMappingHelper$LegacyColumnAnalysisDeserializer**
- class **org.datavec.api.transform.serde.legacy.LegacyMappingHelper$LegacyColumnMetaDataDeserializer**
- class **org.datavec.api.transform.serde.legacy.LegacyMappingHelper$LegacyConditionDeserializer**
- class **org.datavec.api.transform.serde.legacy.LegacyMappingHelper$LegacyFilterDeserializer**
- class **org.datavec.api.transform.serde.legacy.LegacyMappingHelper$LegacyIStringReducerDeserializer**
- class **org.datavec.api.transform.serde.legacy.LegacyMappingHelper$LegacySchemaDeserializer**
- class **org.datavec.api.transform.serde.legacy.LegacyMappingHelper$LegacySequenceComparatorDeserializer**
- class **org.datavec.api.transform.serde.legacy.LegacyMappingHelper$LegacySequenceSplitDeserializer**
- class **org.datavec.api.transform.serde.legacy.LegacyMappingHelper$LegacyTransformDeserializer**
- class **org.datavec.api.transform.serde.legacy.LegacyMappingHelper$LegacyWindowFunctionDeserializer**
- class **org.datavec.api.transform.serde.legacy.LegacyMappingHelper$LegacyWritableComparatorDeserializer**
- class **org.datavec.api.transform.serde.legacy.LegacyMappingHelper$LegacyWritableDeserializer**
- class **org.datavec.api.transform.serde.legacy.LegacyMappingHelper$SchemaHelper**
- class **org.datavec.api.transform.serde.legacy.LegacyMappingHelper$SequenceComparatorHelper**
- class **org.datavec.api.transform.serde.legacy.LegacyMappingHelper$SequenceSplitHelper**
- class **org.datavec.api.transform.serde.legacy.LegacyMappingHelper$TransformHelper**
- class **org.datavec.api.transform.serde.legacy.LegacyMappingHelper$WindowFunctionHelper**
- class **org.datavec.api.transform.serde.legacy.LegacyMappingHelper$WritableComparatorHelper**
- class **org.datavec.api.transform.serde.legacy.LegacyMappingHelper$WritableHelper**
- class **org.datavec.api.transform.serde.legacy.LegacyMappingHelper**
- class **org.datavec.api.transform.split.RandomSplit**
- interface **org.datavec.api.transform.split.SplitStrategy**
- interface **org.datavec.api.transform.stringreduce.IStringReducer**
- class **org.datavec.api.transform.stringreduce.StringReducer$Builder**
- class **org.datavec.api.transform.stringreduce.StringReducer**
- class **org.datavec.api.transform.transform.BaseColumnTransform**
- class **org.datavec.api.transform.transform.BaseColumnsMathOpTransform**
- class **org.datavec.api.transform.transform.BaseTransform**
- class **org.datavec.api.transform.transform.categorical.CategoricalToIntegerTransform**
- class **org.datavec.api.transform.transform.categorical.CategoricalToOneHotTransform**
- class **org.datavec.api.transform.transform.categorical.IntegerToCategoricalTransform**
- class **org.datavec.api.transform.transform.categorical.PivotTransform**
- class **org.datavec.api.transform.transform.categorical.StringToCategoricalTransform**
- class **org.datavec.api.transform.transform.column.AddConstantColumnTransform**
- class **org.datavec.api.transform.transform.column.DuplicateColumnsTransform**
- class **org.datavec.api.transform.transform.column.RemoveAllColumnsExceptForTransform**
- class **org.datavec.api.transform.transform.column.RemoveColumnsTransform**
- class **org.datavec.api.transform.transform.column.RenameColumnsTransform**
- class **org.datavec.api.transform.transform.column.ReorderColumnsTransform**
- class **org.datavec.api.transform.transform.condition.ConditionalCopyValueTransform**
- class **org.datavec.api.transform.transform.condition.ConditionalReplaceValueTransform**
- class **org.datavec.api.transform.transform.condition.ConditionalReplaceValueTransformWithDefault**
- class **org.datavec.api.transform.transform.doubletransform.BaseDoubleTransform**
- class **org.datavec.api.transform.transform.doubletransform.ConvertToDouble**
- class **org.datavec.api.transform.transform.doubletransform.DoubleColumnsMathOpTransform**
- class **org.datavec.api.transform.transform.doubletransform.DoubleMathFunctionTransform**
- class **org.datavec.api.transform.transform.doubletransform.DoubleMathOpTransform**
- class **org.datavec.api.transform.transform.doubletransform.Log2Normalizer**
- class **org.datavec.api.transform.transform.doubletransform.MinMaxNormalizer**
- class **org.datavec.api.transform.transform.doubletransform.StandardizeNormalizer**
- class **org.datavec.api.transform.transform.doubletransform.SubtractMeanNormalizer**
- class **org.datavec.api.transform.transform.floattransform.BaseFloatTransform**
- class **org.datavec.api.transform.transform.floattransform.ConvertToFloat**
- class **org.datavec.api.transform.transform.floattransform.FloatColumnsMathOpTransform**
- class **org.datavec.api.transform.transform.floattransform.FloatMathFunctionTransform**
- class **org.datavec.api.transform.transform.floattransform.FloatMathOpTransform**
- class **org.datavec.api.transform.transform.geo.CoordinatesDistanceTransform**
- class **org.datavec.api.transform.transform.geo.GeoIPFetcher**
- class **org.datavec.api.transform.transform.geo.IPAddressToCoordinatesTransform**
- class **org.datavec.api.transform.transform.geo.IPAddressToLocationTransform**
- class **org.datavec.api.transform.transform.integer.BaseIntegerTransform**
- class **org.datavec.api.transform.transform.integer.ConvertToInteger**
- class **org.datavec.api.transform.transform.integer.IntegerColumnsMathOpTransform**
- class **org.datavec.api.transform.transform.integer.IntegerMathOpTransform**
- class **org.datavec.api.transform.transform.integer.IntegerToOneHotTransform**
- class **org.datavec.api.transform.transform.integer.ReplaceEmptyIntegerWithValueTransform**
- class **org.datavec.api.transform.transform.integer.ReplaceInvalidWithIntegerTransform**
- class **org.datavec.api.transform.transform.longtransform.LongColumnsMathOpTransform**
- class **org.datavec.api.transform.transform.longtransform.LongMathOpTransform**
- class **org.datavec.api.transform.transform.nlp.TextToCharacterIndexTransform**
- class **org.datavec.api.transform.transform.nlp.TextToTermIndexSequenceTransform**
- enum **org.datavec.api.transform.transform.normalize.Normalize**
- class **org.datavec.api.transform.transform.parse.ParseDoubleTransform**
- enum **org.datavec.api.transform.transform.sequence.SequenceDifferenceTransform$FirstStepMode**
- class **org.datavec.api.transform.transform.sequence.SequenceDifferenceTransform**
- enum **org.datavec.api.transform.transform.sequence.SequenceMovingWindowReduceTransform$EdgeCaseHandling**
- class **org.datavec.api.transform.transform.sequence.SequenceMovingWindowReduceTransform**
- enum **org.datavec.api.transform.transform.sequence.SequenceOffsetTransform$EdgeHandling**
- enum **org.datavec.api.transform.transform.sequence.SequenceOffsetTransform$OperationType**
- class **org.datavec.api.transform.transform.sequence.SequenceOffsetTransform**
- class **org.datavec.api.transform.transform.string.AppendStringColumnTransform**
- class **org.datavec.api.transform.transform.string.BaseStringTransform**
- enum **org.datavec.api.transform.transform.string.ChangeCaseStringTransform$CaseType**
- class **org.datavec.api.transform.transform.string.ChangeCaseStringTransform**
- class **org.datavec.api.transform.transform.string.ConcatenateStringColumns**
- class **org.datavec.api.transform.transform.string.ConvertToString**
- class **org.datavec.api.transform.transform.string.MapAllStringsExceptListTransform**
- class **org.datavec.api.transform.transform.string.RemoveWhiteSpaceTransform**
- class **org.datavec.api.transform.transform.string.ReplaceEmptyStringTransform**
- class **org.datavec.api.transform.transform.string.ReplaceStringTransform**
- class **org.datavec.api.transform.transform.string.StringListToCategoricalSetTransform**
- class **org.datavec.api.transform.transform.string.StringListToCountsNDArrayTransform**
- class **org.datavec.api.transform.transform.string.StringListToIndicesNDArrayTransform**
- class **org.datavec.api.transform.transform.string.StringMapTransform**
- class **org.datavec.api.transform.transform.time.DeriveColumnsFromTimeTransform$Builder**
- class **org.datavec.api.transform.transform.time.DeriveColumnsFromTimeTransform$DerivedColumn**
- class **org.datavec.api.transform.transform.time.DeriveColumnsFromTimeTransform**
- class **org.datavec.api.transform.transform.time.StringToTimeTransform**
- class **org.datavec.api.transform.transform.time.TimeMathOpTransform**
- class **org.datavec.api.transform.ui.DivObject**
- class **org.datavec.api.transform.ui.HtmlAnalysis**
- class **org.datavec.api.transform.ui.HtmlSequencePlotting**
- class **org.datavec.api.transform.ui.components.RenderableComponent**
- class **org.datavec.api.transform.ui.components.RenderableComponentHistogram$Builder**
- class **org.datavec.api.transform.ui.components.RenderableComponentHistogram**
- class **org.datavec.api.transform.ui.components.RenderableComponentLineChart$Builder**
- class **org.datavec.api.transform.ui.components.RenderableComponentLineChart**
- class **org.datavec.api.transform.ui.components.RenderableComponentTable$Builder**
- class **org.datavec.api.transform.ui.components.RenderableComponentTable**
- class **org.datavec.api.util.ClassPathResource**
- class **org.datavec.api.util.RecordUtils**
- class **org.datavec.api.util.ReflectionUtils**
- class **org.datavec.api.util.files.FileFromPathIterator**
- class **org.datavec.api.util.files.ShuffledListIterator**
- class **org.datavec.api.util.files.URIUtil**
- class **org.datavec.api.util.files.UriFromPathIterator**
- class **org.datavec.api.util.jackson.DateTimeFieldTypeDeserializer**
- class **org.datavec.api.util.jackson.DateTimeFieldTypeSerializer**
- class **org.datavec.api.util.jdbc.JdbcWritableConverter**
- class **org.datavec.api.util.jdbc.ResettableResultSetIterator**
- class **org.datavec.api.util.ndarray.DataInputWrapperStream**
- class **org.datavec.api.util.ndarray.DataOutputWrapperStream**
- class **org.datavec.api.util.ndarray.RecordConverter**
- interface **org.datavec.api.vector.Vectorizer$RecordCallBack**
- interface **org.datavec.api.vector.Vectorizer**
- class **org.datavec.api.writable.ArrayWritable**
- class **org.datavec.api.writable.BooleanWritable$Comparator**
- class **org.datavec.api.writable.BooleanWritable**
- class **org.datavec.api.writable.ByteWritable$Comparator**
- class **org.datavec.api.writable.ByteWritable**
- class **org.datavec.api.writable.BytesWritable**
- class **org.datavec.api.writable.DoubleWritable$Comparator**
- class **org.datavec.api.writable.DoubleWritable**
- class **org.datavec.api.writable.FloatWritable$Comparator**
- class **org.datavec.api.writable.FloatWritable**
- class **org.datavec.api.writable.IntWritable$Comparator**
- class **org.datavec.api.writable.IntWritable**
- class **org.datavec.api.writable.LongWritable$Comparator**
- class **org.datavec.api.writable.LongWritable$DecreasingComparator**
- class **org.datavec.api.writable.LongWritable**
- class **org.datavec.api.writable.NDArrayWritable**
- class **org.datavec.api.writable.NullWritable**
- class **org.datavec.api.writable.Text$Comparator**
- class **org.datavec.api.writable.Text**
- class **org.datavec.api.writable.UnsafeWritableInjector**
- interface **org.datavec.api.writable.Writable**
- class **org.datavec.api.writable.WritableFactory**
- enum **org.datavec.api.writable.WritableType**
- class **org.datavec.api.writable.batch.AbstractTimeSeriesWritableRecordBatch**
- class **org.datavec.api.writable.batch.AbstractWritableRecordBatch$RecordBatchListIterator**
- class **org.datavec.api.writable.batch.AbstractWritableRecordBatch**
- class **org.datavec.api.writable.batch.NDArrayRecordBatch**
- class **org.datavec.api.writable.comparator.Comparators**
- class **org.datavec.api.writable.comparator.DoubleWritableComparator**
- class **org.datavec.api.writable.comparator.FloatWritableComparator**
- class **org.datavec.api.writable.comparator.IntWritableComparator**
- class **org.datavec.api.writable.comparator.LongWritableComparator**
- class **org.datavec.api.writable.comparator.ReverseComparator**
- class **org.datavec.api.writable.comparator.TextWritableComparator**
- interface **org.datavec.api.writable.comparator.WritableComparator**
- class **org.datavec.arrow.ArrowConverter**
- class **org.datavec.arrow.recordreader.ArrowRecord**
- class **org.datavec.arrow.recordreader.ArrowRecordReader**
- class **org.datavec.arrow.recordreader.ArrowRecordWriter**
- class **org.datavec.arrow.recordreader.ArrowWritableRecordBatch**
- class **org.datavec.arrow.recordreader.ArrowWritableRecordTimeSeriesBatch**
- class **org.datavec.audio.Wave**
- class **org.datavec.audio.WaveFileManager**
- class **org.datavec.audio.WaveHeader**
- class **org.datavec.audio.dsp.FastFourierTransform**
- class **org.datavec.audio.dsp.LinearInterpolation**
- class **org.datavec.audio.dsp.Resampler**
- class **org.datavec.audio.dsp.WindowFunction**
- class **org.datavec.audio.extension.NormalizedSampleAmplitudes**
- class **org.datavec.audio.extension.Spectrogram**
- class **org.datavec.audio.fingerprint.FingerprintManager**
- class **org.datavec.audio.fingerprint.FingerprintSimilarity**
- class **org.datavec.audio.fingerprint.FingerprintSimilarityComputer**
- interface **org.datavec.audio.fingerprint.MapRank**
- class **org.datavec.audio.fingerprint.MapRankDouble**
- class **org.datavec.audio.fingerprint.MapRankInteger**
- class **org.datavec.audio.fingerprint.PairManager**
- class **org.datavec.audio.fingerprint.QuickSort**
- class **org.datavec.audio.fingerprint.QuickSortDouble**
- class **org.datavec.audio.fingerprint.QuickSortIndexPreserved**
- class **org.datavec.audio.fingerprint.QuickSortInteger**
- class **org.datavec.audio.fingerprint.QuickSortShort**
- class **org.datavec.audio.formats.input.WavInputFormat**
- class **org.datavec.audio.formats.output.WaveOutputFormat**
- class **org.datavec.audio.processor.ArrayRankDouble**
- interface **org.datavec.audio.processor.IntensityProcessor**
- class **org.datavec.audio.processor.ProcessorChain**
- class **org.datavec.audio.processor.RobustIntensityProcessor**
- class **org.datavec.audio.processor.TopManyPointsProcessorChain**
- class **org.datavec.audio.properties.FingerprintProperties**
- class **org.datavec.audio.recordreader.BaseAudioRecordReader**
- class **org.datavec.audio.recordreader.NativeAudioRecordReader**
- class **org.datavec.audio.recordreader.WavFileRecordReader**
- class **org.datavec.camel.component.DataVecComponent**
- class **org.datavec.camel.component.DataVecConsumer**
- class **org.datavec.camel.component.DataVecEndpoint**
- interface **org.datavec.camel.component.DataVecMarshaller**
- class **org.datavec.camel.component.DataVecProducer**
- class **org.datavec.camel.component.csv.marshaller.ListStringInputMarshaller**
- class **org.datavec.codec.format.input.CodecInputFormat**
- class **org.datavec.codec.reader.BaseCodecRecordReader**
- class **org.datavec.codec.reader.CodecRecordReader**
- class **org.datavec.codec.reader.NativeCodecRecordReader**
- class **org.datavec.hadoop.conf.ConfigurationUtil**
- interface **org.datavec.hadoop.records.reader.mapfile.IndexToKey**
- class **org.datavec.hadoop.records.reader.mapfile.MapFileReader**
- class **org.datavec.hadoop.records.reader.mapfile.MapFileRecordReader**
- class **org.datavec.hadoop.records.reader.mapfile.MapFileSequenceRecordReader**
- class **org.datavec.hadoop.records.reader.mapfile.index.LongIndexToKey**
- class **org.datavec.hadoop.records.reader.mapfile.record.RecordWritable**
- class **org.datavec.hadoop.records.reader.mapfile.record.SequenceRecordWritable**
- class **org.datavec.hadoop.records.writer.mapfile.AbstractMapFileWriter**
- class **org.datavec.hadoop.records.writer.mapfile.MapFileRecordWriter**
- class **org.datavec.hadoop.records.writer.mapfile.MapFileSequenceRecordWriter**
- class **org.datavec.image.data.Image**
- class **org.datavec.image.data.ImageWritable**
- class **org.datavec.image.format.ImageInputFormat**
- class **org.datavec.image.loader.AndroidNativeImageLoader**
- enum **org.datavec.image.loader.BaseImageLoader$MultiPageMode**
- class **org.datavec.image.loader.BaseImageLoader**
- class **org.datavec.image.loader.CifarLoader**
- class **org.datavec.image.loader.ImageLoader**
- class **org.datavec.image.loader.Java2DNativeImageLoader**
- class **org.datavec.image.loader.LFWLoader**
- class **org.datavec.image.loader.NativeImageLoader**
- class **org.datavec.image.mnist.MnistDbFile**
- class **org.datavec.image.mnist.MnistFetcher**
- class **org.datavec.image.mnist.MnistImageFile**
- class **org.datavec.image.mnist.MnistLabelFile**
- class **org.datavec.image.mnist.MnistManager**
- class **org.datavec.image.mnist.draw.DrawMnist**
- class **org.datavec.image.mnist.draw.DrawReconstruction**
- class **org.datavec.image.recordreader.BaseImageRecordReader**
- class **org.datavec.image.recordreader.ImageRecordReader**
- class **org.datavec.image.recordreader.VideoRecordReader**
- class **org.datavec.image.recordreader.objdetect.ImageObject**
- interface **org.datavec.image.recordreader.objdetect.ImageObjectLabelProvider**
- class **org.datavec.image.recordreader.objdetect.ObjectDetectionRecordReader**
- class **org.datavec.image.recordreader.objdetect.impl.SvhnLabelProvider**
- class **org.datavec.image.recordreader.objdetect.impl.VocLabelProvider**
- class **org.datavec.image.serde.LegacyImageMappingHelper$ImageTransformHelper**
- class **org.datavec.image.serde.LegacyImageMappingHelper$LegacyImageTransformDeserializer**
- class **org.datavec.image.serde.LegacyImageMappingHelper**
- class **org.datavec.image.transform.BaseImageTransform**
- class **org.datavec.image.transform.BoxImageTransform**
- class **org.datavec.image.transform.ColorConversionTransform**
- class **org.datavec.image.transform.CropImageTransform**
- class **org.datavec.image.transform.EqualizeHistTransform**
- class **org.datavec.image.transform.FilterImageTransform**
- class **org.datavec.image.transform.FlipImageTransform**
- interface **org.datavec.image.transform.ImageTransform**
- class **org.datavec.image.transform.ImageTransformProcess$Builder**
- class **org.datavec.image.transform.ImageTransformProcess**
- class **org.datavec.image.transform.LargestBlobCropTransform**
- class **org.datavec.image.transform.MultiImageTransform**
- class **org.datavec.image.transform.PipelineImageTransform$Builder**
- class **org.datavec.image.transform.PipelineImageTransform**
- class **org.datavec.image.transform.RandomCropTransform**
- class **org.datavec.image.transform.ResizeImageTransform**
- class **org.datavec.image.transform.RotateImageTransform**
- class **org.datavec.image.transform.ScaleImageTransform**
- class **org.datavec.image.transform.ShowImageTransform**
- class **org.datavec.image.transform.WarpImageTransform**
- class **org.datavec.image.util.ImageUtils**
- class **org.datavec.local.transforms.AnalyzeLocal**
- class **org.datavec.local.transforms.BaseFlatMapFunctionAdaptee**
- class **org.datavec.local.transforms.LocalTransformExecutor**
- class **org.datavec.local.transforms.LocalTransformProcessRecordReader**
- class **org.datavec.local.transforms.LocalTransformProcessSequenceRecordReader**
- class **org.datavec.local.transforms.SequenceEmptyRecordFunction**
- class **org.datavec.local.transforms.analysis.aggregate.AnalysisAddFunction**
- class **org.datavec.local.transforms.analysis.aggregate.AnalysisCombineFunction**
- class **org.datavec.local.transforms.analysis.histogram.HistogramAddFunction**
- class **org.datavec.local.transforms.analysis.histogram.HistogramCombineFunction**
- class **org.datavec.local.transforms.functions.EmptyRecordFunction**
- interface **org.datavec.local.transforms.functions.FlatMapFunctionAdapter**
- class **org.datavec.local.transforms.functions.LineRecordReaderFunction**
- class **org.datavec.local.transforms.functions.RecordReaderFunction**
- class **org.datavec.local.transforms.functions.SequenceRecordReaderFunction**
- class **org.datavec.local.transforms.functions.data.FilesAsBytesFunction**
- class **org.datavec.local.transforms.functions.data.RecordReaderBytesFunction**
- class **org.datavec.local.transforms.functions.data.SequenceRecordReaderBytesFunction**
- class **org.datavec.local.transforms.join.ExecuteJoinFromCoGroupFlatMapFunction**
- class **org.datavec.local.transforms.join.ExecuteJoinFromCoGroupFlatMapFunctionAdapter**
- class **org.datavec.local.transforms.join.ExtractKeysFunction**
- class **org.datavec.local.transforms.join.FilterAndFlattenJoinedValues**
- class **org.datavec.local.transforms.join.FilterAndFlattenJoinedValuesAdapter**
- class **org.datavec.local.transforms.join.JoinedValue**
- class **org.datavec.local.transforms.misc.ColumnAsKeyPairFunction**
- class **org.datavec.local.transforms.misc.ColumnToKeyPairTransform**
- class **org.datavec.local.transforms.misc.NDArrayToWritablesFunction**
- class **org.datavec.local.transforms.misc.SequenceMergeFunction**
- class **org.datavec.local.transforms.misc.SequenceWritablesToStringFunction**
- class **org.datavec.local.transforms.misc.StringToWritablesFunction**
- class **org.datavec.local.transforms.misc.SumLongsFunction2**
- class **org.datavec.local.transforms.misc.WritablesToNDArrayFunction**
- class **org.datavec.local.transforms.misc.WritablesToStringFunction**
- class **org.datavec.local.transforms.misc.comparator.Tuple2Comparator**
- class **org.datavec.local.transforms.rank.UnzipForCalculateSortedRankFunction**
- class **org.datavec.local.transforms.reduce.MapToPairForReducerFunction**
- class **org.datavec.local.transforms.reduce.ReducerFunction**
- class **org.datavec.local.transforms.sequence.ConvertToSequenceLengthOne**
- class **org.datavec.local.transforms.sequence.LocalGroupToSequenceFunction**
- class **org.datavec.local.transforms.sequence.LocalMapToPairByColumnFunction**
- class **org.datavec.local.transforms.sequence.LocalMapToPairByMultipleColumnsFunction**
- class **org.datavec.local.transforms.sequence.LocalSequenceFilterFunction**
- class **org.datavec.local.transforms.sequence.LocalSequenceTransformFunction**
- class **org.datavec.local.transforms.transform.LocalTransformFunction**
- class **org.datavec.local.transforms.transform.LocalTransformProcessFunction**
- class **org.datavec.local.transforms.transform.LocalTransformProcessFunctionAdapter**
- class **org.datavec.local.transforms.transform.SequenceSplitFunction**
- class **org.datavec.local.transforms.transform.SequenceSplitFunctionAdapter**
- class **org.datavec.local.transforms.transform.filter.FilterWritablesBySchemaFunction**
- class **org.datavec.local.transforms.transform.filter.LocalFilterFunction**
- class **org.datavec.nlp.annotator.PoStagger**
- class **org.datavec.nlp.annotator.SentenceAnnotator**
- class **org.datavec.nlp.annotator.StemmerAnnotator**
- class **org.datavec.nlp.annotator.TokenizerAnnotator**
- class **org.datavec.nlp.input.TextInputFormat**
- class **org.datavec.nlp.metadata.DefaultVocabCache**
- interface **org.datavec.nlp.metadata.VocabCache**
- class **org.datavec.nlp.movingwindow.ContextLabelRetriever**
- class **org.datavec.nlp.movingwindow.Util**
- class **org.datavec.nlp.movingwindow.Window**
- class **org.datavec.nlp.movingwindow.Windows**
- class **org.datavec.nlp.reader.TfidfRecordReader**
- class **org.datavec.nlp.stopwords.StopWords**
- class **org.datavec.nlp.tokenization.tokenizer.ConcurrentTokenizer**
- class **org.datavec.nlp.tokenization.tokenizer.DefaultStreamTokenizer**
- class **org.datavec.nlp.tokenization.tokenizer.DefaultTokenizer**
- class **org.datavec.nlp.tokenization.tokenizer.PosUimaTokenizer**
- interface **org.datavec.nlp.tokenization.tokenizer.TokenPreProcess**
- interface **org.datavec.nlp.tokenization.tokenizer.Tokenizer**
- class **org.datavec.nlp.tokenization.tokenizer.UimaTokenizer**
- class **org.datavec.nlp.tokenization.tokenizer.preprocessor.EndingPreProcessor**
- class **org.datavec.nlp.tokenization.tokenizerfactory.DefaultTokenizerFactory**
- class **org.datavec.nlp.tokenization.tokenizerfactory.PosUimaTokenizerFactory**
- interface **org.datavec.nlp.tokenization.tokenizerfactory.TokenizerFactory**
- class **org.datavec.nlp.tokenization.tokenizerfactory.UimaTokenizerFactory**
- class **org.datavec.nlp.uima.UimaResource**
- class **org.datavec.nlp.vectorizer.AbstractTfidfVectorizer**
- class **org.datavec.nlp.vectorizer.TextVectorizer**
- class **org.datavec.nlp.vectorizer.TfidfVectorizer**
- interface **org.datavec.perf.timing.IOTiming$INDArrayCreationFunction**
- class **org.datavec.perf.timing.IOTiming**
- class **org.datavec.perf.timing.TimingStatistics**
- class **org.datavec.poi.excel.ExcelRecordReader**
- class **org.datavec.poi.excel.ExcelRecordWriter**
- class **org.datavec.spark.SequenceEmptyRecordFunction**
- class **org.datavec.spark.functions.EmptyRecordFunction**
- interface **org.datavec.spark.functions.FlatMapFunctionAdapter**
- class **org.datavec.spark.functions.LineRecordReaderFunction**
- class **org.datavec.spark.functions.RecordReaderFunction**
- class **org.datavec.spark.functions.SequenceRecordReaderFunction**
- class **org.datavec.spark.functions.data.FilesAsBytesFunction**
- class **org.datavec.spark.functions.data.RecordReaderBytesFunction**
- class **org.datavec.spark.functions.data.SequenceRecordReaderBytesFunction**
- class **org.datavec.spark.functions.pairdata.BytesPairWritable**
- class **org.datavec.spark.functions.pairdata.MapToBytesPairWritableFunction**
- class **org.datavec.spark.functions.pairdata.PairSequenceRecordReaderBytesFunction**
- interface **org.datavec.spark.functions.pairdata.PathToKeyConverter**
- class **org.datavec.spark.functions.pairdata.PathToKeyConverterFilename**
- class **org.datavec.spark.functions.pairdata.PathToKeyConverterNumber**
- class **org.datavec.spark.functions.pairdata.PathToKeyFunction**
- class **org.datavec.spark.storage.SparkStorageUtils**
- class **org.datavec.spark.storage.functions.RecordLoadPairFunction**
- class **org.datavec.spark.storage.functions.RecordSavePrepPairFunction**
- class **org.datavec.spark.storage.functions.SequenceRecordLoadPairFunction**
- class **org.datavec.spark.storage.functions.SequenceRecordSavePrepPairFunction**
- class **org.datavec.spark.transform.AnalyzeSpark**
- class **org.datavec.spark.transform.BaseFlatMapFunctionAdaptee**
- class **org.datavec.spark.transform.CSVSparkTransform**
- class **org.datavec.spark.transform.CSVSparkTransformServer**
- class **org.datavec.spark.transform.DataFrames**
- class **org.datavec.spark.transform.DataRowsFacade**
- class **org.datavec.spark.transform.FunctionUtil**
- class **org.datavec.spark.transform.ImageSparkTransform**
- class **org.datavec.spark.transform.ImageSparkTransformServer**
- class **org.datavec.spark.transform.Normalization**
- class **org.datavec.spark.transform.SparkTransformExecutor**
- class **org.datavec.spark.transform.SparkTransformServer**
- class **org.datavec.spark.transform.SparkTransformServerChooser**
- enum **org.datavec.spark.transform.TransformDataType**
- class **org.datavec.spark.transform.analysis.CategoricalToPairFunction**
- class **org.datavec.spark.transform.analysis.SelectColumnFunction**
- class **org.datavec.spark.transform.analysis.SequenceFlatMapFunction**
- class **org.datavec.spark.transform.analysis.SequenceFlatMapFunctionAdapter**
- class **org.datavec.spark.transform.analysis.SequenceLengthFunction**
- class **org.datavec.spark.transform.analysis.StringLengthFunction**
- class **org.datavec.spark.transform.analysis.WritableToDoubleFunction**
- class **org.datavec.spark.transform.analysis.WritableToStringFunction**
- class **org.datavec.spark.transform.analysis.aggregate.AnalysisAddFunction**
- class **org.datavec.spark.transform.analysis.aggregate.AnalysisCombineFunction**
- class **org.datavec.spark.transform.analysis.histogram.HistogramAddFunction**
- class **org.datavec.spark.transform.analysis.histogram.HistogramCombineFunction**
- class **org.datavec.spark.transform.analysis.seqlength.IntToDoubleFunction**
- class **org.datavec.spark.transform.analysis.seqlength.SequenceLengthAnalysisAddFunction**
- class **org.datavec.spark.transform.analysis.seqlength.SequenceLengthAnalysisCounter**
- class **org.datavec.spark.transform.analysis.seqlength.SequenceLengthAnalysisMergeFunction**
- class **org.datavec.spark.transform.analysis.string.StringAnalysisCounter**
- class **org.datavec.spark.transform.analysis.string.StringAnalysisMergeFunction**
- class **org.datavec.spark.transform.analysis.unique.UniqueAddFunction**
- class **org.datavec.spark.transform.analysis.unique.UniqueMergeFunction**
- class **org.datavec.spark.transform.client.DataVecTransformClient**
- class **org.datavec.spark.transform.filter.FilterWritablesBySchemaFunction**
- class **org.datavec.spark.transform.filter.SparkFilterFunction**
- class **org.datavec.spark.transform.join.ExecuteJoinFromCoGroupFlatMapFunction**
- class **org.datavec.spark.transform.join.ExecuteJoinFromCoGroupFlatMapFunctionAdapter**
- class **org.datavec.spark.transform.join.ExtractKeysFunction**
- class **org.datavec.spark.transform.join.FilterAndFlattenJoinedValues**
- class **org.datavec.spark.transform.join.FilterAndFlattenJoinedValuesAdapter**
- class **org.datavec.spark.transform.join.JoinedValue**
- class **org.datavec.spark.transform.misc.ColumnAsKeyPairFunction**
- class **org.datavec.spark.transform.misc.ColumnToKeyPairTransform**
- class **org.datavec.spark.transform.misc.NDArrayToWritablesFunction**
- class **org.datavec.spark.transform.misc.SequenceMergeFunction**
- class **org.datavec.spark.transform.misc.SequenceWritablesToStringFunction**
- class **org.datavec.spark.transform.misc.StringToWritablesFunction**
- class **org.datavec.spark.transform.misc.SumLongsFunction2**
- class **org.datavec.spark.transform.misc.WritablesToNDArrayFunction**
- class **org.datavec.spark.transform.misc.WritablesToStringFunction**
- class **org.datavec.spark.transform.misc.comparator.Tuple2Comparator**
- class **org.datavec.spark.transform.model.Base64NDArrayBody**
- class **org.datavec.spark.transform.model.BatchCSVRecord**
- class **org.datavec.spark.transform.model.BatchImageRecord**
- class **org.datavec.spark.transform.model.SequenceBatchCSVRecord**
- class **org.datavec.spark.transform.model.SingleCSVRecord**
- class **org.datavec.spark.transform.model.SingleImageRecord**
- class **org.datavec.spark.transform.rank.UnzipForCalculateSortedRankFunction**
- class **org.datavec.spark.transform.reduce.MapToPairForReducerFunction**
- class **org.datavec.spark.transform.reduce.ReducerFunction**
- class **org.datavec.spark.transform.sequence.ConvertToSequenceLengthOne**
- class **org.datavec.spark.transform.sequence.SparkGroupToSequenceFunction**
- class **org.datavec.spark.transform.sequence.SparkMapToPairByColumnFunction**
- class **org.datavec.spark.transform.sequence.SparkMapToPairByMultipleColumnsFunction**
- class **org.datavec.spark.transform.sequence.SparkSequenceFilterFunction**
- class **org.datavec.spark.transform.sequence.SparkSequenceTransformFunction**
- interface **org.datavec.spark.transform.service.DataVecTransformService**
- class **org.datavec.spark.transform.sparkfunction.SequenceToRows**
- class **org.datavec.spark.transform.sparkfunction.SequenceToRowsAdapter**
- class **org.datavec.spark.transform.sparkfunction.ToRecord**
- class **org.datavec.spark.transform.sparkfunction.ToRow**
- class **org.datavec.spark.transform.sparkfunction.sequence.DataFrameToSequenceCreateCombiner**
- class **org.datavec.spark.transform.sparkfunction.sequence.DataFrameToSequenceMergeCombiner**
- class **org.datavec.spark.transform.sparkfunction.sequence.DataFrameToSequenceMergeValue**
- class **org.datavec.spark.transform.transform.SequenceSplitFunction**
- class **org.datavec.spark.transform.transform.SequenceSplitFunctionAdapter**
- class **org.datavec.spark.transform.transform.SparkTransformFunction**
- class **org.datavec.spark.transform.transform.SparkTransformProcessFunction**
- class **org.datavec.spark.transform.transform.SparkTransformProcessFunctionAdapter**
- class **org.datavec.spark.transform.utils.SparkExport**
- class **org.datavec.spark.transform.utils.SparkUtils**
- class **org.datavec.spark.transform.utils.adapter.BiFunctionAdapter**
- class **org.datavec.spark.util.DataVecSparkUtil**
- interface **org.deeplearning4j.api.loader.DataSetLoader**
- interface **org.deeplearning4j.api.loader.MultiDataSetLoader**
- class **org.deeplearning4j.api.loader.impl.SerializedDataSetLoader**
- class **org.deeplearning4j.api.loader.impl.SerializedMultiDataSetLoader**
- interface **org.deeplearning4j.api.storage.Persistable**
- interface **org.deeplearning4j.api.storage.StatsStorage**
- class **org.deeplearning4j.api.storage.StatsStorageEvent**
- enum **org.deeplearning4j.api.storage.StatsStorageListener$EventType**
- interface **org.deeplearning4j.api.storage.StatsStorageListener**
- interface **org.deeplearning4j.api.storage.StatsStorageRouter**
- interface **org.deeplearning4j.api.storage.StatsStorageRouterProvider**
- interface **org.deeplearning4j.api.storage.StorageMetaData**
- enum **org.deeplearning4j.api.storage.StorageType**
- class **org.deeplearning4j.api.storage.impl.CollectionStatsStorageRouter**
- class **org.deeplearning4j.api.storage.impl.RemoteUIStatsStorageRouter**
- interface **org.deeplearning4j.api.storage.listener.RoutingIterationListener**
- class **org.deeplearning4j.arbiter.BaseNetworkSpace$Builder**
- class **org.deeplearning4j.arbiter.BaseNetworkSpace$LayerConf**
- class **org.deeplearning4j.arbiter.BaseNetworkSpace**
- class **org.deeplearning4j.arbiter.ComputationGraphSpace$Builder**
- class **org.deeplearning4j.arbiter.ComputationGraphSpace$VertexConf**
- class **org.deeplearning4j.arbiter.ComputationGraphSpace**
- class **org.deeplearning4j.arbiter.DL4JConfiguration**
- class **org.deeplearning4j.arbiter.GraphConfiguration**
- class **org.deeplearning4j.arbiter.MultiLayerSpace$Builder**
- class **org.deeplearning4j.arbiter.MultiLayerSpace**
- class **org.deeplearning4j.arbiter.adapter.ActivationParameterSpaceAdapter**
- class **org.deeplearning4j.arbiter.adapter.LossFunctionParameterSpaceAdapter**
- class **org.deeplearning4j.arbiter.conf.dropout.DropoutSpace**
- class **org.deeplearning4j.arbiter.conf.updater.AdaGradSpace**
- class **org.deeplearning4j.arbiter.conf.updater.AdaMaxSpace**
- class **org.deeplearning4j.arbiter.conf.updater.AdamSpace**
- class **org.deeplearning4j.arbiter.conf.updater.BaseUpdaterSpace**
- class **org.deeplearning4j.arbiter.conf.updater.NadamSpace**
- class **org.deeplearning4j.arbiter.conf.updater.NesterovsSpace**
- class **org.deeplearning4j.arbiter.conf.updater.RmsPropSpace**
- class **org.deeplearning4j.arbiter.conf.updater.SgdSpace**
- class **org.deeplearning4j.arbiter.conf.updater.schedule.ExponentialScheduleSpace**
- class **org.deeplearning4j.arbiter.conf.updater.schedule.InverseScheduleSpace**
- class **org.deeplearning4j.arbiter.conf.updater.schedule.PolyScheduleSpace**
- class **org.deeplearning4j.arbiter.conf.updater.schedule.SigmoidScheduleSpace**
- class **org.deeplearning4j.arbiter.conf.updater.schedule.StepScheduleSpace**
- class **org.deeplearning4j.arbiter.data.DataSetIteratorFactoryProvider**
- class **org.deeplearning4j.arbiter.data.MnistDataProvider**
- class **org.deeplearning4j.arbiter.dropout.AlphaDropoutSpace**
- class **org.deeplearning4j.arbiter.dropout.DropoutSpace**
- class **org.deeplearning4j.arbiter.dropout.GaussianDropoutSpace**
- class **org.deeplearning4j.arbiter.dropout.GaussianNoiseSpace**
- class **org.deeplearning4j.arbiter.evaluator.multilayer.ClassificationEvaluator**
- class **org.deeplearning4j.arbiter.evaluator.multilayer.RegressionDataEvaluator**
- class **org.deeplearning4j.arbiter.layers.AbstractLSTMLayerSpace$Builder**
- class **org.deeplearning4j.arbiter.layers.AbstractLSTMLayerSpace**
- class **org.deeplearning4j.arbiter.layers.ActivationLayerSpace$Builder**
- class **org.deeplearning4j.arbiter.layers.ActivationLayerSpace**
- class **org.deeplearning4j.arbiter.layers.AutoEncoderLayerSpace$Builder**
- class **org.deeplearning4j.arbiter.layers.AutoEncoderLayerSpace**
- class **org.deeplearning4j.arbiter.layers.BaseConvolutionLayerSpace$Builder**
- class **org.deeplearning4j.arbiter.layers.BaseConvolutionLayerSpace**
- class **org.deeplearning4j.arbiter.layers.BaseLayerSpace$Builder**
- class **org.deeplearning4j.arbiter.layers.BaseLayerSpace**
- class **org.deeplearning4j.arbiter.layers.BaseOutputLayerSpace$Builder**
- class **org.deeplearning4j.arbiter.layers.BaseOutputLayerSpace**
- class **org.deeplearning4j.arbiter.layers.BasePretrainNetworkLayerSpace$Builder**
- class **org.deeplearning4j.arbiter.layers.BasePretrainNetworkLayerSpace**
- class **org.deeplearning4j.arbiter.layers.BatchNormalizationSpace$Builder**
- class **org.deeplearning4j.arbiter.layers.BatchNormalizationSpace**
- class **org.deeplearning4j.arbiter.layers.Bidirectional**
- class **org.deeplearning4j.arbiter.layers.CenterLossOutputLayerSpace$Builder**
- class **org.deeplearning4j.arbiter.layers.CenterLossOutputLayerSpace**
- class **org.deeplearning4j.arbiter.layers.ConvolutionLayerSpace$Builder**
- class **org.deeplearning4j.arbiter.layers.ConvolutionLayerSpace**
- class **org.deeplearning4j.arbiter.layers.Deconvolution2DLayerSpace$Builder**
- class **org.deeplearning4j.arbiter.layers.Deconvolution2DLayerSpace**
- class **org.deeplearning4j.arbiter.layers.DenseLayerSpace$Builder**
- class **org.deeplearning4j.arbiter.layers.DenseLayerSpace**
- class **org.deeplearning4j.arbiter.layers.DropoutLayerSpace$Builder**
- class **org.deeplearning4j.arbiter.layers.DropoutLayerSpace**
- class **org.deeplearning4j.arbiter.layers.EmbeddingLayerSpace$Builder**
- class **org.deeplearning4j.arbiter.layers.EmbeddingLayerSpace**
- class **org.deeplearning4j.arbiter.layers.FeedForwardLayerSpace$Builder**
- class **org.deeplearning4j.arbiter.layers.FeedForwardLayerSpace**
- class **org.deeplearning4j.arbiter.layers.GlobalPoolingLayerSpace$Builder**
- class **org.deeplearning4j.arbiter.layers.GlobalPoolingLayerSpace**
- class **org.deeplearning4j.arbiter.layers.GravesBidirectionalLSTMLayerSpace$Builder**
- class **org.deeplearning4j.arbiter.layers.GravesBidirectionalLSTMLayerSpace**
- class **org.deeplearning4j.arbiter.layers.GravesLSTMLayerSpace$Builder**
- class **org.deeplearning4j.arbiter.layers.GravesLSTMLayerSpace**
- class **org.deeplearning4j.arbiter.layers.LSTMLayerSpace$Builder**
- class **org.deeplearning4j.arbiter.layers.LSTMLayerSpace**
- class **org.deeplearning4j.arbiter.layers.LayerSpace$Builder**
- class **org.deeplearning4j.arbiter.layers.LayerSpace**
- class **org.deeplearning4j.arbiter.layers.LocalResponseNormalizationLayerSpace$Builder**
- class **org.deeplearning4j.arbiter.layers.LocalResponseNormalizationLayerSpace**
- class **org.deeplearning4j.arbiter.layers.LossLayerSpace$Builder**
- class **org.deeplearning4j.arbiter.layers.LossLayerSpace**
- class **org.deeplearning4j.arbiter.layers.OCNNLayerSpace$Builder**
- class **org.deeplearning4j.arbiter.layers.OCNNLayerSpace**
- class **org.deeplearning4j.arbiter.layers.OutputLayerSpace$Builder**
- class **org.deeplearning4j.arbiter.layers.OutputLayerSpace**
- class **org.deeplearning4j.arbiter.layers.RnnOutputLayerSpace$Builder**
- class **org.deeplearning4j.arbiter.layers.RnnOutputLayerSpace**
- class **org.deeplearning4j.arbiter.layers.SeparableConvolution2DLayerSpace$Builder**
- class **org.deeplearning4j.arbiter.layers.SeparableConvolution2DLayerSpace**
- class **org.deeplearning4j.arbiter.layers.SubsamplingLayerSpace$Builder**
- class **org.deeplearning4j.arbiter.layers.SubsamplingLayerSpace**
- class **org.deeplearning4j.arbiter.layers.VariationalAutoencoderLayerSpace$Builder**
- class **org.deeplearning4j.arbiter.layers.VariationalAutoencoderLayerSpace**
- class **org.deeplearning4j.arbiter.layers.fixed.FixedLayerSpace**
- class **org.deeplearning4j.arbiter.listener.DL4JArbiterStatusReportingListener**
- class **org.deeplearning4j.arbiter.optimize.api.AbstractParameterSpace**
- class **org.deeplearning4j.arbiter.optimize.api.Candidate**
- interface **org.deeplearning4j.arbiter.optimize.api.CandidateGenerator**
- class **org.deeplearning4j.arbiter.optimize.api.OptimizationResult**
- interface **org.deeplearning4j.arbiter.optimize.api.ParameterSpace**
- interface **org.deeplearning4j.arbiter.optimize.api.TaskCreator**
- class **org.deeplearning4j.arbiter.optimize.api.TaskCreatorProvider**
- class **org.deeplearning4j.arbiter.optimize.api.adapter.ParameterSpaceAdapter**
- interface **org.deeplearning4j.arbiter.optimize.api.data.DataProvider**
- class **org.deeplearning4j.arbiter.optimize.api.data.DataSetIteratorFactoryProvider**
- interface **org.deeplearning4j.arbiter.optimize.api.data.DataSource**
- interface **org.deeplearning4j.arbiter.optimize.api.evaluation.ModelEvaluator**
- class **org.deeplearning4j.arbiter.optimize.api.saving.InMemoryResultSaver**
- interface **org.deeplearning4j.arbiter.optimize.api.saving.ResultReference**
- interface **org.deeplearning4j.arbiter.optimize.api.saving.ResultSaver**
- interface **org.deeplearning4j.arbiter.optimize.api.score.ScoreFunction**
- class **org.deeplearning4j.arbiter.optimize.api.termination.MaxCandidatesCondition**
- class **org.deeplearning4j.arbiter.optimize.api.termination.MaxTimeCondition**
- interface **org.deeplearning4j.arbiter.optimize.api.termination.TerminationCondition**
- class **org.deeplearning4j.arbiter.optimize.config.OptimizationConfiguration$Builder**
- class **org.deeplearning4j.arbiter.optimize.config.OptimizationConfiguration**
- class **org.deeplearning4j.arbiter.optimize.distribution.DegenerateIntegerDistribution**
- class **org.deeplearning4j.arbiter.optimize.distribution.DistributionUtils**
- class **org.deeplearning4j.arbiter.optimize.distribution.LogUniformDistribution**
- class **org.deeplearning4j.arbiter.optimize.generator.BaseCandidateGenerator**
- enum **org.deeplearning4j.arbiter.optimize.generator.GridSearchCandidateGenerator$Mode**
- class **org.deeplearning4j.arbiter.optimize.generator.GridSearchCandidateGenerator**
- class **org.deeplearning4j.arbiter.optimize.generator.RandomSearchGenerator**
- class **org.deeplearning4j.arbiter.optimize.generator.util.SerializedSupplier**
- class **org.deeplearning4j.arbiter.optimize.parameter.BooleanSpace**
- class **org.deeplearning4j.arbiter.optimize.parameter.FixedValue**
- class **org.deeplearning4j.arbiter.optimize.parameter.continuous.ContinuousParameterSpace**
- class **org.deeplearning4j.arbiter.optimize.parameter.discrete.DiscreteParameterSpace**
- class **org.deeplearning4j.arbiter.optimize.parameter.integer.IntegerParameterSpace**
- class **org.deeplearning4j.arbiter.optimize.parameter.math.MathOp**
- enum **org.deeplearning4j.arbiter.optimize.parameter.math.Op**
- class **org.deeplearning4j.arbiter.optimize.parameter.math.PairMathOp**
- class **org.deeplearning4j.arbiter.optimize.runner.BaseOptimizationRunner**
- class **org.deeplearning4j.arbiter.optimize.runner.CandidateInfo**
- enum **org.deeplearning4j.arbiter.optimize.runner.CandidateStatus**
- interface **org.deeplearning4j.arbiter.optimize.runner.IOptimizationRunner**
- class **org.deeplearning4j.arbiter.optimize.runner.LocalOptimizationRunner**
- class **org.deeplearning4j.arbiter.optimize.runner.listener.BaseStatusListener**
- enum **org.deeplearning4j.arbiter.optimize.runner.listener.StatusChangeType**
- interface **org.deeplearning4j.arbiter.optimize.runner.listener.StatusListener**
- class **org.deeplearning4j.arbiter.optimize.runner.listener.impl.LoggingStatusListener**
- class **org.deeplearning4j.arbiter.optimize.serde.jackson.GenericDeserializer**
- class **org.deeplearning4j.arbiter.optimize.serde.jackson.GenericSerializer**
- class **org.deeplearning4j.arbiter.optimize.serde.jackson.IntegerDistributionDeserializer**
- class **org.deeplearning4j.arbiter.optimize.serde.jackson.IntegerDistributionSerializer**
- class **org.deeplearning4j.arbiter.optimize.serde.jackson.JsonMapper**
- class **org.deeplearning4j.arbiter.optimize.serde.jackson.RealDistributionDeserializer**
- class **org.deeplearning4j.arbiter.optimize.serde.jackson.RealDistributionSerializer**
- class **org.deeplearning4j.arbiter.optimize.serde.jackson.YamlMapper**
- class **org.deeplearning4j.arbiter.saver.local.FileModelSaver**
- class **org.deeplearning4j.arbiter.saver.local.LocalFileNetResultReference**
- enum **org.deeplearning4j.arbiter.scoring.RegressionValue**
- class **org.deeplearning4j.arbiter.scoring.ScoreFunctions**
- class **org.deeplearning4j.arbiter.scoring.impl.BaseNetScoreFunction**
- class **org.deeplearning4j.arbiter.scoring.impl.EvaluationScoreFunction**
- enum **org.deeplearning4j.arbiter.scoring.impl.ROCScoreFunction$Metric**
- enum **org.deeplearning4j.arbiter.scoring.impl.ROCScoreFunction$ROCType**
- class **org.deeplearning4j.arbiter.scoring.impl.ROCScoreFunction**
- class **org.deeplearning4j.arbiter.scoring.impl.RegressionScoreFunction**
- class **org.deeplearning4j.arbiter.scoring.impl.TestSetAccuracyScoreFunction**
- class **org.deeplearning4j.arbiter.scoring.impl.TestSetF1ScoreFunction**
- class **org.deeplearning4j.arbiter.scoring.impl.TestSetLossScoreFunction**
- class **org.deeplearning4j.arbiter.scoring.impl.TestSetRegressionScoreFunction**
- class **org.deeplearning4j.arbiter.scoring.util.ScoreUtil**
- class **org.deeplearning4j.arbiter.server.ArbiterCliGenerator**
- class **org.deeplearning4j.arbiter.server.ArbiterCliRunner**
- class **org.deeplearning4j.arbiter.server.cli.NeuralNetTypeValidator**
- class **org.deeplearning4j.arbiter.server.cli.ProblemTypeValidator**
- class **org.deeplearning4j.arbiter.task.ComputationGraphTaskCreator**
- class **org.deeplearning4j.arbiter.task.MultiLayerNetworkTaskCreator**
- interface **org.deeplearning4j.arbiter.task.TaskListener**
- class **org.deeplearning4j.arbiter.ui.UpdateStatus**
- class **org.deeplearning4j.arbiter.ui.data.BaseJavaPersistable$Builder**
- class **org.deeplearning4j.arbiter.ui.data.BaseJavaPersistable**
- class **org.deeplearning4j.arbiter.ui.data.GlobalConfigPersistable$Builder**
- class **org.deeplearning4j.arbiter.ui.data.GlobalConfigPersistable**
- class **org.deeplearning4j.arbiter.ui.data.ModelInfoPersistable$Builder**
- class **org.deeplearning4j.arbiter.ui.data.ModelInfoPersistable**
- class **org.deeplearning4j.arbiter.ui.listener.ArbiterStatusListener**
- class **org.deeplearning4j.arbiter.ui.misc.JsonMapper**
- class **org.deeplearning4j.arbiter.ui.misc.UIUtils**
- class **org.deeplearning4j.arbiter.ui.module.ArbiterModule**
- class **org.deeplearning4j.arbiter.util.ClassPathResource**
- class **org.deeplearning4j.arbiter.util.CollectionUtils**
- class **org.deeplearning4j.arbiter.util.LeafUtils**
- class **org.deeplearning4j.arbiter.util.ObjectUtils**
- class **org.deeplearning4j.arbiter.util.WebUtils**
- class **org.deeplearning4j.aws.dataset.DataSetLoader**
- class **org.deeplearning4j.aws.ec2.Ec2BoxCreator**
- class **org.deeplearning4j.aws.ec2.provision.ClusterSetup**
- class **org.deeplearning4j.aws.ec2.provision.DistributedDeepLearningTrainer**
- class **org.deeplearning4j.aws.ec2.provision.HostProvisioner**
- class **org.deeplearning4j.aws.emr.EmrConfig**
- class **org.deeplearning4j.aws.emr.SparkEMRClient$Builder**
- class **org.deeplearning4j.aws.emr.SparkEMRClient**
- class **org.deeplearning4j.aws.s3.BaseS3**
- class **org.deeplearning4j.aws.s3.reader.BaseS3DataSetIterator**
- class **org.deeplearning4j.aws.s3.reader.BucketIterator**
- interface **org.deeplearning4j.aws.s3.reader.BucketKeyListener**
- class **org.deeplearning4j.aws.s3.reader.S3Downloader**
- class **org.deeplearning4j.aws.s3.uploader.S3Uploader**
- class **org.deeplearning4j.bagofwords.vectorizer.BagOfWordsVectorizer$Builder**
- class **org.deeplearning4j.bagofwords.vectorizer.BagOfWordsVectorizer**
- class **org.deeplearning4j.bagofwords.vectorizer.BaseTextVectorizer**
- class **org.deeplearning4j.bagofwords.vectorizer.DefaultInputStreamCreator**
- interface **org.deeplearning4j.bagofwords.vectorizer.TextVectorizer**
- class **org.deeplearning4j.bagofwords.vectorizer.TfidfVectorizer$Builder**
- class **org.deeplearning4j.bagofwords.vectorizer.TfidfVectorizer**
- class **org.deeplearning4j.base.EmnistFetcher**
- class **org.deeplearning4j.base.IrisUtils**
- class **org.deeplearning4j.base.MnistFetcher**
- class **org.deeplearning4j.clustering.algorithm.BaseClusteringAlgorithm**
- interface **org.deeplearning4j.clustering.algorithm.ClusteringAlgorithm**
- class **org.deeplearning4j.clustering.cluster.Cluster**
- class **org.deeplearning4j.clustering.cluster.ClusterSet**
- class **org.deeplearning4j.clustering.cluster.ClusterUtils**
- class **org.deeplearning4j.clustering.cluster.Point**
- class **org.deeplearning4j.clustering.cluster.PointClassification**
- interface **org.deeplearning4j.clustering.condition.ClusteringAlgorithmCondition**
- class **org.deeplearning4j.clustering.condition.ConvergenceCondition**
- class **org.deeplearning4j.clustering.condition.FixedIterationCountCondition**
- class **org.deeplearning4j.clustering.condition.VarianceVariationCondition**
- class **org.deeplearning4j.clustering.info.ClusterInfo**
- class **org.deeplearning4j.clustering.info.ClusterSetInfo**
- class **org.deeplearning4j.clustering.iteration.IterationHistory**
- class **org.deeplearning4j.clustering.iteration.IterationInfo**
- class **org.deeplearning4j.clustering.kdtree.HyperRect$Interval**
- class **org.deeplearning4j.clustering.kdtree.HyperRect**
- class **org.deeplearning4j.clustering.kdtree.KDTree$KDNode**
- class **org.deeplearning4j.clustering.kdtree.KDTree**
- class **org.deeplearning4j.clustering.kmeans.KMeansClustering**
- interface **org.deeplearning4j.clustering.lsh.LSH**
- class **org.deeplearning4j.clustering.lsh.RandomProjectionLSH**
- class **org.deeplearning4j.clustering.optimisation.ClusteringOptimization**
- enum **org.deeplearning4j.clustering.optimisation.ClusteringOptimizationType**
- class **org.deeplearning4j.clustering.quadtree.Cell**
- class **org.deeplearning4j.clustering.quadtree.QuadTree**
- class **org.deeplearning4j.clustering.randomprojection.RPForest**
- class **org.deeplearning4j.clustering.randomprojection.RPHyperPlanes**
- class **org.deeplearning4j.clustering.randomprojection.RPNode**
- class **org.deeplearning4j.clustering.randomprojection.RPTree**
- class **org.deeplearning4j.clustering.randomprojection.RPUtils**
- class **org.deeplearning4j.clustering.sptree.Cell**
- class **org.deeplearning4j.clustering.sptree.DataPoint**
- class **org.deeplearning4j.clustering.sptree.HeapItem**
- class **org.deeplearning4j.clustering.sptree.HeapObject**
- class **org.deeplearning4j.clustering.sptree.SpTree**
- class **org.deeplearning4j.clustering.strategy.BaseClusteringStrategy**
- interface **org.deeplearning4j.clustering.strategy.ClusteringStrategy**
- enum **org.deeplearning4j.clustering.strategy.ClusteringStrategyType**
- class **org.deeplearning4j.clustering.strategy.FixedClusterCountStrategy**
- class **org.deeplearning4j.clustering.strategy.OptimisationStrategy**
- class **org.deeplearning4j.clustering.util.MathUtils**
- class **org.deeplearning4j.clustering.util.MultiThreadUtils**
- class **org.deeplearning4j.clustering.util.SetUtils**
- class **org.deeplearning4j.clustering.vptree.VPTree$Node**
- class **org.deeplearning4j.clustering.vptree.VPTree**
- class **org.deeplearning4j.clustering.vptree.VPTreeFillSearch**
- class **org.deeplearning4j.common.resources.DL4JResources**
- enum **org.deeplearning4j.common.resources.ResourceType**
- class **org.deeplearning4j.config.DL4JEnvironmentVars**
- class **org.deeplearning4j.config.DL4JSystemProperties**
- class **org.deeplearning4j.datasets.datavec.RecordReaderDataSetIterator$Builder**
- class **org.deeplearning4j.datasets.datavec.RecordReaderDataSetIterator**
- enum **org.deeplearning4j.datasets.datavec.RecordReaderMultiDataSetIterator$AlignmentMode**
- class **org.deeplearning4j.datasets.datavec.RecordReaderMultiDataSetIterator$Builder**
- class **org.deeplearning4j.datasets.datavec.RecordReaderMultiDataSetIterator**
- enum **org.deeplearning4j.datasets.datavec.SequenceRecordReaderDataSetIterator$AlignmentMode**
- class **org.deeplearning4j.datasets.datavec.SequenceRecordReaderDataSetIterator**
- class **org.deeplearning4j.datasets.datavec.exception.ZeroLengthSequenceException**
- class **org.deeplearning4j.datasets.fetchers.CacheableExtractableDataSetFetcher**
- enum **org.deeplearning4j.datasets.fetchers.DataSetType**
- class **org.deeplearning4j.datasets.fetchers.EmnistDataFetcher**
- class **org.deeplearning4j.datasets.fetchers.IrisDataFetcher**
- class **org.deeplearning4j.datasets.fetchers.MnistDataFetcher**
- class **org.deeplearning4j.datasets.fetchers.SvhnDataFetcher**
- class **org.deeplearning4j.datasets.fetchers.TinyImageNetFetcher**
- class **org.deeplearning4j.datasets.fetchers.UciSequenceDataFetcher**
- class **org.deeplearning4j.datasets.iterator.AbstractDataSetIterator**
- class **org.deeplearning4j.datasets.iterator.AsyncDataSetIterator**
- class **org.deeplearning4j.datasets.iterator.AsyncMultiDataSetIterator**
- class **org.deeplearning4j.datasets.iterator.AsyncShieldDataSetIterator**
- class **org.deeplearning4j.datasets.iterator.AsyncShieldMultiDataSetIterator**
- class **org.deeplearning4j.datasets.iterator.BaseDatasetIterator**
- class **org.deeplearning4j.datasets.iterator.CombinedMultiDataSetPreProcessor$Builder**
- class **org.deeplearning4j.datasets.iterator.CombinedMultiDataSetPreProcessor**
- class **org.deeplearning4j.datasets.iterator.CombinedPreProcessor$Builder**
- class **org.deeplearning4j.datasets.iterator.CombinedPreProcessor**
- interface **org.deeplearning4j.datasets.iterator.DataSetFetcher**
- class **org.deeplearning4j.datasets.iterator.DataSetIteratorSplitter**
- class **org.deeplearning4j.datasets.iterator.DoublesDataSetIterator**
- class **org.deeplearning4j.datasets.iterator.DummyPreProcessor**
- class **org.deeplearning4j.datasets.iterator.EarlyTerminationDataSetIterator**
- class **org.deeplearning4j.datasets.iterator.EarlyTerminationMultiDataSetIterator**
- class **org.deeplearning4j.datasets.iterator.ExistingDataSetIterator**
- class **org.deeplearning4j.datasets.iterator.FileSplitDataSetIterator**
- class **org.deeplearning4j.datasets.iterator.FloatsDataSetIterator**
- class **org.deeplearning4j.datasets.iterator.INDArrayDataSetIterator**
- class **org.deeplearning4j.datasets.iterator.IteratorDataSetIterator**
- class **org.deeplearning4j.datasets.iterator.IteratorMultiDataSetIterator**
- class **org.deeplearning4j.datasets.iterator.JointMultiDataSetIterator**
- class **org.deeplearning4j.datasets.iterator.MovingWindowBaseDataSetIterator**
- class **org.deeplearning4j.datasets.iterator.MultiDataSetIteratorSplitter**
- class **org.deeplearning4j.datasets.iterator.MultiDataSetWrapperIterator**
- class **org.deeplearning4j.datasets.iterator.MultipleEpochsIterator**
- enum **org.deeplearning4j.datasets.iterator.RandomDataSetIterator$Values**
- class **org.deeplearning4j.datasets.iterator.RandomDataSetIterator**
- class **org.deeplearning4j.datasets.iterator.RandomMultiDataSetIterator$Builder**
- enum **org.deeplearning4j.datasets.iterator.RandomMultiDataSetIterator$Values**
- class **org.deeplearning4j.datasets.iterator.RandomMultiDataSetIterator**
- class **org.deeplearning4j.datasets.iterator.ReconstructionDataSetIterator**
- class **org.deeplearning4j.datasets.iterator.SamplingDataSetIterator**
- class **org.deeplearning4j.datasets.iterator.WorkspacesShieldDataSetIterator**
- interface **org.deeplearning4j.datasets.iterator.callbacks.DataSetCallback**
- class **org.deeplearning4j.datasets.iterator.callbacks.DataSetDeserializer**
- class **org.deeplearning4j.datasets.iterator.callbacks.DefaultCallback**
- interface **org.deeplearning4j.datasets.iterator.callbacks.FileCallback**
- class **org.deeplearning4j.datasets.iterator.callbacks.InterleavedDataSetCallback**
- class **org.deeplearning4j.datasets.iterator.file.BaseFileIterator**
- class **org.deeplearning4j.datasets.iterator.file.FileDataSetIterator**
- class **org.deeplearning4j.datasets.iterator.file.FileMultiDataSetIterator**
- class **org.deeplearning4j.datasets.iterator.impl.BenchmarkDataSetIterator**
- class **org.deeplearning4j.datasets.iterator.impl.BenchmarkMultiDataSetIterator**
- class **org.deeplearning4j.datasets.iterator.impl.CifarDataSetIterator**
- enum **org.deeplearning4j.datasets.iterator.impl.EmnistDataSetIterator$Set**
- class **org.deeplearning4j.datasets.iterator.impl.EmnistDataSetIterator**
- class **org.deeplearning4j.datasets.iterator.impl.IrisDataSetIterator**
- class **org.deeplearning4j.datasets.iterator.impl.LFWDataSetIterator**
- class **org.deeplearning4j.datasets.iterator.impl.ListDataSetIterator**
- class **org.deeplearning4j.datasets.iterator.impl.MnistDataSetIterator**
- class **org.deeplearning4j.datasets.iterator.impl.MovingWindowDataSetFetcher**
- class **org.deeplearning4j.datasets.iterator.impl.MultiDataSetIteratorAdapter**
- class **org.deeplearning4j.datasets.iterator.impl.SingletonDataSetIterator**
- class **org.deeplearning4j.datasets.iterator.impl.SingletonMultiDataSetIterator**
- class **org.deeplearning4j.datasets.iterator.impl.TinyImageNetDataSetIterator**
- class **org.deeplearning4j.datasets.iterator.impl.UciSequenceDataSetIterator**
- class **org.deeplearning4j.datasets.iterator.loader.DataSetLoaderIterator**
- class **org.deeplearning4j.datasets.iterator.loader.MultiDataSetLoaderIterator**
- class **org.deeplearning4j.datasets.iterator.parallel.BaseParallelDataSetIterator**
- class **org.deeplearning4j.datasets.iterator.parallel.FileSplitParallelDataSetIterator**
- class **org.deeplearning4j.datasets.iterator.parallel.JointParallelDataSetIterator$Builder**
- class **org.deeplearning4j.datasets.iterator.parallel.JointParallelDataSetIterator**
- class **org.deeplearning4j.datasets.iterator.parallel.MultiBoolean**
- class **org.deeplearning4j.datasets.mnist.MnistDbFile**
- class **org.deeplearning4j.datasets.mnist.MnistImageFile**
- class **org.deeplearning4j.datasets.mnist.MnistLabelFile**
- class **org.deeplearning4j.datasets.mnist.MnistManager**
- class **org.deeplearning4j.datasets.test.TestDataSetIterator**
- interface **org.deeplearning4j.datasets.vectorizer.Vectorizer**
- class **org.deeplearning4j.earlystopping.EarlyStoppingConfiguration$Builder**
- class **org.deeplearning4j.earlystopping.EarlyStoppingConfiguration**
- interface **org.deeplearning4j.earlystopping.EarlyStoppingModelSaver**
- enum **org.deeplearning4j.earlystopping.EarlyStoppingResult$TerminationReason**
- class **org.deeplearning4j.earlystopping.EarlyStoppingResult**
- interface **org.deeplearning4j.earlystopping.listener.EarlyStoppingListener**
- class **org.deeplearning4j.earlystopping.saver.InMemoryModelSaver**
- class **org.deeplearning4j.earlystopping.saver.LocalFileGraphSaver**
- class **org.deeplearning4j.earlystopping.saver.LocalFileModelSaver**
- class **org.deeplearning4j.earlystopping.scorecalc.AutoencoderScoreCalculator**
- class **org.deeplearning4j.earlystopping.scorecalc.ClassificationScoreCalculator**
- class **org.deeplearning4j.earlystopping.scorecalc.DataSetLossCalculator**
- class **org.deeplearning4j.earlystopping.scorecalc.DataSetLossCalculatorCG**
- enum **org.deeplearning4j.earlystopping.scorecalc.ROCScoreCalculator$Metric**
- enum **org.deeplearning4j.earlystopping.scorecalc.ROCScoreCalculator$ROCType**
- class **org.deeplearning4j.earlystopping.scorecalc.ROCScoreCalculator**
- class **org.deeplearning4j.earlystopping.scorecalc.RegressionScoreCalculator**
- interface **org.deeplearning4j.earlystopping.scorecalc.ScoreCalculator**
- class **org.deeplearning4j.earlystopping.scorecalc.VAEReconErrorScoreCalculator**
- class **org.deeplearning4j.earlystopping.scorecalc.VAEReconProbScoreCalculator**
- class **org.deeplearning4j.earlystopping.scorecalc.base.BaseIEvaluationScoreCalculator**
- class **org.deeplearning4j.earlystopping.scorecalc.base.BaseMLNScoreCalculator**
- class **org.deeplearning4j.earlystopping.scorecalc.base.BaseScoreCalculator**
- class **org.deeplearning4j.earlystopping.termination.BestScoreEpochTerminationCondition**
- interface **org.deeplearning4j.earlystopping.termination.EpochTerminationCondition**
- class **org.deeplearning4j.earlystopping.termination.InvalidScoreIterationTerminationCondition**
- interface **org.deeplearning4j.earlystopping.termination.IterationTerminationCondition**
- class **org.deeplearning4j.earlystopping.termination.MaxEpochsTerminationCondition**
- class **org.deeplearning4j.earlystopping.termination.MaxScoreIterationTerminationCondition**
- class **org.deeplearning4j.earlystopping.termination.MaxTimeIterationTerminationCondition**
- class **org.deeplearning4j.earlystopping.termination.ScoreImprovementEpochTerminationCondition**
- class **org.deeplearning4j.earlystopping.trainer.BaseEarlyStoppingTrainer**
- class **org.deeplearning4j.earlystopping.trainer.EarlyStoppingGraphTrainer**
- class **org.deeplearning4j.earlystopping.trainer.EarlyStoppingTrainer**
- interface **org.deeplearning4j.earlystopping.trainer.IEarlyStoppingTrainer**
- class **org.deeplearning4j.eval.BaseEvaluation**
- class **org.deeplearning4j.eval.ConfusionMatrix**
- enum **org.deeplearning4j.eval.Evaluation$Metric**
- class **org.deeplearning4j.eval.Evaluation**
- enum **org.deeplearning4j.eval.EvaluationAveraging**
- class **org.deeplearning4j.eval.EvaluationBinary**
- class **org.deeplearning4j.eval.EvaluationCalibration**
- class **org.deeplearning4j.eval.EvaluationUtils**
- interface **org.deeplearning4j.eval.IEvaluation**
- class **org.deeplearning4j.eval.ROC$CountsForThreshold**
- class **org.deeplearning4j.eval.ROC**
- class **org.deeplearning4j.eval.ROCBinary**
- class **org.deeplearning4j.eval.ROCMultiClass**
- enum **org.deeplearning4j.eval.RegressionEvaluation$Metric**
- class **org.deeplearning4j.eval.RegressionEvaluation**
- class **org.deeplearning4j.eval.curves.BaseCurve**
- class **org.deeplearning4j.eval.curves.BaseHistogram**
- class **org.deeplearning4j.eval.curves.Histogram**
- class **org.deeplearning4j.eval.curves.PrecisionRecallCurve$Confusion**
- class **org.deeplearning4j.eval.curves.PrecisionRecallCurve$Point**
- class **org.deeplearning4j.eval.curves.PrecisionRecallCurve**
- class **org.deeplearning4j.eval.curves.ReliabilityDiagram**
- class **org.deeplearning4j.eval.curves.RocCurve**
- class **org.deeplearning4j.eval.meta.Prediction**
- class **org.deeplearning4j.eval.serde.ConfusionMatrixDeserializer**
- class **org.deeplearning4j.eval.serde.ConfusionMatrixSerializer**
- class **org.deeplearning4j.eval.serde.ROCArraySerializer**
- class **org.deeplearning4j.eval.serde.ROCSerializer**
- class **org.deeplearning4j.evaluation.EvaluationTools**
- class **org.deeplearning4j.exception.DL4JException**
- class **org.deeplearning4j.exception.DL4JInvalidConfigException**
- class **org.deeplearning4j.exception.DL4JInvalidInputException**
- class **org.deeplearning4j.exception.DeepLearningException**
- class **org.deeplearning4j.exception.InvalidStepException**
- class **org.deeplearning4j.gradientcheck.GradientCheckUtil**
- class **org.deeplearning4j.graph.api.BaseGraph**
- class **org.deeplearning4j.graph.api.Edge**
- interface **org.deeplearning4j.graph.api.IGraph**
- interface **org.deeplearning4j.graph.api.IVertexSequence**
- enum **org.deeplearning4j.graph.api.NoEdgeHandling**
- class **org.deeplearning4j.graph.api.Vertex**
- interface **org.deeplearning4j.graph.data.EdgeLineProcessor**
- class **org.deeplearning4j.graph.data.GraphLoader**
- interface **org.deeplearning4j.graph.data.VertexLoader**
- class **org.deeplearning4j.graph.data.impl.DelimitedEdgeLineProcessor**
- class **org.deeplearning4j.graph.data.impl.DelimitedVertexLoader**
- class **org.deeplearning4j.graph.data.impl.WeightedEdgeLineProcessor**
- class **org.deeplearning4j.graph.exception.NoEdgesException**
- class **org.deeplearning4j.graph.exception.ParseException**
- class **org.deeplearning4j.graph.graph.Graph**
- class **org.deeplearning4j.graph.graph.VertexSequence**
- interface **org.deeplearning4j.graph.iterator.GraphWalkIterator**
- class **org.deeplearning4j.graph.iterator.RandomWalkIterator**
- class **org.deeplearning4j.graph.iterator.WeightedRandomWalkIterator**
- interface **org.deeplearning4j.graph.iterator.parallel.GraphWalkIteratorProvider**
- class **org.deeplearning4j.graph.iterator.parallel.RandomWalkGraphIteratorProvider**
- class **org.deeplearning4j.graph.iterator.parallel.WeightedRandomWalkGraphIteratorProvider**
- interface **org.deeplearning4j.graph.models.BinaryTree**
- interface **org.deeplearning4j.graph.models.GraphVectors**
- class **org.deeplearning4j.graph.models.deepwalk.DeepWalk$Builder**
- class **org.deeplearning4j.graph.models.deepwalk.DeepWalk**
- class **org.deeplearning4j.graph.models.deepwalk.GraphHuffman**
- interface **org.deeplearning4j.graph.models.embeddings.GraphVectorLookupTable**
- class **org.deeplearning4j.graph.models.embeddings.GraphVectorsImpl**
- class **org.deeplearning4j.graph.models.embeddings.InMemoryGraphLookupTable**
- class **org.deeplearning4j.graph.models.loader.GraphVectorSerializer**
- class **org.deeplearning4j.graph.vertexfactory.IntegerVertexFactory**
- class **org.deeplearning4j.graph.vertexfactory.StringVertexFactory**
- interface **org.deeplearning4j.graph.vertexfactory.VertexFactory**
- class **org.deeplearning4j.graph.vertexfactory.VoidVertexFactory**
- class **org.deeplearning4j.gym.Client**
- class **org.deeplearning4j.gym.ClientFactory**
- class **org.deeplearning4j.gym.ClientUtils**
- class **org.deeplearning4j.gym.StepReply**
- class **org.deeplearning4j.iterator.CnnSentenceDataSetIterator$Builder**
- enum **org.deeplearning4j.iterator.CnnSentenceDataSetIterator$Format**
- enum **org.deeplearning4j.iterator.CnnSentenceDataSetIterator$UnknownWordHandling**
- class **org.deeplearning4j.iterator.CnnSentenceDataSetIterator**
- interface **org.deeplearning4j.iterator.LabeledSentenceProvider**
- class **org.deeplearning4j.iterator.provider.CollectionLabeledSentenceProvider**
- class **org.deeplearning4j.iterator.provider.FileLabeledSentenceProvider**
- class **org.deeplearning4j.iterator.provider.LabelAwareConverter**
- class **org.deeplearning4j.malmo.MalmoActionSpace**
- class **org.deeplearning4j.malmo.MalmoActionSpaceDiscrete**
- class **org.deeplearning4j.malmo.MalmoBox**
- class **org.deeplearning4j.malmo.MalmoConnectionError**
- class **org.deeplearning4j.malmo.MalmoDescretePositionPolicy**
- class **org.deeplearning4j.malmo.MalmoEnv**
- class **org.deeplearning4j.malmo.MalmoObservationSpace**
- class **org.deeplearning4j.malmo.MalmoObservationSpaceGrid**
- class **org.deeplearning4j.malmo.MalmoObservationSpacePixels**
- class **org.deeplearning4j.malmo.MalmoObservationSpacePosition**
- interface **org.deeplearning4j.malmo.MalmoResetHandler**
- interface **org.deeplearning4j.models.embeddings.WeightLookupTable**
- class **org.deeplearning4j.models.embeddings.inmemory.InMemoryLookupTable$Builder**
- class **org.deeplearning4j.models.embeddings.inmemory.InMemoryLookupTable**
- interface **org.deeplearning4j.models.embeddings.learning.ElementsLearningAlgorithm**
- interface **org.deeplearning4j.models.embeddings.learning.SequenceLearningAlgorithm**
- class **org.deeplearning4j.models.embeddings.learning.impl.elements.CBOW**
- class **org.deeplearning4j.models.embeddings.learning.impl.elements.GloVe$Builder**
- class **org.deeplearning4j.models.embeddings.learning.impl.elements.GloVe**
- class **org.deeplearning4j.models.embeddings.learning.impl.elements.RandomUtils**
- class **org.deeplearning4j.models.embeddings.learning.impl.elements.SkipGram**
- class **org.deeplearning4j.models.embeddings.learning.impl.sequence.DBOW**
- class **org.deeplearning4j.models.embeddings.learning.impl.sequence.DM**
- class **org.deeplearning4j.models.embeddings.loader.VectorsConfiguration**
- class **org.deeplearning4j.models.embeddings.loader.WordVectorSerializer$BinaryReader**
- class **org.deeplearning4j.models.embeddings.loader.WordVectorSerializer$CSVReader**
- interface **org.deeplearning4j.models.embeddings.loader.WordVectorSerializer$Reader**
- class **org.deeplearning4j.models.embeddings.loader.WordVectorSerializer**
- interface **org.deeplearning4j.models.embeddings.reader.ModelUtils**
- class **org.deeplearning4j.models.embeddings.reader.impl.BasicModelUtils$ArrayComparator**
- class **org.deeplearning4j.models.embeddings.reader.impl.BasicModelUtils$SimilarityComparator**
- class **org.deeplearning4j.models.embeddings.reader.impl.BasicModelUtils$WordSimilarity**
- class **org.deeplearning4j.models.embeddings.reader.impl.BasicModelUtils**
- class **org.deeplearning4j.models.embeddings.reader.impl.FlatModelUtils**
- class **org.deeplearning4j.models.embeddings.reader.impl.TreeModelUtils**
- interface **org.deeplearning4j.models.embeddings.wordvectors.WordVectors**
- class **org.deeplearning4j.models.embeddings.wordvectors.WordVectorsImpl**
- class **org.deeplearning4j.models.glove.AbstractCoOccurrences$Builder**
- class **org.deeplearning4j.models.glove.AbstractCoOccurrences**
- class **org.deeplearning4j.models.glove.Glove$Builder**
- class **org.deeplearning4j.models.glove.Glove**
- class **org.deeplearning4j.models.glove.GloveWeightLookupTable$Builder**
- class **org.deeplearning4j.models.glove.GloveWeightLookupTable**
- class **org.deeplearning4j.models.glove.count.ASCIICoOccurrenceReader**
- class **org.deeplearning4j.models.glove.count.ASCIICoOccurrenceWriter**
- class **org.deeplearning4j.models.glove.count.BinaryCoOccurrenceReader**
- class **org.deeplearning4j.models.glove.count.BinaryCoOccurrenceWriter**
- interface **org.deeplearning4j.models.glove.count.CoOccurenceReader**
- class **org.deeplearning4j.models.glove.count.CoOccurrenceWeight**
- interface **org.deeplearning4j.models.glove.count.CoOccurrenceWriter**
- class **org.deeplearning4j.models.glove.count.CountMap**
- class **org.deeplearning4j.models.glove.count.RoundCount**
- class **org.deeplearning4j.models.node2vec.Node2Vec$Builder**
- class **org.deeplearning4j.models.node2vec.Node2Vec**
- class **org.deeplearning4j.models.paragraphvectors.ParagraphVectors$Builder**
- class **org.deeplearning4j.models.paragraphvectors.ParagraphVectors**
- class **org.deeplearning4j.models.sequencevectors.SequenceVectors$Builder**
- class **org.deeplearning4j.models.sequencevectors.SequenceVectors**
- enum **org.deeplearning4j.models.sequencevectors.enums.ListenerEvent**
- enum **org.deeplearning4j.models.sequencevectors.graph.enums.NoEdgeHandling**
- enum **org.deeplearning4j.models.sequencevectors.graph.enums.PopularityMode**
- enum **org.deeplearning4j.models.sequencevectors.graph.enums.SamplingMode**
- enum **org.deeplearning4j.models.sequencevectors.graph.enums.SpreadSpectrum**
- enum **org.deeplearning4j.models.sequencevectors.graph.enums.WalkDirection**
- enum **org.deeplearning4j.models.sequencevectors.graph.enums.WalkMode**
- class **org.deeplearning4j.models.sequencevectors.graph.exception.NoEdgesException**
- class **org.deeplearning4j.models.sequencevectors.graph.exception.ParseException**
- interface **org.deeplearning4j.models.sequencevectors.graph.huffman.BinaryTree**
- class **org.deeplearning4j.models.sequencevectors.graph.huffman.GraphHuffman**
- class **org.deeplearning4j.models.sequencevectors.graph.primitives.Edge**
- class **org.deeplearning4j.models.sequencevectors.graph.primitives.Graph**
- interface **org.deeplearning4j.models.sequencevectors.graph.primitives.IGraph**
- class **org.deeplearning4j.models.sequencevectors.graph.primitives.Vertex**
- class **org.deeplearning4j.models.sequencevectors.graph.vertex.AbstractVertexFactory**
- interface **org.deeplearning4j.models.sequencevectors.graph.vertex.VertexFactory**
- interface **org.deeplearning4j.models.sequencevectors.graph.walkers.GraphWalker**
- class **org.deeplearning4j.models.sequencevectors.graph.walkers.impl.NearestVertexWalker$Builder**
- class **org.deeplearning4j.models.sequencevectors.graph.walkers.impl.NearestVertexWalker**
- class **org.deeplearning4j.models.sequencevectors.graph.walkers.impl.PopularityWalker$Builder**
- class **org.deeplearning4j.models.sequencevectors.graph.walkers.impl.PopularityWalker**
- class **org.deeplearning4j.models.sequencevectors.graph.walkers.impl.RandomWalker$Builder**
- class **org.deeplearning4j.models.sequencevectors.graph.walkers.impl.RandomWalker**
- class **org.deeplearning4j.models.sequencevectors.graph.walkers.impl.WeightedWalker$Builder**
- class **org.deeplearning4j.models.sequencevectors.graph.walkers.impl.WeightedWalker**
- interface **org.deeplearning4j.models.sequencevectors.interfaces.SequenceElementFactory**
- interface **org.deeplearning4j.models.sequencevectors.interfaces.SequenceIterator**
- interface **org.deeplearning4j.models.sequencevectors.interfaces.VectorsListener**
- class **org.deeplearning4j.models.sequencevectors.iterators.AbstractSequenceIterator$Builder**
- class **org.deeplearning4j.models.sequencevectors.iterators.AbstractSequenceIterator**
- class **org.deeplearning4j.models.sequencevectors.iterators.FilteredSequenceIterator**
- class **org.deeplearning4j.models.sequencevectors.iterators.SynchronizedSequenceIterator**
- class **org.deeplearning4j.models.sequencevectors.listeners.ScoreListener**
- class **org.deeplearning4j.models.sequencevectors.listeners.SerializingListener$Builder**
- class **org.deeplearning4j.models.sequencevectors.listeners.SerializingListener**
- class **org.deeplearning4j.models.sequencevectors.listeners.SimilarityListener**
- class **org.deeplearning4j.models.sequencevectors.sequence.Sequence**
- class **org.deeplearning4j.models.sequencevectors.sequence.SequenceElement**
- class **org.deeplearning4j.models.sequencevectors.sequence.ShallowSequenceElement**
- class **org.deeplearning4j.models.sequencevectors.serialization.AbstractElementFactory**
- class **org.deeplearning4j.models.sequencevectors.serialization.VocabWordFactory**
- interface **org.deeplearning4j.models.sequencevectors.transformers.SequenceTransformer**
- class **org.deeplearning4j.models.sequencevectors.transformers.impl.GraphTransformer$Builder**
- class **org.deeplearning4j.models.sequencevectors.transformers.impl.GraphTransformer**
- class **org.deeplearning4j.models.sequencevectors.transformers.impl.SentenceTransformer$Builder**
- class **org.deeplearning4j.models.sequencevectors.transformers.impl.SentenceTransformer**
- class **org.deeplearning4j.models.sequencevectors.transformers.impl.iterables.BasicTransformerIterator**
- class **org.deeplearning4j.models.sequencevectors.transformers.impl.iterables.ParallelTransformerIterator**
- class **org.deeplearning4j.models.word2vec.Huffman**
- interface **org.deeplearning4j.models.word2vec.InputStreamCreator**
- class **org.deeplearning4j.models.word2vec.StaticWord2Vec$Builder**
- class **org.deeplearning4j.models.word2vec.StaticWord2Vec**
- class **org.deeplearning4j.models.word2vec.StreamWork**
- class **org.deeplearning4j.models.word2vec.VocabWord**
- class **org.deeplearning4j.models.word2vec.VocabWork**
- class **org.deeplearning4j.models.word2vec.Word2Vec$Builder**
- class **org.deeplearning4j.models.word2vec.Word2Vec**
- class **org.deeplearning4j.models.word2vec.iterator.Word2VecDataFetcher**
- class **org.deeplearning4j.models.word2vec.iterator.Word2VecDataSetIterator**
- class **org.deeplearning4j.models.word2vec.wordstore.HuffmanNode**
- interface **org.deeplearning4j.models.word2vec.wordstore.VocabCache**
- class **org.deeplearning4j.models.word2vec.wordstore.VocabConstructor$Builder**
- class **org.deeplearning4j.models.word2vec.wordstore.VocabConstructor**
- class **org.deeplearning4j.models.word2vec.wordstore.VocabularyHolder$Builder**
- class **org.deeplearning4j.models.word2vec.wordstore.VocabularyHolder**
- class **org.deeplearning4j.models.word2vec.wordstore.VocabularyWord**
- class **org.deeplearning4j.models.word2vec.wordstore.inmemory.AbstractCache$Builder**
- class **org.deeplearning4j.models.word2vec.wordstore.inmemory.AbstractCache**
- class **org.deeplearning4j.models.word2vec.wordstore.inmemory.InMemoryLookupCache**
- class **org.deeplearning4j.nearestneighbor.client.NearestNeighborsClient**
- class **org.deeplearning4j.nearestneighbor.model.Base64NDArrayBody**
- class **org.deeplearning4j.nearestneighbor.model.BatchRecord**
- class **org.deeplearning4j.nearestneighbor.model.CSVRecord**
- class **org.deeplearning4j.nearestneighbor.model.NearestNeighborRequest**
- class **org.deeplearning4j.nearestneighbor.model.NearestNeighborsResult**
- class **org.deeplearning4j.nearestneighbor.model.NearestNeighborsResults**
- class **org.deeplearning4j.nearestneighbor.server.FunctionUtil**
- class **org.deeplearning4j.nearestneighbor.server.NearestNeighbor**
- class **org.deeplearning4j.nearestneighbor.server.NearestNeighborsServer**
- interface **org.deeplearning4j.nn.api.Classifier**
- enum **org.deeplearning4j.nn.api.FwdPassType**
- enum **org.deeplearning4j.nn.api.Layer$TrainingMode**
- enum **org.deeplearning4j.nn.api.Layer$Type**
- interface **org.deeplearning4j.nn.api.Layer**
- enum **org.deeplearning4j.nn.api.MaskState**
- interface **org.deeplearning4j.nn.api.Model**
- interface **org.deeplearning4j.nn.api.NeuralNetwork**
- enum **org.deeplearning4j.nn.api.OptimizationAlgorithm**
- interface **org.deeplearning4j.nn.api.ParamInitializer**
- interface **org.deeplearning4j.nn.api.Trainable**
- interface **org.deeplearning4j.nn.api.TrainingConfig**
- interface **org.deeplearning4j.nn.api.Updater**
- interface **org.deeplearning4j.nn.api.layers.IOutputLayer**
- interface **org.deeplearning4j.nn.api.layers.LayerConstraint**
- interface **org.deeplearning4j.nn.api.layers.RecurrentLayer**
- enum **org.deeplearning4j.nn.conf.BackpropType**
- enum **org.deeplearning4j.nn.conf.CacheMode**
- class **org.deeplearning4j.nn.conf.ComputationGraphConfiguration$GraphBuilder**
- class **org.deeplearning4j.nn.conf.ComputationGraphConfiguration**
- enum **org.deeplearning4j.nn.conf.ConvolutionMode**
- enum **org.deeplearning4j.nn.conf.GradientNormalization**
- interface **org.deeplearning4j.nn.conf.InputPreProcessor**
- class **org.deeplearning4j.nn.conf.MultiLayerConfiguration$Builder**
- class **org.deeplearning4j.nn.conf.MultiLayerConfiguration**
- class **org.deeplearning4j.nn.conf.NeuralNetConfiguration$Builder**
- class **org.deeplearning4j.nn.conf.NeuralNetConfiguration$ListBuilder**
- class **org.deeplearning4j.nn.conf.NeuralNetConfiguration**
- enum **org.deeplearning4j.nn.conf.Updater**
- enum **org.deeplearning4j.nn.conf.WorkspaceMode**
- class **org.deeplearning4j.nn.conf.constraint.BaseConstraint**
- class **org.deeplearning4j.nn.conf.constraint.MaxNormConstraint**
- class **org.deeplearning4j.nn.conf.constraint.MinMaxNormConstraint**
- class **org.deeplearning4j.nn.conf.constraint.NonNegativeConstraint**
- class **org.deeplearning4j.nn.conf.constraint.UnitNormConstraint**
- class **org.deeplearning4j.nn.conf.distribution.BinomialDistribution**
- class **org.deeplearning4j.nn.conf.distribution.ConstantDistribution**
- class **org.deeplearning4j.nn.conf.distribution.Distribution**
- class **org.deeplearning4j.nn.conf.distribution.Distributions**
- class **org.deeplearning4j.nn.conf.distribution.GaussianDistribution**
- class **org.deeplearning4j.nn.conf.distribution.LogNormalDistribution**
- class **org.deeplearning4j.nn.conf.distribution.NormalDistribution**
- class **org.deeplearning4j.nn.conf.distribution.OrthogonalDistribution**
- class **org.deeplearning4j.nn.conf.distribution.TruncatedNormalDistribution**
- class **org.deeplearning4j.nn.conf.distribution.UniformDistribution**
- class **org.deeplearning4j.nn.conf.distribution.serde.LegacyDistributionDeserializer**
- class **org.deeplearning4j.nn.conf.distribution.serde.LegacyDistributionHelper**
- class **org.deeplearning4j.nn.conf.dropout.AlphaDropout**
- class **org.deeplearning4j.nn.conf.dropout.Dropout**
- interface **org.deeplearning4j.nn.conf.dropout.DropoutHelper**
- class **org.deeplearning4j.nn.conf.dropout.GaussianDropout**
- class **org.deeplearning4j.nn.conf.dropout.GaussianNoise**
- interface **org.deeplearning4j.nn.conf.dropout.IDropout**
- class **org.deeplearning4j.nn.conf.dropout.SpatialDropout**
- enum **org.deeplearning4j.nn.conf.graph.ElementWiseVertex$Op**
- class **org.deeplearning4j.nn.conf.graph.ElementWiseVertex**
- class **org.deeplearning4j.nn.conf.graph.FrozenVertex**
- class **org.deeplearning4j.nn.conf.graph.GraphVertex**
- class **org.deeplearning4j.nn.conf.graph.L2NormalizeVertex**
- class **org.deeplearning4j.nn.conf.graph.L2Vertex**
- class **org.deeplearning4j.nn.conf.graph.LayerVertex**
- class **org.deeplearning4j.nn.conf.graph.MergeVertex**
- class **org.deeplearning4j.nn.conf.graph.PoolHelperVertex**
- class **org.deeplearning4j.nn.conf.graph.PreprocessorVertex**
- class **org.deeplearning4j.nn.conf.graph.ReshapeVertex**
- class **org.deeplearning4j.nn.conf.graph.ScaleVertex**
- class **org.deeplearning4j.nn.conf.graph.ShiftVertex**
- class **org.deeplearning4j.nn.conf.graph.StackVertex**
- class **org.deeplearning4j.nn.conf.graph.SubsetVertex**
- class **org.deeplearning4j.nn.conf.graph.UnstackVertex**
- class **org.deeplearning4j.nn.conf.graph.rnn.DuplicateToTimeSeriesVertex**
- class **org.deeplearning4j.nn.conf.graph.rnn.LastTimeStepVertex**
- class **org.deeplearning4j.nn.conf.graph.rnn.ReverseTimeSeriesVertex**
- class **org.deeplearning4j.nn.conf.inputs.InputType$InputTypeConvolutional**
- class **org.deeplearning4j.nn.conf.inputs.InputType$InputTypeConvolutional3D**
- class **org.deeplearning4j.nn.conf.inputs.InputType$InputTypeConvolutionalFlat**
- class **org.deeplearning4j.nn.conf.inputs.InputType$InputTypeFeedForward**
- class **org.deeplearning4j.nn.conf.inputs.InputType$InputTypeRecurrent**
- enum **org.deeplearning4j.nn.conf.inputs.InputType$Type**
- class **org.deeplearning4j.nn.conf.inputs.InputType**
- class **org.deeplearning4j.nn.conf.inputs.InvalidInputTypeException**
- class **org.deeplearning4j.nn.conf.layers.AbstractLSTM$Builder**
- class **org.deeplearning4j.nn.conf.layers.AbstractLSTM**
- class **org.deeplearning4j.nn.conf.layers.ActivationLayer$Builder**
- class **org.deeplearning4j.nn.conf.layers.ActivationLayer**
- class **org.deeplearning4j.nn.conf.layers.AutoEncoder$Builder**
- class **org.deeplearning4j.nn.conf.layers.AutoEncoder**
- class **org.deeplearning4j.nn.conf.layers.BaseLayer$Builder**
- class **org.deeplearning4j.nn.conf.layers.BaseLayer**
- class **org.deeplearning4j.nn.conf.layers.BaseOutputLayer$Builder**
- class **org.deeplearning4j.nn.conf.layers.BaseOutputLayer**
- class **org.deeplearning4j.nn.conf.layers.BasePretrainNetwork$Builder**
- class **org.deeplearning4j.nn.conf.layers.BasePretrainNetwork**
- class **org.deeplearning4j.nn.conf.layers.BaseRecurrentLayer$Builder**
- class **org.deeplearning4j.nn.conf.layers.BaseRecurrentLayer**
- class **org.deeplearning4j.nn.conf.layers.BaseUpsamplingLayer$UpsamplingBuilder**
- class **org.deeplearning4j.nn.conf.layers.BaseUpsamplingLayer**
- class **org.deeplearning4j.nn.conf.layers.BatchNormalization$Builder**
- class **org.deeplearning4j.nn.conf.layers.BatchNormalization**
- class **org.deeplearning4j.nn.conf.layers.CenterLossOutputLayer$Builder**
- class **org.deeplearning4j.nn.conf.layers.CenterLossOutputLayer**
- class **org.deeplearning4j.nn.conf.layers.CnnLossLayer$Builder**
- class **org.deeplearning4j.nn.conf.layers.CnnLossLayer**
- class **org.deeplearning4j.nn.conf.layers.Convolution1D**
- class **org.deeplearning4j.nn.conf.layers.Convolution1DLayer$Builder**
- class **org.deeplearning4j.nn.conf.layers.Convolution1DLayer**
- class **org.deeplearning4j.nn.conf.layers.Convolution2D**
- class **org.deeplearning4j.nn.conf.layers.Convolution3D$Builder**
- enum **org.deeplearning4j.nn.conf.layers.Convolution3D$DataFormat**
- class **org.deeplearning4j.nn.conf.layers.Convolution3D**
- enum **org.deeplearning4j.nn.conf.layers.ConvolutionLayer$AlgoMode**
- class **org.deeplearning4j.nn.conf.layers.ConvolutionLayer$BaseConvBuilder**
- class **org.deeplearning4j.nn.conf.layers.ConvolutionLayer$Builder**
- enum **org.deeplearning4j.nn.conf.layers.ConvolutionLayer$BwdDataAlgo**
- enum **org.deeplearning4j.nn.conf.layers.ConvolutionLayer$BwdFilterAlgo**
- enum **org.deeplearning4j.nn.conf.layers.ConvolutionLayer$FwdAlgo**
- class **org.deeplearning4j.nn.conf.layers.ConvolutionLayer**
- class **org.deeplearning4j.nn.conf.layers.Deconvolution2D$Builder**
- class **org.deeplearning4j.nn.conf.layers.Deconvolution2D**
- class **org.deeplearning4j.nn.conf.layers.DenseLayer$Builder**
- class **org.deeplearning4j.nn.conf.layers.DenseLayer**
- class **org.deeplearning4j.nn.conf.layers.DepthwiseConvolution2D$Builder**
- class **org.deeplearning4j.nn.conf.layers.DepthwiseConvolution2D**
- class **org.deeplearning4j.nn.conf.layers.DropoutLayer$Builder**
- class **org.deeplearning4j.nn.conf.layers.DropoutLayer**
- class **org.deeplearning4j.nn.conf.layers.EmbeddingLayer$Builder**
- class **org.deeplearning4j.nn.conf.layers.EmbeddingLayer**
- class **org.deeplearning4j.nn.conf.layers.EmbeddingSequenceLayer$Builder**
- class **org.deeplearning4j.nn.conf.layers.EmbeddingSequenceLayer**
- class **org.deeplearning4j.nn.conf.layers.FeedForwardLayer$Builder**
- class **org.deeplearning4j.nn.conf.layers.FeedForwardLayer**
- class **org.deeplearning4j.nn.conf.layers.GlobalPoolingLayer$Builder**
- class **org.deeplearning4j.nn.conf.layers.GlobalPoolingLayer**
- class **org.deeplearning4j.nn.conf.layers.GravesBidirectionalLSTM$Builder**
- class **org.deeplearning4j.nn.conf.layers.GravesBidirectionalLSTM**
- class **org.deeplearning4j.nn.conf.layers.GravesLSTM$Builder**
- class **org.deeplearning4j.nn.conf.layers.GravesLSTM**
- class **org.deeplearning4j.nn.conf.layers.InputTypeUtil**
- class **org.deeplearning4j.nn.conf.layers.LSTM$Builder**
- class **org.deeplearning4j.nn.conf.layers.LSTM**
- class **org.deeplearning4j.nn.conf.layers.Layer$Builder**
- class **org.deeplearning4j.nn.conf.layers.Layer**
- class **org.deeplearning4j.nn.conf.layers.LayerValidation**
- class **org.deeplearning4j.nn.conf.layers.LocalResponseNormalization$Builder**
- class **org.deeplearning4j.nn.conf.layers.LocalResponseNormalization**
- class **org.deeplearning4j.nn.conf.layers.LocallyConnected1D$Builder**
- class **org.deeplearning4j.nn.conf.layers.LocallyConnected1D**
- class **org.deeplearning4j.nn.conf.layers.LocallyConnected2D$Builder**
- class **org.deeplearning4j.nn.conf.layers.LocallyConnected2D**
- class **org.deeplearning4j.nn.conf.layers.LossLayer$Builder**
- class **org.deeplearning4j.nn.conf.layers.LossLayer**
- class **org.deeplearning4j.nn.conf.layers.NoParamLayer**
- class **org.deeplearning4j.nn.conf.layers.OutputLayer$Builder**
- class **org.deeplearning4j.nn.conf.layers.OutputLayer**
- class **org.deeplearning4j.nn.conf.layers.PReLULayer$Builder**
- class **org.deeplearning4j.nn.conf.layers.PReLULayer**
- class **org.deeplearning4j.nn.conf.layers.Pooling1D**
- class **org.deeplearning4j.nn.conf.layers.Pooling2D**
- enum **org.deeplearning4j.nn.conf.layers.PoolingType**
- class **org.deeplearning4j.nn.conf.layers.RnnLossLayer$Builder**
- class **org.deeplearning4j.nn.conf.layers.RnnLossLayer**
- class **org.deeplearning4j.nn.conf.layers.RnnOutputLayer$Builder**
- class **org.deeplearning4j.nn.conf.layers.RnnOutputLayer**
- class **org.deeplearning4j.nn.conf.layers.SeparableConvolution2D$Builder**
- class **org.deeplearning4j.nn.conf.layers.SeparableConvolution2D**
- class **org.deeplearning4j.nn.conf.layers.SpaceToBatchLayer$Builder**
- class **org.deeplearning4j.nn.conf.layers.SpaceToBatchLayer**
- class **org.deeplearning4j.nn.conf.layers.SpaceToDepthLayer$Builder**
- enum **org.deeplearning4j.nn.conf.layers.SpaceToDepthLayer$DataFormat**
- class **org.deeplearning4j.nn.conf.layers.SpaceToDepthLayer**
- class **org.deeplearning4j.nn.conf.layers.Subsampling1DLayer$Builder**
- class **org.deeplearning4j.nn.conf.layers.Subsampling1DLayer**
- class **org.deeplearning4j.nn.conf.layers.Subsampling3DLayer$BaseSubsamplingBuilder**
- class **org.deeplearning4j.nn.conf.layers.Subsampling3DLayer$Builder**
- enum **org.deeplearning4j.nn.conf.layers.Subsampling3DLayer$PoolingType**
- class **org.deeplearning4j.nn.conf.layers.Subsampling3DLayer**
- class **org.deeplearning4j.nn.conf.layers.SubsamplingLayer$BaseSubsamplingBuilder**
- class **org.deeplearning4j.nn.conf.layers.SubsamplingLayer$Builder**
- enum **org.deeplearning4j.nn.conf.layers.SubsamplingLayer$PoolingType**
- class **org.deeplearning4j.nn.conf.layers.SubsamplingLayer**
- class **org.deeplearning4j.nn.conf.layers.Upsampling1D$Builder**
- class **org.deeplearning4j.nn.conf.layers.Upsampling1D**
- class **org.deeplearning4j.nn.conf.layers.Upsampling2D$Builder**
- class **org.deeplearning4j.nn.conf.layers.Upsampling2D**
- class **org.deeplearning4j.nn.conf.layers.Upsampling3D$Builder**
- class **org.deeplearning4j.nn.conf.layers.Upsampling3D**
- class **org.deeplearning4j.nn.conf.layers.ZeroPadding1DLayer$Builder**
- class **org.deeplearning4j.nn.conf.layers.ZeroPadding1DLayer**
- class **org.deeplearning4j.nn.conf.layers.ZeroPadding3DLayer$Builder**
- class **org.deeplearning4j.nn.conf.layers.ZeroPadding3DLayer**
- class **org.deeplearning4j.nn.conf.layers.ZeroPaddingLayer$Builder**
- class **org.deeplearning4j.nn.conf.layers.ZeroPaddingLayer**
- class **org.deeplearning4j.nn.conf.layers.convolutional.Cropping1D$Builder**
- class **org.deeplearning4j.nn.conf.layers.convolutional.Cropping1D**
- class **org.deeplearning4j.nn.conf.layers.convolutional.Cropping2D$Builder**
- class **org.deeplearning4j.nn.conf.layers.convolutional.Cropping2D**
- class **org.deeplearning4j.nn.conf.layers.convolutional.Cropping3D$Builder**
- class **org.deeplearning4j.nn.conf.layers.convolutional.Cropping3D**
- class **org.deeplearning4j.nn.conf.layers.misc.ElementWiseMultiplicationLayer$Builder**
- class **org.deeplearning4j.nn.conf.layers.misc.ElementWiseMultiplicationLayer**
- class **org.deeplearning4j.nn.conf.layers.misc.FrozenLayer$Builder**
- class **org.deeplearning4j.nn.conf.layers.misc.FrozenLayer**
- class **org.deeplearning4j.nn.conf.layers.misc.FrozenLayerWithBackprop**
- class **org.deeplearning4j.nn.conf.layers.misc.RepeatVector$Builder**
- class **org.deeplearning4j.nn.conf.layers.misc.RepeatVector**
- class **org.deeplearning4j.nn.conf.layers.objdetect.Yolo2OutputLayer$Builder**
- class **org.deeplearning4j.nn.conf.layers.objdetect.Yolo2OutputLayer**
- class **org.deeplearning4j.nn.conf.layers.recurrent.Bidirectional$Builder**
- enum **org.deeplearning4j.nn.conf.layers.recurrent.Bidirectional$Mode**
- class **org.deeplearning4j.nn.conf.layers.recurrent.Bidirectional**
- class **org.deeplearning4j.nn.conf.layers.recurrent.LastTimeStep**
- class **org.deeplearning4j.nn.conf.layers.recurrent.SimpleRnn$Builder**
- class **org.deeplearning4j.nn.conf.layers.recurrent.SimpleRnn**
- class **org.deeplearning4j.nn.conf.layers.samediff.AbstractSameDiffLayer$Builder**
- class **org.deeplearning4j.nn.conf.layers.samediff.AbstractSameDiffLayer**
- class **org.deeplearning4j.nn.conf.layers.samediff.SDLayerParams**
- class **org.deeplearning4j.nn.conf.layers.samediff.SDVertexParams**
- class **org.deeplearning4j.nn.conf.layers.samediff.SameDiffLambdaLayer**
- class **org.deeplearning4j.nn.conf.layers.samediff.SameDiffLambdaVertex**
- class **org.deeplearning4j.nn.conf.layers.samediff.SameDiffLayer$Builder**
- class **org.deeplearning4j.nn.conf.layers.samediff.SameDiffLayer**
- class **org.deeplearning4j.nn.conf.layers.samediff.SameDiffLayerUtils**
- class **org.deeplearning4j.nn.conf.layers.samediff.SameDiffOutputLayer**
- class **org.deeplearning4j.nn.conf.layers.samediff.SameDiffVertex**
- class **org.deeplearning4j.nn.conf.layers.util.MaskLayer**
- class **org.deeplearning4j.nn.conf.layers.util.MaskZeroLayer**
- class **org.deeplearning4j.nn.conf.layers.variational.BernoulliReconstructionDistribution**
- class **org.deeplearning4j.nn.conf.layers.variational.CompositeReconstructionDistribution$Builder**
- class **org.deeplearning4j.nn.conf.layers.variational.CompositeReconstructionDistribution**
- class **org.deeplearning4j.nn.conf.layers.variational.ExponentialReconstructionDistribution**
- class **org.deeplearning4j.nn.conf.layers.variational.GaussianReconstructionDistribution**
- class **org.deeplearning4j.nn.conf.layers.variational.LossFunctionWrapper**
- interface **org.deeplearning4j.nn.conf.layers.variational.ReconstructionDistribution**
- class **org.deeplearning4j.nn.conf.layers.variational.VariationalAutoencoder$Builder**
- class **org.deeplearning4j.nn.conf.layers.variational.VariationalAutoencoder**
- class **org.deeplearning4j.nn.conf.layers.wrapper.BaseWrapperLayer**
- class **org.deeplearning4j.nn.conf.memory.LayerMemoryReport$Builder**
- class **org.deeplearning4j.nn.conf.memory.LayerMemoryReport**
- class **org.deeplearning4j.nn.conf.memory.MemoryReport**
- enum **org.deeplearning4j.nn.conf.memory.MemoryType**
- enum **org.deeplearning4j.nn.conf.memory.MemoryUseMode**
- class **org.deeplearning4j.nn.conf.memory.NetworkMemoryReport**
- class **org.deeplearning4j.nn.conf.misc.DummyConfig**
- interface **org.deeplearning4j.nn.conf.module.GraphBuilderModule**
- class **org.deeplearning4j.nn.conf.ocnn.OCNNOutputLayer$Builder**
- class **org.deeplearning4j.nn.conf.ocnn.OCNNOutputLayer**
- class **org.deeplearning4j.nn.conf.preprocessor.BaseInputPreProcessor**
- class **org.deeplearning4j.nn.conf.preprocessor.Cnn3DToFeedForwardPreProcessor**
- class **org.deeplearning4j.nn.conf.preprocessor.CnnToFeedForwardPreProcessor**
- class **org.deeplearning4j.nn.conf.preprocessor.CnnToRnnPreProcessor**
- class **org.deeplearning4j.nn.conf.preprocessor.ComposableInputPreProcessor**
- class **org.deeplearning4j.nn.conf.preprocessor.FeedForwardToCnn3DPreProcessor**
- class **org.deeplearning4j.nn.conf.preprocessor.FeedForwardToCnnPreProcessor**
- class **org.deeplearning4j.nn.conf.preprocessor.FeedForwardToRnnPreProcessor**
- class **org.deeplearning4j.nn.conf.preprocessor.RnnToCnnPreProcessor**
- class **org.deeplearning4j.nn.conf.preprocessor.RnnToFeedForwardPreProcessor**
- class **org.deeplearning4j.nn.conf.serde.BaseNetConfigDeserializer**
- class **org.deeplearning4j.nn.conf.serde.ComputationGraphConfigurationDeserializer**
- class **org.deeplearning4j.nn.conf.serde.JsonMappers**
- class **org.deeplearning4j.nn.conf.serde.MultiLayerConfigurationDeserializer**
- class **org.deeplearning4j.nn.conf.serde.legacyformat.LegacyGraphVertexDeserializer**
- class **org.deeplearning4j.nn.conf.serde.legacyformat.LegacyGraphVertexDeserializerHelper**
- class **org.deeplearning4j.nn.conf.serde.legacyformat.LegacyIntArrayDeserializer**
- class **org.deeplearning4j.nn.conf.serde.legacyformat.LegacyLayerDeserializer**
- class **org.deeplearning4j.nn.conf.serde.legacyformat.LegacyLayerDeserializerHelper**
- class **org.deeplearning4j.nn.conf.serde.legacyformat.LegacyPreprocessorDeserializer**
- class **org.deeplearning4j.nn.conf.serde.legacyformat.LegacyPreprocessorDeserializerHelper**
- class **org.deeplearning4j.nn.conf.serde.legacyformat.LegacyReconstructionDistributionDeserializer**
- class **org.deeplearning4j.nn.conf.serde.legacyformat.LegacyReconstructionDistributionDeserializerHelper**
- class **org.deeplearning4j.nn.conf.stepfunctions.DefaultStepFunction**
- class **org.deeplearning4j.nn.conf.stepfunctions.GradientStepFunction**
- class **org.deeplearning4j.nn.conf.stepfunctions.NegativeDefaultStepFunction**
- class **org.deeplearning4j.nn.conf.stepfunctions.NegativeGradientStepFunction**
- class **org.deeplearning4j.nn.conf.stepfunctions.StepFunction**
- class **org.deeplearning4j.nn.conf.weightnoise.DropConnect**
- interface **org.deeplearning4j.nn.conf.weightnoise.IWeightNoise**
- class **org.deeplearning4j.nn.conf.weightnoise.WeightNoise**
- class **org.deeplearning4j.nn.gradient.DefaultGradient**
- interface **org.deeplearning4j.nn.gradient.Gradient**
- class **org.deeplearning4j.nn.graph.ComputationGraph**
- class **org.deeplearning4j.nn.graph.util.ComputationGraphUtil**
- class **org.deeplearning4j.nn.graph.util.GraphIndices**
- class **org.deeplearning4j.nn.graph.vertex.BaseGraphVertex**
- class **org.deeplearning4j.nn.graph.vertex.BaseWrapperVertex**
- interface **org.deeplearning4j.nn.graph.vertex.GraphVertex**
- class **org.deeplearning4j.nn.graph.vertex.VertexIndices**
- enum **org.deeplearning4j.nn.graph.vertex.impl.ElementWiseVertex$Op**
- class **org.deeplearning4j.nn.graph.vertex.impl.ElementWiseVertex**
- class **org.deeplearning4j.nn.graph.vertex.impl.FrozenVertex**
- class **org.deeplearning4j.nn.graph.vertex.impl.InputVertex**
- class **org.deeplearning4j.nn.graph.vertex.impl.L2NormalizeVertex**
- class **org.deeplearning4j.nn.graph.vertex.impl.L2Vertex**
- class **org.deeplearning4j.nn.graph.vertex.impl.LayerVertex**
- class **org.deeplearning4j.nn.graph.vertex.impl.MergeVertex**
- class **org.deeplearning4j.nn.graph.vertex.impl.PoolHelperVertex**
- class **org.deeplearning4j.nn.graph.vertex.impl.PreprocessorVertex**
- class **org.deeplearning4j.nn.graph.vertex.impl.ReshapeVertex**
- class **org.deeplearning4j.nn.graph.vertex.impl.ScaleVertex**
- class **org.deeplearning4j.nn.graph.vertex.impl.ShiftVertex**
- class **org.deeplearning4j.nn.graph.vertex.impl.StackVertex**
- class **org.deeplearning4j.nn.graph.vertex.impl.SubsetVertex**
- class **org.deeplearning4j.nn.graph.vertex.impl.UnstackVertex**
- class **org.deeplearning4j.nn.graph.vertex.impl.rnn.DuplicateToTimeSeriesVertex**
- class **org.deeplearning4j.nn.graph.vertex.impl.rnn.LastTimeStepVertex**
- class **org.deeplearning4j.nn.graph.vertex.impl.rnn.ReverseTimeSeriesVertex**
- class **org.deeplearning4j.nn.layers.AbstractLayer**
- class **org.deeplearning4j.nn.layers.ActivationLayer**
- class **org.deeplearning4j.nn.layers.BaseCudnnHelper$CudnnContext$Deallocator**
- class **org.deeplearning4j.nn.layers.BaseCudnnHelper$CudnnContext**
- class **org.deeplearning4j.nn.layers.BaseCudnnHelper$DataCache**
- class **org.deeplearning4j.nn.layers.BaseCudnnHelper$TensorArray**
- class **org.deeplearning4j.nn.layers.BaseCudnnHelper**
- class **org.deeplearning4j.nn.layers.BaseLayer**
- class **org.deeplearning4j.nn.layers.BaseOutputLayer**
- class **org.deeplearning4j.nn.layers.BasePretrainNetwork**
- class **org.deeplearning4j.nn.layers.DropoutLayer**
- class **org.deeplearning4j.nn.layers.FrozenLayer**
- class **org.deeplearning4j.nn.layers.FrozenLayerWithBackprop**
- interface **org.deeplearning4j.nn.layers.LayerHelper**
- class **org.deeplearning4j.nn.layers.LossLayer**
- class **org.deeplearning4j.nn.layers.OutputLayer**
- class **org.deeplearning4j.nn.layers.RepeatVector**
- class **org.deeplearning4j.nn.layers.convolution.CnnLossLayer**
- class **org.deeplearning4j.nn.layers.convolution.Convolution1DLayer**
- class **org.deeplearning4j.nn.layers.convolution.Convolution3DLayer**
- interface **org.deeplearning4j.nn.layers.convolution.ConvolutionHelper**
- class **org.deeplearning4j.nn.layers.convolution.ConvolutionLayer**
- class **org.deeplearning4j.nn.layers.convolution.Cropping1DLayer**
- class **org.deeplearning4j.nn.layers.convolution.Cropping2DLayer**
- class **org.deeplearning4j.nn.layers.convolution.Cropping3DLayer**
- class **org.deeplearning4j.nn.layers.convolution.CudnnConvolutionHelper$CudnnForwardArgs**
- class **org.deeplearning4j.nn.layers.convolution.CudnnConvolutionHelper**
- class **org.deeplearning4j.nn.layers.convolution.Deconvolution2DLayer**
- class **org.deeplearning4j.nn.layers.convolution.DepthwiseConvolution2DLayer**
- class **org.deeplearning4j.nn.layers.convolution.SeparableConvolution2DLayer**
- class **org.deeplearning4j.nn.layers.convolution.SpaceToBatch**
- class **org.deeplearning4j.nn.layers.convolution.SpaceToDepth**
- class **org.deeplearning4j.nn.layers.convolution.ZeroPadding1DLayer**
- class **org.deeplearning4j.nn.layers.convolution.ZeroPadding3DLayer**
- class **org.deeplearning4j.nn.layers.convolution.ZeroPaddingLayer**
- class **org.deeplearning4j.nn.layers.convolution.subsampling.CudnnSubsamplingHelper**
- class **org.deeplearning4j.nn.layers.convolution.subsampling.Subsampling1DLayer**
- class **org.deeplearning4j.nn.layers.convolution.subsampling.Subsampling3DLayer**
- interface **org.deeplearning4j.nn.layers.convolution.subsampling.SubsamplingHelper**
- class **org.deeplearning4j.nn.layers.convolution.subsampling.SubsamplingLayer**
- class **org.deeplearning4j.nn.layers.convolution.upsampling.Upsampling1D**
- class **org.deeplearning4j.nn.layers.convolution.upsampling.Upsampling2D**
- class **org.deeplearning4j.nn.layers.convolution.upsampling.Upsampling3D**
- class **org.deeplearning4j.nn.layers.dropout.CudnnDropoutHelper**
- class **org.deeplearning4j.nn.layers.feedforward.PReLU**
- class **org.deeplearning4j.nn.layers.feedforward.autoencoder.AutoEncoder**
- class **org.deeplearning4j.nn.layers.feedforward.autoencoder.recursive.Tree**
- class **org.deeplearning4j.nn.layers.feedforward.dense.DenseLayer**
- class **org.deeplearning4j.nn.layers.feedforward.elementwise.ElementWiseMultiplicationLayer**
- class **org.deeplearning4j.nn.layers.feedforward.embedding.EmbeddingLayer**
- class **org.deeplearning4j.nn.layers.feedforward.embedding.EmbeddingSequenceLayer**
- class **org.deeplearning4j.nn.layers.normalization.BatchNormalization**
- interface **org.deeplearning4j.nn.layers.normalization.BatchNormalizationHelper**
- class **org.deeplearning4j.nn.layers.normalization.CudnnBatchNormalizationHelper**
- class **org.deeplearning4j.nn.layers.normalization.CudnnLocalResponseNormalizationHelper**
- class **org.deeplearning4j.nn.layers.normalization.LocalResponseNormalization**
- interface **org.deeplearning4j.nn.layers.normalization.LocalResponseNormalizationHelper**
- class **org.deeplearning4j.nn.layers.objdetect.DetectedObject**
- class **org.deeplearning4j.nn.layers.objdetect.Yolo2OutputLayer**
- class **org.deeplearning4j.nn.layers.objdetect.YoloUtils**
- class **org.deeplearning4j.nn.layers.ocnn.OCNNOutputLayer**
- class **org.deeplearning4j.nn.layers.ocnn.OCNNParamInitializer**
- class **org.deeplearning4j.nn.layers.pooling.GlobalPoolingLayer**
- class **org.deeplearning4j.nn.layers.recurrent.BaseRecurrentLayer**
- class **org.deeplearning4j.nn.layers.recurrent.BidirectionalLayer**
- class **org.deeplearning4j.nn.layers.recurrent.CudnnLSTMHelper**
- class **org.deeplearning4j.nn.layers.recurrent.FwdPassReturn**
- class **org.deeplearning4j.nn.layers.recurrent.GravesBidirectionalLSTM**
- class **org.deeplearning4j.nn.layers.recurrent.GravesLSTM**
- class **org.deeplearning4j.nn.layers.recurrent.LSTM**
- interface **org.deeplearning4j.nn.layers.recurrent.LSTMHelper**
- class **org.deeplearning4j.nn.layers.recurrent.LSTMHelpers**
- class **org.deeplearning4j.nn.layers.recurrent.LastTimeStepLayer**
- class **org.deeplearning4j.nn.layers.recurrent.MaskZeroLayer**
- class **org.deeplearning4j.nn.layers.recurrent.RnnLossLayer**
- class **org.deeplearning4j.nn.layers.recurrent.RnnOutputLayer**
- class **org.deeplearning4j.nn.layers.recurrent.SimpleRnn**
- class **org.deeplearning4j.nn.layers.samediff.SameDiffGraphVertex**
- class **org.deeplearning4j.nn.layers.samediff.SameDiffLayer**
- class **org.deeplearning4j.nn.layers.samediff.SameDiffOutputLayer**
- class **org.deeplearning4j.nn.layers.training.CenterLossOutputLayer**
- class **org.deeplearning4j.nn.layers.util.MaskLayer**
- class **org.deeplearning4j.nn.layers.variational.VariationalAutoencoder**
- class **org.deeplearning4j.nn.layers.wrapper.BaseWrapperLayer**
- class **org.deeplearning4j.nn.modelexport.solr.ltr.model.ScoringModel**
- class **org.deeplearning4j.nn.modelimport.keras.Hdf5Archive**
- enum **org.deeplearning4j.nn.modelimport.keras.KerasLayer$DimOrder**
- class **org.deeplearning4j.nn.modelimport.keras.KerasLayer**
- class **org.deeplearning4j.nn.modelimport.keras.KerasModel**
- class **org.deeplearning4j.nn.modelimport.keras.KerasModelImport**
- class **org.deeplearning4j.nn.modelimport.keras.KerasSequentialModel**
- class **org.deeplearning4j.nn.modelimport.keras.config.Keras1LayerConfiguration**
- class **org.deeplearning4j.nn.modelimport.keras.config.Keras2LayerConfiguration**
- class **org.deeplearning4j.nn.modelimport.keras.config.KerasLayerConfiguration**
- class **org.deeplearning4j.nn.modelimport.keras.config.KerasLayerConfigurationFactory**
- class **org.deeplearning4j.nn.modelimport.keras.config.KerasModelConfiguration**
- class **org.deeplearning4j.nn.modelimport.keras.exceptions.InvalidKerasConfigurationException**
- class **org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException**
- class **org.deeplearning4j.nn.modelimport.keras.layers.KerasInput**
- class **org.deeplearning4j.nn.modelimport.keras.layers.KerasLoss**
- class **org.deeplearning4j.nn.modelimport.keras.layers.advanced.activations.KerasLeakyReLU**
- class **org.deeplearning4j.nn.modelimport.keras.layers.advanced.activations.KerasPReLU**
- class **org.deeplearning4j.nn.modelimport.keras.layers.advanced.activations.KerasThresholdedReLU**
- class **org.deeplearning4j.nn.modelimport.keras.layers.convolutional.KerasAtrousConvolution1D**
- class **org.deeplearning4j.nn.modelimport.keras.layers.convolutional.KerasAtrousConvolution2D**
- class **org.deeplearning4j.nn.modelimport.keras.layers.convolutional.KerasConvolution**
- class **org.deeplearning4j.nn.modelimport.keras.layers.convolutional.KerasConvolution1D**
- class **org.deeplearning4j.nn.modelimport.keras.layers.convolutional.KerasConvolution2D**
- class **org.deeplearning4j.nn.modelimport.keras.layers.convolutional.KerasConvolution3D**
- class **org.deeplearning4j.nn.modelimport.keras.layers.convolutional.KerasConvolutionUtils**
- class **org.deeplearning4j.nn.modelimport.keras.layers.convolutional.KerasCropping1D**
- class **org.deeplearning4j.nn.modelimport.keras.layers.convolutional.KerasCropping2D**
- class **org.deeplearning4j.nn.modelimport.keras.layers.convolutional.KerasCropping3D**
- class **org.deeplearning4j.nn.modelimport.keras.layers.convolutional.KerasDeconvolution2D**
- class **org.deeplearning4j.nn.modelimport.keras.layers.convolutional.KerasDepthwiseConvolution2D**
- class **org.deeplearning4j.nn.modelimport.keras.layers.convolutional.KerasSeparableConvolution2D**
- class **org.deeplearning4j.nn.modelimport.keras.layers.convolutional.KerasSpaceToDepth**
- class **org.deeplearning4j.nn.modelimport.keras.layers.convolutional.KerasUpsampling1D**
- class **org.deeplearning4j.nn.modelimport.keras.layers.convolutional.KerasUpsampling2D**
- class **org.deeplearning4j.nn.modelimport.keras.layers.convolutional.KerasUpsampling3D**
- class **org.deeplearning4j.nn.modelimport.keras.layers.convolutional.KerasZeroPadding1D**
- class **org.deeplearning4j.nn.modelimport.keras.layers.convolutional.KerasZeroPadding2D**
- class **org.deeplearning4j.nn.modelimport.keras.layers.convolutional.KerasZeroPadding3D**
- class **org.deeplearning4j.nn.modelimport.keras.layers.core.KerasActivation**
- class **org.deeplearning4j.nn.modelimport.keras.layers.core.KerasDense**
- class **org.deeplearning4j.nn.modelimport.keras.layers.core.KerasDropout**
- class **org.deeplearning4j.nn.modelimport.keras.layers.core.KerasFlatten**
- class **org.deeplearning4j.nn.modelimport.keras.layers.core.KerasLambda**
- class **org.deeplearning4j.nn.modelimport.keras.layers.core.KerasMerge**
- class **org.deeplearning4j.nn.modelimport.keras.layers.core.KerasPermute**
- class **org.deeplearning4j.nn.modelimport.keras.layers.core.KerasRepeatVector**
- class **org.deeplearning4j.nn.modelimport.keras.layers.core.KerasReshape**
- class **org.deeplearning4j.nn.modelimport.keras.layers.core.KerasSpatialDropout**
- class **org.deeplearning4j.nn.modelimport.keras.layers.custom.KerasLRN**
- class **org.deeplearning4j.nn.modelimport.keras.layers.custom.KerasPoolHelper**
- class **org.deeplearning4j.nn.modelimport.keras.layers.embeddings.KerasEmbedding**
- class **org.deeplearning4j.nn.modelimport.keras.layers.local.KerasLocallyConnected1D**
- class **org.deeplearning4j.nn.modelimport.keras.layers.local.KerasLocallyConnected2D**
- class **org.deeplearning4j.nn.modelimport.keras.layers.noise.KerasAlphaDropout**
- class **org.deeplearning4j.nn.modelimport.keras.layers.noise.KerasGaussianDropout**
- class **org.deeplearning4j.nn.modelimport.keras.layers.noise.KerasGaussianNoise**
- class **org.deeplearning4j.nn.modelimport.keras.layers.normalization.KerasBatchNormalization**
- class **org.deeplearning4j.nn.modelimport.keras.layers.pooling.KerasGlobalPooling**
- class **org.deeplearning4j.nn.modelimport.keras.layers.pooling.KerasPooling1D**
- class **org.deeplearning4j.nn.modelimport.keras.layers.pooling.KerasPooling2D**
- class **org.deeplearning4j.nn.modelimport.keras.layers.pooling.KerasPooling3D**
- class **org.deeplearning4j.nn.modelimport.keras.layers.pooling.KerasPoolingUtils**
- class **org.deeplearning4j.nn.modelimport.keras.layers.recurrent.KerasLstm**
- class **org.deeplearning4j.nn.modelimport.keras.layers.recurrent.KerasRnnUtils**
- class **org.deeplearning4j.nn.modelimport.keras.layers.recurrent.KerasSimpleRnn**
- class **org.deeplearning4j.nn.modelimport.keras.layers.wrappers.KerasBidirectional**
- class **org.deeplearning4j.nn.modelimport.keras.preprocessing.text.KerasTokenizer**
- enum **org.deeplearning4j.nn.modelimport.keras.preprocessing.text.TokenizerMode**
- class **org.deeplearning4j.nn.modelimport.keras.preprocessors.KerasFlattenRnnPreprocessor**
- class **org.deeplearning4j.nn.modelimport.keras.preprocessors.PermutePreprocessor**
- class **org.deeplearning4j.nn.modelimport.keras.preprocessors.ReshapePreprocessor**
- class **org.deeplearning4j.nn.modelimport.keras.preprocessors.TensorFlowCnnToFeedForwardPreProcessor**
- class **org.deeplearning4j.nn.modelimport.keras.utils.KerasActivationUtils**
- class **org.deeplearning4j.nn.modelimport.keras.utils.KerasConstraintUtils**
- class **org.deeplearning4j.nn.modelimport.keras.utils.KerasInitilizationUtils**
- class **org.deeplearning4j.nn.modelimport.keras.utils.KerasLayerUtils**
- class **org.deeplearning4j.nn.modelimport.keras.utils.KerasLossUtils**
- class **org.deeplearning4j.nn.modelimport.keras.utils.KerasModelBuilder**
- class **org.deeplearning4j.nn.modelimport.keras.utils.KerasModelUtils**
- class **org.deeplearning4j.nn.modelimport.keras.utils.KerasOptimizerUtils**
- class **org.deeplearning4j.nn.modelimport.keras.utils.KerasRegularizerUtils**
- class **org.deeplearning4j.nn.multilayer.MultiLayerNetwork**
- class **org.deeplearning4j.nn.params.BatchNormalizationParamInitializer**
- class **org.deeplearning4j.nn.params.BidirectionalParamInitializer**
- class **org.deeplearning4j.nn.params.CenterLossParamInitializer**
- class **org.deeplearning4j.nn.params.Convolution3DParamInitializer**
- class **org.deeplearning4j.nn.params.ConvolutionParamInitializer**
- class **org.deeplearning4j.nn.params.DeconvolutionParamInitializer**
- class **org.deeplearning4j.nn.params.DefaultParamInitializer**
- class **org.deeplearning4j.nn.params.DepthwiseConvolutionParamInitializer**
- class **org.deeplearning4j.nn.params.ElementWiseParamInitializer**
- class **org.deeplearning4j.nn.params.EmptyParamInitializer**
- class **org.deeplearning4j.nn.params.FrozenLayerParamInitializer**
- class **org.deeplearning4j.nn.params.FrozenLayerWithBackpropParamInitializer**
- class **org.deeplearning4j.nn.params.GravesBidirectionalLSTMParamInitializer**
- class **org.deeplearning4j.nn.params.GravesLSTMParamInitializer**
- class **org.deeplearning4j.nn.params.LSTMParamInitializer**
- class **org.deeplearning4j.nn.params.PReLUParamInitializer**
- class **org.deeplearning4j.nn.params.PretrainParamInitializer**
- class **org.deeplearning4j.nn.params.SameDiffParamInitializer**
- class **org.deeplearning4j.nn.params.SeparableConvolutionParamInitializer**
- class **org.deeplearning4j.nn.params.SimpleRnnParamInitializer**
- class **org.deeplearning4j.nn.params.VariationalAutoencoderParamInitializer**
- class **org.deeplearning4j.nn.params.WrapperLayerParamInitializer**
- class **org.deeplearning4j.nn.simple.binary.BinaryClassificationResult**
- class **org.deeplearning4j.nn.simple.multiclass.RankClassificationResult**
- class **org.deeplearning4j.nn.transferlearning.FineTuneConfiguration$Builder**
- class **org.deeplearning4j.nn.transferlearning.FineTuneConfiguration**
- class **org.deeplearning4j.nn.transferlearning.TransferLearning$Builder**
- class **org.deeplearning4j.nn.transferlearning.TransferLearning$GraphBuilder**
- class **org.deeplearning4j.nn.transferlearning.TransferLearning**
- class **org.deeplearning4j.nn.transferlearning.TransferLearningHelper**
- class **org.deeplearning4j.nn.updater.BaseMultiLayerUpdater**
- class **org.deeplearning4j.nn.updater.LayerUpdater**
- class **org.deeplearning4j.nn.updater.MultiLayerUpdater**
- class **org.deeplearning4j.nn.updater.UpdaterBlock$ParamState**
- class **org.deeplearning4j.nn.updater.UpdaterBlock**
- class **org.deeplearning4j.nn.updater.UpdaterCreator**
- class **org.deeplearning4j.nn.updater.UpdaterUtils**
- class **org.deeplearning4j.nn.updater.graph.ComputationGraphUpdater**
- enum **org.deeplearning4j.nn.weights.WeightInit**
- class **org.deeplearning4j.nn.weights.WeightInitUtil**
- enum **org.deeplearning4j.nn.workspace.ArrayType**
- class **org.deeplearning4j.nn.workspace.LayerWorkspaceMgr$Builder**
- class **org.deeplearning4j.nn.workspace.LayerWorkspaceMgr**
- class **org.deeplearning4j.optimize.Solver$Builder**
- class **org.deeplearning4j.optimize.Solver**
- class **org.deeplearning4j.optimize.api.BaseTrainingListener**
- interface **org.deeplearning4j.optimize.api.ConvexOptimizer**
- enum **org.deeplearning4j.optimize.api.InvocationType**
- class **org.deeplearning4j.optimize.api.IterationListener**
- interface **org.deeplearning4j.optimize.api.LineOptimizer**
- interface **org.deeplearning4j.optimize.api.StepFunction**
- interface **org.deeplearning4j.optimize.api.TrainingListener**
- class **org.deeplearning4j.optimize.listeners.CollectScoresIterationListener**
- class **org.deeplearning4j.optimize.listeners.CollectScoresListener**
- class **org.deeplearning4j.optimize.listeners.ComposableIterationListener**
- class **org.deeplearning4j.optimize.listeners.EvaluativeListener**
- class **org.deeplearning4j.optimize.listeners.ParamAndGradientIterationListener**
- class **org.deeplearning4j.optimize.listeners.PerformanceListener$Builder**
- class **org.deeplearning4j.optimize.listeners.PerformanceListener**
- class **org.deeplearning4j.optimize.listeners.ScoreIterationListener**
- class **org.deeplearning4j.optimize.listeners.SharedGradient**
- enum **org.deeplearning4j.optimize.listeners.SleepyTrainingListener$SleepMode**
- enum **org.deeplearning4j.optimize.listeners.SleepyTrainingListener$TimeMode**
- class **org.deeplearning4j.optimize.listeners.SleepyTrainingListener**
- class **org.deeplearning4j.optimize.listeners.TimeIterationListener**
- interface **org.deeplearning4j.optimize.listeners.callbacks.EvaluationCallback**
- class **org.deeplearning4j.optimize.listeners.callbacks.ModelSavingCallback**
- class **org.deeplearning4j.optimize.listeners.checkpoint.Checkpoint**
- class **org.deeplearning4j.optimize.listeners.checkpoint.CheckpointListener$Builder**
- class **org.deeplearning4j.optimize.listeners.checkpoint.CheckpointListener**
- class **org.deeplearning4j.optimize.solvers.BackTrackLineSearch**
- class **org.deeplearning4j.optimize.solvers.BaseOptimizer**
- class **org.deeplearning4j.optimize.solvers.ConjugateGradient**
- class **org.deeplearning4j.optimize.solvers.LBFGS**
- class **org.deeplearning4j.optimize.solvers.LineGradientDescent**
- class **org.deeplearning4j.optimize.solvers.StochasticGradientDescent**
- class **org.deeplearning4j.optimize.solvers.accumulation.BasicGradientsAccumulator**
- class **org.deeplearning4j.optimize.solvers.accumulation.EncodedGradientsAccumulator$Builder**
- class **org.deeplearning4j.optimize.solvers.accumulation.EncodedGradientsAccumulator**
- class **org.deeplearning4j.optimize.solvers.accumulation.EncodingHandler**
- class **org.deeplearning4j.optimize.solvers.accumulation.FancyBlockingQueue**
- interface **org.deeplearning4j.optimize.solvers.accumulation.GradientsAccumulator**
- class **org.deeplearning4j.optimize.solvers.accumulation.LocalHandler**
- interface **org.deeplearning4j.optimize.solvers.accumulation.MessageHandler**
- interface **org.deeplearning4j.optimize.solvers.accumulation.Registerable**
- class **org.deeplearning4j.optimize.stepfunctions.DefaultStepFunction**
- class **org.deeplearning4j.optimize.stepfunctions.GradientStepFunction**
- class **org.deeplearning4j.optimize.stepfunctions.NegativeDefaultStepFunction**
- class **org.deeplearning4j.optimize.stepfunctions.NegativeGradientStepFunction**
- class **org.deeplearning4j.optimize.stepfunctions.StepFunctions**
- class **org.deeplearning4j.parallelism.AsyncIterator**
- class **org.deeplearning4j.parallelism.EarlyStoppingParallelTrainer**
- class **org.deeplearning4j.parallelism.ParallelInference$Builder**
- class **org.deeplearning4j.parallelism.ParallelInference$ObservablesProvider**
- class **org.deeplearning4j.parallelism.ParallelInference**
- class **org.deeplearning4j.parallelism.ParallelWrapper$Builder**
- enum **org.deeplearning4j.parallelism.ParallelWrapper$TrainingMode**
- class **org.deeplearning4j.parallelism.ParallelWrapper**
- class **org.deeplearning4j.parallelism.factory.DefaultTrainerContext**
- class **org.deeplearning4j.parallelism.factory.SymmetricTrainerContext**
- interface **org.deeplearning4j.parallelism.factory.TrainerContext**
- enum **org.deeplearning4j.parallelism.inference.InferenceMode**
- interface **org.deeplearning4j.parallelism.inference.InferenceObservable**
- class **org.deeplearning4j.parallelism.inference.observers.BasicInferenceObservable**
- class **org.deeplearning4j.parallelism.inference.observers.BasicInferenceObserver**
- class **org.deeplearning4j.parallelism.inference.observers.BatchedInferenceObservable**
- interface **org.deeplearning4j.parallelism.main.DataSetIteratorProviderFactory**
- interface **org.deeplearning4j.parallelism.main.MultiDataSetProviderFactory**
- class **org.deeplearning4j.parallelism.main.ParallelWrapperMain**
- class **org.deeplearning4j.parallelism.parameterserver.ParameterServerTrainer$ParameterServerTrainerBuilder**
- class **org.deeplearning4j.parallelism.parameterserver.ParameterServerTrainer**
- class **org.deeplearning4j.parallelism.parameterserver.ParameterServerTrainerContext**
- interface **org.deeplearning4j.parallelism.trainer.CommunicativeTrainer**
- class **org.deeplearning4j.parallelism.trainer.DefaultTrainer$DefaultTrainerBuilder**
- class **org.deeplearning4j.parallelism.trainer.DefaultTrainer**
- class **org.deeplearning4j.parallelism.trainer.SymmetricTrainer**
- interface **org.deeplearning4j.parallelism.trainer.Trainer**
- class **org.deeplearning4j.perf.listener.DeviceMetric**
- class **org.deeplearning4j.perf.listener.DiskInfo**
- class **org.deeplearning4j.perf.listener.HardwareMetric**
- class **org.deeplearning4j.perf.listener.SystemInfoFilePrintListener**
- class **org.deeplearning4j.perf.listener.SystemInfoPrintListener**
- class **org.deeplearning4j.perf.listener.SystemPolling$Builder**
- interface **org.deeplearning4j.perf.listener.SystemPolling$NameProvider**
- class **org.deeplearning4j.perf.listener.SystemPolling**
- class **org.deeplearning4j.plot.BarnesHutTsne$Builder**
- class **org.deeplearning4j.plot.BarnesHutTsne**
- class **org.deeplearning4j.plot.Tsne$Builder**
- class **org.deeplearning4j.plot.Tsne**
- class **org.deeplearning4j.rl4j.learning.HistoryProcessor**
- class **org.deeplearning4j.rl4j.learning.IHistoryProcessor$Configuration**
- interface **org.deeplearning4j.rl4j.learning.IHistoryProcessor**
- interface **org.deeplearning4j.rl4j.learning.ILearning$LConfiguration**
- interface **org.deeplearning4j.rl4j.learning.ILearning**
- class **org.deeplearning4j.rl4j.learning.Learning$InitMdp**
- class **org.deeplearning4j.rl4j.learning.Learning**
- interface **org.deeplearning4j.rl4j.learning.NeuralNetFetchable**
- interface **org.deeplearning4j.rl4j.learning.StepCountable**
- interface **org.deeplearning4j.rl4j.learning.async.AsyncConfiguration**
- class **org.deeplearning4j.rl4j.learning.async.AsyncGlobal**
- class **org.deeplearning4j.rl4j.learning.async.AsyncLearning**
- class **org.deeplearning4j.rl4j.learning.async.AsyncThread$AsyncStatEntry**
- class **org.deeplearning4j.rl4j.learning.async.AsyncThread$SubEpochReturn**
- class **org.deeplearning4j.rl4j.learning.async.AsyncThread**
- class **org.deeplearning4j.rl4j.learning.async.AsyncThreadDiscrete**
- class **org.deeplearning4j.rl4j.learning.async.MiniTrans**
- class **org.deeplearning4j.rl4j.learning.async.a3c.discrete.A3CDiscrete$A3CConfiguration**
- class **org.deeplearning4j.rl4j.learning.async.a3c.discrete.A3CDiscrete**
- class **org.deeplearning4j.rl4j.learning.async.a3c.discrete.A3CDiscreteConv**
- class **org.deeplearning4j.rl4j.learning.async.a3c.discrete.A3CDiscreteDense**
- class **org.deeplearning4j.rl4j.learning.async.a3c.discrete.A3CThreadDiscrete**
- class **org.deeplearning4j.rl4j.learning.async.nstep.discrete.AsyncNStepQLearningDiscrete$AsyncNStepQLConfiguration**
- class **org.deeplearning4j.rl4j.learning.async.nstep.discrete.AsyncNStepQLearningDiscrete**
- class **org.deeplearning4j.rl4j.learning.async.nstep.discrete.AsyncNStepQLearningDiscreteConv**
- class **org.deeplearning4j.rl4j.learning.async.nstep.discrete.AsyncNStepQLearningDiscreteDense**
- class **org.deeplearning4j.rl4j.learning.async.nstep.discrete.AsyncNStepQLearningThreadDiscrete**
- class **org.deeplearning4j.rl4j.learning.sync.ExpReplay**
- interface **org.deeplearning4j.rl4j.learning.sync.IExpReplay**
- class **org.deeplearning4j.rl4j.learning.sync.SyncLearning**
- class **org.deeplearning4j.rl4j.learning.sync.Transition**
- class **org.deeplearning4j.rl4j.learning.sync.qlearning.QLearning$QLConfiguration$QLConfigurationBuilder**
- class **org.deeplearning4j.rl4j.learning.sync.qlearning.QLearning$QLConfiguration**
- class **org.deeplearning4j.rl4j.learning.sync.qlearning.QLearning$QLStatEntry**
- class **org.deeplearning4j.rl4j.learning.sync.qlearning.QLearning$QLStepReturn**
- class **org.deeplearning4j.rl4j.learning.sync.qlearning.QLearning**
- class **org.deeplearning4j.rl4j.learning.sync.qlearning.discrete.QLearningDiscrete**
- class **org.deeplearning4j.rl4j.learning.sync.qlearning.discrete.QLearningDiscreteConv**
- class **org.deeplearning4j.rl4j.learning.sync.qlearning.discrete.QLearningDiscreteDense**
- interface **org.deeplearning4j.rl4j.mdp.MDP**
- class **org.deeplearning4j.rl4j.mdp.ale.ALEMDP$Configuration**
- class **org.deeplearning4j.rl4j.mdp.ale.ALEMDP$GameScreen**
- class **org.deeplearning4j.rl4j.mdp.ale.ALEMDP**
- class **org.deeplearning4j.rl4j.mdp.gym.ActionTransformer**
- class **org.deeplearning4j.rl4j.mdp.gym.GymEnv**
- class **org.deeplearning4j.rl4j.mdp.toy.HardDeteministicToy**
- class **org.deeplearning4j.rl4j.mdp.toy.HardToyState**
- class **org.deeplearning4j.rl4j.mdp.toy.SimpleToy**
- class **org.deeplearning4j.rl4j.mdp.toy.SimpleToyState**
- class **org.deeplearning4j.rl4j.mdp.vizdoom.Basic**
- class **org.deeplearning4j.rl4j.mdp.vizdoom.DeadlyCorridor**
- class **org.deeplearning4j.rl4j.mdp.vizdoom.PredictPosition**
- class **org.deeplearning4j.rl4j.mdp.vizdoom.TakeCover**
- class **org.deeplearning4j.rl4j.mdp.vizdoom.VizDoom$Configuration**
- class **org.deeplearning4j.rl4j.mdp.vizdoom.VizDoom$GameScreen**
- class **org.deeplearning4j.rl4j.mdp.vizdoom.VizDoom**
- interface **org.deeplearning4j.rl4j.network.NeuralNet**
- class **org.deeplearning4j.rl4j.network.ac.ActorCriticCompGraph**
- interface **org.deeplearning4j.rl4j.network.ac.ActorCriticFactoryCompGraph**
- class **org.deeplearning4j.rl4j.network.ac.ActorCriticFactoryCompGraphStdConv$Configuration**
- class **org.deeplearning4j.rl4j.network.ac.ActorCriticFactoryCompGraphStdConv**
- class **org.deeplearning4j.rl4j.network.ac.ActorCriticFactoryCompGraphStdDense$Configuration**
- class **org.deeplearning4j.rl4j.network.ac.ActorCriticFactoryCompGraphStdDense**
- interface **org.deeplearning4j.rl4j.network.ac.ActorCriticFactorySeparate**
- class **org.deeplearning4j.rl4j.network.ac.ActorCriticFactorySeparateStdDense$Configuration**
- class **org.deeplearning4j.rl4j.network.ac.ActorCriticFactorySeparateStdDense**
- class **org.deeplearning4j.rl4j.network.ac.ActorCriticLoss**
- class **org.deeplearning4j.rl4j.network.ac.ActorCriticSeparate**
- interface **org.deeplearning4j.rl4j.network.ac.IActorCritic**
- class **org.deeplearning4j.rl4j.network.dqn.DQN**
- interface **org.deeplearning4j.rl4j.network.dqn.DQNFactory**
- class **org.deeplearning4j.rl4j.network.dqn.DQNFactoryStdConv$Configuration**
- class **org.deeplearning4j.rl4j.network.dqn.DQNFactoryStdConv**
- class **org.deeplearning4j.rl4j.network.dqn.DQNFactoryStdDense$Configuration**
- class **org.deeplearning4j.rl4j.network.dqn.DQNFactoryStdDense**
- interface **org.deeplearning4j.rl4j.network.dqn.IDQN**
- class **org.deeplearning4j.rl4j.policy.ACPolicy**
- class **org.deeplearning4j.rl4j.policy.BoltzmannQ**
- class **org.deeplearning4j.rl4j.policy.DQNPolicy**
- class **org.deeplearning4j.rl4j.policy.EpsGreedy**
- class **org.deeplearning4j.rl4j.policy.Policy**
- interface **org.deeplearning4j.rl4j.space.ActionSpace**
- class **org.deeplearning4j.rl4j.space.ArrayObservationSpace**
- class **org.deeplearning4j.rl4j.space.Box**
- class **org.deeplearning4j.rl4j.space.DiscreteSpace**
- interface **org.deeplearning4j.rl4j.space.Encodable**
- class **org.deeplearning4j.rl4j.space.GymObservationSpace**
- class **org.deeplearning4j.rl4j.space.HighLowDiscrete**
- interface **org.deeplearning4j.rl4j.space.ObservationSpace**
- class **org.deeplearning4j.rl4j.util.Constants**
- class **org.deeplearning4j.rl4j.util.DataManager$Info**
- interface **org.deeplearning4j.rl4j.util.DataManager$StatEntry**
- class **org.deeplearning4j.rl4j.util.DataManager**
- enum **org.deeplearning4j.spark.api.RDDTrainingApproach**
- enum **org.deeplearning4j.spark.api.Repartition**
- enum **org.deeplearning4j.spark.api.RepartitionStrategy**
- interface **org.deeplearning4j.spark.api.Repartitioner**
- interface **org.deeplearning4j.spark.api.TrainingHook**
- interface **org.deeplearning4j.spark.api.TrainingMaster**
- interface **org.deeplearning4j.spark.api.TrainingResult**
- interface **org.deeplearning4j.spark.api.TrainingWorker**
- class **org.deeplearning4j.spark.api.WorkerConfiguration**
- class **org.deeplearning4j.spark.api.stats.CommonSparkTrainingStats$Builder**
- class **org.deeplearning4j.spark.api.stats.CommonSparkTrainingStats**
- interface **org.deeplearning4j.spark.api.stats.SparkTrainingStats**
- class **org.deeplearning4j.spark.api.stats.StatsCalculationHelper**
- class **org.deeplearning4j.spark.api.worker.ExecuteWorkerFlatMap**
- class **org.deeplearning4j.spark.api.worker.ExecuteWorkerMultiDataSetFlatMap**
- class **org.deeplearning4j.spark.api.worker.ExecuteWorkerPDSFlatMap**
- class **org.deeplearning4j.spark.api.worker.ExecuteWorkerPDSMDSFlatMap**
- class **org.deeplearning4j.spark.api.worker.ExecuteWorkerPathFlatMap**
- class **org.deeplearning4j.spark.api.worker.ExecuteWorkerPathMDSFlatMap**
- class **org.deeplearning4j.spark.api.worker.NetBroadcastTuple**
- class **org.deeplearning4j.spark.data.BatchAndExportDataSetsFunction**
- class **org.deeplearning4j.spark.data.BatchAndExportMultiDataSetsFunction**
- class **org.deeplearning4j.spark.data.BatchDataSetsFunction**
- class **org.deeplearning4j.spark.data.DataSetExportFunction**
- interface **org.deeplearning4j.spark.data.DataSetProvider**
- class **org.deeplearning4j.spark.data.MultiDataSetExportFunction**
- interface **org.deeplearning4j.spark.data.MultiDataSetProvider**
- class **org.deeplearning4j.spark.data.PathToDataSetFunction**
- class **org.deeplearning4j.spark.data.PathToMultiDataSetFunction**
- class **org.deeplearning4j.spark.data.SplitDataSetsFunction**
- class **org.deeplearning4j.spark.data.loader.RemoteFileSource**
- class **org.deeplearning4j.spark.data.loader.RemoteFileSourceFactory**
- class **org.deeplearning4j.spark.data.shuffle.SplitDataSetExamplesPairFlatMapFunction**
- class **org.deeplearning4j.spark.datavec.DataVecByteDataSetFunction**
- class **org.deeplearning4j.spark.datavec.DataVecDataSetFunction**
- class **org.deeplearning4j.spark.datavec.DataVecSequenceDataSetFunction**
- enum **org.deeplearning4j.spark.datavec.DataVecSequencePairDataSetFunction$AlignmentMode**
- class **org.deeplearning4j.spark.datavec.DataVecSequencePairDataSetFunction**
- class **org.deeplearning4j.spark.datavec.RDDMiniBatches$MiniBatchFunction**
- class **org.deeplearning4j.spark.datavec.RDDMiniBatches**
- class **org.deeplearning4j.spark.datavec.RecordReaderFunction**
- class **org.deeplearning4j.spark.datavec.export.StringToDataSetExportFunction**
- class **org.deeplearning4j.spark.datavec.iterator.DataVecRecord**
- class **org.deeplearning4j.spark.datavec.iterator.DataVecRecords**
- class **org.deeplearning4j.spark.datavec.iterator.IteratorUtils**
- class **org.deeplearning4j.spark.datavec.iterator.RRMDSIFunction**
- class **org.deeplearning4j.spark.datavec.iterator.SparkSourceDummyReader**
- class **org.deeplearning4j.spark.datavec.iterator.SparkSourceDummySeqReader**
- class **org.deeplearning4j.spark.earlystopping.BaseSparkEarlyStoppingTrainer**
- class **org.deeplearning4j.spark.earlystopping.SparkDataSetLossCalculator**
- class **org.deeplearning4j.spark.earlystopping.SparkEarlyStoppingGraphTrainer**
- class **org.deeplearning4j.spark.earlystopping.SparkEarlyStoppingTrainer**
- class **org.deeplearning4j.spark.earlystopping.SparkLossCalculatorComputationGraph**
- class **org.deeplearning4j.spark.impl.SparkListenable**
- class **org.deeplearning4j.spark.impl.common.Add**
- class **org.deeplearning4j.spark.impl.common.CountPartitionsFunction**
- class **org.deeplearning4j.spark.impl.common.LoadDataSetFunction**
- class **org.deeplearning4j.spark.impl.common.SplitPartitionsFunction**
- class **org.deeplearning4j.spark.impl.common.SplitPartitionsFunction2**
- class **org.deeplearning4j.spark.impl.common.reduce.IntDoubleReduceFunction**
- class **org.deeplearning4j.spark.impl.common.repartition.BalancedPartitioner**
- class **org.deeplearning4j.spark.impl.common.repartition.EqualPartitioner**
- class **org.deeplearning4j.spark.impl.common.repartition.HashingBalancedPartitioner**
- class **org.deeplearning4j.spark.impl.common.repartition.MapTupleToPairFlatMap**
- class **org.deeplearning4j.spark.impl.common.score.BaseVaeReconstructionProbWithKeyFunctionAdapter**
- class **org.deeplearning4j.spark.impl.common.score.BaseVaeScoreWithKeyFunctionAdapter**
- class **org.deeplearning4j.spark.impl.evaluation.EvaluationRunner**
- class **org.deeplearning4j.spark.impl.graph.SparkComputationGraph**
- class **org.deeplearning4j.spark.impl.graph.dataset.DataSetToMultiDataSetFn**
- class **org.deeplearning4j.spark.impl.graph.dataset.PairDataSetToMultiDataSetFn**
- class **org.deeplearning4j.spark.impl.graph.evaluation.IEvaluateMDSFlatMapFunction**
- class **org.deeplearning4j.spark.impl.graph.evaluation.IEvaluateMDSPathsFlatMapFunction**
- class **org.deeplearning4j.spark.impl.graph.scoring.ArrayPairToPair**
- class **org.deeplearning4j.spark.impl.graph.scoring.CGVaeReconstructionErrorWithKeyFunction**
- class **org.deeplearning4j.spark.impl.graph.scoring.CGVaeReconstructionProbWithKeyFunction**
- class **org.deeplearning4j.spark.impl.graph.scoring.GraphFeedForwardWithKeyFunction**
- class **org.deeplearning4j.spark.impl.graph.scoring.PairToArrayPair**
- class **org.deeplearning4j.spark.impl.graph.scoring.ScoreExamplesFunction**
- class **org.deeplearning4j.spark.impl.graph.scoring.ScoreExamplesWithKeyFunction**
- class **org.deeplearning4j.spark.impl.graph.scoring.ScoreFlatMapFunctionCGDataSet**
- class **org.deeplearning4j.spark.impl.graph.scoring.ScoreFlatMapFunctionCGMultiDataSet**
- class **org.deeplearning4j.spark.impl.listeners.VanillaStatsStorageRouter**
- class **org.deeplearning4j.spark.impl.listeners.VanillaStatsStorageRouterProvider**
- class **org.deeplearning4j.spark.impl.multilayer.SparkDl4jMultiLayer**
- class **org.deeplearning4j.spark.impl.multilayer.evaluation.IEvaluateAggregateFunction**
- class **org.deeplearning4j.spark.impl.multilayer.evaluation.IEvaluateFlatMapFunction**
- class **org.deeplearning4j.spark.impl.multilayer.evaluation.IEvaluationReduceFunction**
- class **org.deeplearning4j.spark.impl.multilayer.scoring.FeedForwardWithKeyFunction**
- class **org.deeplearning4j.spark.impl.multilayer.scoring.ScoreExamplesFunction**
- class **org.deeplearning4j.spark.impl.multilayer.scoring.ScoreExamplesWithKeyFunction**
- class **org.deeplearning4j.spark.impl.multilayer.scoring.ScoreFlatMapFunction**
- class **org.deeplearning4j.spark.impl.multilayer.scoring.SingleToPairFunction**
- class **org.deeplearning4j.spark.impl.multilayer.scoring.VaeReconstructionErrorWithKeyFunction**
- class **org.deeplearning4j.spark.impl.multilayer.scoring.VaeReconstructionProbWithKeyFunction**
- class **org.deeplearning4j.spark.impl.paramavg.BaseTrainingMaster**
- class **org.deeplearning4j.spark.impl.paramavg.BaseTrainingResult**
- class **org.deeplearning4j.spark.impl.paramavg.BaseTrainingWorker**
- class **org.deeplearning4j.spark.impl.paramavg.ParameterAveragingTrainingMaster$Builder**
- class **org.deeplearning4j.spark.impl.paramavg.ParameterAveragingTrainingMaster**
- class **org.deeplearning4j.spark.impl.paramavg.ParameterAveragingTrainingResult**
- class **org.deeplearning4j.spark.impl.paramavg.ParameterAveragingTrainingWorker**
- class **org.deeplearning4j.spark.impl.paramavg.aggregator.ParameterAveragingAggregationTuple**
- class **org.deeplearning4j.spark.impl.paramavg.aggregator.ParameterAveragingElementAddFunction**
- class **org.deeplearning4j.spark.impl.paramavg.aggregator.ParameterAveragingElementCombineFunction**
- class **org.deeplearning4j.spark.impl.paramavg.stats.ParameterAveragingTrainingMasterStats$ParameterAveragingTrainingMasterStatsHelper**
- class **org.deeplearning4j.spark.impl.paramavg.stats.ParameterAveragingTrainingMasterStats**
- class **org.deeplearning4j.spark.impl.paramavg.stats.ParameterAveragingTrainingWorkerStats$ParameterAveragingTrainingWorkerStatsHelper**
- class **org.deeplearning4j.spark.impl.paramavg.stats.ParameterAveragingTrainingWorkerStats**
- class **org.deeplearning4j.spark.impl.paramavg.util.ExportSupport**
- class **org.deeplearning4j.spark.impl.repartitioner.DefaultRepartitioner**
- class **org.deeplearning4j.spark.impl.repartitioner.EqualRepartitioner**
- class **org.deeplearning4j.spark.impl.repartitioner.NoOpRepartitioner**
- class **org.deeplearning4j.spark.iterator.BaseDataSetIterator**
- class **org.deeplearning4j.spark.iterator.PathSparkDataSetIterator**
- class **org.deeplearning4j.spark.iterator.PathSparkMultiDataSetIterator**
- class **org.deeplearning4j.spark.iterator.PortableDataStreamDataSetIterator**
- class **org.deeplearning4j.spark.iterator.PortableDataStreamMultiDataSetIterator**
- class **org.deeplearning4j.spark.iterator.SparkADSI**
- class **org.deeplearning4j.spark.iterator.SparkAMDSI**
- class **org.deeplearning4j.spark.models.embeddings.glove.Glove**
- class **org.deeplearning4j.spark.models.embeddings.glove.GloveChange**
- class **org.deeplearning4j.spark.models.embeddings.glove.GloveParam$Builder**
- class **org.deeplearning4j.spark.models.embeddings.glove.GloveParam**
- class **org.deeplearning4j.spark.models.embeddings.glove.GlovePerformer**
- class **org.deeplearning4j.spark.models.embeddings.glove.VocabWordPairs**
- class **org.deeplearning4j.spark.models.embeddings.glove.cooccurrences.CoOccurrenceCalculator**
- class **org.deeplearning4j.spark.models.embeddings.glove.cooccurrences.CoOccurrenceCounts**
- class **org.deeplearning4j.spark.models.embeddings.word2vec.FirstIterationFunction**
- class **org.deeplearning4j.spark.models.embeddings.word2vec.FirstIterationFunctionAdapter**
- class **org.deeplearning4j.spark.models.embeddings.word2vec.MapToPairFunction**
- class **org.deeplearning4j.spark.models.embeddings.word2vec.NegativeHolder**
- class **org.deeplearning4j.spark.models.embeddings.word2vec.SecondIterationFunction**
- class **org.deeplearning4j.spark.models.embeddings.word2vec.SentenceBatch**
- class **org.deeplearning4j.spark.models.embeddings.word2vec.VocabHolder**
- class **org.deeplearning4j.spark.models.embeddings.word2vec.Word2Vec$Builder**
- class **org.deeplearning4j.spark.models.embeddings.word2vec.Word2Vec**
- class **org.deeplearning4j.spark.models.embeddings.word2vec.Word2VecChange**
- class **org.deeplearning4j.spark.models.embeddings.word2vec.Word2VecFuncCall**
- class **org.deeplearning4j.spark.models.embeddings.word2vec.Word2VecParam$Builder**
- class **org.deeplearning4j.spark.models.embeddings.word2vec.Word2VecParam**
- class **org.deeplearning4j.spark.models.embeddings.word2vec.Word2VecPerformer**
- class **org.deeplearning4j.spark.models.embeddings.word2vec.Word2VecPerformerVoid**
- class **org.deeplearning4j.spark.models.embeddings.word2vec.Word2VecSetup**
- class **org.deeplearning4j.spark.models.embeddings.word2vec.Word2VecVariables**
- class **org.deeplearning4j.spark.models.paragraphvectors.SparkParagraphVectors**
- class **org.deeplearning4j.spark.models.paragraphvectors.functions.DocumentSequenceConvertFunction**
- class **org.deeplearning4j.spark.models.paragraphvectors.functions.KeySequenceConvertFunction**
- class **org.deeplearning4j.spark.models.sequencevectors.SparkSequenceVectors$Builder**
- class **org.deeplearning4j.spark.models.sequencevectors.SparkSequenceVectors**
- class **org.deeplearning4j.spark.models.sequencevectors.export.ExportContainer**
- interface **org.deeplearning4j.spark.models.sequencevectors.export.SparkModelExporter**
- class **org.deeplearning4j.spark.models.sequencevectors.export.impl.HdfsModelExporter**
- class **org.deeplearning4j.spark.models.sequencevectors.export.impl.VocabCacheExporter**
- class **org.deeplearning4j.spark.models.sequencevectors.functions.BaseTokenizerFunction**
- class **org.deeplearning4j.spark.models.sequencevectors.functions.CountFunction**
- class **org.deeplearning4j.spark.models.sequencevectors.functions.DistributedFunction**
- class **org.deeplearning4j.spark.models.sequencevectors.functions.ElementsFrequenciesAccumulator**
- class **org.deeplearning4j.spark.models.sequencevectors.functions.ExportFunction**
- class **org.deeplearning4j.spark.models.sequencevectors.functions.ExtraCountFunction**
- class **org.deeplearning4j.spark.models.sequencevectors.functions.ExtraElementsFrequenciesAccumulator**
- class **org.deeplearning4j.spark.models.sequencevectors.functions.ListSequenceConvertFunction**
- class **org.deeplearning4j.spark.models.sequencevectors.functions.PartitionTrainingFunction**
- class **org.deeplearning4j.spark.models.sequencevectors.functions.TokenizerFunction**
- class **org.deeplearning4j.spark.models.sequencevectors.functions.TrainingFunction**
- class **org.deeplearning4j.spark.models.sequencevectors.functions.VocabRddFunctionFlat**
- interface **org.deeplearning4j.spark.models.sequencevectors.learning.SparkElementsLearningAlgorithm**
- interface **org.deeplearning4j.spark.models.sequencevectors.learning.SparkSequenceLearningAlgorithm**
- class **org.deeplearning4j.spark.models.sequencevectors.learning.elements.BaseSparkLearningAlgorithm**
- class **org.deeplearning4j.spark.models.sequencevectors.learning.elements.SparkCBOW**
- class **org.deeplearning4j.spark.models.sequencevectors.learning.elements.SparkSkipGram**
- class **org.deeplearning4j.spark.models.sequencevectors.learning.sequence.BaseSparkSequenceLearningAlgorithm**
- class **org.deeplearning4j.spark.models.sequencevectors.learning.sequence.SparkDBOW**
- class **org.deeplearning4j.spark.models.sequencevectors.learning.sequence.SparkDM**
- class **org.deeplearning4j.spark.models.sequencevectors.primitives.ExtraCounter**
- class **org.deeplearning4j.spark.models.word2vec.SparkWord2Vec$Builder**
- class **org.deeplearning4j.spark.models.word2vec.SparkWord2Vec**
- class **org.deeplearning4j.spark.ordering.DataSetOrdering**
- class **org.deeplearning4j.spark.parameterserver.ParameterServerSubscriber**
- class **org.deeplearning4j.spark.parameterserver.ParameterServerTrainingHook**
- class **org.deeplearning4j.spark.parameterserver.accumulation.SharedTrainingAccumulationFunction**
- class **org.deeplearning4j.spark.parameterserver.accumulation.SharedTrainingAccumulationTuple**
- class **org.deeplearning4j.spark.parameterserver.accumulation.SharedTrainingAggregateFunction**
- class **org.deeplearning4j.spark.parameterserver.callbacks.DataSetDeserializationCallback**
- class **org.deeplearning4j.spark.parameterserver.callbacks.MultiDataSetDeserializationCallback**
- interface **org.deeplearning4j.spark.parameterserver.callbacks.PortableDataStreamCallback**
- interface **org.deeplearning4j.spark.parameterserver.callbacks.PortableDataStreamMDSCallback**
- class **org.deeplearning4j.spark.parameterserver.conf.SharedTrainingConfiguration**
- class **org.deeplearning4j.spark.parameterserver.functions.SharedFlatMapDataSet**
- class **org.deeplearning4j.spark.parameterserver.functions.SharedFlatMapMultiDataSet**
- class **org.deeplearning4j.spark.parameterserver.functions.SharedFlatMapPaths**
- class **org.deeplearning4j.spark.parameterserver.functions.SharedFlatMapPathsMDS**
- class **org.deeplearning4j.spark.parameterserver.iterators.MultiPdsIterator**
- class **org.deeplearning4j.spark.parameterserver.iterators.PdsIterator**
- class **org.deeplearning4j.spark.parameterserver.iterators.VirtualDataSetIterator**
- class **org.deeplearning4j.spark.parameterserver.iterators.VirtualIterator**
- class **org.deeplearning4j.spark.parameterserver.iterators.VirtualMultiDataSetIterator**
- class **org.deeplearning4j.spark.parameterserver.networking.SilentTrainingDriver**
- class **org.deeplearning4j.spark.parameterserver.networking.WiredEncodingHandler**
- class **org.deeplearning4j.spark.parameterserver.networking.messages.SilentIntroductoryConfirmation**
- class **org.deeplearning4j.spark.parameterserver.networking.messages.SilentIntroductoryMessage**
- class **org.deeplearning4j.spark.parameterserver.networking.messages.SilentUpdatesMessage**
- class **org.deeplearning4j.spark.parameterserver.pw.SharedTrainingWrapper**
- class **org.deeplearning4j.spark.parameterserver.training.SharedTrainingMaster$Builder**
- class **org.deeplearning4j.spark.parameterserver.training.SharedTrainingMaster**
- class **org.deeplearning4j.spark.parameterserver.training.SharedTrainingResult**
- class **org.deeplearning4j.spark.parameterserver.training.SharedTrainingWorker**
- class **org.deeplearning4j.spark.parameterserver.util.BlockingObserver**
- class **org.deeplearning4j.spark.parameterserver.util.CountingIterator**
- class **org.deeplearning4j.spark.stats.BaseEventStats**
- interface **org.deeplearning4j.spark.stats.EventStats**
- class **org.deeplearning4j.spark.stats.ExampleCountEventStats**
- class **org.deeplearning4j.spark.stats.PartitionCountEventStats**
- class **org.deeplearning4j.spark.stats.StatsUtils$StartTimeComparator**
- class **org.deeplearning4j.spark.stats.StatsUtils**
- class **org.deeplearning4j.spark.text.accumulators.MaxPerPartitionAccumulator**
- class **org.deeplearning4j.spark.text.accumulators.WordFreqAccumulator**
- class **org.deeplearning4j.spark.text.functions.CountCumSum**
- class **org.deeplearning4j.spark.text.functions.FoldBetweenPartitionFunction**
- class **org.deeplearning4j.spark.text.functions.FoldWithinPartitionFunction**
- class **org.deeplearning4j.spark.text.functions.GetSentenceCountFunction**
- class **org.deeplearning4j.spark.text.functions.MapPerPartitionVoidFunction**
- class **org.deeplearning4j.spark.text.functions.ReduceSentenceCount**
- class **org.deeplearning4j.spark.text.functions.TextPipeline**
- class **org.deeplearning4j.spark.text.functions.TokenizerFunction**
- class **org.deeplearning4j.spark.text.functions.UpdateWordFreqAccumulatorFunction**
- class **org.deeplearning4j.spark.text.functions.WordsListToVocabWordsFunction**
- class **org.deeplearning4j.spark.time.NTPTimeSource**
- class **org.deeplearning4j.spark.time.SystemClockTimeSource**
- interface **org.deeplearning4j.spark.time.TimeSource**
- class **org.deeplearning4j.spark.time.TimeSourceProvider**
- class **org.deeplearning4j.spark.util.BaseDoubleFlatMapFunctionAdaptee**
- class **org.deeplearning4j.spark.util.BasePairFlatMapFunctionAdaptee**
- class **org.deeplearning4j.spark.util.MLLibUtil**
- class **org.deeplearning4j.spark.util.SparkUtils**
- class **org.deeplearning4j.spark.util.data.SparkDataValidation**
- class **org.deeplearning4j.spark.util.data.ValidationResult**
- class **org.deeplearning4j.spark.util.data.validation.ValidateDataSetFn**
- class **org.deeplearning4j.spark.util.data.validation.ValidateMultiDataSetFn**
- class **org.deeplearning4j.spark.util.data.validation.ValidationResultReduceFn**
- class **org.deeplearning4j.spark.util.serde.StorageLevelDeserializer**
- class **org.deeplearning4j.spark.util.serde.StorageLevelSerializer**
- class **org.deeplearning4j.text.annotator.PoStagger**
- class **org.deeplearning4j.text.annotator.SentenceAnnotator**
- class **org.deeplearning4j.text.annotator.StemmerAnnotator**
- class **org.deeplearning4j.text.annotator.TokenizerAnnotator**
- class **org.deeplearning4j.text.corpora.sentiwordnet.SWN3**
- class **org.deeplearning4j.text.corpora.treeparser.BinarizeTreeTransformer**
- class **org.deeplearning4j.text.corpora.treeparser.CollapseUnaries**
- class **org.deeplearning4j.text.corpora.treeparser.HeadWordFinder**
- class **org.deeplearning4j.text.corpora.treeparser.TreeFactory**
- class **org.deeplearning4j.text.corpora.treeparser.TreeIterator**
- class **org.deeplearning4j.text.corpora.treeparser.TreeParser**
- class **org.deeplearning4j.text.corpora.treeparser.TreeVectorizer**
- interface **org.deeplearning4j.text.corpora.treeparser.transformer.TreeTransformer**
- class **org.deeplearning4j.text.documentiterator.AsyncLabelAwareIterator**
- class **org.deeplearning4j.text.documentiterator.BasicLabelAwareIterator$Builder**
- class **org.deeplearning4j.text.documentiterator.BasicLabelAwareIterator**
- interface **org.deeplearning4j.text.documentiterator.DocumentIterator**
- class **org.deeplearning4j.text.documentiterator.FileDocumentIterator**
- class **org.deeplearning4j.text.documentiterator.FileLabelAwareIterator$Builder**
- class **org.deeplearning4j.text.documentiterator.FileLabelAwareIterator**
- class **org.deeplearning4j.text.documentiterator.FilenamesLabelAwareIterator$Builder**
- class **org.deeplearning4j.text.documentiterator.FilenamesLabelAwareIterator**
- interface **org.deeplearning4j.text.documentiterator.LabelAwareDocumentIterator**
- interface **org.deeplearning4j.text.documentiterator.LabelAwareIterator**
- class **org.deeplearning4j.text.documentiterator.LabelledDocument**
- class **org.deeplearning4j.text.documentiterator.LabelsSource**
- class **org.deeplearning4j.text.documentiterator.SimpleLabelAwareIterator**
- class **org.deeplearning4j.text.documentiterator.interoperability.DocumentIteratorConverter**
- class **org.deeplearning4j.text.inputsanitation.InputHomogenization**
- interface **org.deeplearning4j.text.invertedindex.InvertedIndex**
- interface **org.deeplearning4j.text.labels.LabelsProvider**
- class **org.deeplearning4j.text.movingwindow.ContextLabelRetriever**
- class **org.deeplearning4j.text.movingwindow.Util**
- class **org.deeplearning4j.text.movingwindow.Window**
- class **org.deeplearning4j.text.movingwindow.WindowConverter**
- class **org.deeplearning4j.text.movingwindow.Windows**
- class **org.deeplearning4j.text.movingwindow.WordConverter**
- class **org.deeplearning4j.text.sentenceiterator.AggregatingSentenceIterator$Builder**
- class **org.deeplearning4j.text.sentenceiterator.AggregatingSentenceIterator**
- class **org.deeplearning4j.text.sentenceiterator.BaseSentenceIterator**
- class **org.deeplearning4j.text.sentenceiterator.BasicLineIterator**
- class **org.deeplearning4j.text.sentenceiterator.BasicResultSetIterator**
- class **org.deeplearning4j.text.sentenceiterator.CollectionSentenceIterator**
- class **org.deeplearning4j.text.sentenceiterator.FileSentenceIterator**
- class **org.deeplearning4j.text.sentenceiterator.LineSentenceIterator**
- class **org.deeplearning4j.text.sentenceiterator.MutipleEpochsSentenceIterator**
- class **org.deeplearning4j.text.sentenceiterator.PrefetchingSentenceIterator$Builder**
- class **org.deeplearning4j.text.sentenceiterator.PrefetchingSentenceIterator**
- interface **org.deeplearning4j.text.sentenceiterator.SentenceIterator**
- interface **org.deeplearning4j.text.sentenceiterator.SentencePreProcessor**
- class **org.deeplearning4j.text.sentenceiterator.StreamLineIterator$Builder**
- class **org.deeplearning4j.text.sentenceiterator.StreamLineIterator**
- class **org.deeplearning4j.text.sentenceiterator.SynchronizedSentenceIterator**
- class **org.deeplearning4j.text.sentenceiterator.UimaResultSetIterator**
- class **org.deeplearning4j.text.sentenceiterator.UimaSentenceIterator**
- class **org.deeplearning4j.text.sentenceiterator.interoperability.SentenceIteratorConverter**
- class **org.deeplearning4j.text.sentenceiterator.labelaware.LabelAwareFileSentenceIterator**
- interface **org.deeplearning4j.text.sentenceiterator.labelaware.LabelAwareSentenceIterator**
- class **org.deeplearning4j.text.sentenceiterator.labelaware.LabelAwareUimaSentenceIterator**
- class **org.deeplearning4j.text.stopwords.StopWords**
- class **org.deeplearning4j.text.tokenization.tokenizer.ChineseTokenizer**
- class **org.deeplearning4j.text.tokenization.tokenizer.ConcurrentTokenizer**
- class **org.deeplearning4j.text.tokenization.tokenizer.DefaultStreamTokenizer**
- class **org.deeplearning4j.text.tokenization.tokenizer.DefaultTokenizer**
- class **org.deeplearning4j.text.tokenization.tokenizer.JapaneseTokenizer**
- class **org.deeplearning4j.text.tokenization.tokenizer.KoreanTokenizer**
- class **org.deeplearning4j.text.tokenization.tokenizer.NGramTokenizer**
- class **org.deeplearning4j.text.tokenization.tokenizer.PosUimaTokenizer**
- interface **org.deeplearning4j.text.tokenization.tokenizer.TokenPreProcess**
- interface **org.deeplearning4j.text.tokenization.tokenizer.Tokenizer**
- class **org.deeplearning4j.text.tokenization.tokenizer.UimaTokenizer**
- class **org.deeplearning4j.text.tokenization.tokenizer.preprocessor.CommonPreprocessor**
- class **org.deeplearning4j.text.tokenization.tokenizer.preprocessor.CustomStemmingPreprocessor**
- class **org.deeplearning4j.text.tokenization.tokenizer.preprocessor.EmbeddedStemmingPreprocessor**
- class **org.deeplearning4j.text.tokenization.tokenizer.preprocessor.EndingPreProcessor**
- class **org.deeplearning4j.text.tokenization.tokenizer.preprocessor.LowCasePreProcessor**
- class **org.deeplearning4j.text.tokenization.tokenizer.preprocessor.StemmingPreprocessor**
- class **org.deeplearning4j.text.tokenization.tokenizer.preprocessor.StringCleaning**
- class **org.deeplearning4j.text.tokenization.tokenizerFactory.ChineseTokenizerFactory**
- class **org.deeplearning4j.text.uima.UimaResource**
- class **org.deeplearning4j.ui.UiConnectionInfo$Builder**
- class **org.deeplearning4j.ui.UiConnectionInfo**
- class **org.deeplearning4j.ui.UiUtils**
- class **org.deeplearning4j.ui.WebReporter**
- class **org.deeplearning4j.ui.activation.PathUpdate**
- class **org.deeplearning4j.ui.api.Component**
- enum **org.deeplearning4j.ui.api.FunctionType**
- enum **org.deeplearning4j.ui.api.HttpMethod**
- interface **org.deeplearning4j.ui.api.I18N**
- enum **org.deeplearning4j.ui.api.LengthUnit**
- class **org.deeplearning4j.ui.api.Route**
- class **org.deeplearning4j.ui.api.Style$Builder**
- class **org.deeplearning4j.ui.api.Style**
- interface **org.deeplearning4j.ui.api.UIModule**
- class **org.deeplearning4j.ui.api.UIServer**
- class **org.deeplearning4j.ui.api.Utils**
- class **org.deeplearning4j.ui.components.chart.Chart$Builder**
- class **org.deeplearning4j.ui.components.chart.Chart**
- class **org.deeplearning4j.ui.components.chart.ChartHistogram$Builder**
- class **org.deeplearning4j.ui.components.chart.ChartHistogram**
- class **org.deeplearning4j.ui.components.chart.ChartHorizontalBar$Builder**
- class **org.deeplearning4j.ui.components.chart.ChartHorizontalBar**
- class **org.deeplearning4j.ui.components.chart.ChartLine$Builder**
- class **org.deeplearning4j.ui.components.chart.ChartLine**
- class **org.deeplearning4j.ui.components.chart.ChartScatter$Builder**
- class **org.deeplearning4j.ui.components.chart.ChartScatter**
- class **org.deeplearning4j.ui.components.chart.ChartStackedArea$Builder**
- class **org.deeplearning4j.ui.components.chart.ChartStackedArea**
- class **org.deeplearning4j.ui.components.chart.ChartTimeline$Builder**
- class **org.deeplearning4j.ui.components.chart.ChartTimeline$TimelineEntry**
- class **org.deeplearning4j.ui.components.chart.ChartTimeline**
- class **org.deeplearning4j.ui.components.chart.style.StyleChart$Builder**
- class **org.deeplearning4j.ui.components.chart.style.StyleChart**
- class **org.deeplearning4j.ui.components.component.ComponentDiv**
- class **org.deeplearning4j.ui.components.component.style.StyleDiv$Builder**
- enum **org.deeplearning4j.ui.components.component.style.StyleDiv$FloatValue**
- class **org.deeplearning4j.ui.components.component.style.StyleDiv**
- class **org.deeplearning4j.ui.components.decorator.DecoratorAccordion$Builder**
- class **org.deeplearning4j.ui.components.decorator.DecoratorAccordion**
- class **org.deeplearning4j.ui.components.decorator.style.StyleAccordion$Builder**
- class **org.deeplearning4j.ui.components.decorator.style.StyleAccordion**
- class **org.deeplearning4j.ui.components.table.ComponentTable$Builder**
- class **org.deeplearning4j.ui.components.table.ComponentTable**
- class **org.deeplearning4j.ui.components.table.style.StyleTable$Builder**
- class **org.deeplearning4j.ui.components.table.style.StyleTable**
- class **org.deeplearning4j.ui.components.text.ComponentText$Builder**
- class **org.deeplearning4j.ui.components.text.ComponentText**
- class **org.deeplearning4j.ui.components.text.style.StyleText$Builder**
- class **org.deeplearning4j.ui.components.text.style.StyleText**
- class **org.deeplearning4j.ui.exception.GenericExceptionMapper**
- class **org.deeplearning4j.ui.exception.JsonExceptionMapper**
- class **org.deeplearning4j.ui.i18n.DefaultI18N**
- class **org.deeplearning4j.ui.i18n.I18NProvider**
- class **org.deeplearning4j.ui.i18n.I18NResource**
- class **org.deeplearning4j.ui.module.convolutional.ConvolutionalListenerModule**
- class **org.deeplearning4j.ui.module.defaultModule.DefaultModule**
- class **org.deeplearning4j.ui.module.remote.RemoteReceiverModule**
- class **org.deeplearning4j.ui.module.train.TrainModule**
- class **org.deeplearning4j.ui.module.train.TrainModuleUtils$GraphInfo**
- class **org.deeplearning4j.ui.module.train.TrainModuleUtils**
- class **org.deeplearning4j.ui.module.tsne.TsneModule**
- class **org.deeplearning4j.ui.nearestneighbors.word2vec.NearestNeighborsQuery**
- class **org.deeplearning4j.ui.play.PlayUIServer**
- class **org.deeplearning4j.ui.play.misc.FunctionUtil**
- class **org.deeplearning4j.ui.play.staticroutes.Assets**
- class **org.deeplearning4j.ui.play.staticroutes.I18NRoute**
- class **org.deeplearning4j.ui.providers.ObjectMapperProvider**
- class **org.deeplearning4j.ui.renders.PathUpdate**
- class **org.deeplearning4j.ui.standalone.ComponentObject**
- class **org.deeplearning4j.ui.standalone.StaticPageUtil**
- class **org.deeplearning4j.ui.stats.BaseStatsListener**
- class **org.deeplearning4j.ui.stats.J7StatsListener**
- class **org.deeplearning4j.ui.stats.StatsListener**
- class **org.deeplearning4j.ui.stats.api.Histogram**
- interface **org.deeplearning4j.ui.stats.api.StatsInitializationConfiguration**
- interface **org.deeplearning4j.ui.stats.api.StatsInitializationReport**
- interface **org.deeplearning4j.ui.stats.api.StatsReport**
- enum **org.deeplearning4j.ui.stats.api.StatsType**
- interface **org.deeplearning4j.ui.stats.api.StatsUpdateConfiguration**
- enum **org.deeplearning4j.ui.stats.api.SummaryType**
- class **org.deeplearning4j.ui.stats.impl.DefaultStatsInitializationConfiguration**
- class **org.deeplearning4j.ui.stats.impl.DefaultStatsUpdateConfiguration$Builder**
- class **org.deeplearning4j.ui.stats.impl.DefaultStatsUpdateConfiguration**
- class **org.deeplearning4j.ui.stats.impl.SbeStatsInitializationReport**
- class **org.deeplearning4j.ui.stats.impl.SbeStatsReport**
- class **org.deeplearning4j.ui.stats.impl.SbeUtil**
- class **org.deeplearning4j.ui.stats.impl.java.JavaStatsInitializationReport**
- class **org.deeplearning4j.ui.stats.impl.java.JavaStatsReport**
- class **org.deeplearning4j.ui.stats.sbe.GroupSizeEncodingDecoder**
- class **org.deeplearning4j.ui.stats.sbe.GroupSizeEncodingEncoder**
- class **org.deeplearning4j.ui.stats.sbe.InitFieldsPresentDecoder**
- class **org.deeplearning4j.ui.stats.sbe.InitFieldsPresentEncoder**
- enum **org.deeplearning4j.ui.stats.sbe.MemoryType**
- class **org.deeplearning4j.ui.stats.sbe.MessageHeaderDecoder**
- class **org.deeplearning4j.ui.stats.sbe.MessageHeaderEncoder**
- enum **org.deeplearning4j.ui.stats.sbe.MetaAttribute**
- enum **org.deeplearning4j.ui.stats.sbe.StatSource**
- enum **org.deeplearning4j.ui.stats.sbe.StatType**
- class **org.deeplearning4j.ui.stats.sbe.StaticInfoDecoder$HwDeviceInfoGroupDecoder**
- class **org.deeplearning4j.ui.stats.sbe.StaticInfoDecoder$ModelParamNamesDecoder**
- class **org.deeplearning4j.ui.stats.sbe.StaticInfoDecoder$SwEnvironmentInfoDecoder**
- class **org.deeplearning4j.ui.stats.sbe.StaticInfoDecoder**
- class **org.deeplearning4j.ui.stats.sbe.StaticInfoEncoder$HwDeviceInfoGroupEncoder**
- class **org.deeplearning4j.ui.stats.sbe.StaticInfoEncoder$ModelParamNamesEncoder**
- class **org.deeplearning4j.ui.stats.sbe.StaticInfoEncoder$SwEnvironmentInfoEncoder**
- class **org.deeplearning4j.ui.stats.sbe.StaticInfoEncoder**
- enum **org.deeplearning4j.ui.stats.sbe.StatsType**
- class **org.deeplearning4j.ui.stats.sbe.StorageMetaDataDecoder$ExtraMetaDataBytesDecoder**
- class **org.deeplearning4j.ui.stats.sbe.StorageMetaDataDecoder**
- class **org.deeplearning4j.ui.stats.sbe.StorageMetaDataEncoder$ExtraMetaDataBytesEncoder**
- class **org.deeplearning4j.ui.stats.sbe.StorageMetaDataEncoder**
- enum **org.deeplearning4j.ui.stats.sbe.SummaryType**
- class **org.deeplearning4j.ui.stats.sbe.UpdateDecoder$DataSetMetaDataBytesDecoder$MetaDataBytesDecoder**
- class **org.deeplearning4j.ui.stats.sbe.UpdateDecoder$DataSetMetaDataBytesDecoder**
- class **org.deeplearning4j.ui.stats.sbe.UpdateDecoder$GcStatsDecoder**
- class **org.deeplearning4j.ui.stats.sbe.UpdateDecoder$LayerNamesDecoder**
- class **org.deeplearning4j.ui.stats.sbe.UpdateDecoder$MemoryUseDecoder**
- class **org.deeplearning4j.ui.stats.sbe.UpdateDecoder$ParamNamesDecoder**
- class **org.deeplearning4j.ui.stats.sbe.UpdateDecoder$PerParameterStatsDecoder$HistogramsDecoder$HistogramCountsDecoder**
- class **org.deeplearning4j.ui.stats.sbe.UpdateDecoder$PerParameterStatsDecoder$HistogramsDecoder**
- class **org.deeplearning4j.ui.stats.sbe.UpdateDecoder$PerParameterStatsDecoder$SummaryStatDecoder**
- class **org.deeplearning4j.ui.stats.sbe.UpdateDecoder$PerParameterStatsDecoder**
- class **org.deeplearning4j.ui.stats.sbe.UpdateDecoder$PerformanceDecoder**
- class **org.deeplearning4j.ui.stats.sbe.UpdateDecoder**
- class **org.deeplearning4j.ui.stats.sbe.UpdateEncoder$DataSetMetaDataBytesEncoder$MetaDataBytesEncoder**
- class **org.deeplearning4j.ui.stats.sbe.UpdateEncoder$DataSetMetaDataBytesEncoder**
- class **org.deeplearning4j.ui.stats.sbe.UpdateEncoder$GcStatsEncoder**
- class **org.deeplearning4j.ui.stats.sbe.UpdateEncoder$LayerNamesEncoder**
- class **org.deeplearning4j.ui.stats.sbe.UpdateEncoder$MemoryUseEncoder**
- class **org.deeplearning4j.ui.stats.sbe.UpdateEncoder$ParamNamesEncoder**
- class **org.deeplearning4j.ui.stats.sbe.UpdateEncoder$PerParameterStatsEncoder$HistogramsEncoder$HistogramCountsEncoder**
- class **org.deeplearning4j.ui.stats.sbe.UpdateEncoder$PerParameterStatsEncoder$HistogramsEncoder**
- class **org.deeplearning4j.ui.stats.sbe.UpdateEncoder$PerParameterStatsEncoder$SummaryStatEncoder**
- class **org.deeplearning4j.ui.stats.sbe.UpdateEncoder$PerParameterStatsEncoder**
- class **org.deeplearning4j.ui.stats.sbe.UpdateEncoder$PerformanceEncoder**
- class **org.deeplearning4j.ui.stats.sbe.UpdateEncoder**
- class **org.deeplearning4j.ui.stats.sbe.UpdateFieldsPresentDecoder**
- class **org.deeplearning4j.ui.stats.sbe.UpdateFieldsPresentEncoder**
- class **org.deeplearning4j.ui.stats.sbe.VarDataUTF8Decoder**
- class **org.deeplearning4j.ui.stats.sbe.VarDataUTF8Encoder**
- interface **org.deeplearning4j.ui.storage.AgronaPersistable**
- class **org.deeplearning4j.ui.storage.BaseCollectionStatsStorage$SessionTypeId**
- class **org.deeplearning4j.ui.storage.BaseCollectionStatsStorage$SessionTypeWorkerId**
- class **org.deeplearning4j.ui.storage.BaseCollectionStatsStorage**
- class **org.deeplearning4j.ui.storage.FileStatsStorage**
- class **org.deeplearning4j.ui.storage.InMemoryStatsStorage**
- class **org.deeplearning4j.ui.storage.impl.JavaStorageMetaData**
- class **org.deeplearning4j.ui.storage.impl.QueuePairStatsStorageListener**
- class **org.deeplearning4j.ui.storage.impl.QueueStatsStorageListener**
- class **org.deeplearning4j.ui.storage.impl.SbeStorageMetaData**
- class **org.deeplearning4j.ui.storage.mapdb.MapDBStatsStorage$Builder**
- class **org.deeplearning4j.ui.storage.mapdb.MapDBStatsStorage**
- class **org.deeplearning4j.ui.storage.sqlite.J7FileStatsStorage**
- class **org.deeplearning4j.ui.weights.ConvolutionListenerPersistable**
- class **org.deeplearning4j.ui.weights.ConvolutionalIterationListener**
- class **org.deeplearning4j.ui.weights.HistogramBin$Builder**
- class **org.deeplearning4j.ui.weights.HistogramBin**
- class **org.deeplearning4j.ui.weights.beans.CompactModelAndGradient**
- class **org.deeplearning4j.util.Convolution1DUtils**
- class **org.deeplearning4j.util.Convolution3DUtils**
- class **org.deeplearning4j.util.ConvolutionUtils**
- class **org.deeplearning4j.util.CrashReportingUtil**
- class **org.deeplearning4j.util.DiskBasedQueue**
- class **org.deeplearning4j.util.Dl4jReflection**
- class **org.deeplearning4j.util.MaskedReductionUtil**
- class **org.deeplearning4j.util.ModelGuesser**
- class **org.deeplearning4j.util.ModelGuesserException**
- class **org.deeplearning4j.util.ModelSerializer**
- class **org.deeplearning4j.util.MovingWindowMatrix**
- class **org.deeplearning4j.util.NetworkUtils**
- class **org.deeplearning4j.util.ThreadUtils$UncheckedInterruptedException**
- class **org.deeplearning4j.util.ThreadUtils**
- class **org.deeplearning4j.util.TimeSeriesUtils**
- class **org.deeplearning4j.util.UIDProvider**
- interface **org.deeplearning4j.zoo.InstantiableModel**
- class **org.deeplearning4j.zoo.ModelMetaData**
- enum **org.deeplearning4j.zoo.PretrainedType**
- class **org.deeplearning4j.zoo.ZooModel**
- enum **org.deeplearning4j.zoo.ZooType**
- class **org.deeplearning4j.zoo.model.AlexNet**
- class **org.deeplearning4j.zoo.model.Darknet19**
- class **org.deeplearning4j.zoo.model.FaceNetNN4Small2**
- class **org.deeplearning4j.zoo.model.InceptionResNetV1**
- class **org.deeplearning4j.zoo.model.LeNet**
- class **org.deeplearning4j.zoo.model.NASNet**
- class **org.deeplearning4j.zoo.model.ResNet50**
- class **org.deeplearning4j.zoo.model.SimpleCNN**
- class **org.deeplearning4j.zoo.model.SqueezeNet**
- class **org.deeplearning4j.zoo.model.TextGenerationLSTM**
- class **org.deeplearning4j.zoo.model.TinyYOLO**
- class **org.deeplearning4j.zoo.model.UNet**
- class **org.deeplearning4j.zoo.model.VGG16**
- class **org.deeplearning4j.zoo.model.VGG19**
- class **org.deeplearning4j.zoo.model.Xception**
- class **org.deeplearning4j.zoo.model.YOLO2**
- class **org.deeplearning4j.zoo.model.helper.DarknetHelper**
- class **org.deeplearning4j.zoo.model.helper.FaceNetHelper**
- class **org.deeplearning4j.zoo.model.helper.InceptionResNetHelper**
- class **org.deeplearning4j.zoo.model.helper.NASNetHelper**
- class **org.deeplearning4j.zoo.util.BaseLabels**
- class **org.deeplearning4j.zoo.util.ClassPrediction**
- interface **org.deeplearning4j.zoo.util.Labels**
- class **org.deeplearning4j.zoo.util.darknet.COCOLabels**
- class **org.deeplearning4j.zoo.util.darknet.DarknetLabels**
- class **org.deeplearning4j.zoo.util.darknet.VOCLabels**
- class **org.deeplearning4j.zoo.util.imagenet.ImageNetLabels**
- class **org.nd4j.Nd4jRegistrator**
- class **org.nd4j.Nd4jSerializer**
- class **org.nd4j.aeron.ipc.AeronConnectionInformation**
- class **org.nd4j.aeron.ipc.AeronNDArrayPublisher**
- class **org.nd4j.aeron.ipc.AeronNDArraySerde**
- class **org.nd4j.aeron.ipc.AeronNDArraySubscriber**
- class **org.nd4j.aeron.ipc.AeronUtil**
- class **org.nd4j.aeron.ipc.LowLatencyMediaDriver**
- interface **org.nd4j.aeron.ipc.NDArrayCallback**
- class **org.nd4j.aeron.ipc.NDArrayFragmentHandler**
- interface **org.nd4j.aeron.ipc.NDArrayHolder**
- enum **org.nd4j.aeron.ipc.NDArrayMessage$MessageType**
- enum **org.nd4j.aeron.ipc.NDArrayMessage$MessageValidity**
- class **org.nd4j.aeron.ipc.NDArrayMessage**
- interface **org.nd4j.aeron.ipc.chunk.ChunkAccumulator**
- class **org.nd4j.aeron.ipc.chunk.InMemoryChunkAccumulator**
- class **org.nd4j.aeron.ipc.chunk.NDArrayMessageChunk**
- class **org.nd4j.aeron.ipc.response.AeronNDArrayResponder**
- class **org.nd4j.aeron.ipc.response.HostPortPublisher**
- class **org.nd4j.aeron.ipc.response.NDArrayResponseFragmentHandler**
- class **org.nd4j.aeron.ndarrayholder.InMemoryNDArrayHolder**
- class **org.nd4j.aeron.util.AeronStat**
- class **org.nd4j.aeron.util.BufferUtil**
- class **org.nd4j.aeron.util.LogInspector**
- interface **org.nd4j.api.loader.Loader**
- class **org.nd4j.api.loader.LocalFileSource**
- class **org.nd4j.api.loader.LocalFileSourceFactory**
- interface **org.nd4j.api.loader.Source**
- interface **org.nd4j.api.loader.SourceFactory**
- class **org.nd4j.arrow.ArrowSerde**
- class **org.nd4j.arrow.DataBufferStruct**
- class **org.nd4j.autodiff.execution.BasicGraphExecutioner**
- enum **org.nd4j.autodiff.execution.GraphExecutioner$Type**
- interface **org.nd4j.autodiff.execution.GraphExecutioner**
- class **org.nd4j.autodiff.execution.NativeGraphExecutioner**
- class **org.nd4j.autodiff.execution.Node**
- enum **org.nd4j.autodiff.execution.conf.ExecutionMode**
- class **org.nd4j.autodiff.execution.conf.ExecutorConfiguration**
- enum **org.nd4j.autodiff.execution.conf.OutputMode**
- class **org.nd4j.autodiff.functions.DifferentialFunction**
- class **org.nd4j.autodiff.functions.DifferentialFunctionFactory**
- class **org.nd4j.autodiff.functions.FunctionProperties**
- enum **org.nd4j.autodiff.loss.LossFunctions$Reduction**
- class **org.nd4j.autodiff.loss.LossFunctions**
- class **org.nd4j.autodiff.loss.LossInfo**
- enum **org.nd4j.autodiff.samediff.SDIndex$IndexType**
- class **org.nd4j.autodiff.samediff.SDIndex**
- class **org.nd4j.autodiff.samediff.SDVariable**
- class **org.nd4j.autodiff.samediff.SameDiff**
- interface **org.nd4j.autodiff.samediff.SameDiffConditional**
- interface **org.nd4j.autodiff.samediff.SameDiffFunctionDefinition**
- class **org.nd4j.autodiff.samediff.SameDiffOpExecutioner**
- class **org.nd4j.autodiff.samediff.flow.FlowPath**
- class **org.nd4j.autodiff.samediff.flow.FrameState**
- class **org.nd4j.autodiff.samediff.flow.NodeState**
- class **org.nd4j.autodiff.samediff.impl.DefaultSameDiffConditional**
- class **org.nd4j.autodiff.util.cloner.DataBufferFastCloner**
- class **org.nd4j.autodiff.util.cloner.INDArrayFastCloner**
- class **org.nd4j.autodiff.validation.GradCheckUtil**
- class **org.nd4j.autodiff.validation.OpTestCase**
- class **org.nd4j.autodiff.validation.OpValidation**
- class **org.nd4j.autodiff.validation.TestCase**
- class **org.nd4j.autodiff.validation.functions.EqualityFn**
- class **org.nd4j.autodiff.validation.functions.RelErrorFn**
- class **org.nd4j.base.Preconditions**
- class **org.nd4j.camel.kafka.KafkaConnectionInformation**
- class **org.nd4j.camel.kafka.Nd4jKafkaConsumer**
- class **org.nd4j.camel.kafka.Nd4jKafkaProducer**
- class **org.nd4j.camel.kafka.Nd4jKafkaRoute**
- class **org.nd4j.compression.impl.AbstractCompressor**
- class **org.nd4j.compression.impl.Float16**
- class **org.nd4j.compression.impl.Float8**
- class **org.nd4j.compression.impl.Gzip**
- class **org.nd4j.compression.impl.Int16**
- class **org.nd4j.compression.impl.Int8**
- class **org.nd4j.compression.impl.NoOp**
- class **org.nd4j.compression.impl.Uint8**
- class **org.nd4j.config.ND4JEnvironmentVars**
- class **org.nd4j.config.ND4JSystemProperties**
- class **org.nd4j.context.Nd4jContext**
- class **org.nd4j.finitedifferences.TwoPointApproximation**
- class **org.nd4j.graph.ByteOrder**
- class **org.nd4j.graph.DataType**
- class **org.nd4j.graph.Direction**
- class **org.nd4j.graph.ExecutionMode**
- class **org.nd4j.graph.FlatArray**
- class **org.nd4j.graph.FlatConfiguration**
- class **org.nd4j.graph.FlatGraph**
- class **org.nd4j.graph.FlatNode**
- class **org.nd4j.graph.FlatProperties**
- class **org.nd4j.graph.FlatResult**
- class **org.nd4j.graph.FlatTiming**
- class **org.nd4j.graph.FlatVariable**
- class **org.nd4j.graph.InputType**
- class **org.nd4j.graph.IntPair**
- class **org.nd4j.graph.IntTriple**
- class **org.nd4j.graph.LongPair**
- class **org.nd4j.graph.LongTriple**
- class **org.nd4j.graph.OpClass**
- class **org.nd4j.graph.OpType**
- class **org.nd4j.graph.OutputMode**
- class **org.nd4j.graph.ProfilingMode**
- class **org.nd4j.imports.NoOpNameFoundException**
- class **org.nd4j.imports.converters.DifferentialFunctionClassHolder**
- class **org.nd4j.imports.descriptors.onnx.OnnxDescriptor**
- class **org.nd4j.imports.descriptors.onnx.OnnxDescriptorParser**
- class **org.nd4j.imports.descriptors.onnx.OpDescriptor**
- class **org.nd4j.imports.descriptors.onnx.TensorDescriptor**
- interface **org.nd4j.imports.descriptors.properties.AttributeAdapter**
- class **org.nd4j.imports.descriptors.properties.PropertyMapping**
- class **org.nd4j.imports.descriptors.properties.adapters.BooleanAdapter**
- class **org.nd4j.imports.descriptors.properties.adapters.ConditionalFieldValueIntIndexArrayAdapter**
- class **org.nd4j.imports.descriptors.properties.adapters.ConditionalFieldValueNDArrayShapeAdapter**
- class **org.nd4j.imports.descriptors.properties.adapters.DataTypeAdapter**
- class **org.nd4j.imports.descriptors.properties.adapters.IntArrayIntIndexAdpater**
- class **org.nd4j.imports.descriptors.properties.adapters.NDArrayShapeAdapter**
- class **org.nd4j.imports.descriptors.properties.adapters.SizeThresholdIntArrayIntIndexAdpater**
- class **org.nd4j.imports.descriptors.properties.adapters.StringEqualsAdapter**
- class **org.nd4j.imports.descriptors.properties.adapters.StringNotEqualsAdapter**
- class **org.nd4j.imports.descriptors.tensorflow.TensorflowDescriptorParser**
- class **org.nd4j.imports.graphmapper.BaseGraphMapper**
- interface **org.nd4j.imports.graphmapper.GraphMapper**
- class **org.nd4j.imports.graphmapper.ImportState**
- class **org.nd4j.imports.graphmapper.onnx.OnnxGraphMapper**
- class **org.nd4j.imports.graphmapper.tf.TFGraphMapper**
- class **org.nd4j.instrumentation.server.InstrumentationApplication**
- class **org.nd4j.instrumentation.server.InstrumentationResource**
- class **org.nd4j.instrumentation.server.Nd4jInstrumentationConfiguration**
- class **org.nd4j.jdbc.driverfinder.DriverFinder**
- class **org.nd4j.jdbc.hsql.HsqlLoader**
- interface **org.nd4j.jdbc.loader.api.JDBCNDArrayIO**
- class **org.nd4j.jdbc.loader.impl.BaseLoader**
- class **org.nd4j.jdbc.mysql.MysqlLoader**
- interface **org.nd4j.jita.allocator.Allocator**
- class **org.nd4j.jita.allocator.concurrency.AtomicState**
- class **org.nd4j.jita.allocator.concurrency.DeviceAllocationsTracker**
- interface **org.nd4j.jita.allocator.concurrency.Lock**
- class **org.nd4j.jita.allocator.concurrency.RRWLock**
- class **org.nd4j.jita.allocator.context.ContextPack**
- interface **org.nd4j.jita.allocator.context.ContextPool**
- class **org.nd4j.jita.allocator.context.ExternalContext**
- class **org.nd4j.jita.allocator.context.impl.BasicContextPool**
- class **org.nd4j.jita.allocator.context.impl.LimitedContextPool**
- class **org.nd4j.jita.allocator.context.impl.PackedContextPool**
- enum **org.nd4j.jita.allocator.enums.AccessState**
- enum **org.nd4j.jita.allocator.enums.Aggressiveness**
- enum **org.nd4j.jita.allocator.enums.AllocationStatus**
- class **org.nd4j.jita.allocator.enums.CudaConstants**
- enum **org.nd4j.jita.allocator.enums.SyncState**
- class **org.nd4j.jita.allocator.garbage.GarbageBufferReference**
- class **org.nd4j.jita.allocator.garbage.GarbageResourceReference**
- class **org.nd4j.jita.allocator.impl.AllocationPoint**
- class **org.nd4j.jita.allocator.impl.AllocationShape**
- class **org.nd4j.jita.allocator.impl.AtomicAllocator**
- class **org.nd4j.jita.allocator.impl.NestedPoint**
- class **org.nd4j.jita.allocator.pointers.CudaPointer**
- class **org.nd4j.jita.allocator.pointers.PointersPair**
- class **org.nd4j.jita.allocator.pointers.cuda.CUcontext**
- class **org.nd4j.jita.allocator.pointers.cuda.cublasHandle_t**
- class **org.nd4j.jita.allocator.pointers.cuda.cudaEvent_t**
- class **org.nd4j.jita.allocator.pointers.cuda.cudaStream_t**
- class **org.nd4j.jita.allocator.pointers.cuda.cusolverDnHandle_t**
- class **org.nd4j.jita.allocator.tad.BasicTADManager**
- class **org.nd4j.jita.allocator.tad.DeviceTADManager**
- interface **org.nd4j.jita.allocator.time.RateTimer**
- interface **org.nd4j.jita.allocator.time.Ring**
- interface **org.nd4j.jita.allocator.time.TimeProvider**
- class **org.nd4j.jita.allocator.time.impl.BinaryTimer**
- class **org.nd4j.jita.allocator.time.impl.SimpleTimer**
- class **org.nd4j.jita.allocator.time.providers.MillisecondsProvider**
- class **org.nd4j.jita.allocator.time.providers.NanosecondsProvider**
- class **org.nd4j.jita.allocator.time.providers.OperativeProvider**
- class **org.nd4j.jita.allocator.time.rings.LockedRing**
- class **org.nd4j.jita.allocator.utils.AllocationUtils**
- interface **org.nd4j.jita.balance.Balancer**
- class **org.nd4j.jita.concurrency.CudaAffinityManager**
- class **org.nd4j.jita.concurrency.EventsProvider**
- enum **org.nd4j.jita.conf.Configuration$AllocationModel**
- enum **org.nd4j.jita.conf.Configuration$ExecutionModel**
- enum **org.nd4j.jita.conf.Configuration$MemoryModel**
- class **org.nd4j.jita.conf.Configuration**
- class **org.nd4j.jita.conf.CudaEnvironment**
- class **org.nd4j.jita.conf.DeviceInformation**
- class **org.nd4j.jita.constant.ConstantProtector**
- class **org.nd4j.jita.constant.CudaConstantHandler**
- class **org.nd4j.jita.constant.ProtectedCudaConstantHandler**
- class **org.nd4j.jita.constant.ProtectedCudaShapeInfoProvider**
- interface **org.nd4j.jita.flow.FlowController**
- class **org.nd4j.jita.flow.impl.AsynchronousFlowController**
- class **org.nd4j.jita.flow.impl.GridFlowController**
- class **org.nd4j.jita.flow.impl.SynchronousFlowController**
- interface **org.nd4j.jita.handler.MemoryHandler**
- class **org.nd4j.jita.handler.impl.CudaZeroHandler**
- class **org.nd4j.jita.memory.CudaMemoryManager**
- interface **org.nd4j.jita.memory.MemoryProvider**
- class **org.nd4j.jita.memory.impl.CudaCachingZeroProvider**
- class **org.nd4j.jita.memory.impl.CudaDirectProvider**
- class **org.nd4j.jita.memory.impl.CudaFullCachingProvider**
- class **org.nd4j.jita.workspace.CudaWorkspace**
- class **org.nd4j.jita.workspace.CudaWorkspaceManager**
- enum **org.nd4j.linalg.activations.Activation**
- class **org.nd4j.linalg.activations.BaseActivationFunction**
- interface **org.nd4j.linalg.activations.IActivation**
- class **org.nd4j.linalg.activations.impl.ActivationCube**
- class **org.nd4j.linalg.activations.impl.ActivationELU**
- class **org.nd4j.linalg.activations.impl.ActivationHardSigmoid**
- class **org.nd4j.linalg.activations.impl.ActivationHardTanH**
- class **org.nd4j.linalg.activations.impl.ActivationIdentity**
- class **org.nd4j.linalg.activations.impl.ActivationLReLU**
- class **org.nd4j.linalg.activations.impl.ActivationPReLU**
- class **org.nd4j.linalg.activations.impl.ActivationRReLU**
- class **org.nd4j.linalg.activations.impl.ActivationRationalTanh**
- class **org.nd4j.linalg.activations.impl.ActivationReLU**
- class **org.nd4j.linalg.activations.impl.ActivationReLU6**
- class **org.nd4j.linalg.activations.impl.ActivationRectifiedTanh**
- class **org.nd4j.linalg.activations.impl.ActivationSELU**
- class **org.nd4j.linalg.activations.impl.ActivationSigmoid**
- class **org.nd4j.linalg.activations.impl.ActivationSoftPlus**
- class **org.nd4j.linalg.activations.impl.ActivationSoftSign**
- class **org.nd4j.linalg.activations.impl.ActivationSoftmax**
- class **org.nd4j.linalg.activations.impl.ActivationSwish**
- class **org.nd4j.linalg.activations.impl.ActivationTanH**
- class **org.nd4j.linalg.activations.impl.ActivationThresholdedReLU**
- enum **org.nd4j.linalg.api.blas.Blas$Vendor**
- interface **org.nd4j.linalg.api.blas.Blas**
- class **org.nd4j.linalg.api.blas.BlasBufferUtil**
- class **org.nd4j.linalg.api.blas.BlasException**
- interface **org.nd4j.linalg.api.blas.Lapack**
- interface **org.nd4j.linalg.api.blas.Level1**
- interface **org.nd4j.linalg.api.blas.Level2**
- interface **org.nd4j.linalg.api.blas.Level3**
- class **org.nd4j.linalg.api.blas.impl.BaseLapack**
- class **org.nd4j.linalg.api.blas.impl.BaseLevel**
- class **org.nd4j.linalg.api.blas.impl.BaseLevel1**
- class **org.nd4j.linalg.api.blas.impl.BaseLevel2**
- class **org.nd4j.linalg.api.blas.impl.BaseLevel3**
- class **org.nd4j.linalg.api.blas.impl.SparseBaseLapack**
- class **org.nd4j.linalg.api.blas.impl.SparseBaseLevel**
- class **org.nd4j.linalg.api.blas.impl.SparseBaseLevel1**
- class **org.nd4j.linalg.api.blas.impl.SparseBaseLevel2**
- class **org.nd4j.linalg.api.blas.impl.SparseBaseLevel3**
- class **org.nd4j.linalg.api.blas.params.GemmParams**
- class **org.nd4j.linalg.api.blas.params.GemvParameters**
- class **org.nd4j.linalg.api.blas.params.MMulTranspose**
- class **org.nd4j.linalg.api.blas.params.SparseCOOGemvParameters**
- class **org.nd4j.linalg.api.buffer.BaseDataBuffer**
- enum **org.nd4j.linalg.api.buffer.DataBuffer$AllocationMode**
- enum **org.nd4j.linalg.api.buffer.DataBuffer$Type**
- enum **org.nd4j.linalg.api.buffer.DataBuffer$TypeEx**
- interface **org.nd4j.linalg.api.buffer.DataBuffer**
- class **org.nd4j.linalg.api.buffer.DoubleBuffer**
- class **org.nd4j.linalg.api.buffer.FloatBuffer**
- class **org.nd4j.linalg.api.buffer.IntBuffer**
- class **org.nd4j.linalg.api.buffer.LongBuffer**
- interface **org.nd4j.linalg.api.buffer.allocation.MemoryStrategy**
- class **org.nd4j.linalg.api.buffer.factory.AllocatorFactory**
- class **org.nd4j.linalg.api.buffer.factory.AllocatorInstanceHolder**
- interface **org.nd4j.linalg.api.buffer.factory.DataBufferFactory**
- class **org.nd4j.linalg.api.buffer.factory.DefaultDataBufferFactory**
- class **org.nd4j.linalg.api.buffer.util.AllocUtil**
- class **org.nd4j.linalg.api.buffer.util.DataTypeUtil**
- enum **org.nd4j.linalg.api.concurrency.AffinityManager$Location**
- interface **org.nd4j.linalg.api.concurrency.AffinityManager**
- class **org.nd4j.linalg.api.concurrency.BasicAffinityManager**
- class **org.nd4j.linalg.api.environment.Nd4jEnvironment**
- class **org.nd4j.linalg.api.instrumentation.DataBufferLogEntry**
- class **org.nd4j.linalg.api.instrumentation.InMemoryInstrumentation**
- interface **org.nd4j.linalg.api.instrumentation.Instrumentation**
- class **org.nd4j.linalg.api.instrumentation.LogEntry**
- class **org.nd4j.linalg.api.iter.FirstAxisIterator**
- class **org.nd4j.linalg.api.iter.FlatIterator**
- class **org.nd4j.linalg.api.iter.INDArrayIterator**
- class **org.nd4j.linalg.api.iter.LinearIndexLookup**
- class **org.nd4j.linalg.api.iter.NdIndexIterator**
- enum **org.nd4j.linalg.api.memory.MemoryWorkspace$Type**
- interface **org.nd4j.linalg.api.memory.MemoryWorkspace**
- interface **org.nd4j.linalg.api.memory.MemoryWorkspaceManager**
- class **org.nd4j.linalg.api.memory.conf.WorkspaceConfiguration**
- enum **org.nd4j.linalg.api.memory.enums.AllocationPolicy**
- enum **org.nd4j.linalg.api.memory.enums.DebugMode**
- enum **org.nd4j.linalg.api.memory.enums.LearningPolicy**
- enum **org.nd4j.linalg.api.memory.enums.LocationPolicy**
- enum **org.nd4j.linalg.api.memory.enums.MemoryKind**
- enum **org.nd4j.linalg.api.memory.enums.MirroringPolicy**
- enum **org.nd4j.linalg.api.memory.enums.ResetPolicy**
- enum **org.nd4j.linalg.api.memory.enums.SpillPolicy**
- class **org.nd4j.linalg.api.memory.pointers.ImmortalFloatPointer**
- class **org.nd4j.linalg.api.memory.pointers.PagedPointer**
- class **org.nd4j.linalg.api.memory.pointers.PointersPair**
- class **org.nd4j.linalg.api.ndarray.BaseNDArray**
- class **org.nd4j.linalg.api.ndarray.BaseNDArrayProxy**
- class **org.nd4j.linalg.api.ndarray.BaseShapeInfoProvider**
- class **org.nd4j.linalg.api.ndarray.BaseSparseInfoProvider**
- class **org.nd4j.linalg.api.ndarray.BaseSparseNDArray**
- class **org.nd4j.linalg.api.ndarray.BaseSparseNDArrayCOO**
- class **org.nd4j.linalg.api.ndarray.BaseSparseNDArrayCSR**
- interface **org.nd4j.linalg.api.ndarray.INDArray**
- interface **org.nd4j.linalg.api.ndarray.ISparseNDArray**
- class **org.nd4j.linalg.api.ndarray.JvmShapeInfo**
- class **org.nd4j.linalg.api.ndarray.NdArrayJSONReader**
- class **org.nd4j.linalg.api.ndarray.NdArrayJSONWriter**
- interface **org.nd4j.linalg.api.ndarray.ShapeInfoProvider**
- enum **org.nd4j.linalg.api.ndarray.SparseFormat**
- interface **org.nd4j.linalg.api.ndarray.SparseInfoProvider**
- interface **org.nd4j.linalg.api.ops.Accumulation**
- class **org.nd4j.linalg.api.ops.BaseAccumulation**
- class **org.nd4j.linalg.api.ops.BaseBroadcastOp**
- class **org.nd4j.linalg.api.ops.BaseGradientOp**
- class **org.nd4j.linalg.api.ops.BaseIndexAccumulation**
- class **org.nd4j.linalg.api.ops.BaseModule**
- class **org.nd4j.linalg.api.ops.BaseOp**
- class **org.nd4j.linalg.api.ops.BaseScalarOp**
- class **org.nd4j.linalg.api.ops.BaseTransformOp**
- interface **org.nd4j.linalg.api.ops.BroadcastOp**
- interface **org.nd4j.linalg.api.ops.CustomOp**
- class **org.nd4j.linalg.api.ops.CustomOpDescriptor**
- class **org.nd4j.linalg.api.ops.DefaultOpConverter**
- class **org.nd4j.linalg.api.ops.DynamicCustomOp$DynamicCustomOpsBuilder**
- class **org.nd4j.linalg.api.ops.DynamicCustomOp$SameDiffBuilder**
- class **org.nd4j.linalg.api.ops.DynamicCustomOp**
- interface **org.nd4j.linalg.api.ops.GradientOp**
- interface **org.nd4j.linalg.api.ops.GridOp**
- interface **org.nd4j.linalg.api.ops.IndexAccumulation**
- interface **org.nd4j.linalg.api.ops.LossFunction**
- interface **org.nd4j.linalg.api.ops.MetaOp**
- interface **org.nd4j.linalg.api.ops.Module**
- class **org.nd4j.linalg.api.ops.NoOp**
- enum **org.nd4j.linalg.api.ops.Op$Type**
- interface **org.nd4j.linalg.api.ops.Op**
- interface **org.nd4j.linalg.api.ops.RandomOp**
- interface **org.nd4j.linalg.api.ops.ScalarOp**
- class **org.nd4j.linalg.api.ops.ShapeOp**
- interface **org.nd4j.linalg.api.ops.TransformOp**
- interface **org.nd4j.linalg.api.ops.aggregates.Aggregate**
- class **org.nd4j.linalg.api.ops.aggregates.BaseAggregate**
- class **org.nd4j.linalg.api.ops.aggregates.Batch**
- class **org.nd4j.linalg.api.ops.aggregates.impl.AggregateAxpy**
- class **org.nd4j.linalg.api.ops.aggregates.impl.AggregateCBOW**
- class **org.nd4j.linalg.api.ops.aggregates.impl.AggregateDot**
- class **org.nd4j.linalg.api.ops.aggregates.impl.AggregateGEMM**
- class **org.nd4j.linalg.api.ops.aggregates.impl.AggregateSkipGram**
- class **org.nd4j.linalg.api.ops.aggregates.impl.HierarchicSoftmax**
- enum **org.nd4j.linalg.api.ops.custom.ScatterUpdate$UpdateOp**
- class **org.nd4j.linalg.api.ops.custom.ScatterUpdate**
- class **org.nd4j.linalg.api.ops.exception.BlasOpErrorMessage**
- class **org.nd4j.linalg.api.ops.exception.IllegalOpException**
- class **org.nd4j.linalg.api.ops.executioner.DefaultOpExecutioner**
- interface **org.nd4j.linalg.api.ops.executioner.GridExecutioner**
- enum **org.nd4j.linalg.api.ops.executioner.OpExecutioner$ExecutionMode**
- enum **org.nd4j.linalg.api.ops.executioner.OpExecutioner$ExecutionerType**
- enum **org.nd4j.linalg.api.ops.executioner.OpExecutioner$ProfilingMode**
- interface **org.nd4j.linalg.api.ops.executioner.OpExecutioner**
- class **org.nd4j.linalg.api.ops.executioner.OpExecutionerUtil$Tensor1DStats**
- class **org.nd4j.linalg.api.ops.executioner.OpExecutionerUtil**
- enum **org.nd4j.linalg.api.ops.executioner.OpStatus**
- class **org.nd4j.linalg.api.ops.factory.DefaultOpFactory**
- interface **org.nd4j.linalg.api.ops.factory.OpFactory**
- class **org.nd4j.linalg.api.ops.grid.GridDescriptor**
- class **org.nd4j.linalg.api.ops.grid.GridPointers**
- class **org.nd4j.linalg.api.ops.grid.OpDescriptor**
- class **org.nd4j.linalg.api.ops.impl.accum.AMax**
- class **org.nd4j.linalg.api.ops.impl.accum.AMean**
- class **org.nd4j.linalg.api.ops.impl.accum.AMin**
- class **org.nd4j.linalg.api.ops.impl.accum.ASum**
- class **org.nd4j.linalg.api.ops.impl.accum.All**
- class **org.nd4j.linalg.api.ops.impl.accum.Any**
- class **org.nd4j.linalg.api.ops.impl.accum.ArgMax**
- class **org.nd4j.linalg.api.ops.impl.accum.BaseReduction**
- class **org.nd4j.linalg.api.ops.impl.accum.BatchMmul**
- class **org.nd4j.linalg.api.ops.impl.accum.Bias**
- class **org.nd4j.linalg.api.ops.impl.accum.CountNonZero**
- class **org.nd4j.linalg.api.ops.impl.accum.CountZero**
- class **org.nd4j.linalg.api.ops.impl.accum.CumProd**
- class **org.nd4j.linalg.api.ops.impl.accum.CumSum**
- class **org.nd4j.linalg.api.ops.impl.accum.Dot**
- class **org.nd4j.linalg.api.ops.impl.accum.Entropy**
- class **org.nd4j.linalg.api.ops.impl.accum.EqualsWithEps**
- class **org.nd4j.linalg.api.ops.impl.accum.LogEntropy**
- class **org.nd4j.linalg.api.ops.impl.accum.LogSumExp**
- class **org.nd4j.linalg.api.ops.impl.accum.MatchCondition**
- class **org.nd4j.linalg.api.ops.impl.accum.Max**
- class **org.nd4j.linalg.api.ops.impl.accum.Mean**
- class **org.nd4j.linalg.api.ops.impl.accum.Min**
- class **org.nd4j.linalg.api.ops.impl.accum.Mmul**
- class **org.nd4j.linalg.api.ops.impl.accum.Moments**
- class **org.nd4j.linalg.api.ops.impl.accum.Norm1**
- class **org.nd4j.linalg.api.ops.impl.accum.Norm2**
- class **org.nd4j.linalg.api.ops.impl.accum.NormMax**
- class **org.nd4j.linalg.api.ops.impl.accum.NormalizeMoments**
- class **org.nd4j.linalg.api.ops.impl.accum.Prod**
- class **org.nd4j.linalg.api.ops.impl.accum.ShannonEntropy**
- class **org.nd4j.linalg.api.ops.impl.accum.SigmoidCrossEntropyLoss**
- class **org.nd4j.linalg.api.ops.impl.accum.SoftmaxCrossEntropyLoss**
- class **org.nd4j.linalg.api.ops.impl.accum.SoftmaxCrossEntropyLossWithLogits**
- class **org.nd4j.linalg.api.ops.impl.accum.SquaredNorm**
- class **org.nd4j.linalg.api.ops.impl.accum.StandardDeviation**
- class **org.nd4j.linalg.api.ops.impl.accum.Sum**
- class **org.nd4j.linalg.api.ops.impl.accum.TensorMmul**
- class **org.nd4j.linalg.api.ops.impl.accum.Variance**
- class **org.nd4j.linalg.api.ops.impl.accum.WeightedCrossEntropyLoss**
- class **org.nd4j.linalg.api.ops.impl.accum.ZeroFraction**
- class **org.nd4j.linalg.api.ops.impl.accum.bp.BaseReductionBp**
- class **org.nd4j.linalg.api.ops.impl.accum.bp.CumProdBp**
- class **org.nd4j.linalg.api.ops.impl.accum.bp.CumSumBp**
- class **org.nd4j.linalg.api.ops.impl.accum.bp.DotBp**
- class **org.nd4j.linalg.api.ops.impl.accum.bp.MaxBp**
- class **org.nd4j.linalg.api.ops.impl.accum.bp.MeanBp**
- class **org.nd4j.linalg.api.ops.impl.accum.bp.MinBp**
- class **org.nd4j.linalg.api.ops.impl.accum.bp.Norm1Bp**
- class **org.nd4j.linalg.api.ops.impl.accum.bp.Norm2Bp**
- class **org.nd4j.linalg.api.ops.impl.accum.bp.NormMaxBp**
- class **org.nd4j.linalg.api.ops.impl.accum.bp.ProdBp**
- class **org.nd4j.linalg.api.ops.impl.accum.bp.SquaredNormBp**
- class **org.nd4j.linalg.api.ops.impl.accum.bp.StandardDeviationBp**
- class **org.nd4j.linalg.api.ops.impl.accum.bp.SumBp**
- class **org.nd4j.linalg.api.ops.impl.accum.bp.VarianceBp**
- class **org.nd4j.linalg.api.ops.impl.accum.distances.CosineDistance**
- class **org.nd4j.linalg.api.ops.impl.accum.distances.CosineSimilarity**
- class **org.nd4j.linalg.api.ops.impl.accum.distances.EuclideanDistance**
- class **org.nd4j.linalg.api.ops.impl.accum.distances.HammingDistance**
- class **org.nd4j.linalg.api.ops.impl.accum.distances.JaccardDistance**
- class **org.nd4j.linalg.api.ops.impl.accum.distances.ManhattanDistance**
- class **org.nd4j.linalg.api.ops.impl.broadcast.BiasAdd**
- class **org.nd4j.linalg.api.ops.impl.broadcast.BiasAddGrad**
- class **org.nd4j.linalg.api.ops.impl.broadcast.BroadcastAMax**
- class **org.nd4j.linalg.api.ops.impl.broadcast.BroadcastAMin**
- class **org.nd4j.linalg.api.ops.impl.broadcast.BroadcastAddOp**
- class **org.nd4j.linalg.api.ops.impl.broadcast.BroadcastCopyOp**
- class **org.nd4j.linalg.api.ops.impl.broadcast.BroadcastDivOp**
- class **org.nd4j.linalg.api.ops.impl.broadcast.BroadcastEqualTo**
- class **org.nd4j.linalg.api.ops.impl.broadcast.BroadcastGradientArgs**
- class **org.nd4j.linalg.api.ops.impl.broadcast.BroadcastGreaterThan**
- class **org.nd4j.linalg.api.ops.impl.broadcast.BroadcastGreaterThanOrEqual**
- class **org.nd4j.linalg.api.ops.impl.broadcast.BroadcastLessThan**
- class **org.nd4j.linalg.api.ops.impl.broadcast.BroadcastLessThanOrEqual**
- class **org.nd4j.linalg.api.ops.impl.broadcast.BroadcastMax**
- class **org.nd4j.linalg.api.ops.impl.broadcast.BroadcastMin**
- class **org.nd4j.linalg.api.ops.impl.broadcast.BroadcastMulOp**
- class **org.nd4j.linalg.api.ops.impl.broadcast.BroadcastNotEqual**
- class **org.nd4j.linalg.api.ops.impl.broadcast.BroadcastRDivOp**
- class **org.nd4j.linalg.api.ops.impl.broadcast.BroadcastRSubOp**
- class **org.nd4j.linalg.api.ops.impl.broadcast.BroadcastSubOp**
- class **org.nd4j.linalg.api.ops.impl.controlflow.If**
- class **org.nd4j.linalg.api.ops.impl.controlflow.IfDerivative**
- class **org.nd4j.linalg.api.ops.impl.controlflow.IfImportState**
- class **org.nd4j.linalg.api.ops.impl.controlflow.Select**
- class **org.nd4j.linalg.api.ops.impl.controlflow.Where**
- class **org.nd4j.linalg.api.ops.impl.controlflow.WhereNumpy**
- class **org.nd4j.linalg.api.ops.impl.controlflow.While**
- class **org.nd4j.linalg.api.ops.impl.controlflow.WhileDerivative**
- class **org.nd4j.linalg.api.ops.impl.controlflow.compat.BaseCompatOp**
- class **org.nd4j.linalg.api.ops.impl.controlflow.compat.Enter**
- class **org.nd4j.linalg.api.ops.impl.controlflow.compat.Exit**
- class **org.nd4j.linalg.api.ops.impl.controlflow.compat.LoopCond**
- class **org.nd4j.linalg.api.ops.impl.controlflow.compat.Merge**
- class **org.nd4j.linalg.api.ops.impl.controlflow.compat.NextIteration**
- class **org.nd4j.linalg.api.ops.impl.controlflow.compat.StopGradient**
- class **org.nd4j.linalg.api.ops.impl.controlflow.compat.Switch**
- class **org.nd4j.linalg.api.ops.impl.grid.BaseGridOp**
- class **org.nd4j.linalg.api.ops.impl.grid.FreeGridOp**
- class **org.nd4j.linalg.api.ops.impl.indexaccum.FirstIndex**
- class **org.nd4j.linalg.api.ops.impl.indexaccum.IAMax**
- class **org.nd4j.linalg.api.ops.impl.indexaccum.IAMin**
- class **org.nd4j.linalg.api.ops.impl.indexaccum.IMax**
- class **org.nd4j.linalg.api.ops.impl.indexaccum.IMin**
- class **org.nd4j.linalg.api.ops.impl.indexaccum.LastIndex**
- class **org.nd4j.linalg.api.ops.impl.layers.Linear**
- enum **org.nd4j.linalg.api.ops.impl.layers.convolution.AvgPooling2D$Pooling2DType**
- class **org.nd4j.linalg.api.ops.impl.layers.convolution.AvgPooling2D**
- class **org.nd4j.linalg.api.ops.impl.layers.convolution.BatchNorm**
- class **org.nd4j.linalg.api.ops.impl.layers.convolution.BatchNormDerivative**
- class **org.nd4j.linalg.api.ops.impl.layers.convolution.Col2Im**
- class **org.nd4j.linalg.api.ops.impl.layers.convolution.Conv1D**
- class **org.nd4j.linalg.api.ops.impl.layers.convolution.Conv2D**
- class **org.nd4j.linalg.api.ops.impl.layers.convolution.Conv2DDerivative**
- class **org.nd4j.linalg.api.ops.impl.layers.convolution.Conv3D**
- class **org.nd4j.linalg.api.ops.impl.layers.convolution.Conv3DDerivative**
- class **org.nd4j.linalg.api.ops.impl.layers.convolution.DeConv2D**
- class **org.nd4j.linalg.api.ops.impl.layers.convolution.DeConv2DDerivative**
- class **org.nd4j.linalg.api.ops.impl.layers.convolution.DeConv2DTF**
- class **org.nd4j.linalg.api.ops.impl.layers.convolution.DepthToSpace**
- class **org.nd4j.linalg.api.ops.impl.layers.convolution.DepthwiseConv2D**
- class **org.nd4j.linalg.api.ops.impl.layers.convolution.FullConv3D**
- class **org.nd4j.linalg.api.ops.impl.layers.convolution.FullConv3DDerivative**
- class **org.nd4j.linalg.api.ops.impl.layers.convolution.Im2col**
- class **org.nd4j.linalg.api.ops.impl.layers.convolution.Im2colBp**
- enum **org.nd4j.linalg.api.ops.impl.layers.convolution.LegacyPooling2D$Pooling2DType**
- class **org.nd4j.linalg.api.ops.impl.layers.convolution.LegacyPooling2D**
- class **org.nd4j.linalg.api.ops.impl.layers.convolution.LocalResponseNormalization**
- class **org.nd4j.linalg.api.ops.impl.layers.convolution.LocalResponseNormalizationDerivative**
- class **org.nd4j.linalg.api.ops.impl.layers.convolution.MaxPooling2D**
- enum **org.nd4j.linalg.api.ops.impl.layers.convolution.Pooling2D$Divisor**
- enum **org.nd4j.linalg.api.ops.impl.layers.convolution.Pooling2D$Pooling2DType**
- class **org.nd4j.linalg.api.ops.impl.layers.convolution.Pooling2D**
- class **org.nd4j.linalg.api.ops.impl.layers.convolution.Pooling2DDerivative**
- enum **org.nd4j.linalg.api.ops.impl.layers.convolution.Pooling3D$Pooling3DType**
- class **org.nd4j.linalg.api.ops.impl.layers.convolution.Pooling3D**
- class **org.nd4j.linalg.api.ops.impl.layers.convolution.Pooling3DDerivative**
- class **org.nd4j.linalg.api.ops.impl.layers.convolution.SConv2D**
- class **org.nd4j.linalg.api.ops.impl.layers.convolution.SConv2DDerivative**
- class **org.nd4j.linalg.api.ops.impl.layers.convolution.SpaceToDepth**
- class **org.nd4j.linalg.api.ops.impl.layers.convolution.Upsampling2d**
- class **org.nd4j.linalg.api.ops.impl.layers.convolution.Upsampling2dDerivative**
- class **org.nd4j.linalg.api.ops.impl.layers.convolution.config.BaseConvolutionConfig**
- class **org.nd4j.linalg.api.ops.impl.layers.convolution.config.Conv1DConfig**
- class **org.nd4j.linalg.api.ops.impl.layers.convolution.config.Conv2DConfig**
- class **org.nd4j.linalg.api.ops.impl.layers.convolution.config.Conv3DConfig**
- class **org.nd4j.linalg.api.ops.impl.layers.convolution.config.DeConv2DConfig**
- class **org.nd4j.linalg.api.ops.impl.layers.convolution.config.FullConv3DConfig**
- class **org.nd4j.linalg.api.ops.impl.layers.convolution.config.LocalResponseNormalizationConfig**
- class **org.nd4j.linalg.api.ops.impl.layers.convolution.config.Pooling2DConfig**
- class **org.nd4j.linalg.api.ops.impl.layers.convolution.config.Pooling3DConfig**
- class **org.nd4j.linalg.api.ops.impl.layers.recurrent.GRUCell**
- class **org.nd4j.linalg.api.ops.impl.layers.recurrent.LSTMCell**
- class **org.nd4j.linalg.api.ops.impl.layers.recurrent.SRU**
- class **org.nd4j.linalg.api.ops.impl.layers.recurrent.SRUCell**
- class **org.nd4j.linalg.api.ops.impl.layers.recurrent.config.GRUCellConfiguration**
- class **org.nd4j.linalg.api.ops.impl.layers.recurrent.config.LSTMCellConfiguration**
- class **org.nd4j.linalg.api.ops.impl.layers.recurrent.config.SRUCellConfiguration**
- class **org.nd4j.linalg.api.ops.impl.layers.recurrent.config.SRUConfiguration**
- class **org.nd4j.linalg.api.ops.impl.loss.L2Loss**
- class **org.nd4j.linalg.api.ops.impl.meta.BaseMetaOp**
- class **org.nd4j.linalg.api.ops.impl.meta.InvertedPredicateMetaOp**
- class **org.nd4j.linalg.api.ops.impl.meta.PostulateMetaOp**
- class **org.nd4j.linalg.api.ops.impl.meta.PredicateMetaOp**
- class **org.nd4j.linalg.api.ops.impl.meta.ReduceMetaOp**
- class **org.nd4j.linalg.api.ops.impl.scalar.ScalarAdd**
- class **org.nd4j.linalg.api.ops.impl.scalar.ScalarDivision**
- class **org.nd4j.linalg.api.ops.impl.scalar.ScalarFMod**
- class **org.nd4j.linalg.api.ops.impl.scalar.ScalarMax**
- class **org.nd4j.linalg.api.ops.impl.scalar.ScalarMin**
- class **org.nd4j.linalg.api.ops.impl.scalar.ScalarMultiplication**
- class **org.nd4j.linalg.api.ops.impl.scalar.ScalarRemainder**
- class **org.nd4j.linalg.api.ops.impl.scalar.ScalarReverseDivision**
- class **org.nd4j.linalg.api.ops.impl.scalar.ScalarReverseSubtraction**
- class **org.nd4j.linalg.api.ops.impl.scalar.ScalarSet**
- class **org.nd4j.linalg.api.ops.impl.scalar.ScalarSubtraction**
- class **org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarEquals**
- class **org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarGreaterThan**
- class **org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarGreaterThanOrEqual**
- class **org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarLessThan**
- class **org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarLessThanOrEqual**
- class **org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarNotEquals**
- class **org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarSetValue**
- class **org.nd4j.linalg.api.ops.impl.scatter.ScatterAdd**
- class **org.nd4j.linalg.api.ops.impl.scatter.ScatterDiv**
- class **org.nd4j.linalg.api.ops.impl.scatter.ScatterMax**
- class **org.nd4j.linalg.api.ops.impl.scatter.ScatterMin**
- class **org.nd4j.linalg.api.ops.impl.scatter.ScatterMul**
- class **org.nd4j.linalg.api.ops.impl.scatter.ScatterSub**
- class **org.nd4j.linalg.api.ops.impl.scatter.ScatterUpdate**
- class **org.nd4j.linalg.api.ops.impl.shape.ApplyGradientDescent**
- class **org.nd4j.linalg.api.ops.impl.shape.Broadcast**
- class **org.nd4j.linalg.api.ops.impl.shape.BroadcastDynamicShape**
- class **org.nd4j.linalg.api.ops.impl.shape.Concat**
- class **org.nd4j.linalg.api.ops.impl.shape.ConfusionMatrix**
- class **org.nd4j.linalg.api.ops.impl.shape.Cross**
- class **org.nd4j.linalg.api.ops.impl.shape.Diag**
- class **org.nd4j.linalg.api.ops.impl.shape.DiagPart**
- class **org.nd4j.linalg.api.ops.impl.shape.ExpandDims**
- class **org.nd4j.linalg.api.ops.impl.shape.Eye**
- class **org.nd4j.linalg.api.ops.impl.shape.Gather**
- class **org.nd4j.linalg.api.ops.impl.shape.GatherNd**
- class **org.nd4j.linalg.api.ops.impl.shape.MergeAvg**
- class **org.nd4j.linalg.api.ops.impl.shape.MergeMax**
- class **org.nd4j.linalg.api.ops.impl.shape.MergeSum**
- class **org.nd4j.linalg.api.ops.impl.shape.MeshGrid**
- class **org.nd4j.linalg.api.ops.impl.shape.OneHot**
- class **org.nd4j.linalg.api.ops.impl.shape.OnesLike**
- class **org.nd4j.linalg.api.ops.impl.shape.ParallelStack**
- class **org.nd4j.linalg.api.ops.impl.shape.Permute**
- class **org.nd4j.linalg.api.ops.impl.shape.Rank**
- class **org.nd4j.linalg.api.ops.impl.shape.Repeat**
- class **org.nd4j.linalg.api.ops.impl.shape.Reshape**
- class **org.nd4j.linalg.api.ops.impl.shape.RollAxis**
- class **org.nd4j.linalg.api.ops.impl.shape.SequenceMask**
- class **org.nd4j.linalg.api.ops.impl.shape.Shape**
- class **org.nd4j.linalg.api.ops.impl.shape.Size**
- class **org.nd4j.linalg.api.ops.impl.shape.SizeAt**
- class **org.nd4j.linalg.api.ops.impl.shape.Slice**
- class **org.nd4j.linalg.api.ops.impl.shape.Split**
- class **org.nd4j.linalg.api.ops.impl.shape.SplitV**
- class **org.nd4j.linalg.api.ops.impl.shape.Squeeze**
- class **org.nd4j.linalg.api.ops.impl.shape.Stack**
- class **org.nd4j.linalg.api.ops.impl.shape.StridedSlice**
- class **org.nd4j.linalg.api.ops.impl.shape.Tile**
- class **org.nd4j.linalg.api.ops.impl.shape.Transpose**
- class **org.nd4j.linalg.api.ops.impl.shape.Unstack**
- class **org.nd4j.linalg.api.ops.impl.shape.ZerosLike**
- class **org.nd4j.linalg.api.ops.impl.shape.bp.ConcatBp**
- class **org.nd4j.linalg.api.ops.impl.shape.bp.SliceBp**
- class **org.nd4j.linalg.api.ops.impl.shape.bp.StridedSliceBp**
- class **org.nd4j.linalg.api.ops.impl.shape.bp.TileBp**
- class **org.nd4j.linalg.api.ops.impl.shape.tensorops.BaseTensorOp**
- class **org.nd4j.linalg.api.ops.impl.shape.tensorops.TensorArrayConcatV3**
- class **org.nd4j.linalg.api.ops.impl.shape.tensorops.TensorArrayGatherV3**
- class **org.nd4j.linalg.api.ops.impl.shape.tensorops.TensorArrayReadV3**
- class **org.nd4j.linalg.api.ops.impl.shape.tensorops.TensorArrayScatterV3**
- class **org.nd4j.linalg.api.ops.impl.shape.tensorops.TensorArrayV3**
- class **org.nd4j.linalg.api.ops.impl.shape.tensorops.TensorArrayWriteV3**
- class **org.nd4j.linalg.api.ops.impl.shape.tensorops.TensorSizeV3**
- class **org.nd4j.linalg.api.ops.impl.transforms.ACos**
- class **org.nd4j.linalg.api.ops.impl.transforms.ACosh**
- class **org.nd4j.linalg.api.ops.impl.transforms.ASin**
- class **org.nd4j.linalg.api.ops.impl.transforms.ASinh**
- class **org.nd4j.linalg.api.ops.impl.transforms.ATan**
- class **org.nd4j.linalg.api.ops.impl.transforms.ATan2**
- class **org.nd4j.linalg.api.ops.impl.transforms.ATanh**
- class **org.nd4j.linalg.api.ops.impl.transforms.Abs**
- class **org.nd4j.linalg.api.ops.impl.transforms.And**
- class **org.nd4j.linalg.api.ops.impl.transforms.Assign**
- class **org.nd4j.linalg.api.ops.impl.transforms.BaseDynamicTransformOp**
- class **org.nd4j.linalg.api.ops.impl.transforms.BatchToSpace**
- class **org.nd4j.linalg.api.ops.impl.transforms.BinaryMinimalRelativeError**
- class **org.nd4j.linalg.api.ops.impl.transforms.BinaryRelativeError**
- class **org.nd4j.linalg.api.ops.impl.transforms.Ceil**
- class **org.nd4j.linalg.api.ops.impl.transforms.Constant**
- class **org.nd4j.linalg.api.ops.impl.transforms.Cos**
- class **org.nd4j.linalg.api.ops.impl.transforms.Cosh**
- class **org.nd4j.linalg.api.ops.impl.transforms.Cube**
- class **org.nd4j.linalg.api.ops.impl.transforms.Dilation2D**
- class **org.nd4j.linalg.api.ops.impl.transforms.DynamicPartition**
- class **org.nd4j.linalg.api.ops.impl.transforms.DynamicStitch**
- class **org.nd4j.linalg.api.ops.impl.transforms.ELU**
- class **org.nd4j.linalg.api.ops.impl.transforms.Erf**
- class **org.nd4j.linalg.api.ops.impl.transforms.Erfc**
- class **org.nd4j.linalg.api.ops.impl.transforms.Exp**
- class **org.nd4j.linalg.api.ops.impl.transforms.Expm1**
- class **org.nd4j.linalg.api.ops.impl.transforms.Fill**
- class **org.nd4j.linalg.api.ops.impl.transforms.Floor**
- class **org.nd4j.linalg.api.ops.impl.transforms.HardSigmoid**
- class **org.nd4j.linalg.api.ops.impl.transforms.HardTanh**
- class **org.nd4j.linalg.api.ops.impl.transforms.Histogram**
- class **org.nd4j.linalg.api.ops.impl.transforms.Identity**
- class **org.nd4j.linalg.api.ops.impl.transforms.InvertPermutation**
- class **org.nd4j.linalg.api.ops.impl.transforms.IsFinite**
- class **org.nd4j.linalg.api.ops.impl.transforms.IsInf**
- class **org.nd4j.linalg.api.ops.impl.transforms.IsMax**
- class **org.nd4j.linalg.api.ops.impl.transforms.IsNaN**
- class **org.nd4j.linalg.api.ops.impl.transforms.LeakyReLU**
- class **org.nd4j.linalg.api.ops.impl.transforms.LegacyDropOut**
- class **org.nd4j.linalg.api.ops.impl.transforms.LegacyDropOutInverted**
- class **org.nd4j.linalg.api.ops.impl.transforms.Log**
- class **org.nd4j.linalg.api.ops.impl.transforms.Log1p**
- class **org.nd4j.linalg.api.ops.impl.transforms.LogSigmoid**
- class **org.nd4j.linalg.api.ops.impl.transforms.LogSigmoidDerivative**
- class **org.nd4j.linalg.api.ops.impl.transforms.LogSoftMax**
- class **org.nd4j.linalg.api.ops.impl.transforms.LogX**
- class **org.nd4j.linalg.api.ops.impl.transforms.MatchConditionTransform**
- class **org.nd4j.linalg.api.ops.impl.transforms.MatrixDeterminant**
- class **org.nd4j.linalg.api.ops.impl.transforms.MatrixDiag**
- class **org.nd4j.linalg.api.ops.impl.transforms.MatrixDiagPart**
- class **org.nd4j.linalg.api.ops.impl.transforms.MatrixInverse**
- class **org.nd4j.linalg.api.ops.impl.transforms.MatrixSetDiag**
- class **org.nd4j.linalg.api.ops.impl.transforms.MaxOut**
- class **org.nd4j.linalg.api.ops.impl.transforms.MirrorPad**
- class **org.nd4j.linalg.api.ops.impl.transforms.Negative**
- class **org.nd4j.linalg.api.ops.impl.transforms.Not**
- class **org.nd4j.linalg.api.ops.impl.transforms.OldAtan2Op**
- class **org.nd4j.linalg.api.ops.impl.transforms.OldIdentity**
- class **org.nd4j.linalg.api.ops.impl.transforms.OldReverse**
- class **org.nd4j.linalg.api.ops.impl.transforms.OldSoftMax**
- class **org.nd4j.linalg.api.ops.impl.transforms.OneMinus**
- class **org.nd4j.linalg.api.ops.impl.transforms.Or**
- class **org.nd4j.linalg.api.ops.impl.transforms.ParallelConcat**
- class **org.nd4j.linalg.api.ops.impl.transforms.Pow**
- class **org.nd4j.linalg.api.ops.impl.transforms.PowDerivative**
- class **org.nd4j.linalg.api.ops.impl.transforms.RSqrt**
- class **org.nd4j.linalg.api.ops.impl.transforms.RationalTanh**
- class **org.nd4j.linalg.api.ops.impl.transforms.Reciprocal**
- class **org.nd4j.linalg.api.ops.impl.transforms.RectifedLinear**
- class **org.nd4j.linalg.api.ops.impl.transforms.RectifiedTanh**
- class **org.nd4j.linalg.api.ops.impl.transforms.RelativeError**
- class **org.nd4j.linalg.api.ops.impl.transforms.Relu6**
- class **org.nd4j.linalg.api.ops.impl.transforms.ReluLayer**
- class **org.nd4j.linalg.api.ops.impl.transforms.ReplaceNans**
- class **org.nd4j.linalg.api.ops.impl.transforms.Reverse**
- class **org.nd4j.linalg.api.ops.impl.transforms.ReverseSequence**
- class **org.nd4j.linalg.api.ops.impl.transforms.ReverseV2**
- class **org.nd4j.linalg.api.ops.impl.transforms.Rint**
- class **org.nd4j.linalg.api.ops.impl.transforms.Round**
- class **org.nd4j.linalg.api.ops.impl.transforms.SELU**
- class **org.nd4j.linalg.api.ops.impl.transforms.Set**
- class **org.nd4j.linalg.api.ops.impl.transforms.SetRange**
- class **org.nd4j.linalg.api.ops.impl.transforms.Sigmoid**
- class **org.nd4j.linalg.api.ops.impl.transforms.SigmoidDerivative**
- class **org.nd4j.linalg.api.ops.impl.transforms.Sign**
- class **org.nd4j.linalg.api.ops.impl.transforms.Sin**
- class **org.nd4j.linalg.api.ops.impl.transforms.Sinh**
- class **org.nd4j.linalg.api.ops.impl.transforms.SoftMax**
- class **org.nd4j.linalg.api.ops.impl.transforms.SoftMaxDerivative**
- class **org.nd4j.linalg.api.ops.impl.transforms.SoftPlus**
- class **org.nd4j.linalg.api.ops.impl.transforms.SoftSign**
- class **org.nd4j.linalg.api.ops.impl.transforms.SpaceToBatch**
- class **org.nd4j.linalg.api.ops.impl.transforms.Sqrt**
- class **org.nd4j.linalg.api.ops.impl.transforms.Square**
- class **org.nd4j.linalg.api.ops.impl.transforms.Stabilize**
- class **org.nd4j.linalg.api.ops.impl.transforms.Step**
- class **org.nd4j.linalg.api.ops.impl.transforms.Swish**
- class **org.nd4j.linalg.api.ops.impl.transforms.SwishDerivative**
- class **org.nd4j.linalg.api.ops.impl.transforms.Tan**
- class **org.nd4j.linalg.api.ops.impl.transforms.TanDerivative**
- class **org.nd4j.linalg.api.ops.impl.transforms.Tanh**
- class **org.nd4j.linalg.api.ops.impl.transforms.TanhDerivative**
- class **org.nd4j.linalg.api.ops.impl.transforms.TimesOneMinus**
- class **org.nd4j.linalg.api.ops.impl.transforms.Trace**
- class **org.nd4j.linalg.api.ops.impl.transforms.Xor**
- class **org.nd4j.linalg.api.ops.impl.transforms.XwPlusB**
- class **org.nd4j.linalg.api.ops.impl.transforms.arithmetic.AddOp**
- class **org.nd4j.linalg.api.ops.impl.transforms.arithmetic.Axpy**
- class **org.nd4j.linalg.api.ops.impl.transforms.arithmetic.CopyOp**
- class **org.nd4j.linalg.api.ops.impl.transforms.arithmetic.DivOp**
- class **org.nd4j.linalg.api.ops.impl.transforms.arithmetic.FModOp**
- class **org.nd4j.linalg.api.ops.impl.transforms.arithmetic.FloorDivOp**
- class **org.nd4j.linalg.api.ops.impl.transforms.arithmetic.FloorModOp**
- class **org.nd4j.linalg.api.ops.impl.transforms.arithmetic.MergeAddOp**
- class **org.nd4j.linalg.api.ops.impl.transforms.arithmetic.MulOp**
- class **org.nd4j.linalg.api.ops.impl.transforms.arithmetic.OldAddOp**
- class **org.nd4j.linalg.api.ops.impl.transforms.arithmetic.OldDivOp**
- class **org.nd4j.linalg.api.ops.impl.transforms.arithmetic.OldFModOp**
- class **org.nd4j.linalg.api.ops.impl.transforms.arithmetic.OldFloorDivOp**
- class **org.nd4j.linalg.api.ops.impl.transforms.arithmetic.OldMulOp**
- class **org.nd4j.linalg.api.ops.impl.transforms.arithmetic.OldRDivOp**
- class **org.nd4j.linalg.api.ops.impl.transforms.arithmetic.OldSubOp**
- class **org.nd4j.linalg.api.ops.impl.transforms.arithmetic.RDivOp**
- class **org.nd4j.linalg.api.ops.impl.transforms.arithmetic.RSubOp**
- class **org.nd4j.linalg.api.ops.impl.transforms.arithmetic.RealDivOp**
- class **org.nd4j.linalg.api.ops.impl.transforms.arithmetic.RemainderOp**
- class **org.nd4j.linalg.api.ops.impl.transforms.arithmetic.SquaredDifferenceOp**
- class **org.nd4j.linalg.api.ops.impl.transforms.arithmetic.SubOp**
- class **org.nd4j.linalg.api.ops.impl.transforms.arithmetic.TruncateDivOp**
- class **org.nd4j.linalg.api.ops.impl.transforms.arithmetic.bp.AddBpOp**
- class **org.nd4j.linalg.api.ops.impl.transforms.arithmetic.bp.BaseArithmeticBackpropOp**
- class **org.nd4j.linalg.api.ops.impl.transforms.arithmetic.bp.DivBpOp**
- class **org.nd4j.linalg.api.ops.impl.transforms.arithmetic.bp.FloorDivBpOp**
- class **org.nd4j.linalg.api.ops.impl.transforms.arithmetic.bp.FloorModBpOp**
- class **org.nd4j.linalg.api.ops.impl.transforms.arithmetic.bp.MulBpOp**
- class **org.nd4j.linalg.api.ops.impl.transforms.arithmetic.bp.RDivBpOp**
- class **org.nd4j.linalg.api.ops.impl.transforms.arithmetic.bp.RSubBpOp**
- class **org.nd4j.linalg.api.ops.impl.transforms.arithmetic.bp.SquaredDifferenceBpOp**
- class **org.nd4j.linalg.api.ops.impl.transforms.arithmetic.bp.SubBpOp**
- class **org.nd4j.linalg.api.ops.impl.transforms.clip.ClipByNorm**
- class **org.nd4j.linalg.api.ops.impl.transforms.clip.ClipByNormBp**
- class **org.nd4j.linalg.api.ops.impl.transforms.clip.ClipByValue**
- class **org.nd4j.linalg.api.ops.impl.transforms.comparison.Choose**
- class **org.nd4j.linalg.api.ops.impl.transforms.comparison.CompareAndReplace**
- class **org.nd4j.linalg.api.ops.impl.transforms.comparison.CompareAndSet**
- class **org.nd4j.linalg.api.ops.impl.transforms.comparison.Eps**
- class **org.nd4j.linalg.api.ops.impl.transforms.comparison.EqualTo**
- class **org.nd4j.linalg.api.ops.impl.transforms.comparison.GreaterThan**
- class **org.nd4j.linalg.api.ops.impl.transforms.comparison.GreaterThanOrEqual**
- class **org.nd4j.linalg.api.ops.impl.transforms.comparison.IsNonDecreasing**
- class **org.nd4j.linalg.api.ops.impl.transforms.comparison.IsNumericTensor**
- class **org.nd4j.linalg.api.ops.impl.transforms.comparison.IsStrictlyIncreasing**
- class **org.nd4j.linalg.api.ops.impl.transforms.comparison.LessThan**
- class **org.nd4j.linalg.api.ops.impl.transforms.comparison.LessThanOrEqual**
- class **org.nd4j.linalg.api.ops.impl.transforms.comparison.ListDiff**
- class **org.nd4j.linalg.api.ops.impl.transforms.comparison.Max**
- class **org.nd4j.linalg.api.ops.impl.transforms.comparison.Min**
- class **org.nd4j.linalg.api.ops.impl.transforms.comparison.NotEqualTo**
- class **org.nd4j.linalg.api.ops.impl.transforms.comparison.OldEqualTo**
- class **org.nd4j.linalg.api.ops.impl.transforms.comparison.OldGreaterThan**
- class **org.nd4j.linalg.api.ops.impl.transforms.comparison.OldGreaterThanOrEqual**
- class **org.nd4j.linalg.api.ops.impl.transforms.comparison.OldLessThan**
- class **org.nd4j.linalg.api.ops.impl.transforms.comparison.OldLessThanOrEqual**
- class **org.nd4j.linalg.api.ops.impl.transforms.comparison.OldMax**
- class **org.nd4j.linalg.api.ops.impl.transforms.comparison.OldMin**
- class **org.nd4j.linalg.api.ops.impl.transforms.comparison.OldNotEqualTo**
- class **org.nd4j.linalg.api.ops.impl.transforms.dtype.Cast**
- class **org.nd4j.linalg.api.ops.impl.transforms.gradient.CubeDerivative**
- class **org.nd4j.linalg.api.ops.impl.transforms.gradient.ELUDerivative**
- class **org.nd4j.linalg.api.ops.impl.transforms.gradient.GradientBackwardsMarker**
- class **org.nd4j.linalg.api.ops.impl.transforms.gradient.HardSigmoidDerivative**
- class **org.nd4j.linalg.api.ops.impl.transforms.gradient.HardTanhDerivative**
- class **org.nd4j.linalg.api.ops.impl.transforms.gradient.LeakyReLUDerivative**
- class **org.nd4j.linalg.api.ops.impl.transforms.gradient.LogSoftMaxDerivative**
- class **org.nd4j.linalg.api.ops.impl.transforms.gradient.RationalTanhDerivative**
- class **org.nd4j.linalg.api.ops.impl.transforms.gradient.RectifiedTanhDerivative**
- class **org.nd4j.linalg.api.ops.impl.transforms.gradient.Relu6Derivative**
- class **org.nd4j.linalg.api.ops.impl.transforms.gradient.SELUDerivative**
- class **org.nd4j.linalg.api.ops.impl.transforms.gradient.SigmoidDerivative**
- class **org.nd4j.linalg.api.ops.impl.transforms.gradient.SoftMaxDerivative**
- class **org.nd4j.linalg.api.ops.impl.transforms.gradient.SoftSignDerivative**
- class **org.nd4j.linalg.api.ops.impl.transforms.gradient.SoftmaxBp**
- class **org.nd4j.linalg.api.ops.impl.transforms.gradient.TanhDerivative**
- class **org.nd4j.linalg.api.ops.impl.transforms.segment.SegmentMax**
- class **org.nd4j.linalg.api.ops.impl.transforms.segment.SegmentMean**
- class **org.nd4j.linalg.api.ops.impl.transforms.segment.SegmentMin**
- class **org.nd4j.linalg.api.ops.impl.transforms.segment.SegmentProd**
- class **org.nd4j.linalg.api.ops.impl.transforms.segment.SegmentSum**
- class **org.nd4j.linalg.api.ops.impl.transforms.temp.ExternalErrorsFunction**
- class **org.nd4j.linalg.api.ops.performance.PerformanceTracker**
- class **org.nd4j.linalg.api.ops.performance.primitives.AveragingTransactionsHolder**
- class **org.nd4j.linalg.api.ops.persistence.RestoreV2**
- class **org.nd4j.linalg.api.ops.persistence.SaveV2**
- class **org.nd4j.linalg.api.ops.random.BaseRandomOp**
- class **org.nd4j.linalg.api.ops.random.compat.RandomStandardNormal**
- class **org.nd4j.linalg.api.ops.random.custom.DistributionUniform**
- class **org.nd4j.linalg.api.ops.random.custom.RandomBernoulli**
- class **org.nd4j.linalg.api.ops.random.custom.RandomExponential**
- class **org.nd4j.linalg.api.ops.random.custom.RandomNormal**
- class **org.nd4j.linalg.api.ops.random.impl.AlphaDropOut**
- class **org.nd4j.linalg.api.ops.random.impl.BernoulliDistribution**
- class **org.nd4j.linalg.api.ops.random.impl.BinomialDistribution**
- class **org.nd4j.linalg.api.ops.random.impl.BinomialDistributionEx**
- class **org.nd4j.linalg.api.ops.random.impl.Choice**
- class **org.nd4j.linalg.api.ops.random.impl.DropOut**
- class **org.nd4j.linalg.api.ops.random.impl.DropOutInverted**
- class **org.nd4j.linalg.api.ops.random.impl.GaussianDistribution**
- class **org.nd4j.linalg.api.ops.random.impl.Linspace**
- class **org.nd4j.linalg.api.ops.random.impl.LogNormalDistribution**
- class **org.nd4j.linalg.api.ops.random.impl.ProbablisticMerge**
- class **org.nd4j.linalg.api.ops.random.impl.Range**
- class **org.nd4j.linalg.api.ops.random.impl.TruncatedNormalDistribution**
- class **org.nd4j.linalg.api.ops.random.impl.UniformDistribution**
- class **org.nd4j.linalg.api.rng.DefaultRandom**
- interface **org.nd4j.linalg.api.rng.Random**
- class **org.nd4j.linalg.api.rng.distribution.BaseDistribution**
- interface **org.nd4j.linalg.api.rng.distribution.Distribution**
- class **org.nd4j.linalg.api.rng.distribution.factory.DefaultDistributionFactory**
- interface **org.nd4j.linalg.api.rng.distribution.factory.DistributionFactory**
- class **org.nd4j.linalg.api.rng.distribution.impl.BinomialDistribution**
- class **org.nd4j.linalg.api.rng.distribution.impl.ConstantDistribution**
- class **org.nd4j.linalg.api.rng.distribution.impl.LogNormalDistribution**
- class **org.nd4j.linalg.api.rng.distribution.impl.NormalDistribution**
- class **org.nd4j.linalg.api.rng.distribution.impl.OrthogonalDistribution**
- class **org.nd4j.linalg.api.rng.distribution.impl.SaddlePointExpansion**
- class **org.nd4j.linalg.api.rng.distribution.impl.TruncatedNormalDistribution**
- class **org.nd4j.linalg.api.rng.distribution.impl.UniformDistribution**
- class **org.nd4j.linalg.api.shape.LongShapeDescriptor**
- class **org.nd4j.linalg.api.shape.Shape**
- class **org.nd4j.linalg.api.shape.ShapeDescriptor**
- class **org.nd4j.linalg.api.shape.SparseDescriptor**
- interface **org.nd4j.linalg.api.shape.loop.coordinatefunction.CoordinateFunction**
- class **org.nd4j.linalg.api.shape.options.ArrayOptionsHelper**
- enum **org.nd4j.linalg.api.shape.options.ArrayType**
- class **org.nd4j.linalg.cache.ArrayDescriptor**
- class **org.nd4j.linalg.cache.BasicConstantHandler**
- interface **org.nd4j.linalg.cache.ConstantHandler**
- interface **org.nd4j.linalg.cache.TADManager**
- class **org.nd4j.linalg.cache.TadDescriptor**
- class **org.nd4j.linalg.checkutil.CheckUtil**
- class **org.nd4j.linalg.checkutil.NDArrayCreationUtil**
- class **org.nd4j.linalg.collection.CompactHeapStringList**
- class **org.nd4j.linalg.collection.IntArrayKeyMap$IntArray**
- class **org.nd4j.linalg.collection.IntArrayKeyMap**
- class **org.nd4j.linalg.collection.IntArrayKeySet**
- class **org.nd4j.linalg.collection.MultiDimensionalMap$Entry**
- class **org.nd4j.linalg.collection.MultiDimensionalMap**
- class **org.nd4j.linalg.collection.MultiDimensionalSet**
- interface **org.nd4j.linalg.compression.AbstractStorage**
- class **org.nd4j.linalg.compression.BasicNDArrayCompressor**
- class **org.nd4j.linalg.compression.CompressedDataBuffer**
- enum **org.nd4j.linalg.compression.CompressionAlgorithm**
- class **org.nd4j.linalg.compression.CompressionDescriptor**
- enum **org.nd4j.linalg.compression.CompressionType**
- class **org.nd4j.linalg.compression.CompressionUtils**
- interface **org.nd4j.linalg.compression.NDArrayCompressor**
- class **org.nd4j.linalg.compression.ThresholdCompression**
- class **org.nd4j.linalg.convolution.BaseConvolution**
- enum **org.nd4j.linalg.convolution.Convolution$Type**
- class **org.nd4j.linalg.convolution.Convolution**
- interface **org.nd4j.linalg.convolution.ConvolutionInstance**
- class **org.nd4j.linalg.convolution.DefaultConvolutionInstance**
- class **org.nd4j.linalg.convolution.OldConvolution**
- class **org.nd4j.linalg.cpu.nativecpu.BlasWrapper**
- class **org.nd4j.linalg.cpu.nativecpu.CpuAffinityManager**
- class **org.nd4j.linalg.cpu.nativecpu.CpuBackend**
- class **org.nd4j.linalg.cpu.nativecpu.CpuMemoryManager**
- class **org.nd4j.linalg.cpu.nativecpu.CpuNDArrayFactory**
- class **org.nd4j.linalg.cpu.nativecpu.CpuSparseNDArrayFactory**
- class **org.nd4j.linalg.cpu.nativecpu.CpuTADManager**
- class **org.nd4j.linalg.cpu.nativecpu.DirectShapeInfoProvider**
- class **org.nd4j.linalg.cpu.nativecpu.DirectSparseInfoProvider**
- class **org.nd4j.linalg.cpu.nativecpu.NDArray**
- class **org.nd4j.linalg.cpu.nativecpu.SparseBlasWrapper**
- class **org.nd4j.linalg.cpu.nativecpu.SparseNDArrayCOO**
- class **org.nd4j.linalg.cpu.nativecpu.SparseNDArrayCSR**
- class **org.nd4j.linalg.cpu.nativecpu.blas.CpuBlas**
- class **org.nd4j.linalg.cpu.nativecpu.blas.CpuLapack**
- class **org.nd4j.linalg.cpu.nativecpu.blas.CpuLevel1**
- class **org.nd4j.linalg.cpu.nativecpu.blas.CpuLevel2**
- class **org.nd4j.linalg.cpu.nativecpu.blas.CpuLevel3**
- class **org.nd4j.linalg.cpu.nativecpu.blas.SparseCpuBlas**
- class **org.nd4j.linalg.cpu.nativecpu.blas.SparseCpuLapack**
- class **org.nd4j.linalg.cpu.nativecpu.blas.SparseCpuLevel1**
- class **org.nd4j.linalg.cpu.nativecpu.blas.SparseCpuLevel2**
- class **org.nd4j.linalg.cpu.nativecpu.blas.SparseCpuLevel3**
- class **org.nd4j.linalg.cpu.nativecpu.cache.ConstantBuffersCache**
- class **org.nd4j.linalg.cpu.nativecpu.compression.CpuFlexibleThreshold**
- class **org.nd4j.linalg.cpu.nativecpu.compression.CpuThreshold**
- class **org.nd4j.linalg.cpu.nativecpu.ops.NativeOpExecutioner**
- class **org.nd4j.linalg.cpu.nativecpu.rng.CpuNativeRandom**
- class **org.nd4j.linalg.cpu.nativecpu.workspace.CpuWorkspace**
- class **org.nd4j.linalg.cpu.nativecpu.workspace.CpuWorkspaceManager**
- class **org.nd4j.linalg.dataset.BalanceMinibatches**
- class **org.nd4j.linalg.dataset.DataSet**
- class **org.nd4j.linalg.dataset.ExistingMiniBatchDataSetIterator**
- class **org.nd4j.linalg.dataset.MiniBatchFileDataSetIterator**
- class **org.nd4j.linalg.dataset.MultiDataSet**
- class **org.nd4j.linalg.dataset.SplitTestAndTrain**
- class **org.nd4j.linalg.dataset.ViewIterator**
- interface **org.nd4j.linalg.dataset.api.DataSet**
- interface **org.nd4j.linalg.dataset.api.DataSetPreProcessor**
- class **org.nd4j.linalg.dataset.api.DataSetUtil**
- interface **org.nd4j.linalg.dataset.api.MultiDataSet**
- interface **org.nd4j.linalg.dataset.api.MultiDataSetPreProcessor**
- class **org.nd4j.linalg.dataset.api.iterator.BaseDatasetIterator**
- class **org.nd4j.linalg.dataset.api.iterator.CachingDataSetIterator**
- interface **org.nd4j.linalg.dataset.api.iterator.DataSetIterator**
- interface **org.nd4j.linalg.dataset.api.iterator.DataSetIteratorFactory**
- class **org.nd4j.linalg.dataset.api.iterator.KFoldIterator**
- interface **org.nd4j.linalg.dataset.api.iterator.MultiDataSetIterator**
- interface **org.nd4j.linalg.dataset.api.iterator.MultiDataSetIteratorFactory**
- class **org.nd4j.linalg.dataset.api.iterator.MultipleEpochsIterator**
- interface **org.nd4j.linalg.dataset.api.iterator.ParallelDataSetIterator**
- interface **org.nd4j.linalg.dataset.api.iterator.ParallelMultiDataSetIterator**
- class **org.nd4j.linalg.dataset.api.iterator.SamplingDataSetIterator**
- class **org.nd4j.linalg.dataset.api.iterator.StandardScaler**
- class **org.nd4j.linalg.dataset.api.iterator.TestDataSetIterator**
- class **org.nd4j.linalg.dataset.api.iterator.TestMultiDataSetIterator**
- interface **org.nd4j.linalg.dataset.api.iterator.cache.DataSetCache**
- class **org.nd4j.linalg.dataset.api.iterator.cache.InFileAndMemoryDataSetCache**
- class **org.nd4j.linalg.dataset.api.iterator.cache.InFileDataSetCache**
- class **org.nd4j.linalg.dataset.api.iterator.cache.InMemoryDataSetCache**
- enum **org.nd4j.linalg.dataset.api.iterator.enums.InequalityHandling**
- class **org.nd4j.linalg.dataset.api.iterator.fetcher.BaseDataFetcher**
- interface **org.nd4j.linalg.dataset.api.iterator.fetcher.DataSetFetcher**
- class **org.nd4j.linalg.dataset.api.preprocessor.AbstractDataSetNormalizer**
- class **org.nd4j.linalg.dataset.api.preprocessor.AbstractMultiDataSetNormalizer**
- class **org.nd4j.linalg.dataset.api.preprocessor.AbstractNormalizer**
- class **org.nd4j.linalg.dataset.api.preprocessor.CompositeDataSetPreProcessor**
- class **org.nd4j.linalg.dataset.api.preprocessor.CompositeMultiDataSetPreProcessor**
- interface **org.nd4j.linalg.dataset.api.preprocessor.DataNormalization**
- class **org.nd4j.linalg.dataset.api.preprocessor.ImageFlatteningDataSetPreProcessor**
- class **org.nd4j.linalg.dataset.api.preprocessor.ImageMultiPreProcessingScaler**
- class **org.nd4j.linalg.dataset.api.preprocessor.ImagePreProcessingScaler**
- class **org.nd4j.linalg.dataset.api.preprocessor.MinMaxStrategy**
- interface **org.nd4j.linalg.dataset.api.preprocessor.MultiDataNormalization**
- class **org.nd4j.linalg.dataset.api.preprocessor.MultiNormalizerHybrid**
- class **org.nd4j.linalg.dataset.api.preprocessor.MultiNormalizerMinMaxScaler**
- class **org.nd4j.linalg.dataset.api.preprocessor.MultiNormalizerStandardize**
- interface **org.nd4j.linalg.dataset.api.preprocessor.Normalizer**
- class **org.nd4j.linalg.dataset.api.preprocessor.NormalizerMinMaxScaler**
- class **org.nd4j.linalg.dataset.api.preprocessor.NormalizerStandardize**
- interface **org.nd4j.linalg.dataset.api.preprocessor.NormalizerStrategy**
- class **org.nd4j.linalg.dataset.api.preprocessor.StandardizeStrategy**
- class **org.nd4j.linalg.dataset.api.preprocessor.VGG16ImagePreProcessor**
- class **org.nd4j.linalg.dataset.api.preprocessor.classimbalance.BaseUnderSamplingPreProcessor**
- class **org.nd4j.linalg.dataset.api.preprocessor.classimbalance.UnderSamplingByMaskingMultiDataSetPreProcessor**
- class **org.nd4j.linalg.dataset.api.preprocessor.classimbalance.UnderSamplingByMaskingPreProcessor**
- class **org.nd4j.linalg.dataset.api.preprocessor.serializer.CustomSerializerStrategy**
- class **org.nd4j.linalg.dataset.api.preprocessor.serializer.ImagePreProcessingSerializerStrategy**
- class **org.nd4j.linalg.dataset.api.preprocessor.serializer.MinMaxSerializerStrategy**
- class **org.nd4j.linalg.dataset.api.preprocessor.serializer.MultiHybridSerializerStrategy**
- class **org.nd4j.linalg.dataset.api.preprocessor.serializer.MultiMinMaxSerializerStrategy**
- class **org.nd4j.linalg.dataset.api.preprocessor.serializer.MultiStandardizeSerializerStrategy**
- class **org.nd4j.linalg.dataset.api.preprocessor.serializer.NormalizerSerializer**
- interface **org.nd4j.linalg.dataset.api.preprocessor.serializer.NormalizerSerializerStrategy**
- enum **org.nd4j.linalg.dataset.api.preprocessor.serializer.NormalizerType**
- class **org.nd4j.linalg.dataset.api.preprocessor.serializer.StandardizeSerializerStrategy**
- class **org.nd4j.linalg.dataset.api.preprocessor.stats.DistributionStats$Builder**
- class **org.nd4j.linalg.dataset.api.preprocessor.stats.DistributionStats**
- class **org.nd4j.linalg.dataset.api.preprocessor.stats.MinMaxStats$Builder**
- class **org.nd4j.linalg.dataset.api.preprocessor.stats.MinMaxStats**
- interface **org.nd4j.linalg.dataset.api.preprocessor.stats.NormalizerStats$Builder**
- interface **org.nd4j.linalg.dataset.api.preprocessor.stats.NormalizerStats**
- class **org.nd4j.linalg.dimensionalityreduction.PCA**
- class **org.nd4j.linalg.dimensionalityreduction.RandomProjection**
- class **org.nd4j.linalg.eigen.Eigen**
- interface **org.nd4j.linalg.env.EnvironmentalAction**
- class **org.nd4j.linalg.env.impl.ConcurrencyAction**
- class **org.nd4j.linalg.env.impl.DebugAction**
- class **org.nd4j.linalg.env.impl.FallbackAction**
- class **org.nd4j.linalg.env.impl.NDArrayUnpackAction**
- class **org.nd4j.linalg.env.impl.OmpNumThreadsAction**
- class **org.nd4j.linalg.env.impl.VerboseAction**
- class **org.nd4j.linalg.env.impl.WorkspacesBypassAction**
- class **org.nd4j.linalg.env.impl.WorkspacesDebugAction**
- class **org.nd4j.linalg.env.impl.WorkspacesSpillAction**
- class **org.nd4j.linalg.exception.ND4JArraySizeException**
- class **org.nd4j.linalg.exception.ND4JException**
- class **org.nd4j.linalg.exception.ND4JIllegalAccessException**
- class **org.nd4j.linalg.exception.ND4JIllegalArgumentException**
- class **org.nd4j.linalg.exception.ND4JIllegalStateException**
- class **org.nd4j.linalg.exception.ND4UnresolvedOutputVariables**
- class **org.nd4j.linalg.exception.Nd4jNoSuchWorkspaceException**
- class **org.nd4j.linalg.executors.ExecutorServiceProvider**
- class **org.nd4j.linalg.factory.BaseBlasWrapper**
- class **org.nd4j.linalg.factory.BaseNDArrayFactory**
- class **org.nd4j.linalg.factory.BaseSparseBlasWrapper**
- class **org.nd4j.linalg.factory.BaseSparseNDArrayFactory**
- interface **org.nd4j.linalg.factory.BlasWrapper**
- class **org.nd4j.linalg.factory.Broadcast**
- class **org.nd4j.linalg.factory.DataTypeValidation**
- interface **org.nd4j.linalg.factory.NDArrayFactory**
- enum **org.nd4j.linalg.factory.Nd4j$PadMode**
- class **org.nd4j.linalg.factory.Nd4j**
- class **org.nd4j.linalg.factory.Nd4jBackend$NoAvailableBackendException**
- class **org.nd4j.linalg.factory.Nd4jBackend**
- class **org.nd4j.linalg.factory.RandomFactory**
- interface **org.nd4j.linalg.function.BiConsumer**
- interface **org.nd4j.linalg.function.BiFunction**
- interface **org.nd4j.linalg.function.BiPredicate**
- interface **org.nd4j.linalg.function.Consumer**
- interface **org.nd4j.linalg.function.Function**
- class **org.nd4j.linalg.function.FunctionalUtils**
- interface **org.nd4j.linalg.function.Predicate**
- interface **org.nd4j.linalg.function.Supplier**
- interface **org.nd4j.linalg.function.UnaryOperator**
- class **org.nd4j.linalg.heartbeat.Heartbeat**
- class **org.nd4j.linalg.heartbeat.reports.Environment**
- enum **org.nd4j.linalg.heartbeat.reports.Event**
- enum **org.nd4j.linalg.heartbeat.reports.Task$ArchitectureType**
- enum **org.nd4j.linalg.heartbeat.reports.Task$NetworkType**
- class **org.nd4j.linalg.heartbeat.reports.Task**
- class **org.nd4j.linalg.heartbeat.utils.EnvironmentUtils**
- class **org.nd4j.linalg.heartbeat.utils.TaskUtils**
- class **org.nd4j.linalg.indexing.BooleanIndexing**
- interface **org.nd4j.linalg.indexing.INDArrayIndex**
- class **org.nd4j.linalg.indexing.IndexInfo**
- class **org.nd4j.linalg.indexing.Indices**
- class **org.nd4j.linalg.indexing.IntervalIndex**
- class **org.nd4j.linalg.indexing.NDArrayIndex**
- class **org.nd4j.linalg.indexing.NDArrayIndexAll**
- class **org.nd4j.linalg.indexing.NDArrayIndexEmpty**
- class **org.nd4j.linalg.indexing.NewAxis**
- class **org.nd4j.linalg.indexing.PointIndex**
- class **org.nd4j.linalg.indexing.ShapeOffsetResolution**
- class **org.nd4j.linalg.indexing.SpecifiedIndex$SparseSpecifiedIndexesGenerator**
- class **org.nd4j.linalg.indexing.SpecifiedIndex$SpecifiedIndexesGenerator**
- class **org.nd4j.linalg.indexing.SpecifiedIndex**
- class **org.nd4j.linalg.indexing.conditions.AbsValueGreaterOrEqualsThan**
- class **org.nd4j.linalg.indexing.conditions.AbsValueGreaterThan**
- class **org.nd4j.linalg.indexing.conditions.AbsValueLessOrEqualsThan**
- class **org.nd4j.linalg.indexing.conditions.AbsValueLessThan**
- class **org.nd4j.linalg.indexing.conditions.And**
- class **org.nd4j.linalg.indexing.conditions.BaseCondition**
- interface **org.nd4j.linalg.indexing.conditions.Condition**
- class **org.nd4j.linalg.indexing.conditions.ConditionBuilder**
- class **org.nd4j.linalg.indexing.conditions.ConditionEquals**
- class **org.nd4j.linalg.indexing.conditions.Conditions**
- class **org.nd4j.linalg.indexing.conditions.EpsilonEquals**
- class **org.nd4j.linalg.indexing.conditions.EpsilonNotEquals**
- class **org.nd4j.linalg.indexing.conditions.EqualsCondition**
- class **org.nd4j.linalg.indexing.conditions.GreaterThan**
- class **org.nd4j.linalg.indexing.conditions.GreaterThanOrEqual**
- class **org.nd4j.linalg.indexing.conditions.IsInfinite**
- class **org.nd4j.linalg.indexing.conditions.IsNaN**
- class **org.nd4j.linalg.indexing.conditions.LessThan**
- class **org.nd4j.linalg.indexing.conditions.LessThanOrEqual**
- class **org.nd4j.linalg.indexing.conditions.Not**
- class **org.nd4j.linalg.indexing.conditions.NotEqualsCondition**
- class **org.nd4j.linalg.indexing.conditions.Or**
- class **org.nd4j.linalg.indexing.functions.Identity**
- enum **org.nd4j.linalg.indexing.functions.StableNumber$Type**
- class **org.nd4j.linalg.indexing.functions.StableNumber**
- class **org.nd4j.linalg.indexing.functions.Value**
- class **org.nd4j.linalg.indexing.functions.Zero**
- class **org.nd4j.linalg.inverse.InvertMatrix**
- class **org.nd4j.linalg.io.AbstractFileResolvingResource**
- class **org.nd4j.linalg.io.AbstractResource**
- class **org.nd4j.linalg.io.Assert**
- class **org.nd4j.linalg.io.ClassPathResource**
- class **org.nd4j.linalg.io.ClassUtils**
- class **org.nd4j.linalg.io.CollectionUtils**
- interface **org.nd4j.linalg.io.InputStreamSource**
- class **org.nd4j.linalg.io.ObjectUtils**
- interface **org.nd4j.linalg.io.ReflectionUtils$FieldCallback**
- interface **org.nd4j.linalg.io.ReflectionUtils$FieldFilter**
- interface **org.nd4j.linalg.io.ReflectionUtils$MethodCallback**
- interface **org.nd4j.linalg.io.ReflectionUtils$MethodFilter**
- class **org.nd4j.linalg.io.ReflectionUtils**
- interface **org.nd4j.linalg.io.Resource**
- class **org.nd4j.linalg.io.ResourceUtils**
- class **org.nd4j.linalg.io.StringUtils**
- class **org.nd4j.linalg.io.VfsResource**
- class **org.nd4j.linalg.io.VfsUtils**
- class **org.nd4j.linalg.jcublas.CachedShapeInfoProvider**
- class **org.nd4j.linalg.jcublas.CublasPointer**
- class **org.nd4j.linalg.jcublas.DirectSparseInfoProvider**
- class **org.nd4j.linalg.jcublas.JCublasBackend**
- class **org.nd4j.linalg.jcublas.JCublasNDArray**
- class **org.nd4j.linalg.jcublas.JCublasNDArrayFactory**
- class **org.nd4j.linalg.jcublas.JCublasWrapper**
- class **org.nd4j.linalg.jcublas.JCusparseNDArrayCOO**
- class **org.nd4j.linalg.jcublas.JCusparseNDArrayFactory**
- class **org.nd4j.linalg.jcublas.JcusparseNDArrayCSR**
- class **org.nd4j.linalg.jcublas.SparseBlasWrapper**
- class **org.nd4j.linalg.jcublas.blas.CudaBlas**
- class **org.nd4j.linalg.jcublas.blas.JcublasLapack**
- class **org.nd4j.linalg.jcublas.blas.JcublasLevel1**
- class **org.nd4j.linalg.jcublas.blas.JcublasLevel2**
- class **org.nd4j.linalg.jcublas.blas.JcublasLevel3**
- class **org.nd4j.linalg.jcublas.blas.JcusparseLapack**
- class **org.nd4j.linalg.jcublas.blas.JcusparseLevel1**
- class **org.nd4j.linalg.jcublas.blas.JcusparseLevel2**
- class **org.nd4j.linalg.jcublas.blas.JcusparseLevel3**
- class **org.nd4j.linalg.jcublas.blas.SparseCudaBlas**
- class **org.nd4j.linalg.jcublas.buffer.AddressRetriever**
- class **org.nd4j.linalg.jcublas.buffer.BaseCudaDataBuffer**
- class **org.nd4j.linalg.jcublas.buffer.CudaDoubleDataBuffer**
- class **org.nd4j.linalg.jcublas.buffer.CudaFloatDataBuffer**
- class **org.nd4j.linalg.jcublas.buffer.CudaHalfDataBuffer**
- class **org.nd4j.linalg.jcublas.buffer.CudaIntDataBuffer**
- class **org.nd4j.linalg.jcublas.buffer.CudaLongDataBuffer**
- class **org.nd4j.linalg.jcublas.buffer.DevicePointerInfo**
- interface **org.nd4j.linalg.jcublas.buffer.JCudaBuffer**
- class **org.nd4j.linalg.jcublas.buffer.factory.CudaDataBufferFactory**
- class **org.nd4j.linalg.jcublas.compression.CudaFlexibleThreshold**
- class **org.nd4j.linalg.jcublas.compression.CudaThreshold**
- class **org.nd4j.linalg.jcublas.context.ContextHolder**
- class **org.nd4j.linalg.jcublas.context.CudaContext**
- class **org.nd4j.linalg.jcublas.ops.executioner.CudaExecutioner**
- enum **org.nd4j.linalg.jcublas.ops.executioner.CudaGridExecutioner$MetaType**
- class **org.nd4j.linalg.jcublas.ops.executioner.CudaGridExecutioner**
- class **org.nd4j.linalg.jcublas.ops.executioner.aggregates.AggregateDescriptor**
- class **org.nd4j.linalg.jcublas.rng.CudaNativeRandom**
- class **org.nd4j.linalg.jcublas.util.CudaArgs$ArgsAndReferences**
- class **org.nd4j.linalg.jcublas.util.CudaArgs**
- class **org.nd4j.linalg.jcublas.util.FFTUtils**
- class **org.nd4j.linalg.jcublas.util.OpUtil**
- class **org.nd4j.linalg.learning.AMSGradUpdater**
- class **org.nd4j.linalg.learning.AdaDeltaUpdater**
- class **org.nd4j.linalg.learning.AdaGradUpdater**
- class **org.nd4j.linalg.learning.AdaMaxUpdater**
- class **org.nd4j.linalg.learning.AdamUpdater**
- interface **org.nd4j.linalg.learning.GradientUpdater**
- class **org.nd4j.linalg.learning.NadamUpdater**
- class **org.nd4j.linalg.learning.NesterovsUpdater**
- class **org.nd4j.linalg.learning.NoOpUpdater**
- class **org.nd4j.linalg.learning.RmsPropUpdater**
- class **org.nd4j.linalg.learning.SgdUpdater**
- class **org.nd4j.linalg.learning.config.AMSGrad$Builder**
- class **org.nd4j.linalg.learning.config.AMSGrad**
- class **org.nd4j.linalg.learning.config.AdaDelta$Builder**
- class **org.nd4j.linalg.learning.config.AdaDelta**
- class **org.nd4j.linalg.learning.config.AdaGrad$Builder**
- class **org.nd4j.linalg.learning.config.AdaGrad**
- class **org.nd4j.linalg.learning.config.AdaMax$Builder**
- class **org.nd4j.linalg.learning.config.AdaMax**
- class **org.nd4j.linalg.learning.config.Adam$Builder**
- class **org.nd4j.linalg.learning.config.Adam**
- interface **org.nd4j.linalg.learning.config.IUpdater**
- class **org.nd4j.linalg.learning.config.Nadam$Builder**
- class **org.nd4j.linalg.learning.config.Nadam**
- class **org.nd4j.linalg.learning.config.Nesterovs$Builder**
- class **org.nd4j.linalg.learning.config.Nesterovs**
- class **org.nd4j.linalg.learning.config.NoOp**
- class **org.nd4j.linalg.learning.config.RmsProp$Builder**
- class **org.nd4j.linalg.learning.config.RmsProp**
- class **org.nd4j.linalg.learning.config.Sgd$Builder**
- class **org.nd4j.linalg.learning.config.Sgd**
- class **org.nd4j.linalg.learning.legacy.AdaGrad**
- interface **org.nd4j.linalg.lossfunctions.ILossFunction**
- enum **org.nd4j.linalg.lossfunctions.LossFunctions$LossFunction**
- class **org.nd4j.linalg.lossfunctions.LossFunctions**
- class **org.nd4j.linalg.lossfunctions.LossUtil**
- class **org.nd4j.linalg.lossfunctions.impl.LossBinaryXENT**
- class **org.nd4j.linalg.lossfunctions.impl.LossCosineProximity**
- class **org.nd4j.linalg.lossfunctions.impl.LossFMeasure**
- class **org.nd4j.linalg.lossfunctions.impl.LossHinge**
- class **org.nd4j.linalg.lossfunctions.impl.LossKLD**
- class **org.nd4j.linalg.lossfunctions.impl.LossL1**
- class **org.nd4j.linalg.lossfunctions.impl.LossL2**
- class **org.nd4j.linalg.lossfunctions.impl.LossMAE**
- class **org.nd4j.linalg.lossfunctions.impl.LossMAPE**
- class **org.nd4j.linalg.lossfunctions.impl.LossMCXENT**
- class **org.nd4j.linalg.lossfunctions.impl.LossMSE**
- class **org.nd4j.linalg.lossfunctions.impl.LossMSLE**
- class **org.nd4j.linalg.lossfunctions.impl.LossMixtureDensity$Builder**
- class **org.nd4j.linalg.lossfunctions.impl.LossMixtureDensity$MixtureDensityComponents**
- class **org.nd4j.linalg.lossfunctions.impl.LossMixtureDensity**
- class **org.nd4j.linalg.lossfunctions.impl.LossMultiLabel**
- class **org.nd4j.linalg.lossfunctions.impl.LossNegativeLogLikelihood**
- class **org.nd4j.linalg.lossfunctions.impl.LossPoisson**
- class **org.nd4j.linalg.lossfunctions.impl.LossSquaredHinge**
- class **org.nd4j.linalg.lossfunctions.serde.RowVectorDeserializer**
- class **org.nd4j.linalg.lossfunctions.serde.RowVectorSerializer**
- class **org.nd4j.linalg.memory.BasicMemoryManager**
- enum **org.nd4j.linalg.memory.MemcpyDirection**
- interface **org.nd4j.linalg.memory.MemoryManager**
- class **org.nd4j.linalg.memory.abstracts.DummyWorkspace**
- class **org.nd4j.linalg.memory.abstracts.Nd4jWorkspace$GarbageWorkspaceReference**
- class **org.nd4j.linalg.memory.abstracts.Nd4jWorkspace**
- class **org.nd4j.linalg.memory.provider.BasicWorkspaceManager**
- class **org.nd4j.linalg.memory.stash.BasicStash**
- class **org.nd4j.linalg.memory.stash.BasicStashManager**
- interface **org.nd4j.linalg.memory.stash.Stash**
- interface **org.nd4j.linalg.memory.stash.StashManager**
- class **org.nd4j.linalg.ops.transforms.Transforms**
- class **org.nd4j.linalg.primitives.AtomicBoolean**
- class **org.nd4j.linalg.primitives.AtomicDouble**
- class **org.nd4j.linalg.primitives.Counter**
- class **org.nd4j.linalg.primitives.CounterMap**
- class **org.nd4j.linalg.primitives.ImmutablePair**
- class **org.nd4j.linalg.primitives.ImmutableQuad**
- class **org.nd4j.linalg.primitives.ImmutableTriple**
- class **org.nd4j.linalg.primitives.Optional**
- class **org.nd4j.linalg.primitives.Pair**
- class **org.nd4j.linalg.primitives.Quad**
- class **org.nd4j.linalg.primitives.SynchronizedObject**
- class **org.nd4j.linalg.primitives.Triple**
- class **org.nd4j.linalg.primitives.serde.JsonDeserializerAtomicBoolean**
- class **org.nd4j.linalg.primitives.serde.JsonDeserializerAtomicDouble**
- class **org.nd4j.linalg.primitives.serde.JsonSerializerAtomicBoolean**
- class **org.nd4j.linalg.primitives.serde.JsonSerializerAtomicDouble**
- interface **org.nd4j.linalg.profiler.OpProfiler$OpProfilerListener**
- enum **org.nd4j.linalg.profiler.OpProfiler$PenaltyCause**
- class **org.nd4j.linalg.profiler.OpProfiler**
- class **org.nd4j.linalg.profiler.data.StackAggregator**
- class **org.nd4j.linalg.profiler.data.StringAggregator**
- class **org.nd4j.linalg.profiler.data.StringCounter**
- class **org.nd4j.linalg.profiler.data.primitives.ComparableAtomicLong**
- class **org.nd4j.linalg.profiler.data.primitives.StackComparator**
- class **org.nd4j.linalg.profiler.data.primitives.StackDescriptor**
- class **org.nd4j.linalg.profiler.data.primitives.StackNode**
- class **org.nd4j.linalg.profiler.data.primitives.StackTree**
- class **org.nd4j.linalg.profiler.data.primitives.TimeSet**
- class **org.nd4j.linalg.schedule.CycleSchedule**
- class **org.nd4j.linalg.schedule.ExponentialSchedule**
- interface **org.nd4j.linalg.schedule.ISchedule**
- class **org.nd4j.linalg.schedule.InverseSchedule**
- class **org.nd4j.linalg.schedule.MapSchedule$Builder**
- class **org.nd4j.linalg.schedule.MapSchedule**
- class **org.nd4j.linalg.schedule.PolySchedule**
- enum **org.nd4j.linalg.schedule.ScheduleType**
- class **org.nd4j.linalg.schedule.SigmoidSchedule**
- class **org.nd4j.linalg.schedule.StepSchedule**
- class **org.nd4j.linalg.string.NDArrayStrings**
- interface **org.nd4j.linalg.util.AbstractNumber**
- class **org.nd4j.linalg.util.ArrayUtil**
- class **org.nd4j.linalg.util.AtomicThrowable**
- class **org.nd4j.linalg.util.DataSetUtils**
- class **org.nd4j.linalg.util.DeviceLocal**
- class **org.nd4j.linalg.util.DeviceLocalNDArray**
- class **org.nd4j.linalg.util.FeatureUtil**
- class **org.nd4j.linalg.util.HashUtil**
- class **org.nd4j.linalg.util.InputStreamUtil**
- class **org.nd4j.linalg.util.JarResource**
- class **org.nd4j.linalg.util.LinAlgExceptions**
- class **org.nd4j.linalg.util.LinkedMultiValueMap**
- class **org.nd4j.linalg.util.LongUtils**
- class **org.nd4j.linalg.util.MathUtils**
- interface **org.nd4j.linalg.util.MultiValueMap**
- class **org.nd4j.linalg.util.ND4JTestUtils$ComparisonResult**
- class **org.nd4j.linalg.util.ND4JTestUtils$EqualsFn**
- class **org.nd4j.linalg.util.ND4JTestUtils$EqualsWithEpsFn**
- class **org.nd4j.linalg.util.ND4JTestUtils**
- class **org.nd4j.linalg.util.NDArrayMath**
- class **org.nd4j.linalg.util.NDArrayUtil**
- enum **org.nd4j.linalg.util.NioUtil$BufferType**
- class **org.nd4j.linalg.util.NioUtil**
- class **org.nd4j.linalg.util.Paths**
- class **org.nd4j.linalg.util.SerializationUtils**
- class **org.nd4j.linalg.util.SynchronizedTable**
- class **org.nd4j.linalg.workspace.BaseWorkspaceMgr**
- class **org.nd4j.linalg.workspace.ND4JWorkspaceException**
- interface **org.nd4j.linalg.workspace.WorkspaceMgr**
- class **org.nd4j.linalg.workspace.WorkspaceUtils**
- class **org.nd4j.linalg.workspace.WorkspacesCloseable**
- class **org.nd4j.list.BaseNDArrayList**
- class **org.nd4j.list.FloatNDArrayList**
- class **org.nd4j.list.IntNDArrayList**
- class **org.nd4j.list.NDArrayList**
- class **org.nd4j.list.compat.TensorList**
- class **org.nd4j.list.matrix.FloatMatrixNDArrayList**
- class **org.nd4j.list.matrix.IntMatrixNDArrayList**
- class **org.nd4j.list.matrix.MatrixBaseNDArrayList**
- class **org.nd4j.list.matrix.MatrixNDArrayList**
- class **org.nd4j.nativeblas.BaseNativeNDArrayFactory**
- class **org.nd4j.nativeblas.LongPointerWrapper**
- class **org.nd4j.nativeblas.NativeLapack**
- class **org.nd4j.nativeblas.NativeOps**
- class **org.nd4j.nativeblas.NativeOpsHolder**
- class **org.nd4j.nativeblas.Nd4jBlas**
- class **org.nd4j.nativeblas.Nd4jCpu$ArgumentsList**
- class **org.nd4j.nativeblas.Nd4jCpu$CurrentIndexing**
- class **org.nd4j.nativeblas.Nd4jCpu$DoubleBooleanOp**
- class **org.nd4j.nativeblas.Nd4jCpu$DoubleBroadcastableOp**
- class **org.nd4j.nativeblas.Nd4jCpu$DoubleContext**
- class **org.nd4j.nativeblas.Nd4jCpu$DoubleContextPrototype**
- class **org.nd4j.nativeblas.Nd4jCpu$DoubleDeclarableCustomOp**
- class **org.nd4j.nativeblas.Nd4jCpu$DoubleDeclarableListOp**
- class **org.nd4j.nativeblas.Nd4jCpu$DoubleDeclarableOp**
- class **org.nd4j.nativeblas.Nd4jCpu$DoubleDeclarableReductionOp**
- class **org.nd4j.nativeblas.Nd4jCpu$DoubleGraphState**
- class **org.nd4j.nativeblas.Nd4jCpu$DoubleLogicOp**
- class **org.nd4j.nativeblas.Nd4jCpu$DoubleNDArray**
- class **org.nd4j.nativeblas.Nd4jCpu$DoubleNDArrayList**
- class **org.nd4j.nativeblas.Nd4jCpu$DoubleNDArrayVector$Iterator**
- class **org.nd4j.nativeblas.Nd4jCpu$DoubleNDArrayVector**
- class **org.nd4j.nativeblas.Nd4jCpu$DoubleOpArgsHolder**
- class **org.nd4j.nativeblas.Nd4jCpu$DoubleResultSet**
- class **org.nd4j.nativeblas.Nd4jCpu$DoubleStash**
- class **org.nd4j.nativeblas.Nd4jCpu$DoubleVariable**
- class **org.nd4j.nativeblas.Nd4jCpu$DoubleVariableSpace**
- class **org.nd4j.nativeblas.Nd4jCpu$DoubleVariablesSet**
- class **org.nd4j.nativeblas.Nd4jCpu$ExternalWorkspace**
- class **org.nd4j.nativeblas.Nd4jCpu$FloatBooleanOp**
- class **org.nd4j.nativeblas.Nd4jCpu$FloatBroadcastableOp**
- class **org.nd4j.nativeblas.Nd4jCpu$FloatContext**
- class **org.nd4j.nativeblas.Nd4jCpu$FloatContextPrototype**
- class **org.nd4j.nativeblas.Nd4jCpu$FloatDeclarableCustomOp**
- class **org.nd4j.nativeblas.Nd4jCpu$FloatDeclarableListOp**
- class **org.nd4j.nativeblas.Nd4jCpu$FloatDeclarableOp**
- class **org.nd4j.nativeblas.Nd4jCpu$FloatDeclarableReductionOp**
- class **org.nd4j.nativeblas.Nd4jCpu$FloatGraphState**
- class **org.nd4j.nativeblas.Nd4jCpu$FloatLogicOp**
- class **org.nd4j.nativeblas.Nd4jCpu$FloatNDArray**
- class **org.nd4j.nativeblas.Nd4jCpu$FloatNDArrayList**
- class **org.nd4j.nativeblas.Nd4jCpu$FloatNDArrayVector$Iterator**
- class **org.nd4j.nativeblas.Nd4jCpu$FloatNDArrayVector**
- class **org.nd4j.nativeblas.Nd4jCpu$FloatOpArgsHolder**
- class **org.nd4j.nativeblas.Nd4jCpu$FloatResultSet**
- class **org.nd4j.nativeblas.Nd4jCpu$FloatStash**
- class **org.nd4j.nativeblas.Nd4jCpu$FloatVariable**
- class **org.nd4j.nativeblas.Nd4jCpu$FloatVariableSpace**
- class **org.nd4j.nativeblas.Nd4jCpu$FloatVariablesSet**
- class **org.nd4j.nativeblas.Nd4jCpu$FlowPath**
- class **org.nd4j.nativeblas.Nd4jCpu$GraphProfile**
- class **org.nd4j.nativeblas.Nd4jCpu$HalfBooleanOp**
- class **org.nd4j.nativeblas.Nd4jCpu$HalfBroadcastableOp**
- class **org.nd4j.nativeblas.Nd4jCpu$HalfContext**
- class **org.nd4j.nativeblas.Nd4jCpu$HalfContextPrototype**
- class **org.nd4j.nativeblas.Nd4jCpu$HalfDeclarableCustomOp**
- class **org.nd4j.nativeblas.Nd4jCpu$HalfDeclarableListOp**
- class **org.nd4j.nativeblas.Nd4jCpu$HalfDeclarableOp**
- class **org.nd4j.nativeblas.Nd4jCpu$HalfDeclarableReductionOp**
- class **org.nd4j.nativeblas.Nd4jCpu$HalfGraphState**
- class **org.nd4j.nativeblas.Nd4jCpu$HalfLogicOp**
- class **org.nd4j.nativeblas.Nd4jCpu$HalfNDArray**
- class **org.nd4j.nativeblas.Nd4jCpu$HalfNDArrayList**
- class **org.nd4j.nativeblas.Nd4jCpu$HalfNDArrayVector$Iterator**
- class **org.nd4j.nativeblas.Nd4jCpu$HalfNDArrayVector**
- class **org.nd4j.nativeblas.Nd4jCpu$HalfOpArgsHolder**
- class **org.nd4j.nativeblas.Nd4jCpu$HalfResultSet**
- class **org.nd4j.nativeblas.Nd4jCpu$HalfStash**
- class **org.nd4j.nativeblas.Nd4jCpu$HalfVariable**
- class **org.nd4j.nativeblas.Nd4jCpu$HalfVariableSpace**
- class **org.nd4j.nativeblas.Nd4jCpu$HalfVariablesSet**
- class **org.nd4j.nativeblas.Nd4jCpu$IGenerator**
- class **org.nd4j.nativeblas.Nd4jCpu$IndicesList**
- class **org.nd4j.nativeblas.Nd4jCpu$IntIntPair**
- class **org.nd4j.nativeblas.Nd4jCpu$IntVectorVector**
- class **org.nd4j.nativeblas.Nd4jCpu$Intervals**
- class **org.nd4j.nativeblas.Nd4jCpu$KeyPair**
- class **org.nd4j.nativeblas.Nd4jCpu$LongVectorVector**
- class **org.nd4j.nativeblas.Nd4jCpu$NDIndex**
- class **org.nd4j.nativeblas.Nd4jCpu$NDIndexAll**
- class **org.nd4j.nativeblas.Nd4jCpu$NDIndexInterval**
- class **org.nd4j.nativeblas.Nd4jCpu$NDIndexPoint**
- class **org.nd4j.nativeblas.Nd4jCpu$NativeOps**
- class **org.nd4j.nativeblas.Nd4jCpu$NodeProfile**
- class **org.nd4j.nativeblas.Nd4jCpu$OpDescriptor**
- class **org.nd4j.nativeblas.Nd4jCpu$OpRegistrator**
- class **org.nd4j.nativeblas.Nd4jCpu$Pair**
- class **org.nd4j.nativeblas.Nd4jCpu$RandomBuffer**
- class **org.nd4j.nativeblas.Nd4jCpu$ResultWrapper**
- class **org.nd4j.nativeblas.Nd4jCpu$ShapeInformation**
- class **org.nd4j.nativeblas.Nd4jCpu$ShapeList**
- class **org.nd4j.nativeblas.Nd4jCpu$Workspace**
- class **org.nd4j.nativeblas.Nd4jCpu$Xoroshiro128**
- class **org.nd4j.nativeblas.Nd4jCpu$_loader**
- class **org.nd4j.nativeblas.Nd4jCpu$double_Conditional**
- class **org.nd4j.nativeblas.Nd4jCpu$double_Floor**
- class **org.nd4j.nativeblas.Nd4jCpu$double_Log1p**
- class **org.nd4j.nativeblas.Nd4jCpu$double_Return**
- class **org.nd4j.nativeblas.Nd4jCpu$double_Scope**
- class **org.nd4j.nativeblas.Nd4jCpu$double_Switch**
- class **org.nd4j.nativeblas.Nd4jCpu$double_Where**
- class **org.nd4j.nativeblas.Nd4jCpu$double_While**
- class **org.nd4j.nativeblas.Nd4jCpu$double_absolute_difference_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$double_add**
- class **org.nd4j.nativeblas.Nd4jCpu$double_add_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_adjust_hue**
- class **org.nd4j.nativeblas.Nd4jCpu$double_adjust_saturation**
- class **org.nd4j.nativeblas.Nd4jCpu$double_apply_sgd**
- class **org.nd4j.nativeblas.Nd4jCpu$double_argmax**
- class **org.nd4j.nativeblas.Nd4jCpu$double_argmin**
- class **org.nd4j.nativeblas.Nd4jCpu$double_assign**
- class **org.nd4j.nativeblas.Nd4jCpu$double_assign_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_avgpool2d**
- class **org.nd4j.nativeblas.Nd4jCpu$double_avgpool2d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_avgpool3d**
- class **org.nd4j.nativeblas.Nd4jCpu$double_avgpool3d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_avgpool3dnew**
- class **org.nd4j.nativeblas.Nd4jCpu$double_avgpool3dnew_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_axpy**
- class **org.nd4j.nativeblas.Nd4jCpu$double_batch_to_space**
- class **org.nd4j.nativeblas.Nd4jCpu$double_batched_gemm**
- class **org.nd4j.nativeblas.Nd4jCpu$double_batchnorm**
- class **org.nd4j.nativeblas.Nd4jCpu$double_batchnorm_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_betainc**
- class **org.nd4j.nativeblas.Nd4jCpu$double_biasadd**
- class **org.nd4j.nativeblas.Nd4jCpu$double_biasadd_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_bincount**
- class **org.nd4j.nativeblas.Nd4jCpu$double_boolean_and**
- class **org.nd4j.nativeblas.Nd4jCpu$double_boolean_or**
- class **org.nd4j.nativeblas.Nd4jCpu$double_broadcast_dynamic_shape**
- class **org.nd4j.nativeblas.Nd4jCpu$double_broadcastgradientargs**
- class **org.nd4j.nativeblas.Nd4jCpu$double_cast**
- class **org.nd4j.nativeblas.Nd4jCpu$double_choose**
- class **org.nd4j.nativeblas.Nd4jCpu$double_clip_by_global_norm**
- class **org.nd4j.nativeblas.Nd4jCpu$double_clipbyavgnorm**
- class **org.nd4j.nativeblas.Nd4jCpu$double_clipbynorm**
- class **org.nd4j.nativeblas.Nd4jCpu$double_clipbynorm_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_clipbyvalue**
- class **org.nd4j.nativeblas.Nd4jCpu$double_clone_list**
- class **org.nd4j.nativeblas.Nd4jCpu$double_col2im**
- class **org.nd4j.nativeblas.Nd4jCpu$double_concat**
- class **org.nd4j.nativeblas.Nd4jCpu$double_concat_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_confusion_matrix**
- class **org.nd4j.nativeblas.Nd4jCpu$double_conv1d**
- class **org.nd4j.nativeblas.Nd4jCpu$double_conv1d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_conv2d**
- class **org.nd4j.nativeblas.Nd4jCpu$double_conv2d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_conv2d_input_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_conv3d**
- class **org.nd4j.nativeblas.Nd4jCpu$double_conv3d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_conv3dnew**
- class **org.nd4j.nativeblas.Nd4jCpu$double_conv3dnew_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_cosine_distance_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$double_create_list**
- class **org.nd4j.nativeblas.Nd4jCpu$double_crelu**
- class **org.nd4j.nativeblas.Nd4jCpu$double_crelu_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_cross**
- class **org.nd4j.nativeblas.Nd4jCpu$double_cube**
- class **org.nd4j.nativeblas.Nd4jCpu$double_cube_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_cumprod**
- class **org.nd4j.nativeblas.Nd4jCpu$double_cumprod_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_cumsum**
- class **org.nd4j.nativeblas.Nd4jCpu$double_cumsum_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_deconv2d**
- class **org.nd4j.nativeblas.Nd4jCpu$double_deconv2d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_deconv2d_tf**
- class **org.nd4j.nativeblas.Nd4jCpu$double_depth_to_space**
- class **org.nd4j.nativeblas.Nd4jCpu$double_depthwise_conv2d**
- class **org.nd4j.nativeblas.Nd4jCpu$double_depthwise_conv2d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_diag**
- class **org.nd4j.nativeblas.Nd4jCpu$double_diag_part**
- class **org.nd4j.nativeblas.Nd4jCpu$double_dilation2d**
- class **org.nd4j.nativeblas.Nd4jCpu$double_divide**
- class **org.nd4j.nativeblas.Nd4jCpu$double_divide_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_dropout**
- class **org.nd4j.nativeblas.Nd4jCpu$double_dynamic_bidirectional_rnn**
- class **org.nd4j.nativeblas.Nd4jCpu$double_dynamic_partition**
- class **org.nd4j.nativeblas.Nd4jCpu$double_dynamic_rnn**
- class **org.nd4j.nativeblas.Nd4jCpu$double_dynamic_stitch**
- class **org.nd4j.nativeblas.Nd4jCpu$double_elu**
- class **org.nd4j.nativeblas.Nd4jCpu$double_elu_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_embedding_lookup**
- class **org.nd4j.nativeblas.Nd4jCpu$double_eq_scalar**
- class **org.nd4j.nativeblas.Nd4jCpu$double_equals**
- class **org.nd4j.nativeblas.Nd4jCpu$double_expand_dims**
- class **org.nd4j.nativeblas.Nd4jCpu$double_expose**
- class **org.nd4j.nativeblas.Nd4jCpu$double_extract_image_patches**
- class **org.nd4j.nativeblas.Nd4jCpu$double_eye**
- class **org.nd4j.nativeblas.Nd4jCpu$double_fill**
- class **org.nd4j.nativeblas.Nd4jCpu$double_fill_as**
- class **org.nd4j.nativeblas.Nd4jCpu$double_firas_sparse**
- class **org.nd4j.nativeblas.Nd4jCpu$double_floordiv**
- class **org.nd4j.nativeblas.Nd4jCpu$double_floordiv_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_floormod**
- class **org.nd4j.nativeblas.Nd4jCpu$double_floormod_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_fullconv3d**
- class **org.nd4j.nativeblas.Nd4jCpu$double_fullconv3d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_fullconv3d_grad**
- class **org.nd4j.nativeblas.Nd4jCpu$double_fused_batch_norm**
- class **org.nd4j.nativeblas.Nd4jCpu$double_gather**
- class **org.nd4j.nativeblas.Nd4jCpu$double_gather_list**
- class **org.nd4j.nativeblas.Nd4jCpu$double_gather_nd**
- class **org.nd4j.nativeblas.Nd4jCpu$double_get_seed**
- class **org.nd4j.nativeblas.Nd4jCpu$double_greater**
- class **org.nd4j.nativeblas.Nd4jCpu$double_greater_equal**
- class **org.nd4j.nativeblas.Nd4jCpu$double_gru**
- class **org.nd4j.nativeblas.Nd4jCpu$double_gruCell**
- class **org.nd4j.nativeblas.Nd4jCpu$double_gt_scalar**
- class **org.nd4j.nativeblas.Nd4jCpu$double_gte_scalar**
- class **org.nd4j.nativeblas.Nd4jCpu$double_hardsigmoid**
- class **org.nd4j.nativeblas.Nd4jCpu$double_hardsigmoid_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_hardtanh**
- class **org.nd4j.nativeblas.Nd4jCpu$double_hardtanh_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_hinge_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$double_huber_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$double_identity**
- class **org.nd4j.nativeblas.Nd4jCpu$double_identity_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_im2col**
- class **org.nd4j.nativeblas.Nd4jCpu$double_im2col_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_in_top_k**
- class **org.nd4j.nativeblas.Nd4jCpu$double_invert_permutation**
- class **org.nd4j.nativeblas.Nd4jCpu$double_is_non_decreasing**
- class **org.nd4j.nativeblas.Nd4jCpu$double_is_numeric_tensor**
- class **org.nd4j.nativeblas.Nd4jCpu$double_is_strictly_increasing**
- class **org.nd4j.nativeblas.Nd4jCpu$double_ismax**
- class **org.nd4j.nativeblas.Nd4jCpu$double_l2_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$double_less**
- class **org.nd4j.nativeblas.Nd4jCpu$double_less_equal**
- class **org.nd4j.nativeblas.Nd4jCpu$double_listdiff**
- class **org.nd4j.nativeblas.Nd4jCpu$double_log_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$double_log_poison_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$double_log_softmax**
- class **org.nd4j.nativeblas.Nd4jCpu$double_log_softmax_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_lrelu**
- class **org.nd4j.nativeblas.Nd4jCpu$double_lrelu_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_lrn**
- class **org.nd4j.nativeblas.Nd4jCpu$double_lrn_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_lrn_old**
- class **org.nd4j.nativeblas.Nd4jCpu$double_lstm**
- class **org.nd4j.nativeblas.Nd4jCpu$double_lstmCell**
- class **org.nd4j.nativeblas.Nd4jCpu$double_lt_scalar**
- class **org.nd4j.nativeblas.Nd4jCpu$double_lte_scalar**
- class **org.nd4j.nativeblas.Nd4jCpu$double_matmul**
- class **org.nd4j.nativeblas.Nd4jCpu$double_matrix_determinant**
- class **org.nd4j.nativeblas.Nd4jCpu$double_matrix_diag**
- class **org.nd4j.nativeblas.Nd4jCpu$double_matrix_diag_part**
- class **org.nd4j.nativeblas.Nd4jCpu$double_matrix_inverse**
- class **org.nd4j.nativeblas.Nd4jCpu$double_matrix_set_diag**
- class **org.nd4j.nativeblas.Nd4jCpu$double_max_pool_with_argmax**
- class **org.nd4j.nativeblas.Nd4jCpu$double_maximum**
- class **org.nd4j.nativeblas.Nd4jCpu$double_maximum_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_maxpool2d**
- class **org.nd4j.nativeblas.Nd4jCpu$double_maxpool2d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_maxpool3d**
- class **org.nd4j.nativeblas.Nd4jCpu$double_maxpool3d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_maxpool3dnew**
- class **org.nd4j.nativeblas.Nd4jCpu$double_maxpool3dnew_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_mean_pairwssqerr_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$double_mean_sqerr_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$double_mergeadd**
- class **org.nd4j.nativeblas.Nd4jCpu$double_mergeavg**
- class **org.nd4j.nativeblas.Nd4jCpu$double_mergemax**
- class **org.nd4j.nativeblas.Nd4jCpu$double_mergemaxindex**
- class **org.nd4j.nativeblas.Nd4jCpu$double_meshgrid**
- class **org.nd4j.nativeblas.Nd4jCpu$double_minimum**
- class **org.nd4j.nativeblas.Nd4jCpu$double_minimum_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_mirror_pad**
- class **org.nd4j.nativeblas.Nd4jCpu$double_mod**
- class **org.nd4j.nativeblas.Nd4jCpu$double_mod_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_moments**
- class **org.nd4j.nativeblas.Nd4jCpu$double_multiply**
- class **org.nd4j.nativeblas.Nd4jCpu$double_multiply_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_neq_scalar**
- class **org.nd4j.nativeblas.Nd4jCpu$double_noop**
- class **org.nd4j.nativeblas.Nd4jCpu$double_norm**
- class **org.nd4j.nativeblas.Nd4jCpu$double_normalize_moments**
- class **org.nd4j.nativeblas.Nd4jCpu$double_not_equals**
- class **org.nd4j.nativeblas.Nd4jCpu$double_onehot**
- class **org.nd4j.nativeblas.Nd4jCpu$double_ones_as**
- class **org.nd4j.nativeblas.Nd4jCpu$double_order**
- class **org.nd4j.nativeblas.Nd4jCpu$double_pad**
- class **org.nd4j.nativeblas.Nd4jCpu$double_parallel_stack**
- class **org.nd4j.nativeblas.Nd4jCpu$double_percentile**
- class **org.nd4j.nativeblas.Nd4jCpu$double_permute**
- class **org.nd4j.nativeblas.Nd4jCpu$double_pick_list**
- class **org.nd4j.nativeblas.Nd4jCpu$double_pnormpool2d**
- class **org.nd4j.nativeblas.Nd4jCpu$double_pnormpool2d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_pointwise_conv2d**
- class **org.nd4j.nativeblas.Nd4jCpu$double_polygamma**
- class **org.nd4j.nativeblas.Nd4jCpu$double_pooling2d**
- class **org.nd4j.nativeblas.Nd4jCpu$double_prelu**
- class **org.nd4j.nativeblas.Nd4jCpu$double_prelu_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_random_bernoulli**
- class **org.nd4j.nativeblas.Nd4jCpu$double_random_crop**
- class **org.nd4j.nativeblas.Nd4jCpu$double_random_exponential**
- class **org.nd4j.nativeblas.Nd4jCpu$double_random_normal**
- class **org.nd4j.nativeblas.Nd4jCpu$double_random_shuffle**
- class **org.nd4j.nativeblas.Nd4jCpu$double_randomuniform**
- class **org.nd4j.nativeblas.Nd4jCpu$double_range**
- class **org.nd4j.nativeblas.Nd4jCpu$double_rank**
- class **org.nd4j.nativeblas.Nd4jCpu$double_rationaltanh**
- class **org.nd4j.nativeblas.Nd4jCpu$double_rationaltanh_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_read_list**
- class **org.nd4j.nativeblas.Nd4jCpu$double_realdiv**
- class **org.nd4j.nativeblas.Nd4jCpu$double_realdiv_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_rectifiedtanh**
- class **org.nd4j.nativeblas.Nd4jCpu$double_rectifiedtanh_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reduce_dot_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reduce_max**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reduce_max_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reduce_mean**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reduce_mean_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reduce_min**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reduce_min_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reduce_norm1**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reduce_norm1_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reduce_norm2**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reduce_norm2_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reduce_norm_max**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reduce_norm_max_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reduce_prod**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reduce_prod_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reduce_sqnorm**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reduce_sqnorm_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reduce_stdev**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reduce_stdev_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reduce_sum**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reduce_sum_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reduce_variance**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reduce_variance_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_relu**
- class **org.nd4j.nativeblas.Nd4jCpu$double_relu6**
- class **org.nd4j.nativeblas.Nd4jCpu$double_relu6_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_relu_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_relu_layer**
- class **org.nd4j.nativeblas.Nd4jCpu$double_repeat**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reshape**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reshapeas**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reverse**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reverse_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reverse_sequence**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reversedivide**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reversedivide_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reversemod**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reversemod_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reversesubtract**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reversesubtract_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_rint**
- class **org.nd4j.nativeblas.Nd4jCpu$double_roll**
- class **org.nd4j.nativeblas.Nd4jCpu$double_scatter_add**
- class **org.nd4j.nativeblas.Nd4jCpu$double_scatter_div**
- class **org.nd4j.nativeblas.Nd4jCpu$double_scatter_list**
- class **org.nd4j.nativeblas.Nd4jCpu$double_scatter_max**
- class **org.nd4j.nativeblas.Nd4jCpu$double_scatter_min**
- class **org.nd4j.nativeblas.Nd4jCpu$double_scatter_mul**
- class **org.nd4j.nativeblas.Nd4jCpu$double_scatter_sub**
- class **org.nd4j.nativeblas.Nd4jCpu$double_scatter_upd**
- class **org.nd4j.nativeblas.Nd4jCpu$double_scatter_update**
- class **org.nd4j.nativeblas.Nd4jCpu$double_sconv2d**
- class **org.nd4j.nativeblas.Nd4jCpu$double_sconv2d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_segment_max**
- class **org.nd4j.nativeblas.Nd4jCpu$double_segment_mean**
- class **org.nd4j.nativeblas.Nd4jCpu$double_segment_min**
- class **org.nd4j.nativeblas.Nd4jCpu$double_segment_prod**
- class **org.nd4j.nativeblas.Nd4jCpu$double_segment_sum**
- class **org.nd4j.nativeblas.Nd4jCpu$double_select**
- class **org.nd4j.nativeblas.Nd4jCpu$double_selu**
- class **org.nd4j.nativeblas.Nd4jCpu$double_selu_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_sequence_mask**
- class **org.nd4j.nativeblas.Nd4jCpu$double_set_seed**
- class **org.nd4j.nativeblas.Nd4jCpu$double_shape_of**
- class **org.nd4j.nativeblas.Nd4jCpu$double_shapes_of**
- class **org.nd4j.nativeblas.Nd4jCpu$double_sigm_cross_entropy_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$double_sigmoid**
- class **org.nd4j.nativeblas.Nd4jCpu$double_sigmoid_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_size**
- class **org.nd4j.nativeblas.Nd4jCpu$double_size_at**
- class **org.nd4j.nativeblas.Nd4jCpu$double_size_list**
- class **org.nd4j.nativeblas.Nd4jCpu$double_slice**
- class **org.nd4j.nativeblas.Nd4jCpu$double_slice_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_softmax**
- class **org.nd4j.nativeblas.Nd4jCpu$double_softmax_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_softmax_cross_entropy_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$double_softmax_cross_entropy_loss_with_logits**
- class **org.nd4j.nativeblas.Nd4jCpu$double_softplus**
- class **org.nd4j.nativeblas.Nd4jCpu$double_softplus_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_softsign**
- class **org.nd4j.nativeblas.Nd4jCpu$double_softsign_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_space_to_batch**
- class **org.nd4j.nativeblas.Nd4jCpu$double_space_to_depth**
- class **org.nd4j.nativeblas.Nd4jCpu$double_split**
- class **org.nd4j.nativeblas.Nd4jCpu$double_split_list**
- class **org.nd4j.nativeblas.Nd4jCpu$double_split_v**
- class **org.nd4j.nativeblas.Nd4jCpu$double_square**
- class **org.nd4j.nativeblas.Nd4jCpu$double_squaredsubtract**
- class **org.nd4j.nativeblas.Nd4jCpu$double_squaredsubtract_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_squeeze**
- class **org.nd4j.nativeblas.Nd4jCpu$double_sru**
- class **org.nd4j.nativeblas.Nd4jCpu$double_sruCell**
- class **org.nd4j.nativeblas.Nd4jCpu$double_sru_bi**
- class **org.nd4j.nativeblas.Nd4jCpu$double_sru_bi_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_sru_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_sru_bp_logic**
- class **org.nd4j.nativeblas.Nd4jCpu$double_sru_logic**
- class **org.nd4j.nativeblas.Nd4jCpu$double_sru_old**
- class **org.nd4j.nativeblas.Nd4jCpu$double_stack**
- class **org.nd4j.nativeblas.Nd4jCpu$double_stack_list**
- class **org.nd4j.nativeblas.Nd4jCpu$double_static_bidirectional_rnn**
- class **org.nd4j.nativeblas.Nd4jCpu$double_static_rnn**
- class **org.nd4j.nativeblas.Nd4jCpu$double_stop_gradient**
- class **org.nd4j.nativeblas.Nd4jCpu$double_strided_slice**
- class **org.nd4j.nativeblas.Nd4jCpu$double_strided_slice_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_subtract**
- class **org.nd4j.nativeblas.Nd4jCpu$double_subtract_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_sufficient_statistics**
- class **org.nd4j.nativeblas.Nd4jCpu$double_svd**
- class **org.nd4j.nativeblas.Nd4jCpu$double_tanh**
- class **org.nd4j.nativeblas.Nd4jCpu$double_tanh_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_tear**
- class **org.nd4j.nativeblas.Nd4jCpu$double_tensormmul**
- class **org.nd4j.nativeblas.Nd4jCpu$double_test_output_reshape**
- class **org.nd4j.nativeblas.Nd4jCpu$double_test_scalar**
- class **org.nd4j.nativeblas.Nd4jCpu$double_testcustom**
- class **org.nd4j.nativeblas.Nd4jCpu$double_testop2i2o**
- class **org.nd4j.nativeblas.Nd4jCpu$double_testreduction**
- class **org.nd4j.nativeblas.Nd4jCpu$double_tf_atan2**
- class **org.nd4j.nativeblas.Nd4jCpu$double_thresholdedrelu**
- class **org.nd4j.nativeblas.Nd4jCpu$double_thresholdedrelu_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_tile**
- class **org.nd4j.nativeblas.Nd4jCpu$double_tile_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_tile_to_shape**
- class **org.nd4j.nativeblas.Nd4jCpu$double_tile_to_shape_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_to_double**
- class **org.nd4j.nativeblas.Nd4jCpu$double_to_float16**
- class **org.nd4j.nativeblas.Nd4jCpu$double_to_float32**
- class **org.nd4j.nativeblas.Nd4jCpu$double_to_int32**
- class **org.nd4j.nativeblas.Nd4jCpu$double_to_int64**
- class **org.nd4j.nativeblas.Nd4jCpu$double_to_uint32**
- class **org.nd4j.nativeblas.Nd4jCpu$double_to_uint64**
- class **org.nd4j.nativeblas.Nd4jCpu$double_toggle_bits**
- class **org.nd4j.nativeblas.Nd4jCpu$double_top_k**
- class **org.nd4j.nativeblas.Nd4jCpu$double_trace**
- class **org.nd4j.nativeblas.Nd4jCpu$double_transpose**
- class **org.nd4j.nativeblas.Nd4jCpu$double_tri**
- class **org.nd4j.nativeblas.Nd4jCpu$double_triu**
- class **org.nd4j.nativeblas.Nd4jCpu$double_triu_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_truncatediv**
- class **org.nd4j.nativeblas.Nd4jCpu$double_unique**
- class **org.nd4j.nativeblas.Nd4jCpu$double_unique_with_counts**
- class **org.nd4j.nativeblas.Nd4jCpu$double_unstack**
- class **org.nd4j.nativeblas.Nd4jCpu$double_unstack_list**
- class **org.nd4j.nativeblas.Nd4jCpu$double_upsampling2d**
- class **org.nd4j.nativeblas.Nd4jCpu$double_upsampling2d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_upsampling3d**
- class **org.nd4j.nativeblas.Nd4jCpu$double_upsampling3d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_weighted_cross_entropy_with_logits**
- class **org.nd4j.nativeblas.Nd4jCpu$double_where_np**
- class **org.nd4j.nativeblas.Nd4jCpu$double_write_list**
- class **org.nd4j.nativeblas.Nd4jCpu$double_xw_plus_b**
- class **org.nd4j.nativeblas.Nd4jCpu$double_zero_fraction**
- class **org.nd4j.nativeblas.Nd4jCpu$double_zeros_as**
- class **org.nd4j.nativeblas.Nd4jCpu$double_zeta**
- class **org.nd4j.nativeblas.Nd4jCpu$float_Conditional**
- class **org.nd4j.nativeblas.Nd4jCpu$float_Floor**
- class **org.nd4j.nativeblas.Nd4jCpu$float_Log1p**
- class **org.nd4j.nativeblas.Nd4jCpu$float_Return**
- class **org.nd4j.nativeblas.Nd4jCpu$float_Scope**
- class **org.nd4j.nativeblas.Nd4jCpu$float_Switch**
- class **org.nd4j.nativeblas.Nd4jCpu$float_Where**
- class **org.nd4j.nativeblas.Nd4jCpu$float_While**
- class **org.nd4j.nativeblas.Nd4jCpu$float_absolute_difference_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$float_add**
- class **org.nd4j.nativeblas.Nd4jCpu$float_add_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_adjust_hue**
- class **org.nd4j.nativeblas.Nd4jCpu$float_adjust_saturation**
- class **org.nd4j.nativeblas.Nd4jCpu$float_apply_sgd**
- class **org.nd4j.nativeblas.Nd4jCpu$float_argmax**
- class **org.nd4j.nativeblas.Nd4jCpu$float_argmin**
- class **org.nd4j.nativeblas.Nd4jCpu$float_assign**
- class **org.nd4j.nativeblas.Nd4jCpu$float_assign_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_avgpool2d**
- class **org.nd4j.nativeblas.Nd4jCpu$float_avgpool2d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_avgpool3d**
- class **org.nd4j.nativeblas.Nd4jCpu$float_avgpool3d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_avgpool3dnew**
- class **org.nd4j.nativeblas.Nd4jCpu$float_avgpool3dnew_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_axpy**
- class **org.nd4j.nativeblas.Nd4jCpu$float_batch_to_space**
- class **org.nd4j.nativeblas.Nd4jCpu$float_batched_gemm**
- class **org.nd4j.nativeblas.Nd4jCpu$float_batchnorm**
- class **org.nd4j.nativeblas.Nd4jCpu$float_batchnorm_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_betainc**
- class **org.nd4j.nativeblas.Nd4jCpu$float_biasadd**
- class **org.nd4j.nativeblas.Nd4jCpu$float_biasadd_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_bincount**
- class **org.nd4j.nativeblas.Nd4jCpu$float_boolean_and**
- class **org.nd4j.nativeblas.Nd4jCpu$float_boolean_or**
- class **org.nd4j.nativeblas.Nd4jCpu$float_broadcast_dynamic_shape**
- class **org.nd4j.nativeblas.Nd4jCpu$float_broadcastgradientargs**
- class **org.nd4j.nativeblas.Nd4jCpu$float_cast**
- class **org.nd4j.nativeblas.Nd4jCpu$float_choose**
- class **org.nd4j.nativeblas.Nd4jCpu$float_clip_by_global_norm**
- class **org.nd4j.nativeblas.Nd4jCpu$float_clipbyavgnorm**
- class **org.nd4j.nativeblas.Nd4jCpu$float_clipbynorm**
- class **org.nd4j.nativeblas.Nd4jCpu$float_clipbynorm_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_clipbyvalue**
- class **org.nd4j.nativeblas.Nd4jCpu$float_clone_list**
- class **org.nd4j.nativeblas.Nd4jCpu$float_col2im**
- class **org.nd4j.nativeblas.Nd4jCpu$float_concat**
- class **org.nd4j.nativeblas.Nd4jCpu$float_concat_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_confusion_matrix**
- class **org.nd4j.nativeblas.Nd4jCpu$float_conv1d**
- class **org.nd4j.nativeblas.Nd4jCpu$float_conv1d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_conv2d**
- class **org.nd4j.nativeblas.Nd4jCpu$float_conv2d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_conv2d_input_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_conv3d**
- class **org.nd4j.nativeblas.Nd4jCpu$float_conv3d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_conv3dnew**
- class **org.nd4j.nativeblas.Nd4jCpu$float_conv3dnew_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_cosine_distance_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$float_create_list**
- class **org.nd4j.nativeblas.Nd4jCpu$float_crelu**
- class **org.nd4j.nativeblas.Nd4jCpu$float_crelu_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_cross**
- class **org.nd4j.nativeblas.Nd4jCpu$float_cube**
- class **org.nd4j.nativeblas.Nd4jCpu$float_cube_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_cumprod**
- class **org.nd4j.nativeblas.Nd4jCpu$float_cumprod_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_cumsum**
- class **org.nd4j.nativeblas.Nd4jCpu$float_cumsum_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_deconv2d**
- class **org.nd4j.nativeblas.Nd4jCpu$float_deconv2d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_deconv2d_tf**
- class **org.nd4j.nativeblas.Nd4jCpu$float_depth_to_space**
- class **org.nd4j.nativeblas.Nd4jCpu$float_depthwise_conv2d**
- class **org.nd4j.nativeblas.Nd4jCpu$float_depthwise_conv2d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_diag**
- class **org.nd4j.nativeblas.Nd4jCpu$float_diag_part**
- class **org.nd4j.nativeblas.Nd4jCpu$float_dilation2d**
- class **org.nd4j.nativeblas.Nd4jCpu$float_divide**
- class **org.nd4j.nativeblas.Nd4jCpu$float_divide_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_dropout**
- class **org.nd4j.nativeblas.Nd4jCpu$float_dynamic_bidirectional_rnn**
- class **org.nd4j.nativeblas.Nd4jCpu$float_dynamic_partition**
- class **org.nd4j.nativeblas.Nd4jCpu$float_dynamic_rnn**
- class **org.nd4j.nativeblas.Nd4jCpu$float_dynamic_stitch**
- class **org.nd4j.nativeblas.Nd4jCpu$float_elu**
- class **org.nd4j.nativeblas.Nd4jCpu$float_elu_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_embedding_lookup**
- class **org.nd4j.nativeblas.Nd4jCpu$float_eq_scalar**
- class **org.nd4j.nativeblas.Nd4jCpu$float_equals**
- class **org.nd4j.nativeblas.Nd4jCpu$float_expand_dims**
- class **org.nd4j.nativeblas.Nd4jCpu$float_expose**
- class **org.nd4j.nativeblas.Nd4jCpu$float_extract_image_patches**
- class **org.nd4j.nativeblas.Nd4jCpu$float_eye**
- class **org.nd4j.nativeblas.Nd4jCpu$float_fill**
- class **org.nd4j.nativeblas.Nd4jCpu$float_fill_as**
- class **org.nd4j.nativeblas.Nd4jCpu$float_firas_sparse**
- class **org.nd4j.nativeblas.Nd4jCpu$float_floordiv**
- class **org.nd4j.nativeblas.Nd4jCpu$float_floordiv_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_floormod**
- class **org.nd4j.nativeblas.Nd4jCpu$float_floormod_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_fullconv3d**
- class **org.nd4j.nativeblas.Nd4jCpu$float_fullconv3d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_fullconv3d_grad**
- class **org.nd4j.nativeblas.Nd4jCpu$float_fused_batch_norm**
- class **org.nd4j.nativeblas.Nd4jCpu$float_gather**
- class **org.nd4j.nativeblas.Nd4jCpu$float_gather_list**
- class **org.nd4j.nativeblas.Nd4jCpu$float_gather_nd**
- class **org.nd4j.nativeblas.Nd4jCpu$float_get_seed**
- class **org.nd4j.nativeblas.Nd4jCpu$float_greater**
- class **org.nd4j.nativeblas.Nd4jCpu$float_greater_equal**
- class **org.nd4j.nativeblas.Nd4jCpu$float_gru**
- class **org.nd4j.nativeblas.Nd4jCpu$float_gruCell**
- class **org.nd4j.nativeblas.Nd4jCpu$float_gt_scalar**
- class **org.nd4j.nativeblas.Nd4jCpu$float_gte_scalar**
- class **org.nd4j.nativeblas.Nd4jCpu$float_hardsigmoid**
- class **org.nd4j.nativeblas.Nd4jCpu$float_hardsigmoid_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_hardtanh**
- class **org.nd4j.nativeblas.Nd4jCpu$float_hardtanh_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_hinge_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$float_huber_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$float_identity**
- class **org.nd4j.nativeblas.Nd4jCpu$float_identity_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_im2col**
- class **org.nd4j.nativeblas.Nd4jCpu$float_im2col_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_in_top_k**
- class **org.nd4j.nativeblas.Nd4jCpu$float_invert_permutation**
- class **org.nd4j.nativeblas.Nd4jCpu$float_is_non_decreasing**
- class **org.nd4j.nativeblas.Nd4jCpu$float_is_numeric_tensor**
- class **org.nd4j.nativeblas.Nd4jCpu$float_is_strictly_increasing**
- class **org.nd4j.nativeblas.Nd4jCpu$float_ismax**
- class **org.nd4j.nativeblas.Nd4jCpu$float_l2_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$float_less**
- class **org.nd4j.nativeblas.Nd4jCpu$float_less_equal**
- class **org.nd4j.nativeblas.Nd4jCpu$float_listdiff**
- class **org.nd4j.nativeblas.Nd4jCpu$float_log_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$float_log_poison_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$float_log_softmax**
- class **org.nd4j.nativeblas.Nd4jCpu$float_log_softmax_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_lrelu**
- class **org.nd4j.nativeblas.Nd4jCpu$float_lrelu_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_lrn**
- class **org.nd4j.nativeblas.Nd4jCpu$float_lrn_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_lrn_old**
- class **org.nd4j.nativeblas.Nd4jCpu$float_lstm**
- class **org.nd4j.nativeblas.Nd4jCpu$float_lstmCell**
- class **org.nd4j.nativeblas.Nd4jCpu$float_lt_scalar**
- class **org.nd4j.nativeblas.Nd4jCpu$float_lte_scalar**
- class **org.nd4j.nativeblas.Nd4jCpu$float_matmul**
- class **org.nd4j.nativeblas.Nd4jCpu$float_matrix_determinant**
- class **org.nd4j.nativeblas.Nd4jCpu$float_matrix_diag**
- class **org.nd4j.nativeblas.Nd4jCpu$float_matrix_diag_part**
- class **org.nd4j.nativeblas.Nd4jCpu$float_matrix_inverse**
- class **org.nd4j.nativeblas.Nd4jCpu$float_matrix_set_diag**
- class **org.nd4j.nativeblas.Nd4jCpu$float_max_pool_with_argmax**
- class **org.nd4j.nativeblas.Nd4jCpu$float_maximum**
- class **org.nd4j.nativeblas.Nd4jCpu$float_maximum_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_maxpool2d**
- class **org.nd4j.nativeblas.Nd4jCpu$float_maxpool2d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_maxpool3d**
- class **org.nd4j.nativeblas.Nd4jCpu$float_maxpool3d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_maxpool3dnew**
- class **org.nd4j.nativeblas.Nd4jCpu$float_maxpool3dnew_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_mean_pairwssqerr_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$float_mean_sqerr_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$float_mergeadd**
- class **org.nd4j.nativeblas.Nd4jCpu$float_mergeavg**
- class **org.nd4j.nativeblas.Nd4jCpu$float_mergemax**
- class **org.nd4j.nativeblas.Nd4jCpu$float_mergemaxindex**
- class **org.nd4j.nativeblas.Nd4jCpu$float_meshgrid**
- class **org.nd4j.nativeblas.Nd4jCpu$float_minimum**
- class **org.nd4j.nativeblas.Nd4jCpu$float_minimum_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_mirror_pad**
- class **org.nd4j.nativeblas.Nd4jCpu$float_mod**
- class **org.nd4j.nativeblas.Nd4jCpu$float_mod_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_moments**
- class **org.nd4j.nativeblas.Nd4jCpu$float_multiply**
- class **org.nd4j.nativeblas.Nd4jCpu$float_multiply_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_neq_scalar**
- class **org.nd4j.nativeblas.Nd4jCpu$float_noop**
- class **org.nd4j.nativeblas.Nd4jCpu$float_norm**
- class **org.nd4j.nativeblas.Nd4jCpu$float_normalize_moments**
- class **org.nd4j.nativeblas.Nd4jCpu$float_not_equals**
- class **org.nd4j.nativeblas.Nd4jCpu$float_onehot**
- class **org.nd4j.nativeblas.Nd4jCpu$float_ones_as**
- class **org.nd4j.nativeblas.Nd4jCpu$float_order**
- class **org.nd4j.nativeblas.Nd4jCpu$float_pad**
- class **org.nd4j.nativeblas.Nd4jCpu$float_parallel_stack**
- class **org.nd4j.nativeblas.Nd4jCpu$float_percentile**
- class **org.nd4j.nativeblas.Nd4jCpu$float_permute**
- class **org.nd4j.nativeblas.Nd4jCpu$float_pick_list**
- class **org.nd4j.nativeblas.Nd4jCpu$float_pnormpool2d**
- class **org.nd4j.nativeblas.Nd4jCpu$float_pnormpool2d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_pointwise_conv2d**
- class **org.nd4j.nativeblas.Nd4jCpu$float_polygamma**
- class **org.nd4j.nativeblas.Nd4jCpu$float_pooling2d**
- class **org.nd4j.nativeblas.Nd4jCpu$float_prelu**
- class **org.nd4j.nativeblas.Nd4jCpu$float_prelu_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_random_bernoulli**
- class **org.nd4j.nativeblas.Nd4jCpu$float_random_crop**
- class **org.nd4j.nativeblas.Nd4jCpu$float_random_exponential**
- class **org.nd4j.nativeblas.Nd4jCpu$float_random_normal**
- class **org.nd4j.nativeblas.Nd4jCpu$float_random_shuffle**
- class **org.nd4j.nativeblas.Nd4jCpu$float_randomuniform**
- class **org.nd4j.nativeblas.Nd4jCpu$float_range**
- class **org.nd4j.nativeblas.Nd4jCpu$float_rank**
- class **org.nd4j.nativeblas.Nd4jCpu$float_rationaltanh**
- class **org.nd4j.nativeblas.Nd4jCpu$float_rationaltanh_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_read_list**
- class **org.nd4j.nativeblas.Nd4jCpu$float_realdiv**
- class **org.nd4j.nativeblas.Nd4jCpu$float_realdiv_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_rectifiedtanh**
- class **org.nd4j.nativeblas.Nd4jCpu$float_rectifiedtanh_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reduce_dot_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reduce_max**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reduce_max_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reduce_mean**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reduce_mean_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reduce_min**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reduce_min_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reduce_norm1**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reduce_norm1_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reduce_norm2**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reduce_norm2_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reduce_norm_max**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reduce_norm_max_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reduce_prod**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reduce_prod_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reduce_sqnorm**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reduce_sqnorm_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reduce_stdev**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reduce_stdev_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reduce_sum**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reduce_sum_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reduce_variance**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reduce_variance_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_relu**
- class **org.nd4j.nativeblas.Nd4jCpu$float_relu6**
- class **org.nd4j.nativeblas.Nd4jCpu$float_relu6_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_relu_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_relu_layer**
- class **org.nd4j.nativeblas.Nd4jCpu$float_repeat**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reshape**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reshapeas**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reverse**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reverse_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reverse_sequence**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reversedivide**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reversedivide_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reversemod**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reversemod_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reversesubtract**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reversesubtract_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_rint**
- class **org.nd4j.nativeblas.Nd4jCpu$float_roll**
- class **org.nd4j.nativeblas.Nd4jCpu$float_scatter_add**
- class **org.nd4j.nativeblas.Nd4jCpu$float_scatter_div**
- class **org.nd4j.nativeblas.Nd4jCpu$float_scatter_list**
- class **org.nd4j.nativeblas.Nd4jCpu$float_scatter_max**
- class **org.nd4j.nativeblas.Nd4jCpu$float_scatter_min**
- class **org.nd4j.nativeblas.Nd4jCpu$float_scatter_mul**
- class **org.nd4j.nativeblas.Nd4jCpu$float_scatter_sub**
- class **org.nd4j.nativeblas.Nd4jCpu$float_scatter_upd**
- class **org.nd4j.nativeblas.Nd4jCpu$float_scatter_update**
- class **org.nd4j.nativeblas.Nd4jCpu$float_sconv2d**
- class **org.nd4j.nativeblas.Nd4jCpu$float_sconv2d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_segment_max**
- class **org.nd4j.nativeblas.Nd4jCpu$float_segment_mean**
- class **org.nd4j.nativeblas.Nd4jCpu$float_segment_min**
- class **org.nd4j.nativeblas.Nd4jCpu$float_segment_prod**
- class **org.nd4j.nativeblas.Nd4jCpu$float_segment_sum**
- class **org.nd4j.nativeblas.Nd4jCpu$float_select**
- class **org.nd4j.nativeblas.Nd4jCpu$float_selu**
- class **org.nd4j.nativeblas.Nd4jCpu$float_selu_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_sequence_mask**
- class **org.nd4j.nativeblas.Nd4jCpu$float_set_seed**
- class **org.nd4j.nativeblas.Nd4jCpu$float_shape_of**
- class **org.nd4j.nativeblas.Nd4jCpu$float_shapes_of**
- class **org.nd4j.nativeblas.Nd4jCpu$float_sigm_cross_entropy_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$float_sigmoid**
- class **org.nd4j.nativeblas.Nd4jCpu$float_sigmoid_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_size**
- class **org.nd4j.nativeblas.Nd4jCpu$float_size_at**
- class **org.nd4j.nativeblas.Nd4jCpu$float_size_list**
- class **org.nd4j.nativeblas.Nd4jCpu$float_slice**
- class **org.nd4j.nativeblas.Nd4jCpu$float_slice_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_softmax**
- class **org.nd4j.nativeblas.Nd4jCpu$float_softmax_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_softmax_cross_entropy_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$float_softmax_cross_entropy_loss_with_logits**
- class **org.nd4j.nativeblas.Nd4jCpu$float_softplus**
- class **org.nd4j.nativeblas.Nd4jCpu$float_softplus_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_softsign**
- class **org.nd4j.nativeblas.Nd4jCpu$float_softsign_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_space_to_batch**
- class **org.nd4j.nativeblas.Nd4jCpu$float_space_to_depth**
- class **org.nd4j.nativeblas.Nd4jCpu$float_split**
- class **org.nd4j.nativeblas.Nd4jCpu$float_split_list**
- class **org.nd4j.nativeblas.Nd4jCpu$float_split_v**
- class **org.nd4j.nativeblas.Nd4jCpu$float_square**
- class **org.nd4j.nativeblas.Nd4jCpu$float_squaredsubtract**
- class **org.nd4j.nativeblas.Nd4jCpu$float_squaredsubtract_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_squeeze**
- class **org.nd4j.nativeblas.Nd4jCpu$float_sru**
- class **org.nd4j.nativeblas.Nd4jCpu$float_sruCell**
- class **org.nd4j.nativeblas.Nd4jCpu$float_sru_bi**
- class **org.nd4j.nativeblas.Nd4jCpu$float_sru_bi_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_sru_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_sru_bp_logic**
- class **org.nd4j.nativeblas.Nd4jCpu$float_sru_logic**
- class **org.nd4j.nativeblas.Nd4jCpu$float_sru_old**
- class **org.nd4j.nativeblas.Nd4jCpu$float_stack**
- class **org.nd4j.nativeblas.Nd4jCpu$float_stack_list**
- class **org.nd4j.nativeblas.Nd4jCpu$float_static_bidirectional_rnn**
- class **org.nd4j.nativeblas.Nd4jCpu$float_static_rnn**
- class **org.nd4j.nativeblas.Nd4jCpu$float_stop_gradient**
- class **org.nd4j.nativeblas.Nd4jCpu$float_strided_slice**
- class **org.nd4j.nativeblas.Nd4jCpu$float_strided_slice_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_subtract**
- class **org.nd4j.nativeblas.Nd4jCpu$float_subtract_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_sufficient_statistics**
- class **org.nd4j.nativeblas.Nd4jCpu$float_svd**
- class **org.nd4j.nativeblas.Nd4jCpu$float_tanh**
- class **org.nd4j.nativeblas.Nd4jCpu$float_tanh_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_tear**
- class **org.nd4j.nativeblas.Nd4jCpu$float_tensormmul**
- class **org.nd4j.nativeblas.Nd4jCpu$float_test_output_reshape**
- class **org.nd4j.nativeblas.Nd4jCpu$float_test_scalar**
- class **org.nd4j.nativeblas.Nd4jCpu$float_testcustom**
- class **org.nd4j.nativeblas.Nd4jCpu$float_testop2i2o**
- class **org.nd4j.nativeblas.Nd4jCpu$float_testreduction**
- class **org.nd4j.nativeblas.Nd4jCpu$float_tf_atan2**
- class **org.nd4j.nativeblas.Nd4jCpu$float_thresholdedrelu**
- class **org.nd4j.nativeblas.Nd4jCpu$float_thresholdedrelu_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_tile**
- class **org.nd4j.nativeblas.Nd4jCpu$float_tile_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_tile_to_shape**
- class **org.nd4j.nativeblas.Nd4jCpu$float_tile_to_shape_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_to_double**
- class **org.nd4j.nativeblas.Nd4jCpu$float_to_float16**
- class **org.nd4j.nativeblas.Nd4jCpu$float_to_float32**
- class **org.nd4j.nativeblas.Nd4jCpu$float_to_int32**
- class **org.nd4j.nativeblas.Nd4jCpu$float_to_int64**
- class **org.nd4j.nativeblas.Nd4jCpu$float_to_uint32**
- class **org.nd4j.nativeblas.Nd4jCpu$float_to_uint64**
- class **org.nd4j.nativeblas.Nd4jCpu$float_toggle_bits**
- class **org.nd4j.nativeblas.Nd4jCpu$float_top_k**
- class **org.nd4j.nativeblas.Nd4jCpu$float_trace**
- class **org.nd4j.nativeblas.Nd4jCpu$float_transpose**
- class **org.nd4j.nativeblas.Nd4jCpu$float_tri**
- class **org.nd4j.nativeblas.Nd4jCpu$float_triu**
- class **org.nd4j.nativeblas.Nd4jCpu$float_triu_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_truncatediv**
- class **org.nd4j.nativeblas.Nd4jCpu$float_unique**
- class **org.nd4j.nativeblas.Nd4jCpu$float_unique_with_counts**
- class **org.nd4j.nativeblas.Nd4jCpu$float_unstack**
- class **org.nd4j.nativeblas.Nd4jCpu$float_unstack_list**
- class **org.nd4j.nativeblas.Nd4jCpu$float_upsampling2d**
- class **org.nd4j.nativeblas.Nd4jCpu$float_upsampling2d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_upsampling3d**
- class **org.nd4j.nativeblas.Nd4jCpu$float_upsampling3d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_weighted_cross_entropy_with_logits**
- class **org.nd4j.nativeblas.Nd4jCpu$float_where_np**
- class **org.nd4j.nativeblas.Nd4jCpu$float_write_list**
- class **org.nd4j.nativeblas.Nd4jCpu$float_xw_plus_b**
- class **org.nd4j.nativeblas.Nd4jCpu$float_zero_fraction**
- class **org.nd4j.nativeblas.Nd4jCpu$float_zeros_as**
- class **org.nd4j.nativeblas.Nd4jCpu$float_zeta**
- class **org.nd4j.nativeblas.Nd4jCpu$half_Conditional**
- class **org.nd4j.nativeblas.Nd4jCpu$half_Floor**
- class **org.nd4j.nativeblas.Nd4jCpu$half_Log1p**
- class **org.nd4j.nativeblas.Nd4jCpu$half_Return**
- class **org.nd4j.nativeblas.Nd4jCpu$half_Scope**
- class **org.nd4j.nativeblas.Nd4jCpu$half_Switch**
- class **org.nd4j.nativeblas.Nd4jCpu$half_Where**
- class **org.nd4j.nativeblas.Nd4jCpu$half_While**
- class **org.nd4j.nativeblas.Nd4jCpu$half_absolute_difference_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$half_add**
- class **org.nd4j.nativeblas.Nd4jCpu$half_add_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_adjust_hue**
- class **org.nd4j.nativeblas.Nd4jCpu$half_adjust_saturation**
- class **org.nd4j.nativeblas.Nd4jCpu$half_apply_sgd**
- class **org.nd4j.nativeblas.Nd4jCpu$half_argmax**
- class **org.nd4j.nativeblas.Nd4jCpu$half_argmin**
- class **org.nd4j.nativeblas.Nd4jCpu$half_assign**
- class **org.nd4j.nativeblas.Nd4jCpu$half_assign_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_avgpool2d**
- class **org.nd4j.nativeblas.Nd4jCpu$half_avgpool2d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_avgpool3d**
- class **org.nd4j.nativeblas.Nd4jCpu$half_avgpool3d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_avgpool3dnew**
- class **org.nd4j.nativeblas.Nd4jCpu$half_avgpool3dnew_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_axpy**
- class **org.nd4j.nativeblas.Nd4jCpu$half_batch_to_space**
- class **org.nd4j.nativeblas.Nd4jCpu$half_batched_gemm**
- class **org.nd4j.nativeblas.Nd4jCpu$half_batchnorm**
- class **org.nd4j.nativeblas.Nd4jCpu$half_batchnorm_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_betainc**
- class **org.nd4j.nativeblas.Nd4jCpu$half_biasadd**
- class **org.nd4j.nativeblas.Nd4jCpu$half_biasadd_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_bincount**
- class **org.nd4j.nativeblas.Nd4jCpu$half_boolean_and**
- class **org.nd4j.nativeblas.Nd4jCpu$half_boolean_or**
- class **org.nd4j.nativeblas.Nd4jCpu$half_broadcast_dynamic_shape**
- class **org.nd4j.nativeblas.Nd4jCpu$half_broadcastgradientargs**
- class **org.nd4j.nativeblas.Nd4jCpu$half_cast**
- class **org.nd4j.nativeblas.Nd4jCpu$half_choose**
- class **org.nd4j.nativeblas.Nd4jCpu$half_clip_by_global_norm**
- class **org.nd4j.nativeblas.Nd4jCpu$half_clipbyavgnorm**
- class **org.nd4j.nativeblas.Nd4jCpu$half_clipbynorm**
- class **org.nd4j.nativeblas.Nd4jCpu$half_clipbynorm_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_clipbyvalue**
- class **org.nd4j.nativeblas.Nd4jCpu$half_clone_list**
- class **org.nd4j.nativeblas.Nd4jCpu$half_col2im**
- class **org.nd4j.nativeblas.Nd4jCpu$half_concat**
- class **org.nd4j.nativeblas.Nd4jCpu$half_concat_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_confusion_matrix**
- class **org.nd4j.nativeblas.Nd4jCpu$half_conv1d**
- class **org.nd4j.nativeblas.Nd4jCpu$half_conv1d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_conv2d**
- class **org.nd4j.nativeblas.Nd4jCpu$half_conv2d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_conv2d_input_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_conv3d**
- class **org.nd4j.nativeblas.Nd4jCpu$half_conv3d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_conv3dnew**
- class **org.nd4j.nativeblas.Nd4jCpu$half_conv3dnew_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_cosine_distance_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$half_create_list**
- class **org.nd4j.nativeblas.Nd4jCpu$half_crelu**
- class **org.nd4j.nativeblas.Nd4jCpu$half_crelu_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_cross**
- class **org.nd4j.nativeblas.Nd4jCpu$half_cube**
- class **org.nd4j.nativeblas.Nd4jCpu$half_cube_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_cumprod**
- class **org.nd4j.nativeblas.Nd4jCpu$half_cumprod_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_cumsum**
- class **org.nd4j.nativeblas.Nd4jCpu$half_cumsum_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_deconv2d**
- class **org.nd4j.nativeblas.Nd4jCpu$half_deconv2d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_deconv2d_tf**
- class **org.nd4j.nativeblas.Nd4jCpu$half_depth_to_space**
- class **org.nd4j.nativeblas.Nd4jCpu$half_depthwise_conv2d**
- class **org.nd4j.nativeblas.Nd4jCpu$half_depthwise_conv2d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_diag**
- class **org.nd4j.nativeblas.Nd4jCpu$half_diag_part**
- class **org.nd4j.nativeblas.Nd4jCpu$half_dilation2d**
- class **org.nd4j.nativeblas.Nd4jCpu$half_divide**
- class **org.nd4j.nativeblas.Nd4jCpu$half_divide_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_dropout**
- class **org.nd4j.nativeblas.Nd4jCpu$half_dynamic_bidirectional_rnn**
- class **org.nd4j.nativeblas.Nd4jCpu$half_dynamic_partition**
- class **org.nd4j.nativeblas.Nd4jCpu$half_dynamic_rnn**
- class **org.nd4j.nativeblas.Nd4jCpu$half_dynamic_stitch**
- class **org.nd4j.nativeblas.Nd4jCpu$half_elu**
- class **org.nd4j.nativeblas.Nd4jCpu$half_elu_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_embedding_lookup**
- class **org.nd4j.nativeblas.Nd4jCpu$half_eq_scalar**
- class **org.nd4j.nativeblas.Nd4jCpu$half_equals**
- class **org.nd4j.nativeblas.Nd4jCpu$half_expand_dims**
- class **org.nd4j.nativeblas.Nd4jCpu$half_expose**
- class **org.nd4j.nativeblas.Nd4jCpu$half_extract_image_patches**
- class **org.nd4j.nativeblas.Nd4jCpu$half_eye**
- class **org.nd4j.nativeblas.Nd4jCpu$half_fill**
- class **org.nd4j.nativeblas.Nd4jCpu$half_fill_as**
- class **org.nd4j.nativeblas.Nd4jCpu$half_firas_sparse**
- class **org.nd4j.nativeblas.Nd4jCpu$half_floordiv**
- class **org.nd4j.nativeblas.Nd4jCpu$half_floordiv_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_floormod**
- class **org.nd4j.nativeblas.Nd4jCpu$half_floormod_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_fullconv3d**
- class **org.nd4j.nativeblas.Nd4jCpu$half_fullconv3d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_fullconv3d_grad**
- class **org.nd4j.nativeblas.Nd4jCpu$half_fused_batch_norm**
- class **org.nd4j.nativeblas.Nd4jCpu$half_gather**
- class **org.nd4j.nativeblas.Nd4jCpu$half_gather_list**
- class **org.nd4j.nativeblas.Nd4jCpu$half_gather_nd**
- class **org.nd4j.nativeblas.Nd4jCpu$half_get_seed**
- class **org.nd4j.nativeblas.Nd4jCpu$half_greater**
- class **org.nd4j.nativeblas.Nd4jCpu$half_greater_equal**
- class **org.nd4j.nativeblas.Nd4jCpu$half_gru**
- class **org.nd4j.nativeblas.Nd4jCpu$half_gruCell**
- class **org.nd4j.nativeblas.Nd4jCpu$half_gt_scalar**
- class **org.nd4j.nativeblas.Nd4jCpu$half_gte_scalar**
- class **org.nd4j.nativeblas.Nd4jCpu$half_hardsigmoid**
- class **org.nd4j.nativeblas.Nd4jCpu$half_hardsigmoid_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_hardtanh**
- class **org.nd4j.nativeblas.Nd4jCpu$half_hardtanh_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_hinge_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$half_huber_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$half_identity**
- class **org.nd4j.nativeblas.Nd4jCpu$half_identity_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_im2col**
- class **org.nd4j.nativeblas.Nd4jCpu$half_im2col_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_in_top_k**
- class **org.nd4j.nativeblas.Nd4jCpu$half_invert_permutation**
- class **org.nd4j.nativeblas.Nd4jCpu$half_is_non_decreasing**
- class **org.nd4j.nativeblas.Nd4jCpu$half_is_numeric_tensor**
- class **org.nd4j.nativeblas.Nd4jCpu$half_is_strictly_increasing**
- class **org.nd4j.nativeblas.Nd4jCpu$half_ismax**
- class **org.nd4j.nativeblas.Nd4jCpu$half_l2_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$half_less**
- class **org.nd4j.nativeblas.Nd4jCpu$half_less_equal**
- class **org.nd4j.nativeblas.Nd4jCpu$half_listdiff**
- class **org.nd4j.nativeblas.Nd4jCpu$half_log_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$half_log_poison_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$half_log_softmax**
- class **org.nd4j.nativeblas.Nd4jCpu$half_log_softmax_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_lrelu**
- class **org.nd4j.nativeblas.Nd4jCpu$half_lrelu_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_lrn**
- class **org.nd4j.nativeblas.Nd4jCpu$half_lrn_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_lrn_old**
- class **org.nd4j.nativeblas.Nd4jCpu$half_lstm**
- class **org.nd4j.nativeblas.Nd4jCpu$half_lstmCell**
- class **org.nd4j.nativeblas.Nd4jCpu$half_lt_scalar**
- class **org.nd4j.nativeblas.Nd4jCpu$half_lte_scalar**
- class **org.nd4j.nativeblas.Nd4jCpu$half_matmul**
- class **org.nd4j.nativeblas.Nd4jCpu$half_matrix_determinant**
- class **org.nd4j.nativeblas.Nd4jCpu$half_matrix_diag**
- class **org.nd4j.nativeblas.Nd4jCpu$half_matrix_diag_part**
- class **org.nd4j.nativeblas.Nd4jCpu$half_matrix_inverse**
- class **org.nd4j.nativeblas.Nd4jCpu$half_matrix_set_diag**
- class **org.nd4j.nativeblas.Nd4jCpu$half_max_pool_with_argmax**
- class **org.nd4j.nativeblas.Nd4jCpu$half_maximum**
- class **org.nd4j.nativeblas.Nd4jCpu$half_maximum_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_maxpool2d**
- class **org.nd4j.nativeblas.Nd4jCpu$half_maxpool2d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_maxpool3d**
- class **org.nd4j.nativeblas.Nd4jCpu$half_maxpool3d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_maxpool3dnew**
- class **org.nd4j.nativeblas.Nd4jCpu$half_maxpool3dnew_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_mean_pairwssqerr_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$half_mean_sqerr_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$half_mergeadd**
- class **org.nd4j.nativeblas.Nd4jCpu$half_mergeavg**
- class **org.nd4j.nativeblas.Nd4jCpu$half_mergemax**
- class **org.nd4j.nativeblas.Nd4jCpu$half_mergemaxindex**
- class **org.nd4j.nativeblas.Nd4jCpu$half_meshgrid**
- class **org.nd4j.nativeblas.Nd4jCpu$half_minimum**
- class **org.nd4j.nativeblas.Nd4jCpu$half_minimum_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_mirror_pad**
- class **org.nd4j.nativeblas.Nd4jCpu$half_mod**
- class **org.nd4j.nativeblas.Nd4jCpu$half_mod_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_moments**
- class **org.nd4j.nativeblas.Nd4jCpu$half_multiply**
- class **org.nd4j.nativeblas.Nd4jCpu$half_multiply_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_neq_scalar**
- class **org.nd4j.nativeblas.Nd4jCpu$half_noop**
- class **org.nd4j.nativeblas.Nd4jCpu$half_norm**
- class **org.nd4j.nativeblas.Nd4jCpu$half_normalize_moments**
- class **org.nd4j.nativeblas.Nd4jCpu$half_not_equals**
- class **org.nd4j.nativeblas.Nd4jCpu$half_onehot**
- class **org.nd4j.nativeblas.Nd4jCpu$half_ones_as**
- class **org.nd4j.nativeblas.Nd4jCpu$half_order**
- class **org.nd4j.nativeblas.Nd4jCpu$half_pad**
- class **org.nd4j.nativeblas.Nd4jCpu$half_parallel_stack**
- class **org.nd4j.nativeblas.Nd4jCpu$half_percentile**
- class **org.nd4j.nativeblas.Nd4jCpu$half_permute**
- class **org.nd4j.nativeblas.Nd4jCpu$half_pick_list**
- class **org.nd4j.nativeblas.Nd4jCpu$half_pnormpool2d**
- class **org.nd4j.nativeblas.Nd4jCpu$half_pnormpool2d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_pointwise_conv2d**
- class **org.nd4j.nativeblas.Nd4jCpu$half_polygamma**
- class **org.nd4j.nativeblas.Nd4jCpu$half_pooling2d**
- class **org.nd4j.nativeblas.Nd4jCpu$half_prelu**
- class **org.nd4j.nativeblas.Nd4jCpu$half_prelu_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_random_bernoulli**
- class **org.nd4j.nativeblas.Nd4jCpu$half_random_crop**
- class **org.nd4j.nativeblas.Nd4jCpu$half_random_exponential**
- class **org.nd4j.nativeblas.Nd4jCpu$half_random_normal**
- class **org.nd4j.nativeblas.Nd4jCpu$half_random_shuffle**
- class **org.nd4j.nativeblas.Nd4jCpu$half_randomuniform**
- class **org.nd4j.nativeblas.Nd4jCpu$half_range**
- class **org.nd4j.nativeblas.Nd4jCpu$half_rank**
- class **org.nd4j.nativeblas.Nd4jCpu$half_rationaltanh**
- class **org.nd4j.nativeblas.Nd4jCpu$half_rationaltanh_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_read_list**
- class **org.nd4j.nativeblas.Nd4jCpu$half_realdiv**
- class **org.nd4j.nativeblas.Nd4jCpu$half_realdiv_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_rectifiedtanh**
- class **org.nd4j.nativeblas.Nd4jCpu$half_rectifiedtanh_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reduce_dot_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reduce_max**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reduce_max_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reduce_mean**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reduce_mean_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reduce_min**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reduce_min_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reduce_norm1**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reduce_norm1_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reduce_norm2**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reduce_norm2_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reduce_norm_max**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reduce_norm_max_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reduce_prod**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reduce_prod_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reduce_sqnorm**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reduce_sqnorm_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reduce_stdev**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reduce_stdev_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reduce_sum**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reduce_sum_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reduce_variance**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reduce_variance_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_relu**
- class **org.nd4j.nativeblas.Nd4jCpu$half_relu6**
- class **org.nd4j.nativeblas.Nd4jCpu$half_relu6_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_relu_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_relu_layer**
- class **org.nd4j.nativeblas.Nd4jCpu$half_repeat**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reshape**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reshapeas**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reverse**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reverse_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reverse_sequence**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reversedivide**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reversedivide_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reversemod**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reversemod_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reversesubtract**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reversesubtract_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_rint**
- class **org.nd4j.nativeblas.Nd4jCpu$half_roll**
- class **org.nd4j.nativeblas.Nd4jCpu$half_scatter_add**
- class **org.nd4j.nativeblas.Nd4jCpu$half_scatter_div**
- class **org.nd4j.nativeblas.Nd4jCpu$half_scatter_list**
- class **org.nd4j.nativeblas.Nd4jCpu$half_scatter_max**
- class **org.nd4j.nativeblas.Nd4jCpu$half_scatter_min**
- class **org.nd4j.nativeblas.Nd4jCpu$half_scatter_mul**
- class **org.nd4j.nativeblas.Nd4jCpu$half_scatter_sub**
- class **org.nd4j.nativeblas.Nd4jCpu$half_scatter_upd**
- class **org.nd4j.nativeblas.Nd4jCpu$half_scatter_update**
- class **org.nd4j.nativeblas.Nd4jCpu$half_sconv2d**
- class **org.nd4j.nativeblas.Nd4jCpu$half_sconv2d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_segment_max**
- class **org.nd4j.nativeblas.Nd4jCpu$half_segment_mean**
- class **org.nd4j.nativeblas.Nd4jCpu$half_segment_min**
- class **org.nd4j.nativeblas.Nd4jCpu$half_segment_prod**
- class **org.nd4j.nativeblas.Nd4jCpu$half_segment_sum**
- class **org.nd4j.nativeblas.Nd4jCpu$half_select**
- class **org.nd4j.nativeblas.Nd4jCpu$half_selu**
- class **org.nd4j.nativeblas.Nd4jCpu$half_selu_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_sequence_mask**
- class **org.nd4j.nativeblas.Nd4jCpu$half_set_seed**
- class **org.nd4j.nativeblas.Nd4jCpu$half_shape_of**
- class **org.nd4j.nativeblas.Nd4jCpu$half_shapes_of**
- class **org.nd4j.nativeblas.Nd4jCpu$half_sigm_cross_entropy_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$half_sigmoid**
- class **org.nd4j.nativeblas.Nd4jCpu$half_sigmoid_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_size**
- class **org.nd4j.nativeblas.Nd4jCpu$half_size_at**
- class **org.nd4j.nativeblas.Nd4jCpu$half_size_list**
- class **org.nd4j.nativeblas.Nd4jCpu$half_slice**
- class **org.nd4j.nativeblas.Nd4jCpu$half_slice_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_softmax**
- class **org.nd4j.nativeblas.Nd4jCpu$half_softmax_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_softmax_cross_entropy_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$half_softmax_cross_entropy_loss_with_logits**
- class **org.nd4j.nativeblas.Nd4jCpu$half_softplus**
- class **org.nd4j.nativeblas.Nd4jCpu$half_softplus_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_softsign**
- class **org.nd4j.nativeblas.Nd4jCpu$half_softsign_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_space_to_batch**
- class **org.nd4j.nativeblas.Nd4jCpu$half_space_to_depth**
- class **org.nd4j.nativeblas.Nd4jCpu$half_split**
- class **org.nd4j.nativeblas.Nd4jCpu$half_split_list**
- class **org.nd4j.nativeblas.Nd4jCpu$half_split_v**
- class **org.nd4j.nativeblas.Nd4jCpu$half_square**
- class **org.nd4j.nativeblas.Nd4jCpu$half_squaredsubtract**
- class **org.nd4j.nativeblas.Nd4jCpu$half_squaredsubtract_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_squeeze**
- class **org.nd4j.nativeblas.Nd4jCpu$half_sru**
- class **org.nd4j.nativeblas.Nd4jCpu$half_sruCell**
- class **org.nd4j.nativeblas.Nd4jCpu$half_sru_bi**
- class **org.nd4j.nativeblas.Nd4jCpu$half_sru_bi_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_sru_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_sru_bp_logic**
- class **org.nd4j.nativeblas.Nd4jCpu$half_sru_logic**
- class **org.nd4j.nativeblas.Nd4jCpu$half_sru_old**
- class **org.nd4j.nativeblas.Nd4jCpu$half_stack**
- class **org.nd4j.nativeblas.Nd4jCpu$half_stack_list**
- class **org.nd4j.nativeblas.Nd4jCpu$half_static_bidirectional_rnn**
- class **org.nd4j.nativeblas.Nd4jCpu$half_static_rnn**
- class **org.nd4j.nativeblas.Nd4jCpu$half_stop_gradient**
- class **org.nd4j.nativeblas.Nd4jCpu$half_strided_slice**
- class **org.nd4j.nativeblas.Nd4jCpu$half_strided_slice_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_subtract**
- class **org.nd4j.nativeblas.Nd4jCpu$half_subtract_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_sufficient_statistics**
- class **org.nd4j.nativeblas.Nd4jCpu$half_svd**
- class **org.nd4j.nativeblas.Nd4jCpu$half_tanh**
- class **org.nd4j.nativeblas.Nd4jCpu$half_tanh_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_tear**
- class **org.nd4j.nativeblas.Nd4jCpu$half_tensormmul**
- class **org.nd4j.nativeblas.Nd4jCpu$half_test_output_reshape**
- class **org.nd4j.nativeblas.Nd4jCpu$half_test_scalar**
- class **org.nd4j.nativeblas.Nd4jCpu$half_testcustom**
- class **org.nd4j.nativeblas.Nd4jCpu$half_testop2i2o**
- class **org.nd4j.nativeblas.Nd4jCpu$half_testreduction**
- class **org.nd4j.nativeblas.Nd4jCpu$half_tf_atan2**
- class **org.nd4j.nativeblas.Nd4jCpu$half_thresholdedrelu**
- class **org.nd4j.nativeblas.Nd4jCpu$half_thresholdedrelu_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_tile**
- class **org.nd4j.nativeblas.Nd4jCpu$half_tile_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_tile_to_shape**
- class **org.nd4j.nativeblas.Nd4jCpu$half_tile_to_shape_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_to_double**
- class **org.nd4j.nativeblas.Nd4jCpu$half_to_float16**
- class **org.nd4j.nativeblas.Nd4jCpu$half_to_float32**
- class **org.nd4j.nativeblas.Nd4jCpu$half_to_int32**
- class **org.nd4j.nativeblas.Nd4jCpu$half_to_int64**
- class **org.nd4j.nativeblas.Nd4jCpu$half_to_uint32**
- class **org.nd4j.nativeblas.Nd4jCpu$half_to_uint64**
- class **org.nd4j.nativeblas.Nd4jCpu$half_toggle_bits**
- class **org.nd4j.nativeblas.Nd4jCpu$half_top_k**
- class **org.nd4j.nativeblas.Nd4jCpu$half_trace**
- class **org.nd4j.nativeblas.Nd4jCpu$half_transpose**
- class **org.nd4j.nativeblas.Nd4jCpu$half_tri**
- class **org.nd4j.nativeblas.Nd4jCpu$half_triu**
- class **org.nd4j.nativeblas.Nd4jCpu$half_triu_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_truncatediv**
- class **org.nd4j.nativeblas.Nd4jCpu$half_unique**
- class **org.nd4j.nativeblas.Nd4jCpu$half_unique_with_counts**
- class **org.nd4j.nativeblas.Nd4jCpu$half_unstack**
- class **org.nd4j.nativeblas.Nd4jCpu$half_unstack_list**
- class **org.nd4j.nativeblas.Nd4jCpu$half_upsampling2d**
- class **org.nd4j.nativeblas.Nd4jCpu$half_upsampling2d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_upsampling3d**
- class **org.nd4j.nativeblas.Nd4jCpu$half_upsampling3d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_weighted_cross_entropy_with_logits**
- class **org.nd4j.nativeblas.Nd4jCpu$half_where_np**
- class **org.nd4j.nativeblas.Nd4jCpu$half_write_list**
- class **org.nd4j.nativeblas.Nd4jCpu$half_xw_plus_b**
- class **org.nd4j.nativeblas.Nd4jCpu$half_zero_fraction**
- class **org.nd4j.nativeblas.Nd4jCpu$half_zeros_as**
- class **org.nd4j.nativeblas.Nd4jCpu$half_zeta**
- class **org.nd4j.nativeblas.Nd4jCpu**
- class **org.nd4j.nativeblas.Nd4jCpuPresets**
- class **org.nd4j.nativeblas.Nd4jCuda$ArgumentsList**
- class **org.nd4j.nativeblas.Nd4jCuda$CurrentIndexing**
- class **org.nd4j.nativeblas.Nd4jCuda$DoubleBooleanOp**
- class **org.nd4j.nativeblas.Nd4jCuda$DoubleBroadcastableOp**
- class **org.nd4j.nativeblas.Nd4jCuda$DoubleContext**
- class **org.nd4j.nativeblas.Nd4jCuda$DoubleContextPrototype**
- class **org.nd4j.nativeblas.Nd4jCuda$DoubleDeclarableCustomOp**
- class **org.nd4j.nativeblas.Nd4jCuda$DoubleDeclarableListOp**
- class **org.nd4j.nativeblas.Nd4jCuda$DoubleDeclarableOp**
- class **org.nd4j.nativeblas.Nd4jCuda$DoubleDeclarableReductionOp**
- class **org.nd4j.nativeblas.Nd4jCuda$DoubleGraphState**
- class **org.nd4j.nativeblas.Nd4jCuda$DoubleLogicOp**
- class **org.nd4j.nativeblas.Nd4jCuda$DoubleNDArray**
- class **org.nd4j.nativeblas.Nd4jCuda$DoubleNDArrayList**
- class **org.nd4j.nativeblas.Nd4jCuda$DoubleNDArrayVector$Iterator**
- class **org.nd4j.nativeblas.Nd4jCuda$DoubleNDArrayVector**
- class **org.nd4j.nativeblas.Nd4jCuda$DoubleOpArgsHolder**
- class **org.nd4j.nativeblas.Nd4jCuda$DoubleResultSet**
- class **org.nd4j.nativeblas.Nd4jCuda$DoubleStash**
- class **org.nd4j.nativeblas.Nd4jCuda$DoubleVariable**
- class **org.nd4j.nativeblas.Nd4jCuda$DoubleVariableSpace**
- class **org.nd4j.nativeblas.Nd4jCuda$DoubleVariablesSet**
- class **org.nd4j.nativeblas.Nd4jCuda$ExternalWorkspace**
- class **org.nd4j.nativeblas.Nd4jCuda$FloatBooleanOp**
- class **org.nd4j.nativeblas.Nd4jCuda$FloatBroadcastableOp**
- class **org.nd4j.nativeblas.Nd4jCuda$FloatContext**
- class **org.nd4j.nativeblas.Nd4jCuda$FloatContextPrototype**
- class **org.nd4j.nativeblas.Nd4jCuda$FloatDeclarableCustomOp**
- class **org.nd4j.nativeblas.Nd4jCuda$FloatDeclarableListOp**
- class **org.nd4j.nativeblas.Nd4jCuda$FloatDeclarableOp**
- class **org.nd4j.nativeblas.Nd4jCuda$FloatDeclarableReductionOp**
- class **org.nd4j.nativeblas.Nd4jCuda$FloatGraphState**
- class **org.nd4j.nativeblas.Nd4jCuda$FloatLogicOp**
- class **org.nd4j.nativeblas.Nd4jCuda$FloatNDArray**
- class **org.nd4j.nativeblas.Nd4jCuda$FloatNDArrayList**
- class **org.nd4j.nativeblas.Nd4jCuda$FloatNDArrayVector$Iterator**
- class **org.nd4j.nativeblas.Nd4jCuda$FloatNDArrayVector**
- class **org.nd4j.nativeblas.Nd4jCuda$FloatOpArgsHolder**
- class **org.nd4j.nativeblas.Nd4jCuda$FloatResultSet**
- class **org.nd4j.nativeblas.Nd4jCuda$FloatStash**
- class **org.nd4j.nativeblas.Nd4jCuda$FloatVariable**
- class **org.nd4j.nativeblas.Nd4jCuda$FloatVariableSpace**
- class **org.nd4j.nativeblas.Nd4jCuda$FloatVariablesSet**
- class **org.nd4j.nativeblas.Nd4jCuda$FlowPath**
- class **org.nd4j.nativeblas.Nd4jCuda$GraphProfile**
- class **org.nd4j.nativeblas.Nd4jCuda$HalfBooleanOp**
- class **org.nd4j.nativeblas.Nd4jCuda$HalfBroadcastableOp**
- class **org.nd4j.nativeblas.Nd4jCuda$HalfContext**
- class **org.nd4j.nativeblas.Nd4jCuda$HalfContextPrototype**
- class **org.nd4j.nativeblas.Nd4jCuda$HalfDeclarableCustomOp**
- class **org.nd4j.nativeblas.Nd4jCuda$HalfDeclarableListOp**
- class **org.nd4j.nativeblas.Nd4jCuda$HalfDeclarableOp**
- class **org.nd4j.nativeblas.Nd4jCuda$HalfDeclarableReductionOp**
- class **org.nd4j.nativeblas.Nd4jCuda$HalfGraphState**
- class **org.nd4j.nativeblas.Nd4jCuda$HalfLogicOp**
- class **org.nd4j.nativeblas.Nd4jCuda$HalfNDArray**
- class **org.nd4j.nativeblas.Nd4jCuda$HalfNDArrayList**
- class **org.nd4j.nativeblas.Nd4jCuda$HalfNDArrayVector$Iterator**
- class **org.nd4j.nativeblas.Nd4jCuda$HalfNDArrayVector**
- class **org.nd4j.nativeblas.Nd4jCuda$HalfOpArgsHolder**
- class **org.nd4j.nativeblas.Nd4jCuda$HalfResultSet**
- class **org.nd4j.nativeblas.Nd4jCuda$HalfStash**
- class **org.nd4j.nativeblas.Nd4jCuda$HalfVariable**
- class **org.nd4j.nativeblas.Nd4jCuda$HalfVariableSpace**
- class **org.nd4j.nativeblas.Nd4jCuda$HalfVariablesSet**
- class **org.nd4j.nativeblas.Nd4jCuda$IGenerator**
- class **org.nd4j.nativeblas.Nd4jCuda$IndicesList**
- class **org.nd4j.nativeblas.Nd4jCuda$IntIntPair**
- class **org.nd4j.nativeblas.Nd4jCuda$IntVectorVector**
- class **org.nd4j.nativeblas.Nd4jCuda$Intervals**
- class **org.nd4j.nativeblas.Nd4jCuda$KeyPair**
- class **org.nd4j.nativeblas.Nd4jCuda$LongVectorVector**
- class **org.nd4j.nativeblas.Nd4jCuda$NDIndex**
- class **org.nd4j.nativeblas.Nd4jCuda$NDIndexAll**
- class **org.nd4j.nativeblas.Nd4jCuda$NDIndexInterval**
- class **org.nd4j.nativeblas.Nd4jCuda$NDIndexPoint**
- class **org.nd4j.nativeblas.Nd4jCuda$NativeOps**
- class **org.nd4j.nativeblas.Nd4jCuda$NodeProfile**
- class **org.nd4j.nativeblas.Nd4jCuda$OpDescriptor**
- class **org.nd4j.nativeblas.Nd4jCuda$OpRegistrator**
- class **org.nd4j.nativeblas.Nd4jCuda$Pair**
- class **org.nd4j.nativeblas.Nd4jCuda$RandomBuffer**
- class **org.nd4j.nativeblas.Nd4jCuda$ResultWrapper**
- class **org.nd4j.nativeblas.Nd4jCuda$ShapeInformation**
- class **org.nd4j.nativeblas.Nd4jCuda$ShapeList**
- class **org.nd4j.nativeblas.Nd4jCuda$Workspace**
- class **org.nd4j.nativeblas.Nd4jCuda$Xoroshiro128**
- class **org.nd4j.nativeblas.Nd4jCuda$_loader**
- class **org.nd4j.nativeblas.Nd4jCuda**
- class **org.nd4j.nativeblas.Nd4jCudaPresets**
- class **org.nd4j.nativeblas.ResultWrapperAbstraction**
- class **org.nd4j.nativeblas.SparseNd4jBlas**
- class **org.nd4j.parameterserver.ParameterServerListener**
- enum **org.nd4j.parameterserver.ParameterServerSubscriber$UpdateType**
- class **org.nd4j.parameterserver.ParameterServerSubscriber**
- class **org.nd4j.parameterserver.PublishingListener**
- class **org.nd4j.parameterserver.client.ParameterServerClient**
- class **org.nd4j.parameterserver.distributed.VoidParameterServer**
- class **org.nd4j.parameterserver.distributed.conf.VoidConfiguration**
- enum **org.nd4j.parameterserver.distributed.enums.ExecutionMode**
- enum **org.nd4j.parameterserver.distributed.enums.FaultToleranceStrategy**
- enum **org.nd4j.parameterserver.distributed.enums.NodeRole**
- enum **org.nd4j.parameterserver.distributed.enums.TransportType**
- interface **org.nd4j.parameterserver.distributed.logic.ClientRouter**
- enum **org.nd4j.parameterserver.distributed.logic.RetransmissionHandler$TransmissionStatus**
- interface **org.nd4j.parameterserver.distributed.logic.RetransmissionHandler**
- interface **org.nd4j.parameterserver.distributed.logic.SequenceProvider**
- interface **org.nd4j.parameterserver.distributed.logic.Storage**
- class **org.nd4j.parameterserver.distributed.logic.completion.Clipboard**
- class **org.nd4j.parameterserver.distributed.logic.completion.FrameCompletionHandler$FrameDescriptor**
- class **org.nd4j.parameterserver.distributed.logic.completion.FrameCompletionHandler**
- class **org.nd4j.parameterserver.distributed.logic.completion.RequestDescriptor**
- class **org.nd4j.parameterserver.distributed.logic.retransmission.DefaultRetransmissionHandler**
- class **org.nd4j.parameterserver.distributed.logic.routing.BaseRouter**
- class **org.nd4j.parameterserver.distributed.logic.routing.InterleavedRouter**
- class **org.nd4j.parameterserver.distributed.logic.routing.RandomRouter**
- class **org.nd4j.parameterserver.distributed.logic.routing.StaticRouter**
- class **org.nd4j.parameterserver.distributed.logic.sequence.BasicSequenceProvider**
- class **org.nd4j.parameterserver.distributed.logic.storage.BaseStorage**
- class **org.nd4j.parameterserver.distributed.logic.storage.WordVectorStorage**
- class **org.nd4j.parameterserver.distributed.messages.BaseVoidMessage**
- interface **org.nd4j.parameterserver.distributed.messages.Chain**
- interface **org.nd4j.parameterserver.distributed.messages.DistributedMessage**
- class **org.nd4j.parameterserver.distributed.messages.Frame**
- interface **org.nd4j.parameterserver.distributed.messages.MeaningfulMessage**
- interface **org.nd4j.parameterserver.distributed.messages.RequestMessage**
- interface **org.nd4j.parameterserver.distributed.messages.TrainingMessage**
- interface **org.nd4j.parameterserver.distributed.messages.VoidAggregation**
- interface **org.nd4j.parameterserver.distributed.messages.VoidMessage**
- class **org.nd4j.parameterserver.distributed.messages.aggregations.BaseAggregation**
- class **org.nd4j.parameterserver.distributed.messages.aggregations.DotAggregation**
- class **org.nd4j.parameterserver.distributed.messages.aggregations.InitializationAggregation**
- class **org.nd4j.parameterserver.distributed.messages.aggregations.VectorAggregation**
- class **org.nd4j.parameterserver.distributed.messages.complete.BaseCompleteMessage**
- class **org.nd4j.parameterserver.distributed.messages.complete.FrameCompleteMessage**
- class **org.nd4j.parameterserver.distributed.messages.complete.InitializationCompleteMessage**
- class **org.nd4j.parameterserver.distributed.messages.complete.IntroductionCompleteMessage**
- class **org.nd4j.parameterserver.distributed.messages.complete.VectorCompleteMessage**
- class **org.nd4j.parameterserver.distributed.messages.intercom.DistributedAssignMessage**
- class **org.nd4j.parameterserver.distributed.messages.intercom.DistributedCbowDotMessage**
- class **org.nd4j.parameterserver.distributed.messages.intercom.DistributedInitializationMessage**
- class **org.nd4j.parameterserver.distributed.messages.intercom.DistributedIntroductionMessage**
- class **org.nd4j.parameterserver.distributed.messages.intercom.DistributedSgDotMessage**
- class **org.nd4j.parameterserver.distributed.messages.intercom.DistributedShutdownMessage**
- class **org.nd4j.parameterserver.distributed.messages.intercom.DistributedSkipGramMessage**
- class **org.nd4j.parameterserver.distributed.messages.intercom.DistributedSolidMessage**
- class **org.nd4j.parameterserver.distributed.messages.intercom.DistributedVectorMessage**
- class **org.nd4j.parameterserver.distributed.messages.requests.AssignRequestMessage**
- class **org.nd4j.parameterserver.distributed.messages.requests.CbowRequestMessage**
- class **org.nd4j.parameterserver.distributed.messages.requests.InitializationRequestMessage**
- class **org.nd4j.parameterserver.distributed.messages.requests.IntroductionRequestMessage**
- class **org.nd4j.parameterserver.distributed.messages.requests.ShutdownRequestMessage**
- class **org.nd4j.parameterserver.distributed.messages.requests.SkipGramRequestMessage**
- class **org.nd4j.parameterserver.distributed.messages.requests.VectorRequestMessage**
- class **org.nd4j.parameterserver.distributed.training.BaseTrainer**
- class **org.nd4j.parameterserver.distributed.training.TrainerProvider**
- interface **org.nd4j.parameterserver.distributed.training.TrainingDriver**
- class **org.nd4j.parameterserver.distributed.training.chains.CbowChain**
- class **org.nd4j.parameterserver.distributed.training.chains.SkipGramChain**
- class **org.nd4j.parameterserver.distributed.training.impl.CbowTrainer**
- class **org.nd4j.parameterserver.distributed.training.impl.SkipGramTrainer**
- class **org.nd4j.parameterserver.distributed.transport.BaseTransport**
- class **org.nd4j.parameterserver.distributed.transport.LocalTransport**
- class **org.nd4j.parameterserver.distributed.transport.MulticastTransport**
- class **org.nd4j.parameterserver.distributed.transport.RoutedTransport$RemoteConnection$RemoteConnectionBuilder**
- class **org.nd4j.parameterserver.distributed.transport.RoutedTransport$RemoteConnection**
- class **org.nd4j.parameterserver.distributed.transport.RoutedTransport**
- enum **org.nd4j.parameterserver.distributed.transport.Transport$ThreadingModel**
- interface **org.nd4j.parameterserver.distributed.transport.Transport**
- class **org.nd4j.parameterserver.distributed.util.NetworkInformation**
- class **org.nd4j.parameterserver.distributed.util.NetworkOrganizer$VirtualNode**
- class **org.nd4j.parameterserver.distributed.util.NetworkOrganizer$VirtualTree**
- class **org.nd4j.parameterserver.distributed.util.NetworkOrganizer**
- class **org.nd4j.parameterserver.model.MasterConnectionInfo**
- class **org.nd4j.parameterserver.model.MasterStatus**
- enum **org.nd4j.parameterserver.model.ServerState**
- enum **org.nd4j.parameterserver.model.ServerType**
- class **org.nd4j.parameterserver.model.ServerTypeJson**
- class **org.nd4j.parameterserver.model.SlaveConnectionInfo**
- class **org.nd4j.parameterserver.model.SlaveStatus**
- class **org.nd4j.parameterserver.model.SubscriberState**
- class **org.nd4j.parameterserver.node.ParameterServerNode**
- class **org.nd4j.parameterserver.status.play.BaseStatusStorage**
- class **org.nd4j.parameterserver.status.play.InMemoryStatusStorage**
- class **org.nd4j.parameterserver.status.play.MapDbStatusStorage**
- class **org.nd4j.parameterserver.status.play.StatusServer**
- interface **org.nd4j.parameterserver.status.play.StatusStorage**
- class **org.nd4j.parameterserver.updater.BaseParameterUpdater**
- interface **org.nd4j.parameterserver.updater.ParameterServerUpdater**
- class **org.nd4j.parameterserver.updater.SoftSyncParameterUpdater**
- class **org.nd4j.parameterserver.updater.SynchronousParameterUpdater**
- class **org.nd4j.parameterserver.updater.TimeDelayedParameterUpdater**
- class **org.nd4j.parameterserver.updater.storage.BaseUpdateStorage**
- class **org.nd4j.parameterserver.updater.storage.InMemoryUpdateStorage**
- class **org.nd4j.parameterserver.updater.storage.NoUpdateStorage**
- class **org.nd4j.parameterserver.updater.storage.RocksDbStorage**
- interface **org.nd4j.parameterserver.updater.storage.UpdateStorage**
- class **org.nd4j.parameterserver.util.CheckSocket**
- class **org.nd4j.primitives.AtomicDoubleSerializer**
- class **org.nd4j.resources.Downloader**
- class **org.nd4j.rng.NativeRandom**
- class **org.nd4j.rng.deallocator.GarbageStateReference**
- class **org.nd4j.rng.deallocator.NativePack**
- class **org.nd4j.rng.deallocator.NativeRandomDeallocator**
- class **org.nd4j.serde.base64.Nd4jBase64**
- class **org.nd4j.serde.binary.BinarySerde**
- class **org.nd4j.serde.gson.GsonDeserializationUtils**
- class **org.nd4j.serde.json.BaseLegacyDeserializer**
- class **org.nd4j.serde.json.LegacyIActivationDeserializer**
- class **org.nd4j.serde.json.LegacyIActivationDeserializerHelper**
- class **org.nd4j.serde.json.LegacyILossFunctionDeserializer**
- class **org.nd4j.serde.json.LegacyILossFunctionDeserializerHelper**
- class **org.nd4j.shade.serde.jackson.VectorDeSerializer**
- class **org.nd4j.shade.serde.jackson.VectorSerializer**
- class **org.nd4j.shade.serde.jackson.ndarray.NDArrayDeSerializer**
- class **org.nd4j.shade.serde.jackson.ndarray.NDArraySerializer**
- class **org.nd4j.shade.serde.jackson.shaded.NDArrayDeSerializer**
- class **org.nd4j.shade.serde.jackson.shaded.NDArraySerializer**
- class **org.nd4j.storage.CompressedRamStorage$Builder**
- class **org.nd4j.storage.CompressedRamStorage**
- class **org.nd4j.tensorflow.conversion.DummyDeAllocator**
- class **org.nd4j.tensorflow.conversion.TensorflowConversion**
- class **org.nd4j.tensorflow.conversion.graphrunner.GraphRunner**
- class **org.nd4j.tools.BTools**
- class **org.nd4j.tools.InfoLine**
- class **org.nd4j.tools.InfoValues**
- class **org.nd4j.tools.PropertyParser**
- class **org.nd4j.tools.SIS**
- class **org.nd4j.util.ArchiveUtils**
- class **org.nd4j.util.FingerPrintKeyer**
- class **org.nd4j.util.Index**
- class **org.nd4j.util.OneTimeLogger**
- class **org.nd4j.util.ReflectionUtils**
- class **org.nd4j.util.SetUtils**
- enum **org.nd4j.util.StringUtils$TraditionalBinaryPrefix**
- class **org.nd4j.util.StringUtils**
- enum **org.nd4j.versioncheck.VersionCheck$Detail**
- class **org.nd4j.versioncheck.VersionCheck**
- class **org.nd4j.versioncheck.VersionInfo**
- class **org.nd4j.weightinit.BaseWeightInitScheme**
- enum **org.nd4j.weightinit.WeightInit**
- interface **org.nd4j.weightinit.WeightInitScheme**
- class **org.nd4j.weightinit.impl.ConstantInitScheme**
- class **org.nd4j.weightinit.impl.DistributionInitScheme**
- class **org.nd4j.weightinit.impl.IdentityInitScheme**
- class **org.nd4j.weightinit.impl.LecunUniformInitScheme**
- interface **org.nd4j.weightinit.impl.NDArraySupplierInitScheme$NDArraySupplier**
- class **org.nd4j.weightinit.impl.NDArraySupplierInitScheme**
- class **org.nd4j.weightinit.impl.OneInitScheme**
- class **org.nd4j.weightinit.impl.ReluInitScheme**
- class **org.nd4j.weightinit.impl.ReluUniformInitScheme**
- class **org.nd4j.weightinit.impl.SigmoidUniformInitScheme**
- class **org.nd4j.weightinit.impl.UniformInitScheme**
- class **org.nd4j.weightinit.impl.VarScalingNormalFanAvgInitScheme**
- class **org.nd4j.weightinit.impl.VarScalingNormalFanInInitScheme**
- class **org.nd4j.weightinit.impl.VarScalingNormalFanOutInitScheme**
- class **org.nd4j.weightinit.impl.VarScalingNormalUniformFanInInitScheme**
- class **org.nd4j.weightinit.impl.VarScalingNormalUniformFanOutInitScheme**
- class **org.nd4j.weightinit.impl.VarScalingUniformFanAvgInitScheme**
- class **org.nd4j.weightinit.impl.XavierFanInInitScheme**
- class **org.nd4j.weightinit.impl.XavierInitScheme**
- class **org.nd4j.weightinit.impl.XavierUniformInitScheme**
- class **org.nd4j.weightinit.impl.ZeroInitScheme**
- class **org.tensorflow.framework.AllocationDescription$Builder**
- class **org.tensorflow.framework.AllocationDescription**
- interface **org.tensorflow.framework.AllocationDescriptionOrBuilder**
- class **org.tensorflow.framework.AllocationDescriptionProtos**
- class **org.tensorflow.framework.AllocationRecord$Builder**
- class **org.tensorflow.framework.AllocationRecord**
- interface **org.tensorflow.framework.AllocationRecordOrBuilder**
- class **org.tensorflow.framework.AllocatorMemoryUsed$Builder**
- class **org.tensorflow.framework.AllocatorMemoryUsed**
- interface **org.tensorflow.framework.AllocatorMemoryUsedOrBuilder**
- class **org.tensorflow.framework.ApiDef$Arg$Builder**
- class **org.tensorflow.framework.ApiDef$Arg**
- interface **org.tensorflow.framework.ApiDef$ArgOrBuilder**
- class **org.tensorflow.framework.ApiDef$Attr$Builder**
- class **org.tensorflow.framework.ApiDef$Attr**
- interface **org.tensorflow.framework.ApiDef$AttrOrBuilder**
- class **org.tensorflow.framework.ApiDef$Builder**
- class **org.tensorflow.framework.ApiDef$Endpoint$Builder**
- class **org.tensorflow.framework.ApiDef$Endpoint**
- interface **org.tensorflow.framework.ApiDef$EndpointOrBuilder**
- enum **org.tensorflow.framework.ApiDef$Visibility**
- class **org.tensorflow.framework.ApiDef**
- interface **org.tensorflow.framework.ApiDefOrBuilder**
- class **org.tensorflow.framework.ApiDefProtos**
- class **org.tensorflow.framework.ApiDefs$Builder**
- class **org.tensorflow.framework.ApiDefs**
- interface **org.tensorflow.framework.ApiDefsOrBuilder**
- class **org.tensorflow.framework.AttrValue$Builder**
- class **org.tensorflow.framework.AttrValue$ListValue$Builder**
- class **org.tensorflow.framework.AttrValue$ListValue**
- interface **org.tensorflow.framework.AttrValue$ListValueOrBuilder**
- enum **org.tensorflow.framework.AttrValue$ValueCase**
- class **org.tensorflow.framework.AttrValue**
- interface **org.tensorflow.framework.AttrValueOrBuilder**
- class **org.tensorflow.framework.AttrValueProtos**
- class **org.tensorflow.framework.CostGraphDef$Builder**
- class **org.tensorflow.framework.CostGraphDef$Node$Builder**
- class **org.tensorflow.framework.CostGraphDef$Node$InputInfo$Builder**
- class **org.tensorflow.framework.CostGraphDef$Node$InputInfo**
- interface **org.tensorflow.framework.CostGraphDef$Node$InputInfoOrBuilder**
- class **org.tensorflow.framework.CostGraphDef$Node$OutputInfo$Builder**
- class **org.tensorflow.framework.CostGraphDef$Node$OutputInfo**
- interface **org.tensorflow.framework.CostGraphDef$Node$OutputInfoOrBuilder**
- class **org.tensorflow.framework.CostGraphDef$Node**
- interface **org.tensorflow.framework.CostGraphDef$NodeOrBuilder**
- class **org.tensorflow.framework.CostGraphDef**
- interface **org.tensorflow.framework.CostGraphDefOrBuilder**
- class **org.tensorflow.framework.CostGraphProtos**
- enum **org.tensorflow.framework.DataType**
- class **org.tensorflow.framework.DeviceAttributes$Builder**
- class **org.tensorflow.framework.DeviceAttributes**
- interface **org.tensorflow.framework.DeviceAttributesOrBuilder**
- class **org.tensorflow.framework.DeviceAttributesProtos**
- class **org.tensorflow.framework.DeviceLocality$Builder**
- class **org.tensorflow.framework.DeviceLocality**
- interface **org.tensorflow.framework.DeviceLocalityOrBuilder**
- class **org.tensorflow.framework.DeviceStepStats$Builder**
- class **org.tensorflow.framework.DeviceStepStats**
- interface **org.tensorflow.framework.DeviceStepStatsOrBuilder**
- class **org.tensorflow.framework.FunctionDef$Builder**
- class **org.tensorflow.framework.FunctionDef**
- class **org.tensorflow.framework.FunctionDefLibrary$Builder**
- class **org.tensorflow.framework.FunctionDefLibrary**
- interface **org.tensorflow.framework.FunctionDefLibraryOrBuilder**
- interface **org.tensorflow.framework.FunctionDefOrBuilder**
- class **org.tensorflow.framework.FunctionProtos**
- class **org.tensorflow.framework.GradientDef$Builder**
- class **org.tensorflow.framework.GradientDef**
- interface **org.tensorflow.framework.GradientDefOrBuilder**
- class **org.tensorflow.framework.GraphDef$Builder**
- class **org.tensorflow.framework.GraphDef**
- interface **org.tensorflow.framework.GraphDefOrBuilder**
- class **org.tensorflow.framework.GraphProtos**
- class **org.tensorflow.framework.GraphTransferInfo$Builder**
- class **org.tensorflow.framework.GraphTransferInfo$ConstNodeInfo$Builder**
- class **org.tensorflow.framework.GraphTransferInfo$ConstNodeInfo**
- interface **org.tensorflow.framework.GraphTransferInfo$ConstNodeInfoOrBuilder**
- enum **org.tensorflow.framework.GraphTransferInfo$Destination**
- class **org.tensorflow.framework.GraphTransferInfo$GraphInputNodeInfo$Builder**
- class **org.tensorflow.framework.GraphTransferInfo$GraphInputNodeInfo**
- interface **org.tensorflow.framework.GraphTransferInfo$GraphInputNodeInfoOrBuilder**
- class **org.tensorflow.framework.GraphTransferInfo$GraphOutputNodeInfo$Builder**
- class **org.tensorflow.framework.GraphTransferInfo$GraphOutputNodeInfo**
- interface **org.tensorflow.framework.GraphTransferInfo$GraphOutputNodeInfoOrBuilder**
- class **org.tensorflow.framework.GraphTransferInfo$NodeInfo$Builder**
- class **org.tensorflow.framework.GraphTransferInfo$NodeInfo**
- interface **org.tensorflow.framework.GraphTransferInfo$NodeInfoOrBuilder**
- class **org.tensorflow.framework.GraphTransferInfo$NodeInput$Builder**
- class **org.tensorflow.framework.GraphTransferInfo$NodeInput**
- class **org.tensorflow.framework.GraphTransferInfo$NodeInputInfo$Builder**
- class **org.tensorflow.framework.GraphTransferInfo$NodeInputInfo**
- interface **org.tensorflow.framework.GraphTransferInfo$NodeInputInfoOrBuilder**
- interface **org.tensorflow.framework.GraphTransferInfo$NodeInputOrBuilder**
- class **org.tensorflow.framework.GraphTransferInfo$NodeOutputInfo$Builder**
- class **org.tensorflow.framework.GraphTransferInfo$NodeOutputInfo**
- interface **org.tensorflow.framework.GraphTransferInfo$NodeOutputInfoOrBuilder**
- class **org.tensorflow.framework.GraphTransferInfo**
- interface **org.tensorflow.framework.GraphTransferInfoOrBuilder**
- class **org.tensorflow.framework.GraphTransferInfoProto**
- class **org.tensorflow.framework.HistogramProto$Builder**
- class **org.tensorflow.framework.HistogramProto**
- interface **org.tensorflow.framework.HistogramProtoOrBuilder**
- class **org.tensorflow.framework.KernelDef$AttrConstraint$Builder**
- class **org.tensorflow.framework.KernelDef$AttrConstraint**
- interface **org.tensorflow.framework.KernelDef$AttrConstraintOrBuilder**
- class **org.tensorflow.framework.KernelDef$Builder**
- class **org.tensorflow.framework.KernelDef**
- interface **org.tensorflow.framework.KernelDefOrBuilder**
- class **org.tensorflow.framework.KernelDefProtos**
- class **org.tensorflow.framework.LogMemoryProtos**
- class **org.tensorflow.framework.MemoryLogRawAllocation$Builder**
- class **org.tensorflow.framework.MemoryLogRawAllocation**
- interface **org.tensorflow.framework.MemoryLogRawAllocationOrBuilder**
- class **org.tensorflow.framework.MemoryLogRawDeallocation$Builder**
- class **org.tensorflow.framework.MemoryLogRawDeallocation**
- interface **org.tensorflow.framework.MemoryLogRawDeallocationOrBuilder**
- class **org.tensorflow.framework.MemoryLogStep$Builder**
- class **org.tensorflow.framework.MemoryLogStep**
- interface **org.tensorflow.framework.MemoryLogStepOrBuilder**
- class **org.tensorflow.framework.MemoryLogTensorAllocation$Builder**
- class **org.tensorflow.framework.MemoryLogTensorAllocation**
- interface **org.tensorflow.framework.MemoryLogTensorAllocationOrBuilder**
- class **org.tensorflow.framework.MemoryLogTensorDeallocation$Builder**
- class **org.tensorflow.framework.MemoryLogTensorDeallocation**
- interface **org.tensorflow.framework.MemoryLogTensorDeallocationOrBuilder**
- class **org.tensorflow.framework.MemoryLogTensorOutput$Builder**
- class **org.tensorflow.framework.MemoryLogTensorOutput**
- interface **org.tensorflow.framework.MemoryLogTensorOutputOrBuilder**
- class **org.tensorflow.framework.MemoryStats$Builder**
- class **org.tensorflow.framework.MemoryStats**
- interface **org.tensorflow.framework.MemoryStatsOrBuilder**
- class **org.tensorflow.framework.NameAttrList$Builder**
- class **org.tensorflow.framework.NameAttrList**
- interface **org.tensorflow.framework.NameAttrListOrBuilder**
- class **org.tensorflow.framework.NodeDef$Builder**
- class **org.tensorflow.framework.NodeDef**
- interface **org.tensorflow.framework.NodeDefOrBuilder**
- class **org.tensorflow.framework.NodeExecStats$Builder**
- class **org.tensorflow.framework.NodeExecStats**
- interface **org.tensorflow.framework.NodeExecStatsOrBuilder**
- class **org.tensorflow.framework.NodeOutput$Builder**
- class **org.tensorflow.framework.NodeOutput**
- interface **org.tensorflow.framework.NodeOutputOrBuilder**
- class **org.tensorflow.framework.NodeProto**
- class **org.tensorflow.framework.OpDef$ArgDef$Builder**
- class **org.tensorflow.framework.OpDef$ArgDef**
- interface **org.tensorflow.framework.OpDef$ArgDefOrBuilder**
- class **org.tensorflow.framework.OpDef$AttrDef$Builder**
- class **org.tensorflow.framework.OpDef$AttrDef**
- interface **org.tensorflow.framework.OpDef$AttrDefOrBuilder**
- class **org.tensorflow.framework.OpDef$Builder**
- class **org.tensorflow.framework.OpDef**
- interface **org.tensorflow.framework.OpDefOrBuilder**
- class **org.tensorflow.framework.OpDefProtos**
- class **org.tensorflow.framework.OpDeprecation$Builder**
- class **org.tensorflow.framework.OpDeprecation**
- interface **org.tensorflow.framework.OpDeprecationOrBuilder**
- class **org.tensorflow.framework.OpList$Builder**
- class **org.tensorflow.framework.OpList**
- interface **org.tensorflow.framework.OpListOrBuilder**
- class **org.tensorflow.framework.ReaderBaseProtos**
- class **org.tensorflow.framework.ReaderBaseState$Builder**
- class **org.tensorflow.framework.ReaderBaseState**
- interface **org.tensorflow.framework.ReaderBaseStateOrBuilder**
- class **org.tensorflow.framework.RemoteFusedGraphExecuteInfo$Builder**
- enum **org.tensorflow.framework.RemoteFusedGraphExecuteInfo$NodeType**
- class **org.tensorflow.framework.RemoteFusedGraphExecuteInfo$TensorShapeTypeProto$Builder**
- class **org.tensorflow.framework.RemoteFusedGraphExecuteInfo$TensorShapeTypeProto**
- interface **org.tensorflow.framework.RemoteFusedGraphExecuteInfo$TensorShapeTypeProtoOrBuilder**
- class **org.tensorflow.framework.RemoteFusedGraphExecuteInfo**
- interface **org.tensorflow.framework.RemoteFusedGraphExecuteInfoOrBuilder**
- class **org.tensorflow.framework.RemoteFusedGraphExecuteInfoProto**
- class **org.tensorflow.framework.ResourceHandle**
- class **org.tensorflow.framework.ResourceHandleProto$Builder**
- class **org.tensorflow.framework.ResourceHandleProto**
- interface **org.tensorflow.framework.ResourceHandleProtoOrBuilder**
- class **org.tensorflow.framework.SaveSliceInfoDef$Builder**
- class **org.tensorflow.framework.SaveSliceInfoDef**
- interface **org.tensorflow.framework.SaveSliceInfoDefOrBuilder**
- class **org.tensorflow.framework.StepStats$Builder**
- class **org.tensorflow.framework.StepStats**
- interface **org.tensorflow.framework.StepStatsOrBuilder**
- class **org.tensorflow.framework.StepStatsProtos**
- class **org.tensorflow.framework.Summary$Audio$Builder**
- class **org.tensorflow.framework.Summary$Audio**
- interface **org.tensorflow.framework.Summary$AudioOrBuilder**
- class **org.tensorflow.framework.Summary$Builder**
- class **org.tensorflow.framework.Summary$Image$Builder**
- class **org.tensorflow.framework.Summary$Image**
- interface **org.tensorflow.framework.Summary$ImageOrBuilder**
- class **org.tensorflow.framework.Summary$Value$Builder**
- enum **org.tensorflow.framework.Summary$Value$ValueCase**
- class **org.tensorflow.framework.Summary$Value**
- interface **org.tensorflow.framework.Summary$ValueOrBuilder**
- class **org.tensorflow.framework.Summary**
- class **org.tensorflow.framework.SummaryDescription$Builder**
- class **org.tensorflow.framework.SummaryDescription**
- interface **org.tensorflow.framework.SummaryDescriptionOrBuilder**
- class **org.tensorflow.framework.SummaryMetadata$Builder**
- class **org.tensorflow.framework.SummaryMetadata$PluginData$Builder**
- class **org.tensorflow.framework.SummaryMetadata$PluginData**
- interface **org.tensorflow.framework.SummaryMetadata$PluginDataOrBuilder**
- class **org.tensorflow.framework.SummaryMetadata**
- interface **org.tensorflow.framework.SummaryMetadataOrBuilder**
- interface **org.tensorflow.framework.SummaryOrBuilder**
- class **org.tensorflow.framework.SummaryProtos**
- class **org.tensorflow.framework.TensorDescription$Builder**
- class **org.tensorflow.framework.TensorDescription**
- interface **org.tensorflow.framework.TensorDescriptionOrBuilder**
- class **org.tensorflow.framework.TensorDescriptionProtos**
- class **org.tensorflow.framework.TensorProto$Builder**
- class **org.tensorflow.framework.TensorProto**
- interface **org.tensorflow.framework.TensorProtoOrBuilder**
- class **org.tensorflow.framework.TensorProtos**
- class **org.tensorflow.framework.TensorShapeProto$Builder**
- class **org.tensorflow.framework.TensorShapeProto$Dim$Builder**
- class **org.tensorflow.framework.TensorShapeProto$Dim**
- interface **org.tensorflow.framework.TensorShapeProto$DimOrBuilder**
- class **org.tensorflow.framework.TensorShapeProto**
- interface **org.tensorflow.framework.TensorShapeProtoOrBuilder**
- class **org.tensorflow.framework.TensorShapeProtos**
- class **org.tensorflow.framework.TensorSliceProto$Builder**
- class **org.tensorflow.framework.TensorSliceProto$Extent$Builder**
- enum **org.tensorflow.framework.TensorSliceProto$Extent$HasLengthCase**
- class **org.tensorflow.framework.TensorSliceProto$Extent**
- interface **org.tensorflow.framework.TensorSliceProto$ExtentOrBuilder**
- class **org.tensorflow.framework.TensorSliceProto**
- interface **org.tensorflow.framework.TensorSliceProtoOrBuilder**
- class **org.tensorflow.framework.TensorSliceProtos**
- class **org.tensorflow.framework.TypesProtos**
- class **org.tensorflow.framework.VariableDef$Builder**
- class **org.tensorflow.framework.VariableDef**
- interface **org.tensorflow.framework.VariableDefOrBuilder**
- class **org.tensorflow.framework.VariableProtos**
- class **org.tensorflow.framework.VariantTensorDataProto$Builder**
- class **org.tensorflow.framework.VariantTensorDataProto**
- interface **org.tensorflow.framework.VariantTensorDataProtoOrBuilder**
- class **org.tensorflow.framework.VersionDef$Builder**
- class **org.tensorflow.framework.VersionDef**
- interface **org.tensorflow.framework.VersionDefOrBuilder**
- class **org.tensorflow.framework.VersionsProtos**
- class **org.tensorflow.util.IteratorProtos**
- class **org.tensorflow.util.IteratorStateMetadata$Builder**
- class **org.tensorflow.util.IteratorStateMetadata**
- interface **org.tensorflow.util.IteratorStateMetadataOrBuilder**
- class **tensorflow.OpGenOverridesOuterClass$OpGenOverride$AttrDefault$Builder**
- class **tensorflow.OpGenOverridesOuterClass$OpGenOverride$AttrDefault**
- interface **tensorflow.OpGenOverridesOuterClass$OpGenOverride$AttrDefaultOrBuilder**
- class **tensorflow.OpGenOverridesOuterClass$OpGenOverride$Builder**
- class **tensorflow.OpGenOverridesOuterClass$OpGenOverride$Rename$Builder**
- class **tensorflow.OpGenOverridesOuterClass$OpGenOverride$Rename**
- interface **tensorflow.OpGenOverridesOuterClass$OpGenOverride$RenameOrBuilder**
- class **tensorflow.OpGenOverridesOuterClass$OpGenOverride**
- interface **tensorflow.OpGenOverridesOuterClass$OpGenOverrideOrBuilder**
- class **tensorflow.OpGenOverridesOuterClass$OpGenOverrides$Builder**
- class **tensorflow.OpGenOverridesOuterClass$OpGenOverrides**
- interface **tensorflow.OpGenOverridesOuterClass$OpGenOverridesOrBuilder**
- class **tensorflow.OpGenOverridesOuterClass**
- enum **vizdoom.AutomapMode**
- enum **vizdoom.Button**
- class **vizdoom.DoomGame**
- class **vizdoom.FileDoesNotExistException**
- class **vizdoom.GameState**
- enum **vizdoom.GameVariable**
- class **vizdoom.Label**
- class **vizdoom.MessageQueueException**
- enum **vizdoom.Mode**
- enum **vizdoom.ScreenFormat**
- enum **vizdoom.ScreenResolution**
- class **vizdoom.SharedMemoryException**
- class **vizdoom.SignalException**
- class **vizdoom.ViZDoomErrorException**
- class **vizdoom.ViZDoomIsNotRunningException**
- class **vizdoom.ViZDoomUnexpectedExitException**

## Contributors

[Eugene Potapenko](https://github.com/potapenko/)

## License

Distributed under the Eclipse Public License, the same as Clojure.
