(ns org.datavec.api.transform.sequence.window.OverlappingTimeWindowFunction
  "A windowing function based on time, with potentially overlapping windows. Time for each entry in the sequence is provided by a Time column
 The overlapping nature of the windowing function allows for things such as a window size of 1 day, produced every hour.
 Two parameters (and one optional parameter) are necessary to specify how windowing is conducted:
 - The size of the window (for example, 1 day)
 - The separation between window periods (for example, 1 hour)
 - The offet for the start/end time of the windows

 Example with a window size of 12 hours, with the window separation of 1 hour, we end up with windows as follows:
 (0:00 to 12:00), (1:00 to 13:00), (2:00 to 14:00) and so on.
 If the offset was set to 15 minutes, windows would instead be at (0:15 to 12:15), (1:15 to 13:15), (2:15 to 14:15) and so on.

 Note that the windows generated by this window function need not contain any data - i.e., it can generate empty an empty
 window if no data occurs in the specified time period."
  (:refer-clojure :only [require comment defn ->])
  (:import [org.datavec.api.transform.sequence.window OverlappingTimeWindowFunction]))

(defn ->overlapping-time-window-function
  "Constructor.

  Constructor with optional offset, ability to add window start/end time columns

  time-column - Name of the column that contains the time values (must be a time column) - `java.lang.String`
  window-size - Numerical quantity for the size of the time window (used in conjunction with windowSizeUnit) - `long`
  window-size-unit - Unit of the time window - `java.util.concurrent.TimeUnit`
  window-separation - The separation between consecutive window start times (used in conjunction with WindowSeparationUnit) - `long`
  window-separation-unit - Unit for the separation between windows - `java.util.concurrent.TimeUnit`
  offset - Optional offset amount, to shift start/end of the time window forward or back - `long`
  offset-unit - Optional offset unit for the offset amount. - `java.util.concurrent.TimeUnit`
  add-window-start-time-column - If true: add a time column (name: \"windowStartTime\") that contains the start timeof the window - `boolean`
  add-window-end-time-column - If true: add a time column (name: \"windowEndTime\") that contains the end timeof the window - `boolean`
  exclude-empty-windows - If true: exclude any windows that don't have any values in them - `boolean`"
  (^OverlappingTimeWindowFunction [^java.lang.String time-column ^Long window-size ^java.util.concurrent.TimeUnit window-size-unit ^Long window-separation ^java.util.concurrent.TimeUnit window-separation-unit ^Long offset ^java.util.concurrent.TimeUnit offset-unit ^Boolean add-window-start-time-column ^Boolean add-window-end-time-column ^Boolean exclude-empty-windows]
    (new OverlappingTimeWindowFunction time-column window-size window-size-unit window-separation window-separation-unit offset offset-unit add-window-start-time-column add-window-end-time-column exclude-empty-windows))
  (^OverlappingTimeWindowFunction [^java.lang.String time-column ^Long window-size ^java.util.concurrent.TimeUnit window-size-unit ^Long window-separation ^java.util.concurrent.TimeUnit window-separation-unit ^Boolean add-window-start-time-column ^Boolean add-window-end-time-column]
    (new OverlappingTimeWindowFunction time-column window-size window-size-unit window-separation window-separation-unit add-window-start-time-column add-window-end-time-column))
  (^OverlappingTimeWindowFunction [^java.lang.String time-column ^Long window-size ^java.util.concurrent.TimeUnit window-size-unit ^Long window-separation ^java.util.concurrent.TimeUnit window-separation-unit]
    (new OverlappingTimeWindowFunction time-column window-size window-size-unit window-separation window-separation-unit)))

(defn set-input-schema
  "schema - `org.datavec.api.transform.schema.Schema`"
  ([^OverlappingTimeWindowFunction this ^org.datavec.api.transform.schema.Schema schema]
    (-> this (.setInputSchema schema))))

(defn get-input-schema
  "returns: `org.datavec.api.transform.schema.Schema`"
  (^org.datavec.api.transform.schema.Schema [^OverlappingTimeWindowFunction this]
    (-> this (.getInputSchema))))

(defn transform
  "Description copied from interface: WindowFunction

  input-schema - Schema of the input data - `org.datavec.api.transform.schema.Schema`

  returns: Schema of the output windows - `org.datavec.api.transform.schema.Schema`"
  (^org.datavec.api.transform.schema.Schema [^OverlappingTimeWindowFunction this ^org.datavec.api.transform.schema.Schema input-schema]
    (-> this (.transform input-schema))))

(defn to-string
  "returns: `java.lang.String`"
  (^java.lang.String [^OverlappingTimeWindowFunction this]
    (-> this (.toString))))

(defn apply-to-sequence
  "Description copied from interface: WindowFunction

  sequence - the input sequence - `java.util.List`

  returns: the sequence with the window function applied - `java.util.List<java.util.List<java.util.List<org.datavec.api.writable.Writable>>>`"
  (^java.util.List [^OverlappingTimeWindowFunction this ^java.util.List sequence]
    (-> this (.applyToSequence sequence))))

