(ns org.datavec.api.transform.sequence.window.TimeWindowFunction
  "A windowing function based on time, with non-overlapping windows. Time for each entry in the sequence is provided by a Time column
 Functionality here: Calculate windows of data based on a fixed window size (1 minute, 1 hour, etc), with an optional offset.
 Specifically, window start times T are calculated such that (T  timeZoneOffset  offset) % windowSize == 0
 timeZoneOffset comes from the Time column metadata; offset allows for the window to be shifted one way or another,
 for example to allow for windowing like (10:15 to 11:15) instead of (10:00 to 11:00), using an offset of 15 minutes

 Note that the windows generated by this window function need not contain any data - i.e., it can generate empty an empty
 window if no data occurs in the specified time period."
  (:refer-clojure :only [require comment defn ->])
  (:import [org.datavec.api.transform.sequence.window TimeWindowFunction]))

(defn ->time-window-function
  "Constructor.

  Constructor with optional offset

  time-column - Name of the column that contains the time values (must be a time column) - `java.lang.String`
  window-size - Numerical quantity for the size of the time window (used in conjunction with windowSizeUnit) - `long`
  window-size-unit - Unit of the time window - `java.util.concurrent.TimeUnit`
  offset - Optional offset amount, to shift start/end of the time window forward or back - `long`
  offset-unit - Optional offset unit for the offset amount. - `java.util.concurrent.TimeUnit`
  add-window-start-time-column - If true: add a column (at the end) with the window start time - `boolean`
  add-window-end-time-column - If true: add a column (at the end) with the window end time - `boolean`
  exclude-empty-windows - If true: exclude any windows that don't have any values in them - `boolean`"
  (^TimeWindowFunction [^java.lang.String time-column ^Long window-size ^java.util.concurrent.TimeUnit window-size-unit ^Long offset ^java.util.concurrent.TimeUnit offset-unit ^Boolean add-window-start-time-column ^Boolean add-window-end-time-column ^Boolean exclude-empty-windows]
    (new TimeWindowFunction time-column window-size window-size-unit offset offset-unit add-window-start-time-column add-window-end-time-column exclude-empty-windows))
  (^TimeWindowFunction [^java.lang.String time-column ^Long window-size ^java.util.concurrent.TimeUnit window-size-unit ^Boolean add-window-start-time-column ^Boolean add-window-end-time-column]
    (new TimeWindowFunction time-column window-size window-size-unit add-window-start-time-column add-window-end-time-column))
  (^TimeWindowFunction [^java.lang.String time-column ^Long window-size ^java.util.concurrent.TimeUnit window-size-unit]
    (new TimeWindowFunction time-column window-size window-size-unit)))

(defn set-input-schema
  "schema - `org.datavec.api.transform.schema.Schema`"
  ([^TimeWindowFunction this ^org.datavec.api.transform.schema.Schema schema]
    (-> this (.setInputSchema schema))))

(defn get-input-schema
  "returns: `org.datavec.api.transform.schema.Schema`"
  (^org.datavec.api.transform.schema.Schema [^TimeWindowFunction this]
    (-> this (.getInputSchema))))

(defn transform
  "Description copied from interface: WindowFunction

  input-schema - Schema of the input data - `org.datavec.api.transform.schema.Schema`

  returns: Schema of the output windows - `org.datavec.api.transform.schema.Schema`"
  (^org.datavec.api.transform.schema.Schema [^TimeWindowFunction this ^org.datavec.api.transform.schema.Schema input-schema]
    (-> this (.transform input-schema))))

(defn to-string
  "returns: `java.lang.String`"
  (^java.lang.String [^TimeWindowFunction this]
    (-> this (.toString))))

(defn apply-to-sequence
  "Description copied from interface: WindowFunction

  sequence - the input sequence - `java.util.List`

  returns: the sequence with the window function applied - `java.util.List<java.util.List<java.util.List<org.datavec.api.writable.Writable>>>`"
  (^java.util.List [^TimeWindowFunction this ^java.util.List sequence]
    (-> this (.applyToSequence sequence))))

(defn get-window-start-time-for-time
  "Calculates the start time of the window for which the specified time belongs, in unix epoch (millisecond) format
  For example, if the window size is 1 hour with offset 0, then a time 10:17 would return 10:00, as the 1 hour window
  is for 10:00:00.000 to 10:59:59.999 inclusive, or 10:00:00.000 (inclusive) to 11:00:00.000 (exclusive)

  time - Time at which to determine the window start time (milliseconds epoch format) - `long`

  returns: `long`"
  (^Long [^TimeWindowFunction this ^Long time]
    (-> this (.getWindowStartTimeForTime time))))

(defn get-window-end-time-for-time
  "Calculates the end time of the window for which the specified time belongs, in unix epoch (millisecond) format.
  Note: this value is not included in the interval. Put another way, it is the start time of the next
  interval: i.e., is equivalent to getWindowStartTimeForTime(long)  interval (in milliseconds).
  To get the last inclusive time for the interval, subtract 1L (1 millisecond) from the value returned by
  this method.
  For example, if the window size is 1 hour with offset 0, then a time 10:17 would return 11:00, as the 1 hour window
  is for 10:00:00.000 (inclusive) to 11:00:00.000 (exclusive)

  time - Time at which to determine the window start time - `long`

  returns: `long`"
  (^Long [^TimeWindowFunction this ^Long time]
    (-> this (.getWindowEndTimeForTime time))))

