(ns org.deeplearning4j.nn.conf.module.GraphBuilderModule
  "GraphBuilderModule for nn layers. Allows for creation of plugins and modules to generate configurations and layers."
  (:refer-clojure :only [require comment defn ->])
  (:import [org.deeplearning4j.nn.conf.module GraphBuilderModule]))

(defn get-module-name
  "A module should return its name. Useful for automatically generating layer names.

  returns: The module name as a string. - `java.lang.String`"
  (^java.lang.String [^GraphBuilderModule this]
    (-> this (.getModuleName))))

(defn update-builder
  "Add a layer to the collection of layers being generated by this module.

  graph - `org.deeplearning4j.nn.conf.ComputationGraphConfiguration$GraphBuilder`
  layer-name - `java.lang.String`
  input-size - `int`
  config - `int[][]`
  input-layer - `java.lang.String`

  returns: An instance of GraphBuilder with appended layers. - `org.deeplearning4j.nn.conf.ComputationGraphConfiguration$GraphBuilder`"
  (^org.deeplearning4j.nn.conf.ComputationGraphConfiguration$GraphBuilder [^GraphBuilderModule this ^org.deeplearning4j.nn.conf.ComputationGraphConfiguration$GraphBuilder graph ^java.lang.String layer-name ^Integer input-size config ^java.lang.String input-layer]
    (-> this (.updateBuilder graph layer-name input-size config input-layer))))

