(ns org.deeplearning4j.spark.api.TrainingMaster
  "A TrainingMaster controls how distributed training is executed in practice
 In principle, a large number of different approches can be used in distributed training (synchronous vs. asynchronous,
 parameter vs. gradient averaging, etc). Each of these different approaches would be implemented as a TrainingMaster;
 this allows SparkDl4jMultiLayer and SparkComputationGraph to be used with different training methods."
  (:refer-clojure :only [require comment defn ->])
  (:import [org.deeplearning4j.spark.api TrainingMaster]))

(defn get-worker-instance
  "Get the worker instance for this training master

  network - Current SparkDl4jMultiLayer - `org.deeplearning4j.spark.impl.multilayer.SparkDl4jMultiLayer`

  returns: Worker instance - `W`"
  ([^TrainingMaster this ^org.deeplearning4j.spark.impl.multilayer.SparkDl4jMultiLayer network]
    (-> this (.getWorkerInstance network))))

(defn get-training-stats
  "Return the training statistics. Note that this may return null, unless setCollectTrainingStats has been set first

  returns: Training statistics - `org.deeplearning4j.spark.api.stats.SparkTrainingStats`"
  (^org.deeplearning4j.spark.api.stats.SparkTrainingStats [^TrainingMaster this]
    (-> this (.getTrainingStats))))

(defn execute-training
  "Train the SparkDl4jMultiLayer with the specified data set

  network - Current network state - `org.deeplearning4j.spark.impl.multilayer.SparkDl4jMultiLayer`
  training-data - Data to train on - `org.apache.spark.api.java.JavaRDD`"
  ([^TrainingMaster this ^org.deeplearning4j.spark.impl.multilayer.SparkDl4jMultiLayer network ^org.apache.spark.api.java.JavaRDD training-data]
    (-> this (.executeTraining network training-data))))

(defn remove-hook
  "Remove a training hook from the worker

  training-hook - the training hook to remove - `org.deeplearning4j.spark.api.TrainingHook`"
  ([^TrainingMaster this ^org.deeplearning4j.spark.api.TrainingHook training-hook]
    (-> this (.removeHook training-hook))))

(defn execute-training-mds
  "Train the SparkComputationGraph with the specified data set

  graph - Current network state - `org.deeplearning4j.spark.impl.graph.SparkComputationGraph`
  training-data - Data to train on - `org.apache.spark.api.java.JavaRDD`"
  ([^TrainingMaster this ^org.deeplearning4j.spark.impl.graph.SparkComputationGraph graph ^org.apache.spark.api.java.JavaRDD training-data]
    (-> this (.executeTrainingMDS graph training-data))))

(defn add-hook
  "Add a hook for the master for pre and post training

  training-hook - the training hook to add - `org.deeplearning4j.spark.api.TrainingHook`"
  ([^TrainingMaster this ^org.deeplearning4j.spark.api.TrainingHook training-hook]
    (-> this (.addHook training-hook))))

(defn set-listeners
  "Set the iteration listeners and the StatsStorageRouter. This is typically used for UI functionality: for example,
  setListeners(new FileStatsStorage(myFile), Collections.singletonList(new StatsListener(null))). This will pass a
  StatsListener to each worker, and then shuffle the results back to the specified FileStatsStorage instance (which
  can then be attached to the UI or loaded later)

  router - StatsStorageRouter in which to place the results - `org.deeplearning4j.api.storage.StatsStorageRouter`
  listeners - Listeners - `java.util.Collection`"
  ([^TrainingMaster this ^org.deeplearning4j.api.storage.StatsStorageRouter router ^java.util.Collection listeners]
    (-> this (.setListeners router listeners)))
  ([^TrainingMaster this ^java.util.Collection listeners]
    (-> this (.setListeners listeners))))

(defn to-yaml
  "Get the TrainingMaster configuration as YAML

  returns: `java.lang.String`"
  (^java.lang.String [^TrainingMaster this]
    (-> this (.toYaml))))

(defn to-json
  "Get the TrainingMaster configuration as JSON

  returns: `java.lang.String`"
  (^java.lang.String [^TrainingMaster this]
    (-> this (.toJson))))

(defn set-collect-training-stats
  "Set whether the training statistics should be collected. Training statistics may include things like per-epoch run times,
  time spent waiting for data, etc.

  These statistics are primarily used for debugging and optimization, in order to gain some insight into what aspects
  of network training are taking the most time.

  collect-training-stats - If true: collecting training statistics will be - `boolean`"
  ([^TrainingMaster this ^Boolean collect-training-stats]
    (-> this (.setCollectTrainingStats collect-training-stats))))

(defn delete-temp-files
  "Attempt to delete any temporary files generated by this TrainingMaster.
  Depending on the configuration, no temporary files may be generated.

  sc - JavaSparkContext (used to access HDFS etc file systems, when required) - `org.apache.spark.api.java.JavaSparkContext`

  returns: True if deletion was successful (or, no files to delete); false otherwise. - `boolean`"
  (^Boolean [^TrainingMaster this ^org.apache.spark.api.java.JavaSparkContext sc]
    (-> this (.deleteTempFiles sc))))

(defn execute-training-paths
  "Fit the network using a list of paths for serialized DataSet objects.

  network - Current network state - `org.deeplearning4j.spark.impl.multilayer.SparkDl4jMultiLayer`
  graph - `org.deeplearning4j.spark.impl.graph.SparkComputationGraph`
  training-data-paths - Data to train on - `org.apache.spark.api.java.JavaRDD`
  ds-loader - `org.deeplearning4j.api.loader.DataSetLoader`
  mds-loader - `org.deeplearning4j.api.loader.MultiDataSetLoader`"
  ([^TrainingMaster this ^org.deeplearning4j.spark.impl.multilayer.SparkDl4jMultiLayer network ^org.deeplearning4j.spark.impl.graph.SparkComputationGraph graph ^org.apache.spark.api.java.JavaRDD training-data-paths ^org.deeplearning4j.api.loader.DataSetLoader ds-loader ^org.deeplearning4j.api.loader.MultiDataSetLoader mds-loader]
    (-> this (.executeTrainingPaths network graph training-data-paths ds-loader mds-loader))))

(defn get-is-collect-training-stats?
  "Get the current setting for collectTrainingStats

  returns: `boolean`"
  (^Boolean [^TrainingMaster this]
    (-> this (.getIsCollectTrainingStats))))

