(ns org.deeplearning4j.ui.WebReporter
  "This is simple wrapper for sending state updates generated by `TrainingListener`s.
 Basic idea is simple: network processing should be handled in background, without slowing caller thread"
  (:refer-clojure :only [require comment defn ->])
  (:import [org.deeplearning4j.ui WebReporter]))

(defn *get-instance
  "returns: `org.deeplearning4j.ui.WebReporter`"
  (^org.deeplearning4j.ui.WebReporter []
    (WebReporter/getInstance )))

(defn queue-report
  "This method queues UI report for sending

  target - `javax.ws.rs.client.WebTarget`
  entity - `javax.ws.rs.client.Entity`"
  ([^WebReporter this ^javax.ws.rs.client.WebTarget target ^javax.ws.rs.client.Entity entity]
    (-> this (.queueReport target entity))))

(defn post-report
  "This method immediately sends UI report to specified target using POST request

  target - `javax.ws.rs.client.WebTarget`
  entity - `javax.ws.rs.client.Entity`"
  ([^WebReporter this ^javax.ws.rs.client.WebTarget target ^javax.ws.rs.client.Entity entity]
    (-> this (.postReport target entity))))

