(ns com.google.cloud.compute.v1.Disk
  (:refer-clojure :only [require comment defn ->])
  (:import [com.google.cloud.compute.v1 Disk]))

(defn *new-builder
  "prototype - `com.google.cloud.compute.v1.Disk`

  returns: `com.google.cloud.compute.v1.Disk$Builder`"
  (^com.google.cloud.compute.v1.Disk$Builder [^com.google.cloud.compute.v1.Disk prototype]
    (Disk/newBuilder prototype))
  (^com.google.cloud.compute.v1.Disk$Builder []
    (Disk/newBuilder )))

(defn *get-default-instance
  "returns: `com.google.cloud.compute.v1.Disk`"
  (^com.google.cloud.compute.v1.Disk []
    (Disk/getDefaultInstance )))

(defn get-type
  "URL of the disk type resource describing which disk type to use to create the disk. Provide
   this when creating the disk. For example: projects/project/zones/zone/diskTypes/pd-standard or
   pd-ssd

  returns: `java.lang.String`"
  (^java.lang.String [^Disk this]
    (-> this (.getType))))

(defn get-kind
  "[Output Only] Type of the resource. Always compute#disk for disks.

  returns: `java.lang.String`"
  (^java.lang.String [^Disk this]
    (-> this (.getKind))))

(defn get-status
  "[Output Only] The status of disk creation.

  returns: `java.lang.String`"
  (^java.lang.String [^Disk this]
    (-> this (.getStatus))))

(defn get-replica-zones-list
  "URLs of the zones where the disk should be replicated to. Only applicable for regional
   resources.

  returns: `java.util.List<java.lang.String>`"
  (^java.util.List [^Disk this]
    (-> this (.getReplicaZonesList))))

(defn get-source-snapshot-encryption-key
  "The customer-supplied encryption key of the source snapshot. Required if the source snapshot is
   protected by a customer-supplied encryption key.

  returns: `com.google.cloud.compute.v1.CustomerEncryptionKey`"
  (^com.google.cloud.compute.v1.CustomerEncryptionKey [^Disk this]
    (-> this (.getSourceSnapshotEncryptionKey))))

(defn get-users-list
  "[Output Only] Links to the users of the disk (attached instances) in form:
   projects/project/zones/zone/instances/instance

  returns: `java.util.List<java.lang.String>`"
  (^java.util.List [^Disk this]
    (-> this (.getUsersList))))

(defn get-field-mask
  "returns: `java.util.List<java.lang.String>`"
  (^java.util.List [^Disk this]
    (-> this (.getFieldMask))))

(defn to-string
  "returns: `java.lang.String`"
  (^java.lang.String [^Disk this]
    (-> this (.toString))))

(defn get-labels-map
  "Labels to apply to this disk. These can be later modified by the setLabels method.

  returns: `java.util.Map<java.lang.String,java.lang.String>`"
  (^java.util.Map [^Disk this]
    (-> this (.getLabelsMap))))

(defn get-field-value
  "field-name - `java.lang.String`

  returns: `java.lang.Object`"
  (^java.lang.Object [^Disk this ^java.lang.String field-name]
    (-> this (.getFieldValue field-name))))

(defn get-name
  "Name of the resource. Provided by the client when the resource is created. The name must be
   1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   character must be a lowercase letter, and all following characters must be a dash, lowercase
   letter, or digit, except the last character, which cannot be a dash.

  returns: `java.lang.String`"
  (^java.lang.String [^Disk this]
    (-> this (.getName))))

(defn get-licenses-list
  "A list of publicly visible licenses. Reserved for Google's use.

  returns: `java.util.List<java.lang.String>`"
  (^java.util.List [^Disk this]
    (-> this (.getLicensesList))))

(defn get-source-image
  "The source image used to create this disk. If the source image is deleted, this field will not
   be set.

   To create a disk with one of the public operating system images, specify the image by its
   family name. For example, specify family/debian-9 to use the latest Debian 9 image:
   projects/debian-cloud/global/images/family/debian-9

   Alternatively, use a specific version of a public operating system image:
   projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD

   To create a disk with a custom image that you created, specify the image name in the
   following format: global/images/my-custom-image

   You can also specify a custom image by its image family, which returns the latest version of
   the image in that family. Replace the image name with family/family-name:
   global/images/family/my-image-family

  returns: `java.lang.String`"
  (^java.lang.String [^Disk this]
    (-> this (.getSourceImage))))

(defn get-label-fingerprint
  "A fingerprint for the labels being applied to this disk, which is essentially a hash of the
   labels set used for optimistic locking. The fingerprint is initially generated by Compute
   Engine and changes after every request to modify or update labels. You must always provide an
   up-to-date fingerprint hash in order to update or change labels, otherwise the request will
   fail with error 412 conditionNotMet.

   To see the latest fingerprint, make a get() request to retrieve a disk.

  returns: `java.lang.String`"
  (^java.lang.String [^Disk this]
    (-> this (.getLabelFingerprint))))

(defn get-description
  "An optional description of this resource. Provide this property when you create the resource.

  returns: `java.lang.String`"
  (^java.lang.String [^Disk this]
    (-> this (.getDescription))))

(defn get-source-image-encryption-key
  "The customer-supplied encryption key of the source image. Required if the source image is
   protected by a customer-supplied encryption key.

  returns: `com.google.cloud.compute.v1.CustomerEncryptionKey`"
  (^com.google.cloud.compute.v1.CustomerEncryptionKey [^Disk this]
    (-> this (.getSourceImageEncryptionKey))))

(defn get-id
  "[Output Only] The unique identifier for the resource. This identifier is defined by the server.

  returns: `java.lang.String`"
  (^java.lang.String [^Disk this]
    (-> this (.getId))))

(defn get-api-message-request-body
  "returns: `com.google.api.gax.httpjson.ApiMessage`"
  (^com.google.api.gax.httpjson.ApiMessage [^Disk this]
    (-> this (.getApiMessageRequestBody))))

(defn get-options
  "Internal use only.

  returns: `java.lang.String`"
  (^java.lang.String [^Disk this]
    (-> this (.getOptions))))

(defn get-self-link
  "[Output Only] Server-defined fully-qualified URL for this resource.

  returns: `java.lang.String`"
  (^java.lang.String [^Disk this]
    (-> this (.getSelfLink))))

(defn get-source-snapshot
  "The source snapshot used to create this disk. You can provide this as a partial or full URL to
   the resource. For example, the following are valid values: -
   https://www.googleapis.com/compute/v1/projects/project/global/snapshots/snapshot -
   projects/project/global/snapshots/snapshot - global/snapshots/snapshot

  returns: `java.lang.String`"
  (^java.lang.String [^Disk this]
    (-> this (.getSourceSnapshot))))

(defn get-zone
  "[Output Only] URL of the zone where the disk resides. You must specify this field as part of
   the HTTP request URL. It is not settable as a field in the request body.

  returns: `java.lang.String`"
  (^java.lang.String [^Disk this]
    (-> this (.getZone))))

(defn get-guest-os-features-list
  "A list of features to enable on the guest operating system. Applicable only for bootable
   images. Read Enabling guest operating system features to see a list of available options.

  returns: `java.util.List<com.google.cloud.compute.v1.GuestOsFeature>`"
  (^java.util.List [^Disk this]
    (-> this (.getGuestOsFeaturesList))))

(defn get-last-detach-timestamp
  "[Output Only] Last detach timestamp in RFC3339 text format.

  returns: `java.lang.String`"
  (^java.lang.String [^Disk this]
    (-> this (.getLastDetachTimestamp))))

(defn get-disk-encryption-key
  "Encrypts the disk using a customer-supplied encryption key.

   After you encrypt a disk with a customer-supplied key, you must provide the same key if you
   use the disk later (e.g. to create a disk snapshot, to create a disk image, to create a machine
   image, or to attach the disk to a virtual machine).

   Customer-supplied encryption keys do not protect access to metadata of the disk.

   If you do not provide an encryption key when creating the disk, then the disk will be
   encrypted using an automatically generated key and you do not need to provide a key to use the
   disk later.

  returns: `com.google.cloud.compute.v1.CustomerEncryptionKey`"
  (^com.google.cloud.compute.v1.CustomerEncryptionKey [^Disk this]
    (-> this (.getDiskEncryptionKey))))

(defn get-license-codes-list
  "Integer license codes indicating which licenses are attached to this disk.

  returns: `java.util.List<java.lang.String>`"
  (^java.util.List [^Disk this]
    (-> this (.getLicenseCodesList))))

(defn hash-code
  "returns: `int`"
  (^Integer [^Disk this]
    (-> this (.hashCode))))

(defn get-source-snapshot-id
  "[Output Only] The unique ID of the snapshot used to create this disk. This value identifies the
   exact snapshot that was used to create this persistent disk. For example, if you created the
   persistent disk from a snapshot that was later deleted and recreated under the same name, the
   source snapshot ID would identify the exact version of the snapshot that was used.

  returns: `java.lang.String`"
  (^java.lang.String [^Disk this]
    (-> this (.getSourceSnapshotId))))

(defn get-last-attach-timestamp
  "[Output Only] Last attach timestamp in RFC3339 text format.

  returns: `java.lang.String`"
  (^java.lang.String [^Disk this]
    (-> this (.getLastAttachTimestamp))))

(defn get-creation-timestamp
  "[Output Only] Creation timestamp in RFC3339 text format.

  returns: `java.lang.String`"
  (^java.lang.String [^Disk this]
    (-> this (.getCreationTimestamp))))

(defn get-physical-block-size-bytes
  "Physical block size of the persistent disk, in bytes. If not present in a request, a default
   value is used. Currently supported sizes are 4096 and 16384, other sizes may be added in the
   future. If an unsupported value is requested, the error message will list the supported values
   for the caller's project.

  returns: `java.lang.String`"
  (^java.lang.String [^Disk this]
    (-> this (.getPhysicalBlockSizeBytes))))

(defn equals
  "o - `java.lang.Object`

  returns: `boolean`"
  (^Boolean [^Disk this ^java.lang.Object o]
    (-> this (.equals o))))

(defn get-source-image-id
  "[Output Only] The ID value of the image used to create this disk. This value identifies the
   exact image that was used to create this persistent disk. For example, if you created the
   persistent disk from an image that was later deleted and recreated under the same name, the
   source image ID would identify the exact version of the image that was used.

  returns: `java.lang.String`"
  (^java.lang.String [^Disk this]
    (-> this (.getSourceImageId))))

(defn get-size-gb
  "Size of the persistent disk, specified in GB. You can specify this field when creating a
   persistent disk using the sourceImage or sourceSnapshot parameter, or specify it alone to
   create an empty persistent disk.

   If you specify this field along with sourceImage or sourceSnapshot, the value of sizeGb must
   not be less than the size of the sourceImage or the size of the snapshot. Acceptable values are
   1 to 65536, inclusive.

  returns: `java.lang.String`"
  (^java.lang.String [^Disk this]
    (-> this (.getSizeGb))))

(defn get-region
  "[Output Only] URL of the region where the disk resides. Only applicable for regional resources.
   You must specify this field as part of the HTTP request URL. It is not settable as a field in
   the request body.

  returns: `java.lang.String`"
  (^java.lang.String [^Disk this]
    (-> this (.getRegion))))

(defn to-builder
  "returns: `com.google.cloud.compute.v1.Disk$Builder`"
  (^com.google.cloud.compute.v1.Disk$Builder [^Disk this]
    (-> this (.toBuilder))))

