(ns com.google.cloud.compute.v1.GlobalSetLabelsRequest$Builder
  (:refer-clojure :only [require comment defn ->])
  (:import [com.google.cloud.compute.v1 GlobalSetLabelsRequest$Builder]))

(defn merge-from
  "other - `com.google.cloud.compute.v1.GlobalSetLabelsRequest`

  returns: `com.google.cloud.compute.v1.GlobalSetLabelsRequest$Builder`"
  (^com.google.cloud.compute.v1.GlobalSetLabelsRequest$Builder [^GlobalSetLabelsRequest$Builder this ^com.google.cloud.compute.v1.GlobalSetLabelsRequest other]
    (-> this (.mergeFrom other))))

(defn get-label-fingerprint
  "The fingerprint of the previous set of labels for this resource, used to detect conflicts.
   The fingerprint is initially generated by Compute Engine and changes after every request to
   modify or update labels. You must always provide an up-to-date fingerprint hash when updating
   or changing labels, otherwise the request will fail with error 412 conditionNotMet. Make a
   get() request to the resource to get the latest fingerprint.

  returns: `java.lang.String`"
  (^java.lang.String [^GlobalSetLabelsRequest$Builder this]
    (-> this (.getLabelFingerprint))))

(defn set-label-fingerprint
  "The fingerprint of the previous set of labels for this resource, used to detect conflicts.
   The fingerprint is initially generated by Compute Engine and changes after every request to
   modify or update labels. You must always provide an up-to-date fingerprint hash when updating
   or changing labels, otherwise the request will fail with error 412 conditionNotMet. Make a
   get() request to the resource to get the latest fingerprint.

  label-fingerprint - `java.lang.String`

  returns: `com.google.cloud.compute.v1.GlobalSetLabelsRequest$Builder`"
  (^com.google.cloud.compute.v1.GlobalSetLabelsRequest$Builder [^GlobalSetLabelsRequest$Builder this ^java.lang.String label-fingerprint]
    (-> this (.setLabelFingerprint label-fingerprint))))

(defn get-labels-map
  "A list of labels to apply for this resource. Each label key & value must comply with
   RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression
   `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter,
   and all following characters must be a dash, lowercase letter, or digit, except the last
   character, which cannot be a dash. For example, \"webserver-frontend\": \"images\". A label value
   can also be empty (e.g. \"my-label\": \"\").

  returns: `java.util.Map<java.lang.String,java.lang.String>`"
  (^java.util.Map [^GlobalSetLabelsRequest$Builder this]
    (-> this (.getLabelsMap))))

(defn put-all-labels
  "A list of labels to apply for this resource. Each label key & value must comply with
   RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression
   `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter,
   and all following characters must be a dash, lowercase letter, or digit, except the last
   character, which cannot be a dash. For example, \"webserver-frontend\": \"images\". A label value
   can also be empty (e.g. \"my-label\": \"\").

  labels - `java.util.Map`

  returns: `com.google.cloud.compute.v1.GlobalSetLabelsRequest$Builder`"
  (^com.google.cloud.compute.v1.GlobalSetLabelsRequest$Builder [^GlobalSetLabelsRequest$Builder this ^java.util.Map labels]
    (-> this (.putAllLabels labels))))

(defn build
  "returns: `com.google.cloud.compute.v1.GlobalSetLabelsRequest`"
  (^com.google.cloud.compute.v1.GlobalSetLabelsRequest [^GlobalSetLabelsRequest$Builder this]
    (-> this (.build))))

(defn clone
  "returns: `com.google.cloud.compute.v1.GlobalSetLabelsRequest$Builder`"
  (^com.google.cloud.compute.v1.GlobalSetLabelsRequest$Builder [^GlobalSetLabelsRequest$Builder this]
    (-> this (.clone))))

