(ns com.google.cloud.compute.v1.InstanceGroup
  (:refer-clojure :only [require comment defn ->])
  (:import [com.google.cloud.compute.v1 InstanceGroup]))

(defn *new-builder
  "prototype - `com.google.cloud.compute.v1.InstanceGroup`

  returns: `com.google.cloud.compute.v1.InstanceGroup$Builder`"
  (^com.google.cloud.compute.v1.InstanceGroup$Builder [^com.google.cloud.compute.v1.InstanceGroup prototype]
    (InstanceGroup/newBuilder prototype))
  (^com.google.cloud.compute.v1.InstanceGroup$Builder []
    (InstanceGroup/newBuilder )))

(defn *get-default-instance
  "returns: `com.google.cloud.compute.v1.InstanceGroup`"
  (^com.google.cloud.compute.v1.InstanceGroup []
    (InstanceGroup/getDefaultInstance )))

(defn get-subnetwork
  "[Output Only] The URL of the subnetwork to which all instances in the instance group belong.

  returns: `java.lang.String`"
  (^java.lang.String [^InstanceGroup this]
    (-> this (.getSubnetwork))))

(defn get-kind
  "[Output Only] The resource type, which is always compute#instanceGroup for instance groups.

  returns: `java.lang.String`"
  (^java.lang.String [^InstanceGroup this]
    (-> this (.getKind))))

(defn get-fingerprint
  "[Output Only] The fingerprint of the named ports. The system uses this fingerprint to detect
   conflicts when multiple users change the named ports concurrently.

  returns: `java.lang.String`"
  (^java.lang.String [^InstanceGroup this]
    (-> this (.getFingerprint))))

(defn get-field-mask
  "returns: `java.util.List<java.lang.String>`"
  (^java.util.List [^InstanceGroup this]
    (-> this (.getFieldMask))))

(defn to-string
  "returns: `java.lang.String`"
  (^java.lang.String [^InstanceGroup this]
    (-> this (.toString))))

(defn get-field-value
  "field-name - `java.lang.String`

  returns: `java.lang.Object`"
  (^java.lang.Object [^InstanceGroup this ^java.lang.String field-name]
    (-> this (.getFieldValue field-name))))

(defn get-name
  "The name of the instance group. The name must be 1-63 characters long, and comply with RFC1035.

  returns: `java.lang.String`"
  (^java.lang.String [^InstanceGroup this]
    (-> this (.getName))))

(defn get-named-ports-list
  "Assigns a name to a port number. For example: {name: \"http\", port: 80}

   This allows the system to reference ports by the assigned name instead of a port number.
   Named ports can also contain multiple ports. For example: [{name: \"http\", port: 80},{name:
   \"http\", port: 8080}]

   Named ports apply to all instances in this instance group.

  returns: `java.util.List<com.google.cloud.compute.v1.NamedPort>`"
  (^java.util.List [^InstanceGroup this]
    (-> this (.getNamedPortsList))))

(defn get-description
  "An optional description of this resource. Provide this property when you create the resource.

  returns: `java.lang.String`"
  (^java.lang.String [^InstanceGroup this]
    (-> this (.getDescription))))

(defn get-id
  "[Output Only] A unique identifier for this instance group, generated by the server.

  returns: `java.lang.String`"
  (^java.lang.String [^InstanceGroup this]
    (-> this (.getId))))

(defn get-api-message-request-body
  "returns: `com.google.api.gax.httpjson.ApiMessage`"
  (^com.google.api.gax.httpjson.ApiMessage [^InstanceGroup this]
    (-> this (.getApiMessageRequestBody))))

(defn get-self-link
  "[Output Only] The URL for this instance group. The server generates this URL.

  returns: `java.lang.String`"
  (^java.lang.String [^InstanceGroup this]
    (-> this (.getSelfLink))))

(defn get-zone
  "[Output Only] The URL of the zone where the instance group is located (for zonal resources).

  returns: `java.lang.String`"
  (^java.lang.String [^InstanceGroup this]
    (-> this (.getZone))))

(defn get-network
  "The URL of the network to which all instances in the instance group belong.

  returns: `java.lang.String`"
  (^java.lang.String [^InstanceGroup this]
    (-> this (.getNetwork))))

(defn hash-code
  "returns: `int`"
  (^Integer [^InstanceGroup this]
    (-> this (.hashCode))))

(defn get-creation-timestamp
  "[Output Only] The creation timestamp for this instance group in RFC3339 text format.

  returns: `java.lang.String`"
  (^java.lang.String [^InstanceGroup this]
    (-> this (.getCreationTimestamp))))

(defn get-size
  "[Output Only] The total number of instances in the instance group.

  returns: `java.lang.Integer`"
  (^java.lang.Integer [^InstanceGroup this]
    (-> this (.getSize))))

(defn equals
  "o - `java.lang.Object`

  returns: `boolean`"
  (^Boolean [^InstanceGroup this ^java.lang.Object o]
    (-> this (.equals o))))

(defn get-region
  "[Output Only] The URL of the region where the instance group is located (for regional
   resources).

  returns: `java.lang.String`"
  (^java.lang.String [^InstanceGroup this]
    (-> this (.getRegion))))

(defn to-builder
  "returns: `com.google.cloud.compute.v1.InstanceGroup$Builder`"
  (^com.google.cloud.compute.v1.InstanceGroup$Builder [^InstanceGroup this]
    (-> this (.toBuilder))))

