(ns com.google.cloud.compute.v1.Metadata$Builder
  (:refer-clojure :only [require comment defn ->])
  (:import [com.google.cloud.compute.v1 Metadata$Builder]))

(defn get-kind
  "[Output Only] Type of the resource. Always compute#metadata for metadata.

  returns: `java.lang.String`"
  (^java.lang.String [^Metadata$Builder this]
    (-> this (.getKind))))

(defn set-fingerprint
  "Specifies a fingerprint for this request, which is essentially a hash of the metadata's
   contents and used for optimistic locking. The fingerprint is initially generated by Compute
   Engine and changes after every request to modify or update metadata. You must always provide
   an up-to-date fingerprint hash in order to update or change metadata, otherwise the request
   will fail with error 412 conditionNotMet.

   To see the latest fingerprint, make a get() request to retrieve the resource.

  fingerprint - `java.lang.String`

  returns: `com.google.cloud.compute.v1.Metadata$Builder`"
  (^com.google.cloud.compute.v1.Metadata$Builder [^Metadata$Builder this ^java.lang.String fingerprint]
    (-> this (.setFingerprint fingerprint))))

(defn add-all-items
  "Array of key/value pairs. The total size of all keys and values must be less than 512 KB.

  items - `java.util.List`

  returns: `com.google.cloud.compute.v1.Metadata$Builder`"
  (^com.google.cloud.compute.v1.Metadata$Builder [^Metadata$Builder this ^java.util.List items]
    (-> this (.addAllItems items))))

(defn get-fingerprint
  "Specifies a fingerprint for this request, which is essentially a hash of the metadata's
   contents and used for optimistic locking. The fingerprint is initially generated by Compute
   Engine and changes after every request to modify or update metadata. You must always provide
   an up-to-date fingerprint hash in order to update or change metadata, otherwise the request
   will fail with error 412 conditionNotMet.

   To see the latest fingerprint, make a get() request to retrieve the resource.

  returns: `java.lang.String`"
  (^java.lang.String [^Metadata$Builder this]
    (-> this (.getFingerprint))))

(defn set-kind
  "[Output Only] Type of the resource. Always compute#metadata for metadata.

  kind - `java.lang.String`

  returns: `com.google.cloud.compute.v1.Metadata$Builder`"
  (^com.google.cloud.compute.v1.Metadata$Builder [^Metadata$Builder this ^java.lang.String kind]
    (-> this (.setKind kind))))

(defn build
  "returns: `com.google.cloud.compute.v1.Metadata`"
  (^com.google.cloud.compute.v1.Metadata [^Metadata$Builder this]
    (-> this (.build))))

(defn merge-from
  "other - `com.google.cloud.compute.v1.Metadata`

  returns: `com.google.cloud.compute.v1.Metadata$Builder`"
  (^com.google.cloud.compute.v1.Metadata$Builder [^Metadata$Builder this ^com.google.cloud.compute.v1.Metadata other]
    (-> this (.mergeFrom other))))

(defn clone
  "returns: `com.google.cloud.compute.v1.Metadata$Builder`"
  (^com.google.cloud.compute.v1.Metadata$Builder [^Metadata$Builder this]
    (-> this (.clone))))

(defn get-items-list
  "Array of key/value pairs. The total size of all keys and values must be less than 512 KB.

  returns: `java.util.List<com.google.cloud.compute.v1.Items>`"
  (^java.util.List [^Metadata$Builder this]
    (-> this (.getItemsList))))

(defn add-items
  "Array of key/value pairs. The total size of all keys and values must be less than 512 KB.

  items - `com.google.cloud.compute.v1.Items`

  returns: `com.google.cloud.compute.v1.Metadata$Builder`"
  (^com.google.cloud.compute.v1.Metadata$Builder [^Metadata$Builder this ^com.google.cloud.compute.v1.Items items]
    (-> this (.addItems items))))

