(ns com.google.cloud.compute.v1.Metadata
  (:refer-clojure :only [require comment defn ->])
  (:import [com.google.cloud.compute.v1 Metadata]))

(defn *new-builder
  "prototype - `com.google.cloud.compute.v1.Metadata`

  returns: `com.google.cloud.compute.v1.Metadata$Builder`"
  (^com.google.cloud.compute.v1.Metadata$Builder [^com.google.cloud.compute.v1.Metadata prototype]
    (Metadata/newBuilder prototype))
  (^com.google.cloud.compute.v1.Metadata$Builder []
    (Metadata/newBuilder )))

(defn *get-default-instance
  "returns: `com.google.cloud.compute.v1.Metadata`"
  (^com.google.cloud.compute.v1.Metadata []
    (Metadata/getDefaultInstance )))

(defn get-kind
  "[Output Only] Type of the resource. Always compute#metadata for metadata.

  returns: `java.lang.String`"
  (^java.lang.String [^Metadata this]
    (-> this (.getKind))))

(defn get-fingerprint
  "Specifies a fingerprint for this request, which is essentially a hash of the metadata's
   contents and used for optimistic locking. The fingerprint is initially generated by Compute
   Engine and changes after every request to modify or update metadata. You must always provide an
   up-to-date fingerprint hash in order to update or change metadata, otherwise the request will
   fail with error 412 conditionNotMet.

   To see the latest fingerprint, make a get() request to retrieve the resource.

  returns: `java.lang.String`"
  (^java.lang.String [^Metadata this]
    (-> this (.getFingerprint))))

(defn get-field-mask
  "returns: `java.util.List<java.lang.String>`"
  (^java.util.List [^Metadata this]
    (-> this (.getFieldMask))))

(defn to-string
  "returns: `java.lang.String`"
  (^java.lang.String [^Metadata this]
    (-> this (.toString))))

(defn get-field-value
  "field-name - `java.lang.String`

  returns: `java.lang.Object`"
  (^java.lang.Object [^Metadata this ^java.lang.String field-name]
    (-> this (.getFieldValue field-name))))

(defn get-api-message-request-body
  "returns: `com.google.api.gax.httpjson.ApiMessage`"
  (^com.google.api.gax.httpjson.ApiMessage [^Metadata this]
    (-> this (.getApiMessageRequestBody))))

(defn hash-code
  "returns: `int`"
  (^Integer [^Metadata this]
    (-> this (.hashCode))))

(defn get-items-list
  "Array of key/value pairs. The total size of all keys and values must be less than 512 KB.

  returns: `java.util.List<com.google.cloud.compute.v1.Items>`"
  (^java.util.List [^Metadata this]
    (-> this (.getItemsList))))

(defn equals
  "o - `java.lang.Object`

  returns: `boolean`"
  (^Boolean [^Metadata this ^java.lang.Object o]
    (-> this (.equals o))))

(defn to-builder
  "returns: `com.google.cloud.compute.v1.Metadata$Builder`"
  (^com.google.cloud.compute.v1.Metadata$Builder [^Metadata this]
    (-> this (.toBuilder))))

