(ns com.google.cloud.compute.v1.SecurityPolicy$Builder
  (:refer-clojure :only [require comment defn ->])
  (:import [com.google.cloud.compute.v1 SecurityPolicy$Builder]))

(defn set-description
  "An optional description of this resource. Provide this property when you create the resource.

  description - `java.lang.String`

  returns: `com.google.cloud.compute.v1.SecurityPolicy$Builder`"
  (^com.google.cloud.compute.v1.SecurityPolicy$Builder [^SecurityPolicy$Builder this ^java.lang.String description]
    (-> this (.setDescription description))))

(defn set-creation-timestamp
  "[Output Only] Creation timestamp in RFC3339 text format.

  creation-timestamp - `java.lang.String`

  returns: `com.google.cloud.compute.v1.SecurityPolicy$Builder`"
  (^com.google.cloud.compute.v1.SecurityPolicy$Builder [^SecurityPolicy$Builder this ^java.lang.String creation-timestamp]
    (-> this (.setCreationTimestamp creation-timestamp))))

(defn get-kind
  "[Output only] Type of the resource. Always compute#securityPolicyfor security policies

  returns: `java.lang.String`"
  (^java.lang.String [^SecurityPolicy$Builder this]
    (-> this (.getKind))))

(defn add-rules
  "A list of rules that belong to this policy. There must always be a default rule (rule with
   priority 2147483647 and match \"*\"). If no rules are provided when creating a security
   policy, a default rule with action \"allow\" will be added.

  rules - `com.google.cloud.compute.v1.SecurityPolicyRule`

  returns: `com.google.cloud.compute.v1.SecurityPolicy$Builder`"
  (^com.google.cloud.compute.v1.SecurityPolicy$Builder [^SecurityPolicy$Builder this ^com.google.cloud.compute.v1.SecurityPolicyRule rules]
    (-> this (.addRules rules))))

(defn set-fingerprint
  "Specifies a fingerprint for this resource, which is essentially a hash of the metadata's
   contents and used for optimistic locking. The fingerprint is initially generated by Compute
   Engine and changes after every request to modify or update metadata. You must always provide
   an up-to-date fingerprint hash in order to update or change metadata, otherwise the request
   will fail with error 412 conditionNotMet.

   To see the latest fingerprint, make get() request to the security policy.

  fingerprint - `java.lang.String`

  returns: `com.google.cloud.compute.v1.SecurityPolicy$Builder`"
  (^com.google.cloud.compute.v1.SecurityPolicy$Builder [^SecurityPolicy$Builder this ^java.lang.String fingerprint]
    (-> this (.setFingerprint fingerprint))))

(defn get-fingerprint
  "Specifies a fingerprint for this resource, which is essentially a hash of the metadata's
   contents and used for optimistic locking. The fingerprint is initially generated by Compute
   Engine and changes after every request to modify or update metadata. You must always provide
   an up-to-date fingerprint hash in order to update or change metadata, otherwise the request
   will fail with error 412 conditionNotMet.

   To see the latest fingerprint, make get() request to the security policy.

  returns: `java.lang.String`"
  (^java.lang.String [^SecurityPolicy$Builder this]
    (-> this (.getFingerprint))))

(defn set-name
  "Name of the resource. Provided by the client when the resource is created. The name must be
   1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   character must be a lowercase letter, and all following characters must be a dash, lowercase
   letter, or digit, except the last character, which cannot be a dash.

  name - `java.lang.String`

  returns: `com.google.cloud.compute.v1.SecurityPolicy$Builder`"
  (^com.google.cloud.compute.v1.SecurityPolicy$Builder [^SecurityPolicy$Builder this ^java.lang.String name]
    (-> this (.setName name))))

(defn add-all-rules
  "A list of rules that belong to this policy. There must always be a default rule (rule with
   priority 2147483647 and match \"*\"). If no rules are provided when creating a security
   policy, a default rule with action \"allow\" will be added.

  rules - `java.util.List`

  returns: `com.google.cloud.compute.v1.SecurityPolicy$Builder`"
  (^com.google.cloud.compute.v1.SecurityPolicy$Builder [^SecurityPolicy$Builder this ^java.util.List rules]
    (-> this (.addAllRules rules))))

(defn set-kind
  "[Output only] Type of the resource. Always compute#securityPolicyfor security policies

  kind - `java.lang.String`

  returns: `com.google.cloud.compute.v1.SecurityPolicy$Builder`"
  (^com.google.cloud.compute.v1.SecurityPolicy$Builder [^SecurityPolicy$Builder this ^java.lang.String kind]
    (-> this (.setKind kind))))

(defn get-name
  "Name of the resource. Provided by the client when the resource is created. The name must be
   1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   character must be a lowercase letter, and all following characters must be a dash, lowercase
   letter, or digit, except the last character, which cannot be a dash.

  returns: `java.lang.String`"
  (^java.lang.String [^SecurityPolicy$Builder this]
    (-> this (.getName))))

(defn set-id
  "[Output Only] The unique identifier for the resource. This identifier is defined by the
   server.

  id - `java.lang.String`

  returns: `com.google.cloud.compute.v1.SecurityPolicy$Builder`"
  (^com.google.cloud.compute.v1.SecurityPolicy$Builder [^SecurityPolicy$Builder this ^java.lang.String id]
    (-> this (.setId id))))

(defn build
  "returns: `com.google.cloud.compute.v1.SecurityPolicy`"
  (^com.google.cloud.compute.v1.SecurityPolicy [^SecurityPolicy$Builder this]
    (-> this (.build))))

(defn get-description
  "An optional description of this resource. Provide this property when you create the resource.

  returns: `java.lang.String`"
  (^java.lang.String [^SecurityPolicy$Builder this]
    (-> this (.getDescription))))

(defn get-id
  "[Output Only] The unique identifier for the resource. This identifier is defined by the
   server.

  returns: `java.lang.String`"
  (^java.lang.String [^SecurityPolicy$Builder this]
    (-> this (.getId))))

(defn set-self-link
  "[Output Only] Server-defined URL for the resource.

  self-link - `java.lang.String`

  returns: `com.google.cloud.compute.v1.SecurityPolicy$Builder`"
  (^com.google.cloud.compute.v1.SecurityPolicy$Builder [^SecurityPolicy$Builder this ^java.lang.String self-link]
    (-> this (.setSelfLink self-link))))

(defn merge-from
  "other - `com.google.cloud.compute.v1.SecurityPolicy`

  returns: `com.google.cloud.compute.v1.SecurityPolicy$Builder`"
  (^com.google.cloud.compute.v1.SecurityPolicy$Builder [^SecurityPolicy$Builder this ^com.google.cloud.compute.v1.SecurityPolicy other]
    (-> this (.mergeFrom other))))

(defn get-self-link
  "[Output Only] Server-defined URL for the resource.

  returns: `java.lang.String`"
  (^java.lang.String [^SecurityPolicy$Builder this]
    (-> this (.getSelfLink))))

(defn clone
  "returns: `com.google.cloud.compute.v1.SecurityPolicy$Builder`"
  (^com.google.cloud.compute.v1.SecurityPolicy$Builder [^SecurityPolicy$Builder this]
    (-> this (.clone))))

(defn get-rules-list
  "A list of rules that belong to this policy. There must always be a default rule (rule with
   priority 2147483647 and match \"*\"). If no rules are provided when creating a security
   policy, a default rule with action \"allow\" will be added.

  returns: `java.util.List<com.google.cloud.compute.v1.SecurityPolicyRule>`"
  (^java.util.List [^SecurityPolicy$Builder this]
    (-> this (.getRulesList))))

(defn get-creation-timestamp
  "[Output Only] Creation timestamp in RFC3339 text format.

  returns: `java.lang.String`"
  (^java.lang.String [^SecurityPolicy$Builder this]
    (-> this (.getCreationTimestamp))))

