(ns com.google.cloud.compute.v1.SecurityPolicy
  (:refer-clojure :only [require comment defn ->])
  (:import [com.google.cloud.compute.v1 SecurityPolicy]))

(defn *new-builder
  "prototype - `com.google.cloud.compute.v1.SecurityPolicy`

  returns: `com.google.cloud.compute.v1.SecurityPolicy$Builder`"
  (^com.google.cloud.compute.v1.SecurityPolicy$Builder [^com.google.cloud.compute.v1.SecurityPolicy prototype]
    (SecurityPolicy/newBuilder prototype))
  (^com.google.cloud.compute.v1.SecurityPolicy$Builder []
    (SecurityPolicy/newBuilder )))

(defn *get-default-instance
  "returns: `com.google.cloud.compute.v1.SecurityPolicy`"
  (^com.google.cloud.compute.v1.SecurityPolicy []
    (SecurityPolicy/getDefaultInstance )))

(defn get-kind
  "[Output only] Type of the resource. Always compute#securityPolicyfor security policies

  returns: `java.lang.String`"
  (^java.lang.String [^SecurityPolicy this]
    (-> this (.getKind))))

(defn get-fingerprint
  "Specifies a fingerprint for this resource, which is essentially a hash of the metadata's
   contents and used for optimistic locking. The fingerprint is initially generated by Compute
   Engine and changes after every request to modify or update metadata. You must always provide an
   up-to-date fingerprint hash in order to update or change metadata, otherwise the request will
   fail with error 412 conditionNotMet.

   To see the latest fingerprint, make get() request to the security policy.

  returns: `java.lang.String`"
  (^java.lang.String [^SecurityPolicy this]
    (-> this (.getFingerprint))))

(defn get-field-mask
  "returns: `java.util.List<java.lang.String>`"
  (^java.util.List [^SecurityPolicy this]
    (-> this (.getFieldMask))))

(defn to-string
  "returns: `java.lang.String`"
  (^java.lang.String [^SecurityPolicy this]
    (-> this (.toString))))

(defn get-field-value
  "field-name - `java.lang.String`

  returns: `java.lang.Object`"
  (^java.lang.Object [^SecurityPolicy this ^java.lang.String field-name]
    (-> this (.getFieldValue field-name))))

(defn get-name
  "Name of the resource. Provided by the client when the resource is created. The name must be
   1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   character must be a lowercase letter, and all following characters must be a dash, lowercase
   letter, or digit, except the last character, which cannot be a dash.

  returns: `java.lang.String`"
  (^java.lang.String [^SecurityPolicy this]
    (-> this (.getName))))

(defn get-description
  "An optional description of this resource. Provide this property when you create the resource.

  returns: `java.lang.String`"
  (^java.lang.String [^SecurityPolicy this]
    (-> this (.getDescription))))

(defn get-id
  "[Output Only] The unique identifier for the resource. This identifier is defined by the server.

  returns: `java.lang.String`"
  (^java.lang.String [^SecurityPolicy this]
    (-> this (.getId))))

(defn get-api-message-request-body
  "returns: `com.google.api.gax.httpjson.ApiMessage`"
  (^com.google.api.gax.httpjson.ApiMessage [^SecurityPolicy this]
    (-> this (.getApiMessageRequestBody))))

(defn get-self-link
  "[Output Only] Server-defined URL for the resource.

  returns: `java.lang.String`"
  (^java.lang.String [^SecurityPolicy this]
    (-> this (.getSelfLink))))

(defn hash-code
  "returns: `int`"
  (^Integer [^SecurityPolicy this]
    (-> this (.hashCode))))

(defn get-rules-list
  "A list of rules that belong to this policy. There must always be a default rule (rule with
   priority 2147483647 and match \"*\"). If no rules are provided when creating a security
   policy, a default rule with action \"allow\" will be added.

  returns: `java.util.List<com.google.cloud.compute.v1.SecurityPolicyRule>`"
  (^java.util.List [^SecurityPolicy this]
    (-> this (.getRulesList))))

(defn get-creation-timestamp
  "[Output Only] Creation timestamp in RFC3339 text format.

  returns: `java.lang.String`"
  (^java.lang.String [^SecurityPolicy this]
    (-> this (.getCreationTimestamp))))

(defn equals
  "o - `java.lang.Object`

  returns: `boolean`"
  (^Boolean [^SecurityPolicy this ^java.lang.Object o]
    (-> this (.equals o))))

(defn to-builder
  "returns: `com.google.cloud.compute.v1.SecurityPolicy$Builder`"
  (^com.google.cloud.compute.v1.SecurityPolicy$Builder [^SecurityPolicy this]
    (-> this (.toBuilder))))

