(ns com.google.cloud.compute.v1.Tags
  (:refer-clojure :only [require comment defn ->])
  (:import [com.google.cloud.compute.v1 Tags]))

(defn *new-builder
  "prototype - `com.google.cloud.compute.v1.Tags`

  returns: `com.google.cloud.compute.v1.Tags$Builder`"
  (^com.google.cloud.compute.v1.Tags$Builder [^com.google.cloud.compute.v1.Tags prototype]
    (Tags/newBuilder prototype))
  (^com.google.cloud.compute.v1.Tags$Builder []
    (Tags/newBuilder )))

(defn *get-default-instance
  "returns: `com.google.cloud.compute.v1.Tags`"
  (^com.google.cloud.compute.v1.Tags []
    (Tags/getDefaultInstance )))

(defn get-fingerprint
  "Specifies a fingerprint for this request, which is essentially a hash of the tags' contents and
   used for optimistic locking. The fingerprint is initially generated by Compute Engine and
   changes after every request to modify or update tags. You must always provide an up-to-date
   fingerprint hash in order to update or change tags.

   To see the latest fingerprint, make get() request to the instance.

  returns: `java.lang.String`"
  (^java.lang.String [^Tags this]
    (-> this (.getFingerprint))))

(defn get-field-mask
  "returns: `java.util.List<java.lang.String>`"
  (^java.util.List [^Tags this]
    (-> this (.getFieldMask))))

(defn to-string
  "returns: `java.lang.String`"
  (^java.lang.String [^Tags this]
    (-> this (.toString))))

(defn get-field-value
  "field-name - `java.lang.String`

  returns: `java.lang.Object`"
  (^java.lang.Object [^Tags this ^java.lang.String field-name]
    (-> this (.getFieldValue field-name))))

(defn get-api-message-request-body
  "returns: `com.google.api.gax.httpjson.ApiMessage`"
  (^com.google.api.gax.httpjson.ApiMessage [^Tags this]
    (-> this (.getApiMessageRequestBody))))

(defn hash-code
  "returns: `int`"
  (^Integer [^Tags this]
    (-> this (.hashCode))))

(defn get-items-list
  "An array of tags. Each tag must be 1-63 characters long, and comply with RFC1035.

  returns: `java.util.List<java.lang.String>`"
  (^java.util.List [^Tags this]
    (-> this (.getItemsList))))

(defn equals
  "o - `java.lang.Object`

  returns: `boolean`"
  (^Boolean [^Tags this ^java.lang.Object o]
    (-> this (.equals o))))

(defn to-builder
  "returns: `com.google.cloud.compute.v1.Tags$Builder`"
  (^com.google.cloud.compute.v1.Tags$Builder [^Tags this]
    (-> this (.toBuilder))))

