(ns javax.management.MBeanServerFactory
  "Provides MBean server references.  There are no instances of
  this class.

  Since JMX 1.2 this class makes it possible to replace the default
  MBeanServer implementation. This is done using the
  MBeanServerBuilder class.
  The class of the initial MBeanServerBuilder to be
  instantiated can be specified through the
  javax.management.builder.initial system property.
  The specified class must be a public subclass of
  MBeanServerBuilder, and must have a public
  empty constructor.
  By default, if no value for that property is specified, an instance of
  javax.management.MBeanServerBuilder
  is created. Otherwise, the MBeanServerFactory attempts to load the
  specified class using
  Thread.currentThread().getContextClassLoader(), or if that is null,
  Class.forName(). Then
  it creates an initial instance of that Class using
  Class.newInstance(). If any checked exception
  is raised during this process (e.g.
  ClassNotFoundException,
  InstantiationException) the MBeanServerFactory
  will propagate this exception from within a RuntimeException.

  The javax.management.builder.initial system property is
  consulted every time a new MBeanServer needs to be created, and the
  class pointed to by that property is loaded. If that class is different
  from that of the current MBeanServerBuilder, then a new MBeanServerBuilder
  is created. Otherwise, the MBeanServerFactory may create a new
  MBeanServerBuilder or reuse the current one.

  If the class pointed to by the property cannot be
  loaded, or does not correspond to a valid subclass of MBeanServerBuilder
  then an exception is propagated, and no MBeanServer can be created until
  the javax.management.builder.initial system property is reset to
  valid value.

  The MBeanServerBuilder makes it possible to wrap the MBeanServers
  returned by the default MBeanServerBuilder implementation, for the purpose
  of e.g. adding an additional security layer."
  (:refer-clojure :only [require comment defn ->])
  (:import [javax.management MBeanServerFactory]))

(defn *release-m-bean-server
  "Remove internal MBeanServerFactory references to a created
   MBeanServer. This allows the garbage collector to remove the
   MBeanServer object.

  mbean-server - the MBeanServer object to remove. - `javax.management.MBeanServer`

  throws: java.lang.IllegalArgumentException - if mbeanServer was not generated by one of the createMBeanServer methods, or if releaseMBeanServer was already called on it."
  ([mbean-server]
    (MBeanServerFactory/releaseMBeanServer mbean-server)))

(defn *create-m-bean-server
  "Return a new object implementing the MBeanServer
   interface with the specified default domain name.  The given
   domain name is used as the domain part in the ObjectName of
   MBeans when the domain is specified by the user is null.

   The MBeanServer reference is internally kept. This will
   allow findMBeanServer to return a reference to
   this MBeanServer object.

  domain - the default domain name for the created MBeanServer. This is the value that will be returned by MBeanServer.getDefaultDomain(). - `java.lang.String`

  returns: the newly created MBeanServer. - `javax.management.MBeanServer`

  throws: java.lang.SecurityException - if there is a SecurityManager and the caller's permissions do not include or imply MBeanServerPermission(`createMBeanServer`)."
  ([domain]
    (MBeanServerFactory/createMBeanServer domain))
  ([]
    (MBeanServerFactory/createMBeanServer )))

(defn *new-m-bean-server
  "Return a new object implementing the MBeanServer interface
   with the specified default domain name, without keeping an
   internal reference to this new object.  The given domain name
   is used as the domain part in the ObjectName of MBeans when the
   domain is specified by the user is null.

   No reference is kept. findMBeanServer will not
   be able to return a reference to this MBeanServer object, but
   the garbage collector will be able to remove the MBeanServer
   object when it is no longer referenced.

  domain - the default domain name for the created MBeanServer. This is the value that will be returned by MBeanServer.getDefaultDomain(). - `java.lang.String`

  returns: the newly created MBeanServer. - `javax.management.MBeanServer`

  throws: java.lang.SecurityException - if there is a SecurityManager and the caller's permissions do not include or imply MBeanServerPermission(`newMBeanServer`)."
  ([domain]
    (MBeanServerFactory/newMBeanServer domain))
  ([]
    (MBeanServerFactory/newMBeanServer )))

(defn *find-m-bean-server
  "Return a list of registered MBeanServer objects.  A
   registered MBeanServer object is one that was created by one of
   the createMBeanServer methods and not subsequently
   released with releaseMBeanServer.

  agent-id - The agent identifier of the MBeanServer to retrieve. If this parameter is null, all registered MBeanServers in this JVM are returned. Otherwise, only MBeanServers whose id is equal to agentId are returned. The id of an MBeanServer is the MBeanServerId attribute of its delegate MBean. - `java.lang.String`

  returns: A list of MBeanServer objects. - `java.util.ArrayList<javax.management.MBeanServer>`

  throws: java.lang.SecurityException - if there is a SecurityManager and the caller's permissions do not include or imply MBeanServerPermission(`findMBeanServer`)."
  ([agent-id]
    (MBeanServerFactory/findMBeanServer agent-id)))

(defn *get-class-loader-repository
  "Return the ClassLoaderRepository used by the given MBeanServer.
   This method is equivalent to server.getClassLoaderRepository().

  server - The MBeanServer under examination. Since JMX 1.2, if server is null, the result is a NullPointerException. This behavior differs from what was implemented in JMX 1.1 - where the possibility to use null was deprecated. - `javax.management.MBeanServer`

  returns: The Class Loader Repository used by the given MBeanServer. - `javax.management.loading.ClassLoaderRepository`

  throws: java.lang.SecurityException - if there is a SecurityManager and the caller's permissions do not include or imply MBeanPermission(`getClassLoaderRepository`)."
  ([server]
    (MBeanServerFactory/getClassLoaderRepository server)))

