(ns javax.naming.ldap.LdapName
  "This class represents a distinguished name as specified by
  RFC 2253.
  A distinguished name, or DN, is composed of an ordered list of
  components called relative distinguished names, or RDNs.
  Details of a DN's syntax are described in RFC 2253.

  This class resolves a few ambiguities found in RFC 2253
  as follows:

   RFC 2253 leaves the term `whitespace` undefined. The
       ASCII space character 0x20 (` `) is used in its place.
   Whitespace is allowed on either side of ',', ';', '=', and '+'.
       Such whitespace is accepted but not generated by this code,
       and is ignored when comparing names.
   AttributeValue strings containing '=' or non-leading '#'
       characters (unescaped) are accepted.


  String names passed to LdapName or returned by it
  use the full Unicode character set. They may also contain
  characters encoded into UTF-8 with each octet represented by a
  three-character substring such as `\\B4`.
  They may not, however, contain characters encoded into UTF-8 with
  each octet represented by a single character in the string:  the
  meaning would be ambiguous.

  LdapName will properly parse all valid names, but
  does not attempt to detect all possible violations when parsing
  invalid names.  It is `generous` in accepting invalid names.
  The `validity` of a name is determined ultimately when it
  is supplied to an LDAP server, which may accept or
  reject the name based on factors such as its schema information
  and interoperability considerations.

  When names are tested for equality, attribute types, both binary
  and string values, are case-insensitive.
  String values with different but equivalent usage of quoting,
  escaping, or UTF8-hex-encoding are considered equal.  The order of
  components in multi-valued RDNs (such as `ou=Sales+cn=Bob`) is not
  significant.

  The components of a LDAP name, that is, RDNs, are numbered. The
  indexes of a LDAP name with n RDNs range from 0 to n-1.
  This range may be written as [0,n).
  The right most RDN is at index 0, and the left most RDN is at
  index n-1. For example, the distinguished name:
  `CN=Steve Kille, O=Isode Limited, C=GB` is numbered in the following
  sequence ranging from 0 to 2: {C=GB, O=Isode Limited, CN=Steve Kille}. An
  empty LDAP name is represented by an empty RDN list.

  Concurrent multithreaded read-only access of an instance of
  LdapName need not be synchronized.

  Unless otherwise noted, the behavior of passing a null argument
  to a constructor or method in this class will cause a
  NullPointerException to be thrown."
  (:refer-clojure :only [require comment defn ->])
  (:import [javax.naming.ldap LdapName]))

(defn ->ldap-name
  "Constructor.

  Constructs an LDAP name from the given distinguished name.

  name - This is a non-null distinguished name formatted according to the rules defined in RFC 2253. - `java.lang.String`

  throws: javax.naming.InvalidNameException - if a syntax violation is detected."
  ([^java.lang.String name]
    (new LdapName name)))

(defn add-all
  "Adds the components of a name -- in order -- at a specified position
   within this name. Components of this LDAP name at or after the
   index (if any) of the first new component are shifted up
   (away from index 0) to accommodate the new components.

  posn - The index at which to add the new component. Must be in the range [0,size()]. - `int`
  suffix - The non-null components to add. - `javax.naming.Name`

  returns: The updated name (not a new instance). - `javax.naming.Name`

  throws: javax.naming.InvalidNameException - if suffix is not a valid LDAP name, or if the addition of the components would violate the syntax rules of this LDAP name."
  (^javax.naming.Name [^javax.naming.ldap.LdapName this ^Integer posn ^javax.naming.Name suffix]
    (-> this (.addAll posn suffix)))
  (^javax.naming.Name [^javax.naming.ldap.LdapName this ^javax.naming.Name suffix]
    (-> this (.addAll suffix))))

(defn get-rdn
  "Retrieves an RDN of this LDAP name as an Rdn.

  posn - The 0-based index of the RDN to retrieve. Must be in the range [0,size()). - `int`

  returns: The non-null RDN at index posn. - `javax.naming.ldap.Rdn`

  throws: java.lang.IndexOutOfBoundsException - if posn is outside the specified range."
  (^javax.naming.ldap.Rdn [^javax.naming.ldap.LdapName this ^Integer posn]
    (-> this (.getRdn posn))))

(defn ends-with
  "Determines whether this LDAP name ends with a specified
   LDAP name suffix.
   A name n is a suffix if it is equal to
   getSuffix(size()-n.size())--in other words this LDAP
   name ends with 'n'. If n is null or not a RFC2253 formatted name
   as described in the class description, false is returned.

  n - The LDAP name to check. - `javax.naming.Name`

  returns: true if n is a suffix of this name, false otherwise. - `boolean`"
  (^Boolean [^javax.naming.ldap.LdapName this ^javax.naming.Name n]
    (-> this (.endsWith n))))

(defn get-suffix
  "Creates a name whose components consist of a suffix of the
   components in this LDAP name.
   Subsequent changes to this name do not affect the name that is
   returned and vice versa.

  posn - The 0-based index of the component at which to start. Must be in the range [0,size()]. - `int`

  returns: An instance of LdapName consisting of the
            components at indexes in the range [posn,size()).
            If posn is equal to size(), an empty LDAP name is
            returned. - `javax.naming.Name`

  throws: java.lang.IndexOutOfBoundsException - If posn is outside the specified range."
  (^javax.naming.Name [^javax.naming.ldap.LdapName this ^Integer posn]
    (-> this (.getSuffix posn))))

(defn get-all
  "Retrieves the components of this name as an enumeration
   of strings. The effect of updates to this name on this enumeration
   is undefined. If the name has zero components, an empty (non-null)
   enumeration is returned.
   The order of the components returned by the enumeration is same as
   the order in which the components are numbered as described in the
   class description.

  returns: A non-null enumeration of the components of this LDAP name.
   Each element of the enumeration is of class String. - `java.util.Enumeration<java.lang.String>`"
  (^java.util.Enumeration [^javax.naming.ldap.LdapName this]
    (-> this (.getAll))))

(defn to-string
  "Returns a string representation of this LDAP name in a format
   defined by RFC 2253
   and described in the class description. If the name has zero
   components an empty string is returned.

  returns: The string representation of the LdapName. - `java.lang.String`"
  (^java.lang.String [^javax.naming.ldap.LdapName this]
    (-> this (.toString))))

(defn get-rdns
  "Retrieves the list of relative distinguished names.
   The contents of the list are unmodifiable.
   The indexing of RDNs in the returned list follows the numbering of
   RDNs as described in the class description.
   If the name has zero components, an empty list is returned.

  returns: The name as a list of RDNs which are instances of
            the class Rdn. - `java.util.List<javax.naming.ldap.Rdn>`"
  (^java.util.List [^javax.naming.ldap.LdapName this]
    (-> this (.getRdns))))

(defn remove
  "Removes a component from this LDAP name.
   The component of this name at the specified position is removed.
   Components with indexes greater than this position (if any)
   are shifted down (toward index 0) by one.

  posn - The index of the component to remove. Must be in the range [0,size()). - `int`

  returns: The component removed (a String). - `java.lang.Object`

  throws: java.lang.IndexOutOfBoundsException - if posn is outside the specified range."
  (^java.lang.Object [^javax.naming.ldap.LdapName this ^Integer posn]
    (-> this (.remove posn))))

(defn starts-with
  "Determines whether this LDAP name starts with a specified LDAP name
   prefix.
   A name n is a prefix if it is equal to
   getPrefix(n.size())--in other words this LDAP
   name starts with 'n'. If n is null or not a RFC2253 formatted name
   as described in the class description, false is returned.

  n - The LDAP name to check. - `javax.naming.Name`

  returns: true if n is a prefix of this LDAP name,
   false otherwise. - `boolean`"
  (^Boolean [^javax.naming.ldap.LdapName this ^javax.naming.Name n]
    (-> this (.startsWith n))))

(defn clone
  "Generates a new copy of this name.
   Subsequent changes to the components of this name will not
   affect the new copy, and vice versa.

  returns: A copy of the this LDAP name. - `java.lang.Object`"
  (^java.lang.Object [^javax.naming.ldap.LdapName this]
    (-> this (.clone))))

(defn hash-code
  "Computes the hash code of this LDAP name.
   The hash code is the sum of the hash codes of individual RDNs
   of this  name.

  returns: An int representing the hash code of this name. - `int`"
  (^Integer [^javax.naming.ldap.LdapName this]
    (-> this (.hashCode))))

(defn add
  "Adds a single component at a specified position within this
   LDAP name.
   Components of this LDAP name at or after the index (if any) of the new
   component are shifted up by one (away from index 0) to accommodate
   the new component.

  posn - The index at which to add the new component. Must be in the range [0,size()]. - `int`
  comp - The non-null component to add. - `java.lang.String`

  returns: The updated LdapName, not a new instance.
                    Cannot be null. - `javax.naming.Name`

  throws: java.lang.IndexOutOfBoundsException - If posn is outside the specified range."
  (^javax.naming.Name [^javax.naming.ldap.LdapName this ^Integer posn ^java.lang.String comp]
    (-> this (.add posn comp)))
  (^javax.naming.Name [^javax.naming.ldap.LdapName this ^java.lang.String comp]
    (-> this (.add comp))))

(defn empty?
  "Determines whether this LDAP name is empty.
   An empty name is one with zero components.

  returns: true if this LDAP name is empty, false otherwise. - `boolean`"
  (^Boolean [^javax.naming.ldap.LdapName this]
    (-> this (.isEmpty))))

(defn size
  "Retrieves the number of components in this LDAP name.

  returns: The non-negative number of components in this LDAP name. - `int`"
  (^Integer [^javax.naming.ldap.LdapName this]
    (-> this (.size))))

(defn compare-to
  "Compares this LdapName with the specified Object for order.
   Returns a negative integer, zero, or a positive integer as this
   Name is less than, equal to, or greater than the given Object.

   If obj is null or not an instance of LdapName, ClassCastException
   is thrown.

   Ordering of LDAP names follows the lexicographical rules for
   string comparison, with the extension that this applies to all
   the RDNs in the LDAP name. All the RDNs are lined up in their
   specified order and compared lexicographically.
   See Rdn.compareTo(Object obj)
   for RDN comparison rules.

   If this LDAP name is lexicographically lesser than obj,
   a negative number is returned.
   If this LDAP name is lexicographically greater than obj,
   a positive number is returned.

  obj - The non-null LdapName instance to compare against. - `java.lang.Object`

  returns: A negative integer, zero, or a positive integer as this Name
            is less than, equal to, or greater than the given obj. - `int`

  throws: java.lang.ClassCastException - if obj is null or not a LdapName."
  (^Integer [^javax.naming.ldap.LdapName this ^java.lang.Object obj]
    (-> this (.compareTo obj))))

(defn get-prefix
  "Creates a name whose components consist of a prefix of the
   components of this LDAP name.
   Subsequent changes to this name will not affect the name
   that is returned and vice versa.

  posn - The 0-based index of the component at which to stop. Must be in the range [0,size()]. - `int`

  returns: An instance of LdapName consisting of the
            components at indexes in the range [0,posn).
            If posn is zero, an empty LDAP name is returned. - `javax.naming.Name`

  throws: java.lang.IndexOutOfBoundsException - If posn is outside the specified range."
  (^javax.naming.Name [^javax.naming.ldap.LdapName this ^Integer posn]
    (-> this (.getPrefix posn))))

(defn get
  "Retrieves a component of this LDAP name as a string.

  posn - The 0-based index of the component to retrieve. Must be in the range [0,size()). - `int`

  returns: The non-null component at index posn. - `java.lang.String`

  throws: java.lang.IndexOutOfBoundsException - if posn is outside the specified range."
  (^java.lang.String [^javax.naming.ldap.LdapName this ^Integer posn]
    (-> this (.get posn))))

(defn equals
  "Determines whether two LDAP names are equal.
   If obj is null or not an LDAP name, false is returned.

   Two LDAP names are equal if each RDN in one is equal
   to the corresponding RDN in the other. This implies
   both have the same number of RDNs, and each RDN's
   equals() test against the corresponding RDN in the other
   name returns true. See Rdn.equals(Object obj)
   for a definition of RDN equality.

  obj - The possibly null object to compare against. - `java.lang.Object`

  returns: true if obj is equal to this LDAP name,
                    false otherwise. - `boolean`"
  (^Boolean [^javax.naming.ldap.LdapName this ^java.lang.Object obj]
    (-> this (.equals obj))))

